/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.sun.jna.PointerType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CLAbstractEntity<T extends PointerType> {
    protected volatile T entity;
    private final boolean nullable;

    CLAbstractEntity(T entity) {
        this(entity, false);
    }

    CLAbstractEntity(T entity, boolean nullable) {
        if (!nullable && entity == null) {
            throw new IllegalArgumentException("Null OpenCL " + this.getClass().getSimpleName() + " !");
        }
        this.nullable = nullable;
        this.entity = entity;
    }

    public synchronized void release() {
        if (this.entity == null) {
            if (!this.nullable) {
                throw new RuntimeException("This " + this.getClass().getSimpleName() + " has already been released ! Besides, keep in mind that manual release is not necessary, as it will automatically be done by the garbage collector.");
            }
            return;
        }
        this.doRelease();
    }

    public static <E extends PointerType, A extends CLAbstractEntity<E>> E[] getEntities(A[] objects, E[] out) {
        int len = objects.length;
        for (int i = 0; i < len; ++i) {
            out[i] = ((CLAbstractEntity)objects[i]).getEntity();
        }
        return out;
    }

    synchronized T getEntity() {
        if (this.entity == null && !this.nullable) {
            throw new RuntimeException("This " + this.getClass().getSimpleName() + " has been manually released and can't be used anymore !");
        }
        return this.entity;
    }

    synchronized void doRelease() {
        if (this.entity != null) {
            this.clear();
            this.entity = null;
        }
    }

    protected void finalize() throws Throwable {
        this.doRelease();
    }

    protected abstract void clear();

    public int hashCode() {
        return this.getEntity() == null ? 0 : this.getEntity().getPointer().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().isInstance(obj)) {
            return false;
        }
        CLAbstractEntity e = (CLAbstractEntity)obj;
        return this.getEntity().getPointer().equals((Object)e.getEntity().getPointer());
    }
}

