/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLByteBuffer;
import com.nativelibs4java.opencl.CLCharBuffer;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDoubleBuffer;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLFloatBuffer;
import com.nativelibs4java.opencl.CLIntBuffer;
import com.nativelibs4java.opencl.CLLongBuffer;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.CLShortBuffer;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.nativelibs4java.opencl.library.cl_buffer_region;
import com.nativelibs4java.util.JNAUtils;
import com.nativelibs4java.util.NIOUtils;
import com.ochafik.util.listenable.Pair;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLBuffer<T>
extends CLMem {
    Buffer buffer;
    final int elementSize;
    final Class<? extends Buffer> typedBufferClass;
    final Class<T> elementClass;

    CLBuffer(CLContext context, long byteCount, OpenCLLibrary.cl_mem entity, Buffer buffer, int elementSize, Class<? extends Buffer> typedBufferClass) {
        super(context, byteCount, entity);
        this.buffer = buffer;
        this.elementSize = elementSize;
        this.typedBufferClass = typedBufferClass;
        this.elementClass = NIOUtils.getPrimitiveClass(typedBufferClass);
    }

    public Class<? extends Buffer> getBufferClass() {
        return this.typedBufferClass;
    }

    public Class<T> getElementClass() {
        return this.elementClass;
    }

    public int getElementSize() {
        return this.elementSize;
    }

    public long getElementCount() {
        return this.getByteCount() / (long)this.getElementSize();
    }

    public <B extends Buffer> B map(CLQueue queue, CLMem.MapFlags flags, CLEvent ... eventsToWaitFor) throws CLException.MapFailure {
        return (B)((Buffer)this.map(queue, flags, 0L, this.getElementCount(), true, eventsToWaitFor).getFirst());
    }

    public <B extends Buffer> B map(CLQueue queue, CLMem.MapFlags flags, long offset, long length, CLEvent ... eventsToWaitFor) throws CLException.MapFailure {
        return (B)((Buffer)this.map(queue, flags, offset, length, true, eventsToWaitFor).getFirst());
    }

    public <B extends Buffer> Pair<B, CLEvent> mapLater(CLQueue queue, CLMem.MapFlags flags, CLEvent ... eventsToWaitFor) throws CLException.MapFailure {
        return this.map(queue, flags, 0L, this.getElementCount(), false, eventsToWaitFor);
    }

    public <B extends Buffer> Pair<B, CLEvent> mapLater(CLQueue queue, CLMem.MapFlags flags, long offset, long length, CLEvent ... eventsToWaitFor) throws CLException.MapFailure {
        return this.map(queue, flags, offset, length, false, eventsToWaitFor);
    }

    public <B extends Buffer> B read(CLQueue queue, CLEvent ... eventsToWaitFor) {
        B out = this.typedBuffer(NIOUtils.directBytes((int)this.getByteCount(), queue.getDevice().getKernelsDefaultByteOrder()));
        this.read(queue, out, true, eventsToWaitFor);
        return out;
    }

    public <B extends Buffer> B read(CLQueue queue, long offset, long length, CLEvent ... eventsToWaitFor) {
        B out = this.typedBuffer(NIOUtils.directBytes((int)this.getByteCount(), queue.getDevice().getKernelsDefaultByteOrder()));
        this.read(queue, offset, length, (Buffer)out, true, eventsToWaitFor);
        return out;
    }

    protected void checkBounds(long offset, long length) {
        if (offset + length * (long)this.getElementSize() > this.getByteCount()) {
            throw new IndexOutOfBoundsException("Trying to map a region of memory object outside allocated range");
        }
    }

    public CLBuffer<T> createSubBuffer(CLMem.Usage usage, long offset, long length) {
        try {
            int s = this.getElementSize();
            cl_buffer_region region = new cl_buffer_region(JNAUtils.toNS((long)s * offset), JNAUtils.toNS((long)s * length));
            IntByReference pErr = new IntByReference();
            OpenCLLibrary.cl_mem mem = JavaCL.CL.clCreateSubBuffer((OpenCLLibrary.cl_mem)this.getEntity(), (long)usage.getIntFlags(), 4640, region.getPointer(), pErr);
            CLException.error(pErr.getValue());
            return mem == null ? null : this.createBuffer(mem);
        }
        catch (Throwable th) {
            throw new UnsupportedOperationException("Cannot create sub-buffer (OpenCL 1.1 feature).", th);
        }
    }

    public CLEvent copyTo(CLQueue queue, CLMem destination, CLEvent ... eventsToWaitFor) {
        return this.copyTo(queue, 0L, this.getElementCount(), destination, 0L, eventsToWaitFor);
    }

    public CLEvent copyTo(CLQueue queue, long srcOffset, long length, CLMem destination, long destOffset, CLEvent ... eventsToWaitFor) {
        OpenCLLibrary.cl_event[] eventOut = CLEvent.new_event_out(eventsToWaitFor);
        long byteCount = this.getByteCount();
        long destByteCount = destination.getByteCount();
        long eltSize = this.getElementSize();
        long actualSrcOffset = srcOffset * eltSize;
        long actualDestOffset = destOffset * eltSize;
        long actualLength = length * eltSize;
        if (actualSrcOffset < 0L || actualSrcOffset >= byteCount || actualSrcOffset + actualLength > byteCount || actualDestOffset < 0L || actualDestOffset >= destByteCount || actualDestOffset + actualLength > destByteCount) {
            throw new IndexOutOfBoundsException("Invalid copy parameters : srcOffset = " + srcOffset + ", destOffset = " + destOffset + ", length = " + length + " (element size = " + eltSize + ", source byte count = " + byteCount + ", destination byte count = " + destByteCount + ")");
        }
        OpenCLLibrary.cl_event[] evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(JavaCL.CL.clEnqueueCopyBuffer((OpenCLLibrary.cl_command_queue)queue.getEntity(), (OpenCLLibrary.cl_mem)this.getEntity(), (OpenCLLibrary.cl_mem)destination.getEntity(), JNAUtils.toNS(actualSrcOffset), JNAUtils.toNS(actualDestOffset), JNAUtils.toNS(actualLength), evts == null ? 0 : evts.length, evts, eventOut));
        return CLEvent.createEvent(queue, eventOut);
    }

    protected <B extends Buffer> Pair<B, CLEvent> map(CLQueue queue, CLMem.MapFlags flags, long offset, long length, boolean blocking, CLEvent ... eventsToWaitFor) {
        this.checkBounds(offset, length);
        OpenCLLibrary.cl_event[] eventOut = blocking ? null : CLEvent.new_event_out(eventsToWaitFor);
        IntByReference pErr = new IntByReference();
        OpenCLLibrary.cl_event[] evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        Pointer p = JavaCL.CL.clEnqueueMapBuffer((OpenCLLibrary.cl_command_queue)queue.getEntity(), (OpenCLLibrary.cl_mem)this.getEntity(), blocking ? 1 : 0, flags.value(), JNAUtils.toNS(offset * (long)this.getElementSize()), JNAUtils.toNS(length * (long)this.getElementSize()), evts == null ? 0 : evts.length, evts, eventOut, pErr);
        CLException.error(pErr.getValue());
        return new Pair<B, CLEvent>(this.typedBuffer(p.getByteBuffer(0L, length * (long)this.getElementSize()).order(queue.getDevice().getKernelsDefaultByteOrder())), CLEvent.createEvent(queue, eventOut));
    }

    public <B extends Buffer> CLEvent unmap(CLQueue queue, B buffer, CLEvent ... eventsToWaitFor) {
        this.typedBufferClass.cast(buffer);
        OpenCLLibrary.cl_event[] eventOut = CLEvent.new_event_out(eventsToWaitFor);
        OpenCLLibrary.cl_event[] evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(JavaCL.CL.clEnqueueUnmapMemObject((OpenCLLibrary.cl_command_queue)queue.getEntity(), (OpenCLLibrary.cl_mem)this.getEntity(), Native.getDirectBufferPointer(buffer), evts == null ? 0 : evts.length, evts, eventOut));
        return CLEvent.createEvent(queue, eventOut);
    }

    public <B extends Buffer> CLEvent read(CLQueue queue, B out, boolean blocking, CLEvent ... eventsToWaitFor) {
        long length;
        this.typedBufferClass.cast(out);
        if (this.isGL) {
            length = out.capacity();
        } else {
            long s;
            length = this.getElementCount();
            if (length > (s = (long)out.capacity())) {
                length = s;
            }
        }
        return this.read(queue, 0L, length, out, blocking, eventsToWaitFor);
    }

    public CLEvent read(CLQueue queue, long offset, long length, Buffer out, boolean blocking, CLEvent ... eventsToWaitFor) {
        this.typedBufferClass.cast(out);
        if (out.isReadOnly()) {
            throw new IllegalArgumentException("Output buffer for read operation is read-only !");
        }
        Buffer originalOut = null;
        if (!out.isDirect()) {
            originalOut = out;
            out = this.typedBuffer(NIOUtils.directBytes((int)(length * (long)this.getElementSize()), queue.getDevice().getKernelsDefaultByteOrder()));
            blocking = true;
        }
        OpenCLLibrary.cl_event[] eventOut = blocking ? null : CLEvent.new_event_out(eventsToWaitFor);
        OpenCLLibrary.cl_event[] evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(JavaCL.CL.clEnqueueReadBuffer((OpenCLLibrary.cl_command_queue)queue.getEntity(), (OpenCLLibrary.cl_mem)this.getEntity(), blocking ? 1 : 0, JNAUtils.toNS(offset * (long)this.getElementSize()), JNAUtils.toNS(length * (long)this.getElementSize()), Native.getDirectBufferPointer((Buffer)out), evts == null ? 0 : evts.length, evts, eventOut));
        if (originalOut != null) {
            NIOUtils.put(out, originalOut);
        }
        return CLEvent.createEvent(queue, eventOut);
    }

    public CLEvent write(CLQueue queue, Buffer in, boolean blocking, CLEvent ... eventsToWaitFor) {
        long length;
        this.typedBufferClass.cast(in);
        if (this.isGL) {
            length = in.capacity();
        } else {
            long s;
            length = this.getElementCount();
            if (length > (s = (long)in.capacity())) {
                length = s;
            }
        }
        return this.write(queue, 0L, length, in, blocking, eventsToWaitFor);
    }

    public CLEvent write(CLQueue queue, long offset, long length, Buffer in, boolean blocking, CLEvent ... eventsToWaitFor) {
        this.typedBufferClass.cast(in);
        if (!in.isDirect()) {
            blocking = true;
            in = this.typedBuffer(NIOUtils.directCopy(in, queue.getDevice().getKernelsDefaultByteOrder()));
        }
        OpenCLLibrary.cl_event[] eventOut = blocking ? null : CLEvent.new_event_out(eventsToWaitFor);
        OpenCLLibrary.cl_event[] evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(JavaCL.CL.clEnqueueWriteBuffer((OpenCLLibrary.cl_command_queue)queue.getEntity(), (OpenCLLibrary.cl_mem)this.getEntity(), blocking ? 1 : 0, JNAUtils.toNS(offset * (long)this.getElementSize()), JNAUtils.toNS(length * (long)this.getElementSize()), Native.getDirectBufferPointer((Buffer)in), evts == null ? 0 : evts.length, evts, eventOut));
        return CLEvent.createEvent(queue, eventOut);
    }

    public CLEvent writeBytes(CLQueue queue, long offset, long length, ByteBuffer in, boolean blocking, CLEvent ... eventsToWaitFor) {
        if (!in.isDirect()) {
            blocking = true;
            in = NIOUtils.directCopy(in, queue.getDevice().getKernelsDefaultByteOrder());
        }
        OpenCLLibrary.cl_event[] eventOut = blocking ? null : CLEvent.new_event_out(eventsToWaitFor);
        OpenCLLibrary.cl_event[] evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(JavaCL.CL.clEnqueueWriteBuffer((OpenCLLibrary.cl_command_queue)queue.getEntity(), (OpenCLLibrary.cl_mem)this.getEntity(), blocking ? 1 : 0, JNAUtils.toNS(offset), JNAUtils.toNS(length), Native.getDirectBufferPointer((Buffer)in), evts == null ? 0 : evts.length, evts, eventOut));
        return CLEvent.createEvent(queue, eventOut);
    }

    public ByteBuffer readBytes(CLQueue queue, long offset, long length, CLEvent ... eventsToWaitFor) {
        ByteBuffer out = NIOUtils.directBytes((int)this.getByteCount(), queue.getDevice().getKernelsDefaultByteOrder());
        Object tout = this.typedBuffer(out);
        this.read(queue, offset, (long)((Buffer)tout).capacity(), (Buffer)tout, true, eventsToWaitFor);
        return out;
    }

    private <T extends CLMem> T copyGLMark(T mem) {
        mem.isGL = this.isGL;
        return mem;
    }

    public CLBuffer<T> emptyClone(CLMem.Usage usage) {
        return this.getContext().createBuffer(usage, this.typedBufferClass, this.getElementCount());
    }

    protected CLBuffer<T> createBuffer(OpenCLLibrary.cl_mem mem) {
        if (this.typedBufferClass == IntBuffer.class) {
            return new CLIntBuffer(this.getContext(), -1L, mem, null);
        }
        if (this.typedBufferClass == LongBuffer.class) {
            return new CLLongBuffer(this.getContext(), -1L, mem, null);
        }
        if (this.typedBufferClass == ShortBuffer.class) {
            return new CLShortBuffer(this.getContext(), -1L, mem, null);
        }
        if (this.typedBufferClass == ByteBuffer.class) {
            return new CLByteBuffer(this.getContext(), -1L, mem, null);
        }
        if (this.typedBufferClass == CharBuffer.class) {
            return new CLCharBuffer(this.getContext(), -1L, mem, null);
        }
        if (this.typedBufferClass == FloatBuffer.class) {
            return new CLFloatBuffer(this.getContext(), -1L, mem, null);
        }
        if (this.typedBufferClass == DoubleBuffer.class) {
            return new CLDoubleBuffer(this.getContext(), -1L, mem, null);
        }
        throw new RuntimeException("Unable to create an OpenCL buffer for type " + this.typedBufferClass.getName());
    }

    protected <B extends Buffer> B typedBuffer(ByteBuffer b) {
        if (this.typedBufferClass == IntBuffer.class) {
            return (B)b.asIntBuffer();
        }
        if (this.typedBufferClass == LongBuffer.class) {
            return (B)b.asLongBuffer();
        }
        if (this.typedBufferClass == ShortBuffer.class) {
            return (B)b.asShortBuffer();
        }
        if (this.typedBufferClass == ByteBuffer.class) {
            return (B)b;
        }
        if (this.typedBufferClass == CharBuffer.class) {
            return (B)b.asCharBuffer();
        }
        if (this.typedBufferClass == FloatBuffer.class) {
            return (B)b.asFloatBuffer();
        }
        if (this.typedBufferClass == DoubleBuffer.class) {
            return (B)b.asDoubleBuffer();
        }
        throw new RuntimeException("Unable to create a typed buffer for type " + this.typedBufferClass.getName());
    }

    public CLIntBuffer asCLIntBuffer() {
        OpenCLLibrary.cl_mem mem = (OpenCLLibrary.cl_mem)this.getEntity();
        JavaCL.CL.clRetainMemObject((OpenCLLibrary.cl_mem)this.getEntity());
        return this.copyGLMark(new CLIntBuffer(this.context, this.getByteCount(), mem, this.buffer));
    }

    public CLLongBuffer asCLLongBuffer() {
        OpenCLLibrary.cl_mem mem = (OpenCLLibrary.cl_mem)this.getEntity();
        JavaCL.CL.clRetainMemObject((OpenCLLibrary.cl_mem)this.getEntity());
        return this.copyGLMark(new CLLongBuffer(this.context, this.getByteCount(), mem, this.buffer));
    }

    public CLShortBuffer asCLShortBuffer() {
        OpenCLLibrary.cl_mem mem = (OpenCLLibrary.cl_mem)this.getEntity();
        JavaCL.CL.clRetainMemObject((OpenCLLibrary.cl_mem)this.getEntity());
        return this.copyGLMark(new CLShortBuffer(this.context, this.getByteCount(), mem, this.buffer));
    }

    public CLByteBuffer asCLByteBuffer() {
        OpenCLLibrary.cl_mem mem = (OpenCLLibrary.cl_mem)this.getEntity();
        JavaCL.CL.clRetainMemObject((OpenCLLibrary.cl_mem)this.getEntity());
        return this.copyGLMark(new CLByteBuffer(this.context, this.getByteCount(), mem, this.buffer));
    }

    public CLCharBuffer asCLCharBuffer() {
        OpenCLLibrary.cl_mem mem = (OpenCLLibrary.cl_mem)this.getEntity();
        JavaCL.CL.clRetainMemObject((OpenCLLibrary.cl_mem)this.getEntity());
        return this.copyGLMark(new CLCharBuffer(this.context, this.getByteCount(), mem, this.buffer));
    }

    public CLFloatBuffer asCLFloatBuffer() {
        OpenCLLibrary.cl_mem mem = (OpenCLLibrary.cl_mem)this.getEntity();
        JavaCL.CL.clRetainMemObject((OpenCLLibrary.cl_mem)this.getEntity());
        return this.copyGLMark(new CLFloatBuffer(this.context, this.getByteCount(), mem, this.buffer));
    }

    public CLDoubleBuffer asCLDoubleBuffer() {
        OpenCLLibrary.cl_mem mem = (OpenCLLibrary.cl_mem)this.getEntity();
        JavaCL.CL.clRetainMemObject((OpenCLLibrary.cl_mem)this.getEntity());
        return this.copyGLMark(new CLDoubleBuffer(this.context, this.getByteCount(), mem, this.buffer));
    }
}

