/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLImage;
import com.nativelibs4java.opencl.CLImageFormat;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.ImageIOUtils;
import com.nativelibs4java.opencl.InfoName;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.nativelibs4java.util.JNAUtils;
import com.nativelibs4java.util.NIOUtils;
import com.ochafik.util.listenable.Pair;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.nio.Buffer;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLImage2D
extends CLImage {
    CLImage2D(CLContext context, OpenCLLibrary.cl_mem entity, CLImageFormat format) {
        super(context, entity, format);
    }

    @InfoName(value="CL_IMAGE_ROW_PITCH")
    public long getRowPitch() {
        return infos.getIntOrLong(this.getEntity(), 4370);
    }

    @InfoName(value="CL_IMAGE_WIDTH")
    public long getWidth() {
        return infos.getIntOrLong(this.getEntity(), 4372);
    }

    @InfoName(value="CL_IMAGE_HEIGHT")
    public long getHeight() {
        return infos.getIntOrLong(this.getEntity(), 4373);
    }

    public CLEvent read(CLQueue queue, long minX, long minY, long width, long height, long rowPitch, Buffer out, boolean blocking, CLEvent ... eventsToWaitFor) {
        return this.read(queue, JNAUtils.toNS(minX, minY, 0L), JNAUtils.toNS(width, height, 1L), rowPitch, 0L, out, blocking, eventsToWaitFor);
    }

    public CLEvent write(CLQueue queue, long minX, long minY, long width, long height, long rowPitch, Buffer in, boolean blocking, CLEvent ... eventsToWaitFor) {
        return this.write(queue, JNAUtils.toNS(minX, minY, 0L), JNAUtils.toNS(width, height, 1L), rowPitch, 0L, in, blocking, eventsToWaitFor);
    }

    public BufferedImage read(CLQueue queue, CLEvent ... eventsToWaitFor) {
        int imageType;
        ImageIOUtils.ImageInfo<BufferedImage> info = ImageIOUtils.getBufferedImageInfo(this.getFormat());
        int n = imageType = info == null ? 0 : info.bufferedImageType;
        if (imageType == 0) {
            throw new UnsupportedOperationException("Cannot convert image of format " + this.getFormat() + " to a BufferedImage.");
        }
        BufferedImage im = new BufferedImage((int)this.getWidth(), (int)this.getHeight(), imageType);
        this.read(queue, im, false, eventsToWaitFor);
        return im;
    }

    public void read(CLQueue queue, BufferedImage imageOut, boolean allowDeoptimizingDirectWrite, CLEvent ... eventsToWaitFor) {
        ImageIOUtils.ImageInfo<BufferedImage> info = ImageIOUtils.getBufferedImageInfo(this.getFormat());
        int width = imageOut.getWidth(null);
        int height = imageOut.getHeight(null);
        Buffer dataOut = NIOUtils.directBuffer(width * height * info.channelCount, this.getContext().getByteOrder(), info.bufferClass);
        this.read(queue, 0L, 0L, (long)width, (long)height, 0L, dataOut, true, eventsToWaitFor);
        info.dataSetter.setData(imageOut, dataOut, allowDeoptimizingDirectWrite);
    }

    public CLEvent write(CLQueue queue, Image image, CLEvent ... eventsToWaitFor) {
        return this.write(queue, image, 0, 0, image.getWidth(null), image.getHeight(null), false, false, eventsToWaitFor);
    }

    public CLEvent write(CLQueue queue, Image image, boolean allowDeoptimizingDirectRead, boolean blocking, CLEvent ... eventsToWaitFor) {
        return this.write(queue, image, 0, 0, image.getWidth(null), image.getHeight(null), allowDeoptimizingDirectRead, blocking, eventsToWaitFor);
    }

    public CLEvent write(CLQueue queue, Image image, int destX, int destY, int width, int height, boolean allowDeoptimizingDirectRead, boolean blocking, CLEvent ... eventsToWaitFor) {
        ImageIOUtils.ImageInfo<BufferedImage> info = ImageIOUtils.getBufferedImageInfo(this.getFormat());
        return this.write(queue, 0L, 0L, (long)width, (long)height, (long)(width * info.pixelByteSize), info.dataGetter.getData(image, null, false, allowDeoptimizingDirectRead, this.getContext().getByteOrder()), blocking, eventsToWaitFor);
    }

    public void write(CLQueue queue, BufferedImage imageIn, boolean allowDeoptimizingDirectRead, CLEvent ... eventsToWaitFor) {
        int width = imageIn.getWidth(null);
        int height = imageIn.getHeight(null);
        ImageIOUtils.ImageInfo<BufferedImage> info = ImageIOUtils.getBufferedImageInfo(this.getFormat());
        this.write(queue, 0L, 0L, (long)width, (long)height, 0L, info.dataGetter.getData(imageIn, null, false, allowDeoptimizingDirectRead, this.getContext().getByteOrder()), true, eventsToWaitFor);
    }

    public void write(CLQueue queue, BufferedImage im) {
        this.write(queue, im, false, new CLEvent[0]);
    }

    public ByteBuffer map(CLQueue queue, CLMem.MapFlags flags, CLEvent ... eventsToWaitFor) {
        return this.map(queue, flags, JNAUtils.toNS(0L, 0L), JNAUtils.toNS(this.getWidth(), this.getHeight()), (Long)this.getWidth(), null, true, eventsToWaitFor).getFirst();
    }

    public ByteBuffer map(CLQueue queue, CLMem.MapFlags flags, long offsetX, long offsetY, long lengthX, long lengthY, long rowPitch, CLEvent ... eventsToWaitFor) {
        return this.map(queue, flags, JNAUtils.toNS(offsetX, offsetY), JNAUtils.toNS(lengthX, lengthY), (Long)rowPitch, null, true, eventsToWaitFor).getFirst();
    }

    public Pair<ByteBuffer, CLEvent> mapLater(CLQueue queue, CLMem.MapFlags flags, boolean blocking, CLEvent ... eventsToWaitFor) {
        return this.map(queue, flags, JNAUtils.toNS(0L, 0L), JNAUtils.toNS(this.getWidth(), this.getHeight()), (Long)this.getWidth(), null, blocking, eventsToWaitFor);
    }

    public Pair<ByteBuffer, CLEvent> mapLater(CLQueue queue, CLMem.MapFlags flags, long offsetX, long offsetY, long lengthX, long lengthY, long rowPitch, boolean blocking, CLEvent ... eventsToWaitFor) {
        return this.map(queue, flags, JNAUtils.toNS(offsetX, offsetY), JNAUtils.toNS(lengthX, lengthY), (Long)rowPitch, null, blocking, eventsToWaitFor);
    }
}

