/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.util.JNAUtils;
import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.ochafik.lang.jnaerator.runtime.NativeSizeByReference;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CLInfoGetter<T extends PointerType> {
    CLInfoGetter() {
    }

    protected abstract int getInfo(T var1, int var2, NativeSize var3, Pointer var4, NativeSizeByReference var5);

    public String getString(T entity, int infoName) {
        NativeSizeByReference pLen = new NativeSizeByReference();
        CLException.error(this.getInfo(entity, infoName, JNAUtils.toNS(0), null, pLen));
        int len = pLen.getValue().intValue();
        if (len == 0) {
            return "";
        }
        Memory buffer = new Memory((long)(len + 1));
        CLException.error(this.getInfo(entity, infoName, pLen.getValue(), (Pointer)buffer, null));
        return buffer.getString(0L);
    }

    public Pointer getPointer(T entity, int infoName) {
        NativeSizeByReference pLen = new NativeSizeByReference();
        Memory mem = new Memory((long)Pointer.SIZE);
        CLException.error(this.getInfo(entity, infoName, JNAUtils.toNS(Pointer.SIZE), (Pointer)mem, pLen));
        if (pLen.getValue().intValue() != Pointer.SIZE) {
            throw new RuntimeException("Not a pointer : len = " + pLen.getValue());
        }
        return mem.getPointer(0L);
    }

    public Memory getMemory(T entity, int infoName) {
        NativeSizeByReference pLen = new NativeSizeByReference();
        CLException.error(this.getInfo(entity, infoName, JNAUtils.toNS(0), null, pLen));
        Memory buffer = new Memory((long)pLen.getValue().intValue());
        CLException.error(this.getInfo(entity, infoName, pLen.getValue(), (Pointer)buffer, null));
        return buffer;
    }

    public long[] getNativeSizes(T entity, int infoName, int n) {
        int nBytes = NativeSize.SIZE * n;
        NativeSizeByReference pLen = new NativeSizeByReference(JNAUtils.toNS(nBytes));
        Memory mem = new Memory((long)nBytes);
        CLException.error(this.getInfo(entity, infoName, JNAUtils.toNS(nBytes), (Pointer)mem, null));
        if (pLen.getValue().longValue() != (long)nBytes) {
            throw new RuntimeException("Not a Size[" + n + "] : len = " + pLen.getValue());
        }
        long[] longs = new long[n];
        for (int i = 0; i < n; ++i) {
            longs[i] = JNAUtils.readNS((Pointer)mem, i * NativeSize.SIZE).longValue();
        }
        return longs;
    }

    public int getOptionalFeatureInt(T entity, int infoName) {
        try {
            return this.getInt(entity, infoName);
        }
        catch (CLException.InvalidValue ex) {
            throw new UnsupportedOperationException("Cannot get value " + infoName, ex);
        }
        catch (CLException.InvalidOperation ex) {
            throw new UnsupportedOperationException("Cannot get value " + infoName, ex);
        }
    }

    public int getInt(T entity, int infoName) {
        return (int)this.getIntOrLong(entity, infoName);
    }

    public boolean getBool(T entity, int infoName) {
        NativeSizeByReference pLen = new NativeSizeByReference();
        Memory mem = new Memory(8L);
        CLException.error(this.getInfo(entity, infoName, JNAUtils.toNS(8), (Pointer)mem, pLen));
        switch ((int)pLen.getValue().longValue()) {
            case 1: {
                return mem.getByte(0L) != 0;
            }
            case 2: {
                return mem.getShort(0L) != 0;
            }
            case 4: {
                return mem.getInt(0L) != 0;
            }
            case 8: {
                return mem.getLong(0L) != 0L;
            }
        }
        throw new RuntimeException("Not a BOOL : len = " + pLen.getValue());
    }

    public long getIntOrLong(T entity, int infoName) {
        NativeSizeByReference pLen = new NativeSizeByReference();
        Memory mem = new Memory(8L);
        CLException.error(this.getInfo(entity, infoName, JNAUtils.toNS(8), (Pointer)mem, pLen));
        switch (pLen.getValue().intValue()) {
            case 4: {
                return mem.getInt(0L);
            }
            case 8: {
                return mem.getLong(0L);
            }
        }
        throw new RuntimeException("Not a native long : len = " + pLen.getValue());
    }
}

