/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLImageFormat;
import com.nativelibs4java.util.NIOUtils;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImageIOUtils {
    ImageIOUtils() {
    }

    public static ImageInfo<Image> getGenericImageInfo() {
        return new ImageInfo<Image>(0, CLImageFormat.INT_ARGB_FORMAT, new ImageInfo.ImageDataGetter<Image>(){

            @Override
            public Buffer getData(Image image, Buffer optionalExistingOutput, boolean directBuffer, boolean allowDeoptimizingDirectRead, ByteOrder byteOrder) {
                int[] intData = null;
                int width = image.getWidth(null);
                int height = image.getHeight(null);
                PixelGrabber grabber = new PixelGrabber(image, 0, 0, width, height, true);
                try {
                    grabber.grabPixels();
                    intData = (int[])grabber.getPixels();
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException("Pixel read operation was interrupted", ex);
                }
                IntBuffer output = IntBuffer.wrap(intData);
                if (directBuffer) {
                    return NIOUtils.directCopy(output, byteOrder);
                }
                return output;
            }
        }, new ImageInfo.ImageDataSetter(){

            public void setData(Image image, Buffer data, boolean allowDeoptimizingDirectWrite) {
                if (!(image instanceof BufferedImage)) {
                    throw new UnsupportedOperationException("Image must be a BufferedImage");
                }
                BufferedImage bufferedImage = (BufferedImage)image;
                int width = bufferedImage.getWidth();
                int height = bufferedImage.getHeight();
                WritableRaster raster = ImageIOUtils.checkWritableRaster(bufferedImage);
                IntBuffer input = ImageIOUtils.checkBuffer(data, IntBuffer.class);
                int[] intData = input.array();
                if (intData == null) {
                    intData = new int[width * height];
                    input.get(intData);
                }
                raster.setPixels(0, 0, width, height, intData);
            }
        }, IntBuffer.class, 1, 4);
    }

    static void checkSinglePixelPackedSampleModel(Raster raster) {
        if (raster.getNumDataElements() != 1) {
            throw new IllegalArgumentException("Raster has " + raster.getNumBands() + " data elements, should have only 1 !");
        }
    }

    static <DB extends DataBuffer> DB checkDataBuffer(Raster raster, Class<DB> dbType) {
        DataBuffer dataBuffer = raster.getDataBuffer();
        if (!dbType.isInstance(dataBuffer)) {
            throw new IllegalArgumentException("Expected " + dbType.getName() + ", got " + (dataBuffer == null ? null : dataBuffer.getClass().getName()));
        }
        return (DB)dataBuffer;
    }

    static <B extends Buffer> B checkBuffer(Buffer buffer, Class<B> bType) {
        if (!bType.isInstance(buffer)) {
            throw new IllegalArgumentException("Expected " + bType.getName() + ", got " + (buffer == null ? null : buffer.getClass().getName()));
        }
        return (B)buffer;
    }

    static WritableRaster checkWritableRaster(BufferedImage image) {
        WritableRaster raster = image.getRaster();
        if (!(raster instanceof WritableRaster)) {
            throw new UnsupportedOperationException("Image data is not writable");
        }
        return raster;
    }

    public static ImageInfo<BufferedImage> getShortGrayImageInfo() {
        return new ImageInfo<BufferedImage>(11, new CLImageFormat(CLImageFormat.ChannelOrder.LUMINANCE, CLImageFormat.ChannelDataType.UNormInt16), new ImageInfo.ImageDataGetter<BufferedImage>(){

            @Override
            public Buffer getData(BufferedImage image, Buffer optionalExistingOutput, boolean directBuffer, boolean allowDeoptimizingDirectRead, ByteOrder byteOrder) {
                short[] array;
                int width = image.getWidth();
                int height = image.getHeight();
                WritableRaster raster = ImageIOUtils.checkWritableRaster(image);
                ImageIOUtils.checkSinglePixelPackedSampleModel(raster);
                short[] existingArray = ImageIOUtils.getIndirectArray(optionalExistingOutput, width * height, short[].class);
                ShortBuffer output = null;
                if (!allowDeoptimizingDirectRead || ImageIOUtils.isSubRaster(raster)) {
                    array = (short[])raster.getDataElements(0, 0, width, height, existingArray);
                } else {
                    array = ImageIOUtils.checkDataBuffer(raster, DataBufferShort.class).getData();
                    if (optionalExistingOutput instanceof ShortBuffer && (output = (ShortBuffer)optionalExistingOutput) != null && output.capacity() == width * height) {
                        if (!output.isDirect()) {
                            System.arraycopy(array, 0, output.array(), 0, width * height);
                        } else {
                            output.duplicate().put(array);
                        }
                    }
                }
                if (output == null) {
                    output = ShortBuffer.wrap(array);
                }
                return directBuffer && !output.isDirect() ? NIOUtils.directCopy(output, byteOrder) : output;
            }
        }, new ImageInfo.ImageDataSetter<BufferedImage>(){

            @Override
            public void setData(BufferedImage image, Buffer inputBuffer, boolean allowDeoptimizingDirectWrite) {
                short[] inputArray;
                int width = image.getWidth();
                int height = image.getHeight();
                WritableRaster raster = ImageIOUtils.checkWritableRaster(image);
                ImageIOUtils.checkSinglePixelPackedSampleModel(raster);
                ShortBuffer input = ImageIOUtils.checkBuffer(inputBuffer, ShortBuffer.class);
                short[] sArray = inputArray = input.isDirect() ? null : input.array();
                if (allowDeoptimizingDirectWrite && input.isDirect()) {
                    short[] outputArray = ImageIOUtils.checkDataBuffer(raster, DataBufferShort.class).getData();
                    ShortBuffer.wrap(outputArray).put(input.duplicate());
                    return;
                }
                if (inputArray == null) {
                    inputArray = new short[width * height];
                    input.duplicate().get(inputArray);
                }
                raster.setDataElements(0, 0, width, height, inputArray);
            }
        }, ShortBuffer.class, 1, 2);
    }

    public static ImageInfo<BufferedImage> getARGBShortGrayImageInfo(CLImageFormat format) {
        return new ImageInfo<BufferedImage>(11, format, new ImageInfo.ImageDataGetter<BufferedImage>(){

            @Override
            public Buffer getData(BufferedImage image, Buffer optionalExistingOutput, boolean directBuffer, boolean allowDeoptimizingDirectRead, ByteOrder byteOrder) {
                int width = image.getWidth();
                int height = image.getHeight();
                WritableRaster raster = ImageIOUtils.checkWritableRaster(image);
                ImageIOUtils.checkSinglePixelPackedSampleModel(raster);
                int length = width * height;
                short[] existingArray = ImageIOUtils.getIndirectArray(optionalExistingOutput, length, short[].class);
                short[] array = (short[])raster.getDataElements(0, 0, width, height, existingArray);
                ShortBuffer output = null;
                if (optionalExistingOutput instanceof ShortBuffer && (output = (ShortBuffer)optionalExistingOutput).capacity() != length * 4) {
                    output = null;
                }
                if (output == null) {
                    output = NIOUtils.directShorts(length * 4, byteOrder);
                }
                for (int i = 0; i < length; ++i) {
                    int offset = i * 4;
                    short value = array[i];
                    output.put(offset, value);
                    output.put(offset + 1, value);
                    output.put(offset + 2, value);
                    output.put(offset + 3, (short)-1);
                }
                return output;
            }
        }, new ImageInfo.ImageDataSetter<BufferedImage>(){

            @Override
            public void setData(BufferedImage image, Buffer inputBuffer, boolean allowDeoptimizingDirectWrite) {
                int width = image.getWidth();
                int height = image.getHeight();
                WritableRaster raster = ImageIOUtils.checkWritableRaster(image);
                ImageIOUtils.checkSinglePixelPackedSampleModel(raster);
                ShortBuffer input = ImageIOUtils.checkBuffer(inputBuffer, ShortBuffer.class);
                int length = width * height;
                short[] data = new short[length];
                short[] four = new short[4];
                for (int i = 0; i < length; ++i) {
                    int offset = i * 4;
                    short a = input.get(offset);
                    short b = input.get(offset + 1);
                    short c = input.get(offset + 2);
                    short alpha = input.get(offset + 3);
                    data[i] = (short)((a + b + c) / 3);
                }
                raster.setDataElements(0, 0, width, height, data);
            }
        }, ShortBuffer.class, 4, 8);
    }

    public static ImageInfo<BufferedImage> getByteGrayImageInfo() {
        return new ImageInfo<BufferedImage>(10, new CLImageFormat(CLImageFormat.ChannelOrder.LUMINANCE, CLImageFormat.ChannelDataType.SignedInt8), new ImageInfo.ImageDataGetter<BufferedImage>(){

            @Override
            public Buffer getData(BufferedImage image, Buffer optionalExistingOutput, boolean directBuffer, boolean allowDeoptimizingDirectRead, ByteOrder byteOrder) {
                byte[] array;
                int width = image.getWidth();
                int height = image.getHeight();
                WritableRaster raster = ImageIOUtils.checkWritableRaster(image);
                ImageIOUtils.checkSinglePixelPackedSampleModel(raster);
                byte[] existingArray = ImageIOUtils.getIndirectArray(optionalExistingOutput, width * height, byte[].class);
                ByteBuffer output = null;
                if (!allowDeoptimizingDirectRead || ImageIOUtils.isSubRaster(raster)) {
                    array = (byte[])raster.getDataElements(0, 0, width, height, existingArray);
                } else {
                    array = ImageIOUtils.checkDataBuffer(raster, DataBufferByte.class).getData();
                    if (optionalExistingOutput instanceof ByteBuffer && (output = (ByteBuffer)optionalExistingOutput) != null && output.capacity() == width * height) {
                        if (!output.isDirect()) {
                            System.arraycopy(array, 0, output.array(), 0, width * height);
                        } else {
                            output.duplicate().put(array);
                        }
                    }
                }
                if (output == null) {
                    output = ByteBuffer.wrap(array);
                }
                return directBuffer && !output.isDirect() ? NIOUtils.directCopy(output, byteOrder) : output;
            }
        }, new ImageInfo.ImageDataSetter<BufferedImage>(){

            @Override
            public void setData(BufferedImage image, Buffer inputBuffer, boolean allowDeoptimizingDirectWrite) {
                byte[] inputArray;
                int width = image.getWidth();
                int height = image.getHeight();
                WritableRaster raster = ImageIOUtils.checkWritableRaster(image);
                ImageIOUtils.checkSinglePixelPackedSampleModel(raster);
                ByteBuffer input = ImageIOUtils.checkBuffer(inputBuffer, ByteBuffer.class);
                byte[] byArray = inputArray = input.isDirect() ? null : input.array();
                if (allowDeoptimizingDirectWrite && input.isDirect()) {
                    byte[] outputArray = ImageIOUtils.checkDataBuffer(raster, DataBufferByte.class).getData();
                    ByteBuffer.wrap(outputArray).put(input.duplicate());
                    return;
                }
                if (inputArray == null) {
                    inputArray = new byte[width * height];
                    input.duplicate().get(inputArray);
                }
                raster.setDataElements(0, 0, width, height, inputArray);
            }
        }, ByteBuffer.class, 1, 1);
    }

    static <A> A getIndirectArray(Buffer buffer, int length, Class<A> arrayClass) {
        if (buffer instanceof IntBuffer && arrayClass == int[].class) {
            return (A)((IntBuffer)buffer).array();
        }
        if (buffer instanceof ShortBuffer && arrayClass == short[].class) {
            return (A)((ShortBuffer)buffer).array();
        }
        if (buffer instanceof ByteBuffer && arrayClass == byte[].class) {
            return (A)((ByteBuffer)buffer).array();
        }
        if (buffer instanceof FloatBuffer && arrayClass == float[].class) {
            return (A)((FloatBuffer)buffer).array();
        }
        if (buffer instanceof LongBuffer && arrayClass == long[].class) {
            return (A)((LongBuffer)buffer).array();
        }
        if (buffer instanceof DoubleBuffer && arrayClass == double[].class) {
            return (A)((DoubleBuffer)buffer).array();
        }
        if (buffer instanceof CharBuffer && arrayClass == char[].class) {
            return (A)((CharBuffer)buffer).array();
        }
        return null;
    }

    public static boolean isSubRaster(Raster raster) {
        Rectangle bounds = raster.getBounds();
        return raster.getParent() != null || bounds.x != 0 || bounds.y != 0;
    }

    public static ImageInfo<BufferedImage> getIntARGBImageInfo() {
        return new ImageInfo<BufferedImage>(2, CLImageFormat.INT_ARGB_FORMAT, new ImageInfo.ImageDataGetter<BufferedImage>(){

            @Override
            public Buffer getData(BufferedImage image, Buffer optionalExistingOutput, boolean directBuffer, boolean allowDeoptimizingDirectRead, ByteOrder byteOrder) {
                int[] array;
                int width = image.getWidth();
                int height = image.getHeight();
                WritableRaster raster = ImageIOUtils.checkWritableRaster(image);
                ImageIOUtils.checkSinglePixelPackedSampleModel(raster);
                int[] existingArray = ImageIOUtils.getIndirectArray(optionalExistingOutput, width * height, int[].class);
                IntBuffer output = null;
                if (!allowDeoptimizingDirectRead || ImageIOUtils.isSubRaster(raster)) {
                    array = (int[])raster.getDataElements(0, 0, width, height, existingArray);
                } else {
                    array = ImageIOUtils.checkDataBuffer(raster, DataBufferInt.class).getData();
                    if (optionalExistingOutput instanceof IntBuffer && (output = (IntBuffer)optionalExistingOutput) != null && output.capacity() == width * height) {
                        if (output.array() != null) {
                            System.arraycopy(array, 0, output.array(), 0, width * height);
                        } else {
                            output.duplicate().put(array);
                        }
                    }
                }
                if (output == null) {
                    output = IntBuffer.wrap(array);
                }
                return directBuffer && !output.isDirect() ? NIOUtils.directCopy(output, byteOrder) : output;
            }
        }, new ImageInfo.ImageDataSetter<BufferedImage>(){

            @Override
            public void setData(BufferedImage image, Buffer inputBuffer, boolean allowDeoptimizingDirectWrite) {
                int[] inputArray;
                int width = image.getWidth();
                int height = image.getHeight();
                WritableRaster raster = ImageIOUtils.checkWritableRaster(image);
                ImageIOUtils.checkSinglePixelPackedSampleModel(raster);
                IntBuffer input = ImageIOUtils.checkBuffer(inputBuffer, IntBuffer.class);
                int[] nArray = inputArray = input.isDirect() ? null : input.array();
                if (allowDeoptimizingDirectWrite && input.isDirect()) {
                    int[] outputArray = ImageIOUtils.checkDataBuffer(raster, DataBufferInt.class).getData();
                    IntBuffer.wrap(outputArray).put(input.duplicate());
                    return;
                }
                if (inputArray == null) {
                    inputArray = new int[width * height];
                    input.duplicate().get(inputArray);
                }
                raster.setDataElements(0, 0, width, height, inputArray);
            }
        }, IntBuffer.class, 1, 4);
    }

    public static ImageInfo<?> getImageInfo(Image image) {
        if (image instanceof BufferedImage) {
            return ImageIOUtils.getBufferedImageInfo(((BufferedImage)image).getType());
        }
        return ImageIOUtils.getGenericImageInfo();
    }

    public static ImageInfo<BufferedImage> getBufferedImageInfo(int bufferedImageType) {
        switch (bufferedImageType) {
            case 2: {
                return ImageIOUtils.getIntARGBImageInfo();
            }
            case 10: {
                return ImageIOUtils.getByteGrayImageInfo();
            }
            case 11: {
                return ImageIOUtils.getShortGrayImageInfo();
            }
        }
        return ImageIOUtils.getGenericImageInfo();
    }

    public static ImageInfo<BufferedImage> getBufferedImageInfo(CLImageFormat imageFormat) {
        if (imageFormat == null || imageFormat.getChannelOrder() == null || imageFormat.getChannelDataType() == null) {
            return null;
        }
        switch (imageFormat.getChannelOrder()) {
            case BGRA: 
            case RGBA: {
                switch (imageFormat.getChannelDataType()) {
                    case UNormInt16: 
                    case UnsignedInt16: 
                    case SignedInt16: {
                        return ImageIOUtils.getARGBShortGrayImageInfo(imageFormat);
                    }
                }
            }
        }
        return ImageIOUtils.getBufferedImageInfo(ImageIOUtils.getBufferedImageType(imageFormat));
    }

    static int getBufferedImageType(CLImageFormat imageFormat) {
        if (imageFormat == null || imageFormat.getChannelOrder() == null || imageFormat.getChannelDataType() == null) {
            return 0;
        }
        switch (imageFormat.getChannelOrder()) {
            case INTENSITY: 
            case LUMINANCE: {
                switch (imageFormat.getChannelDataType()) {
                    case UNormInt8: 
                    case UnsignedInt8: 
                    case SignedInt8: {
                        return 10;
                    }
                    case UNormInt16: 
                    case UnsignedInt16: 
                    case SignedInt16: {
                        return 11;
                    }
                }
                return 0;
            }
            case BGRA: 
            case RGBA: 
            case ARGB: {
                switch (imageFormat.getChannelDataType()) {
                    case UNormInt8: 
                    case UnsignedInt8: 
                    case SignedInt8: {
                        return 2;
                    }
                }
                return 0;
            }
            case RGB: {
                switch (imageFormat.getChannelDataType()) {
                    case UNormInt8: 
                    case UnsignedInt8: 
                    case SignedInt8: {
                        return 4;
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImageInfo<I extends Image> {
        public final int bufferedImageType;
        public final CLImageFormat clImageFormat;
        public final ImageDataGetter<I> dataGetter;
        public final ImageDataSetter<I> dataSetter;
        public final Class<? extends Buffer> bufferClass;
        public final int channelCount;
        public final int pixelByteSize;

        public ImageInfo(int bufferedImageType, CLImageFormat clImageFormat, ImageDataGetter dataGetter, ImageDataSetter dataSetter, Class<? extends Buffer> bufferClass, int channelCount, int pixelByteSize) {
            this.bufferedImageType = bufferedImageType;
            this.clImageFormat = clImageFormat;
            this.dataGetter = dataGetter;
            this.dataSetter = dataSetter;
            this.bufferClass = bufferClass;
            this.channelCount = channelCount;
            this.pixelByteSize = pixelByteSize;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface ImageDataSetter<I extends Image> {
            public void setData(I var1, Buffer var2, boolean var3);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface ImageDataGetter<I extends Image> {
            public Buffer getData(I var1, Buffer var2, boolean var3, boolean var4, ByteOrder var5);
        }
    }
}

