/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.experiment;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.tools.JComponents.JComboBoxMs;

public class Intervals
extends JPanel {
    private static final long serialVersionUID = -5739112045358747277L;
    Long val = 0L;
    Long min = 0L;
    Long max = 10000L;
    Long step = 1L;
    Long maxLast = 99999999L;
    JSpinner frameFirstJSpinner = new JSpinner(new SpinnerNumberModel(this.val, this.min, this.max, this.step));
    JSpinner frameLastJSpinner = new JSpinner(new SpinnerNumberModel(this.maxLast, this.step, this.maxLast, this.step));
    JSpinner binSizeJSpinner = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 1000.0, 1.0));
    JComboBoxMs binUnit = new JComboBoxMs();
    JButton applyButton = new JButton("Apply changes");
    JButton refreshButton = new JButton("Refresh");
    private MultiSPOTS parent0 = null;

    void init(GridLayout capLayout, MultiSPOTS parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        int bWidth = 50;
        int bHeight = 21;
        this.binSizeJSpinner.setPreferredSize(new Dimension(bWidth, bHeight));
        FlowLayout layout1 = new FlowLayout(0);
        layout1.setVgap(1);
        JPanel panel0 = new JPanel(layout1);
        panel0.add(new JLabel("Frame ", 4));
        panel0.add(this.frameFirstJSpinner);
        panel0.add(new JLabel(" to "));
        panel0.add(this.frameLastJSpinner);
        this.add(panel0);
        JPanel panel1 = new JPanel(layout1);
        panel1.add(new JLabel("Time between frames ", 4));
        panel1.add(this.binSizeJSpinner);
        panel1.add(this.binUnit);
        this.add(panel1);
        panel1.add(this.refreshButton);
        panel1.add(this.applyButton);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Intervals)Intervals.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Intervals.this.setExptParms(exp);
                }
            }
        });
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Intervals)Intervals.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Intervals.this.refreshBinSize(exp);
                }
            }
        });
    }

    private void setExptParms(Experiment exp) {
        long bin_ms = exp.camImageBin_ms = (long)((Double)this.binSizeJSpinner.getValue() * (double)this.binUnit.getMsUnitValue());
        exp.frameFirst = (Long)this.frameFirstJSpinner.getValue();
        exp.binFirst_ms = exp.frameFirst * bin_ms;
        exp.binLast_ms = (Long)this.frameLastJSpinner.getValue() * bin_ms;
    }

    public void getExptParms(Experiment exp) {
        this.refreshBinSize(exp);
        long bin_ms = exp.camImageBin_ms;
        long dFirst = exp.frameFirst;
        this.frameFirstJSpinner.setValue(dFirst);
        if (exp.binLast_ms <= 0L) {
            exp.binLast_ms = (long)exp.getSeqCamSizeT() * bin_ms;
        }
        long dLast = exp.binLast_ms / bin_ms;
        this.frameLastJSpinner.setValue(dLast);
        exp.getFileIntervalsFromSeqCamData();
    }

    private void refreshBinSize(Experiment exp) {
        exp.loadFileIntervalsFromSeqCamData();
        this.binUnit.setSelectedIndex(1);
        this.binSizeJSpinner.setValue((double)exp.camImageBin_ms / (double)this.binUnit.getMsUnitValue());
    }
}

