/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.flies;

import icy.gui.dialog.MessageDialog;
import icy.gui.viewer.Viewer;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.util.StringUtil;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Cage;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.kernel.roi.roi2d.ROI2DPoint;

public class Edit
extends JPanel {
    private static final long serialVersionUID = -5257698990389571518L;
    private MultiSPOTS parent0;
    private JButton findAllButton = new JButton(new String("Find all missed points"));
    private JButton findNextButton = new JButton(new String("Find next missed point"));
    private JButton validateButton = new JButton(new String("Validate selected ROI"));
    private JButton validateAndNextButton = new JButton(new String("Validate and find next"));
    private JComboBox<String> foundCombo = new JComboBox();
    private int foundT = -1;
    private int foundCage = -1;

    void init(GridLayout capLayout, MultiSPOTS parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.findAllButton);
        panel1.add(this.foundCombo);
        this.add(panel1);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(this.findNextButton);
        panel2.add(this.validateButton);
        this.add(panel2);
        JPanel panel3 = new JPanel(flowLayout);
        panel3.add(this.validateAndNextButton);
        this.add(panel3);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.validateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Edit)Edit.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    exp.saveDetRoisToPositions();
                }
            }
        });
        this.findNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Edit)Edit.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Edit.this.findFirstMissed(exp);
                }
            }
        });
        this.validateAndNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Edit)Edit.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    exp.saveDetRoisToPositions();
                    Edit.this.findFirstMissed(exp);
                }
            }
        });
        this.findAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Edit)Edit.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Edit.this.findAllMissedPoints(exp);
                }
            }
        });
        this.foundCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Edit.this.foundCombo.getItemCount() == 0) {
                    return;
                }
                Experiment exp = (Experiment)((Edit)Edit.this).parent0.expListCombo.getSelectedItem();
                if (exp == null) {
                    return;
                }
                String filter = (String)Edit.this.foundCombo.getSelectedItem();
                int indexT = StringUtil.parseInt((String)filter.substring(filter.indexOf("_") + 1), (int)-1);
                if (indexT < 0) {
                    return;
                }
                Edit.this.selectImageT(exp, indexT);
                ArrayList roiList = exp.seqCamData.seq.getROI2Ds();
                for (ROI2D roi : roiList) {
                    String csName = roi.getName();
                    if (!(roi instanceof ROI2DPoint) || !csName.equals(filter)) continue;
                    Edit.this.moveROItoCageCenter(exp, roi, indexT);
                    Edit.this.selectImageT(exp, roi.getT());
                    break;
                }
            }
        });
    }

    void findFirstMissed(Experiment exp) {
        if (this.findFirst(exp)) {
            this.selectImageT(exp, this.foundT);
            Cage cage = exp.cages.getCageFromNumber(this.foundCage);
            String name = "det" + cage.getCageNumber() + "_" + this.foundT;
            this.foundCombo.setSelectedItem(name);
        } else {
            MessageDialog.showDialog((String)"no missed point found", (int)1);
        }
    }

    boolean findFirst(Experiment exp) {
        int dataSize = exp.seqCamData.nTotalFrames;
        this.foundT = -1;
        this.foundCage = -1;
        for (int frame = 0; frame < dataSize; ++frame) {
            for (Cage cage : exp.cages.cagesList) {
                Rectangle2D rect;
                if (frame >= cage.flyPositions.flyPositionList.size() || (rect = cage.flyPositions.flyPositionList.get((int)frame).rectPosition).getX() != -1.0 || rect.getY() != -1.0) continue;
                this.foundT = cage.flyPositions.flyPositionList.get((int)frame).flyIndexT;
                this.foundCage = cage.getCageNumberInteger();
                return true;
            }
        }
        return this.foundT != -1;
    }

    void selectImageT(Experiment exp, int t) {
        Viewer viewer = exp.seqCamData.seq.getFirstViewer();
        viewer.setPositionT(t);
    }

    void findAllMissedPoints(Experiment exp) {
        this.foundCombo.removeAllItems();
        int dataSize = exp.seqCamData.nTotalFrames;
        for (int frame = 0; frame < dataSize; ++frame) {
            for (Cage cage : exp.cages.cagesList) {
                Rectangle2D rect;
                if (frame >= cage.flyPositions.flyPositionList.size() || (rect = cage.flyPositions.flyPositionList.get((int)frame).rectPosition).getX() != -1.0 || rect.getY() != -1.0) continue;
                String name = "det" + cage.getCageNumber() + "_" + cage.flyPositions.flyPositionList.get((int)frame).flyIndexT;
                this.foundCombo.addItem(name);
            }
        }
        if (this.foundCombo.getItemCount() == 0) {
            MessageDialog.showDialog((String)"no missed point found", (int)1);
        }
    }

    private int getCageNumberFromName(String name) {
        int cagenumber = -1;
        String strCageNumber = name.substring(4, 6);
        try {
            return Integer.parseInt(strCageNumber);
        }
        catch (NumberFormatException e) {
            return cagenumber;
        }
    }

    void moveROItoCageCenter(Experiment exp, ROI2D roi, int frame) {
        roi.setColor(Color.RED);
        exp.seqCamData.seq.setSelectedROI((ROI)roi);
        String csName = roi.getName();
        int cageNumber = this.getCageNumberFromName(csName);
        if (cageNumber >= 0) {
            Cage cage = exp.cages.getCageFromNumber(cageNumber);
            Rectangle2D rect0 = cage.flyPositions.flyPositionList.get((int)frame).rectPosition;
            if (rect0.getX() == -1.0 && rect0.getY() == -1.0) {
                Rectangle rect = cage.cageRoi2D.getBounds();
                Point2D.Double point2 = new Point2D.Double(rect.x + rect.width / 2, rect.y + rect.height / 2);
                roi.setPosition2D((Point2D)point2);
            }
        }
    }
}

