/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.kymos;

import icy.util.StringUtil;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.dlg.kymos.EnumStatusComputation;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.series.BuildSeriesOptions;
import plugins.fmp.multiSPOTS.series.BuildSpotsKymos;

public class Create
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1771360416354320887L;
    private String detectString = "Start";
    JButton startComputationButton = new JButton("Start");
    JCheckBox allSeriesCheckBox = new JCheckBox("ALL series (current to last)", false);
    JCheckBox concurrentDisplayCheckBox = new JCheckBox("concurrent display", false);
    Long val = 0L;
    Long min = 0L;
    Long max = 10000L;
    Long step = 1L;
    Long maxLast = 99999999L;
    JSpinner frameFirstJSpinner = new JSpinner(new SpinnerNumberModel(this.val, this.min, this.max, this.step));
    JSpinner frameLastJSpinner = new JSpinner(new SpinnerNumberModel(this.maxLast, this.step, this.maxLast, this.step));
    JSpinner frameDeltaJSpinner = new JSpinner(new SpinnerNumberModel((Number)1L, Long.valueOf(1L), Long.valueOf(100L), (Number)1L));
    EnumStatusComputation sComputation = EnumStatusComputation.START_COMPUTATION;
    private MultiSPOTS parent0 = null;
    private BuildSpotsKymos threadBuildKymo = null;

    void init(GridLayout capLayout, MultiSPOTS parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout layoutLeft = new FlowLayout(0);
        JPanel panel0 = new JPanel(layoutLeft);
        ((FlowLayout)panel0.getLayout()).setVgap(1);
        panel0.add(this.startComputationButton);
        panel0.add(this.allSeriesCheckBox);
        panel0.add(this.concurrentDisplayCheckBox);
        this.add(panel0);
        JPanel panel1 = new JPanel(layoutLeft);
        panel1.add(new JLabel("Frame ", 4));
        panel1.add(this.frameFirstJSpinner);
        panel1.add(new JLabel(" to "));
        panel1.add(this.frameLastJSpinner);
        this.add(panel1);
        JPanel panel2 = new JPanel(layoutLeft);
        panel2.add(new JLabel("Ratio: 1 to ", 4));
        panel2.add(this.frameDeltaJSpinner);
        panel2.add(new JLabel(" image(s)"));
        this.add(panel2);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.startComputationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Create.this.startComputationButton.getText().equals(Create.this.detectString)) {
                    Create.this.startComputation();
                } else {
                    Create.this.stopComputation();
                }
            }
        });
        this.allSeriesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = Color.BLACK;
                if (Create.this.allSeriesCheckBox.isSelected()) {
                    color = Color.RED;
                }
                Create.this.allSeriesCheckBox.setForeground(color);
                Create.this.startComputationButton.setForeground(color);
            }
        });
    }

    private void setExptParms(Experiment exp) {
        long bin_ms = exp.camImageBin_ms;
        exp.frameFirst = (Long)this.frameFirstJSpinner.getValue();
        exp.frameDelta = (Long)this.frameDeltaJSpinner.getValue();
        exp.binFirst_ms = exp.frameFirst * bin_ms;
        exp.binLast_ms = (Long)this.frameLastJSpinner.getValue() * bin_ms;
    }

    public void getExptParms(Experiment exp) {
        long bin_ms = exp.camImageBin_ms;
        long dFirst = exp.frameFirst;
        this.frameFirstJSpinner.setValue(dFirst);
        this.frameDeltaJSpinner.setValue(exp.frameDelta);
        if (exp.binLast_ms <= 0L) {
            exp.binLast_ms = (long)exp.getSeqCamSizeT() * bin_ms;
        }
        long dLast = exp.binLast_ms / bin_ms;
        this.frameLastJSpinner.setValue(dLast);
        exp.getFileIntervalsFromSeqCamData();
    }

    private BuildSeriesOptions initBuildParameters(Experiment exp) {
        this.setExptParms(exp);
        BuildSeriesOptions options = new BuildSeriesOptions();
        options.expList = this.parent0.expListCombo;
        options.expList.index0 = this.parent0.expListCombo.getSelectedIndex();
        options.expList.index1 = this.allSeriesCheckBox.isSelected() ? this.parent0.expListCombo.getItemCount() - 1 : options.expList.index0;
        options.isFrameFixed = false;
        exp.loadFileIntervalsFromSeqCamData();
        options.t_Ms_First = exp.camImageFirst_ms;
        options.t_Ms_Last = exp.camImageLast_ms;
        options.t_Ms_BinDuration = exp.camImageBin_ms;
        options.doCreateBinDir = true;
        options.parent0Rect = this.parent0.mainFrame.getBoundsInternal();
        options.binSubDirectory = "bin_" + options.t_Ms_BinDuration / 1000L;
        options.concurrentDisplay = this.concurrentDisplayCheckBox.isSelected();
        return options;
    }

    private void startComputation() {
        this.sComputation = EnumStatusComputation.STOP_COMPUTATION;
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            this.parent0.dlgSpots.tabFile.saveSpotsArray_file(exp);
        }
        this.threadBuildKymo = new BuildSpotsKymos();
        this.threadBuildKymo.options = this.initBuildParameters(exp);
        this.threadBuildKymo.addPropertyChangeListener(this);
        this.threadBuildKymo.execute();
        this.startComputationButton.setText("STOP");
    }

    private void stopComputation() {
        if (this.threadBuildKymo != null && !this.threadBuildKymo.stopFlag) {
            this.threadBuildKymo.stopFlag = true;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (StringUtil.equals((String)"thread_ended", (String)evt.getPropertyName())) {
            this.startComputationButton.setText(this.detectString);
        }
    }
}

