/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.spots;

import icy.image.IcyBufferedImage;
import icy.painter.Overlay;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.adufour.quickhull.QuickHull2D;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.Spot;
import plugins.fmp.multiSPOTS.series.BuildSeriesOptions;
import plugins.fmp.multiSPOTS.tools.Canvas2D.Canvas2D_2Transforms;
import plugins.fmp.multiSPOTS.tools.ImageTransform.ImageTransformEnums;
import plugins.fmp.multiSPOTS.tools.ImageTransform.ImageTransformInterface;
import plugins.fmp.multiSPOTS.tools.ImageTransform.ImageTransformOptions;
import plugins.fmp.multiSPOTS.tools.Overlay.OverlayThreshold;
import plugins.fmp.multiSPOTS.tools.ROI2D.ROI2DMeasures;
import plugins.fmp.multiSPOTS.tools.ROI2D.ROI2DUtilities;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class Shape
extends JPanel {
    private static final long serialVersionUID = 4950182090521600937L;
    private JButton detectContoursButton = new JButton("Detect spots contours");
    private JButton cutAndInterpolateButton = new JButton("Cut");
    private JLabel spotsFilterLabel = new JLabel("Spots filter");
    private String[] directions = new String[]{" threshold >", " threshold <"};
    ImageTransformEnums[] transforms = new ImageTransformEnums[]{ImageTransformEnums.R_RGB, ImageTransformEnums.G_RGB, ImageTransformEnums.B_RGB, ImageTransformEnums.R2MINUS_GB, ImageTransformEnums.G2MINUS_RB, ImageTransformEnums.B2MINUS_RG, ImageTransformEnums.RGB, ImageTransformEnums.GBMINUS_2R, ImageTransformEnums.RBMINUS_2G, ImageTransformEnums.RGMINUS_2B, ImageTransformEnums.RGB_DIFFS, ImageTransformEnums.H_HSB, ImageTransformEnums.S_HSB, ImageTransformEnums.B_HSB};
    private JComboBox<ImageTransformEnums> spotsTransformsComboBox = new JComboBox<ImageTransformEnums>(this.transforms);
    private JComboBox<String> spotsDirectionComboBox = new JComboBox<String>(this.directions);
    private JSpinner spotsThresholdSpinner = new JSpinner(new SpinnerNumberModel(35, 0, 255, 1));
    private JCheckBox spotsOverlayCheckBox = new JCheckBox("overlay");
    private JToggleButton spotsViewButton = new JToggleButton("View");
    private OverlayThreshold overlayThreshold = null;
    private MultiSPOTS parent0 = null;

    void init(GridLayout gridLayout, MultiSPOTS parent0) {
        this.setLayout(gridLayout);
        this.parent0 = parent0;
        FlowLayout layoutLeft = new FlowLayout(0);
        layoutLeft.setVgap(0);
        JPanel panel0 = new JPanel(layoutLeft);
        panel0.add(this.detectContoursButton);
        this.add(panel0);
        JPanel panel1 = new JPanel(layoutLeft);
        panel1.add(this.spotsFilterLabel);
        panel1.add(this.spotsTransformsComboBox);
        panel1.add(this.spotsDirectionComboBox);
        panel1.add(this.spotsThresholdSpinner);
        panel1.add(this.spotsViewButton);
        panel1.add(this.spotsOverlayCheckBox);
        this.add(panel1);
        JPanel panel2 = new JPanel(layoutLeft);
        panel2.add(this.cutAndInterpolateButton);
        this.add(panel2);
        this.spotsTransformsComboBox.setSelectedItem((Object)ImageTransformEnums.RGB_DIFFS);
        this.spotsDirectionComboBox.setSelectedIndex(1);
        this.declareListeners();
    }

    private void declareListeners() {
        this.spotsOverlayCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Experiment exp = (Experiment)((Shape)Shape.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    if (Shape.this.spotsOverlayCheckBox.isSelected()) {
                        Shape.this.updateOverlay(exp);
                        Shape.this.updateOverlayThreshold();
                    } else {
                        Shape.this.removeOverlay(exp);
                        Shape.this.overlayThreshold = null;
                    }
                }
            }
        });
        this.spotsTransformsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Shape)Shape.this).parent0.expListCombo.getSelectedItem();
                if (exp != null && exp.seqSpotKymos != null) {
                    int index = Shape.this.spotsTransformsComboBox.getSelectedIndex();
                    Canvas2D_2Transforms canvas = (Canvas2D_2Transforms)exp.seqCamData.seq.getFirstViewer().getCanvas();
                    Shape.this.updateTransformFunctionsOfCanvas(exp);
                    if (!Shape.this.spotsViewButton.isSelected()) {
                        Shape.this.spotsViewButton.setSelected(true);
                    }
                    canvas.transformsComboStep1.setSelectedIndex(index + 1);
                    Shape.this.updateOverlayThreshold();
                }
            }
        });
        this.spotsDirectionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Shape.this.updateOverlayThreshold();
            }
        });
        this.spotsThresholdSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Shape.this.updateOverlayThreshold();
            }
        });
        this.spotsViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Shape)Shape.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Shape.this.displayTransform(exp);
                }
            }
        });
        this.detectContoursButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Shape)Shape.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    ROI2DUtilities.removeRoisContainingString(-1, "_mask", exp.seqCamData.seq);
                    Shape.this.detectContours(exp);
                    ((Shape)Shape.this).parent0.dlgSpots.tabFile.saveSpotsArray_file(exp);
                }
            }
        });
        this.cutAndInterpolateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Shape)Shape.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Shape.this.cutAndInterpolate(exp);
                    ((Shape)Shape.this).parent0.dlgSpots.tabFile.saveSpotsArray_file(exp);
                }
            }
        });
    }

    void updateOverlay(Experiment exp) {
        if (this.overlayThreshold == null) {
            this.overlayThreshold = new OverlayThreshold(exp.seqCamData.seq);
        } else {
            exp.seqCamData.seq.removeOverlay((Overlay)this.overlayThreshold);
            this.overlayThreshold.setSequence(exp.seqCamData.seq);
        }
        exp.seqCamData.seq.addOverlay((Overlay)this.overlayThreshold);
    }

    void removeOverlay(Experiment exp) {
        if (exp.seqCamData != null && exp.seqCamData.seq != null) {
            exp.seqCamData.seq.removeOverlay((Overlay)this.overlayThreshold);
        }
    }

    void updateOverlayThreshold() {
        Experiment exp;
        if (!this.spotsOverlayCheckBox.isSelected()) {
            return;
        }
        if (this.overlayThreshold == null && (exp = (Experiment)this.parent0.expListCombo.getSelectedItem()) != null) {
            this.updateOverlay(exp);
        }
        boolean ifGreater = this.spotsDirectionComboBox.getSelectedIndex() == 0;
        int threshold = (Integer)this.spotsThresholdSpinner.getValue();
        ImageTransformEnums transform = (ImageTransformEnums)((Object)this.spotsTransformsComboBox.getSelectedItem());
        this.overlayThreshold.setThresholdSingle(threshold, transform, ifGreater);
        this.overlayThreshold.painterChanged();
    }

    private BuildSeriesOptions initDetectOptions(Experiment exp) {
        BuildSeriesOptions options = new BuildSeriesOptions();
        options.expList = this.parent0.expListCombo;
        options.expList.index0 = this.parent0.expListCombo.getSelectedIndex();
        options.expList.index1 = this.parent0.expListCombo.getSelectedIndex();
        options.detectAllSeries = false;
        options.seriesFirst = 0;
        options.transform01 = (ImageTransformEnums)((Object)this.spotsTransformsComboBox.getSelectedItem());
        options.spotThresholdUp = this.spotsDirectionComboBox.getSelectedIndex() == 0;
        options.spotThreshold = (Integer)this.spotsThresholdSpinner.getValue();
        options.analyzePartOnly = false;
        options.overlayTransform = (ImageTransformEnums)((Object)this.spotsTransformsComboBox.getSelectedItem());
        options.overlayIfGreater = this.spotsDirectionComboBox.getSelectedIndex() == 0;
        options.overlayThreshold = (Integer)this.spotsThresholdSpinner.getValue();
        return options;
    }

    private void displayTransform(Experiment exp) {
        boolean displayCheckOverlay = false;
        if (this.spotsViewButton.isSelected()) {
            this.updateTransformFunctionsOfCanvas(exp);
            displayCheckOverlay = true;
        } else {
            this.removeOverlay(exp);
            this.spotsOverlayCheckBox.setSelected(false);
            Canvas2D_2Transforms canvas = (Canvas2D_2Transforms)exp.seqCamData.seq.getFirstViewer().getCanvas();
            canvas.transformsComboStep1.setSelectedIndex(0);
        }
        this.spotsOverlayCheckBox.setEnabled(displayCheckOverlay);
    }

    private void updateTransformFunctionsOfCanvas(Experiment exp) {
        Canvas2D_2Transforms canvas = (Canvas2D_2Transforms)exp.seqCamData.seq.getFirstViewer().getCanvas();
        if (canvas.transformsComboStep1.getItemCount() < this.spotsTransformsComboBox.getItemCount() + 1) {
            canvas.updateTransformsComboStep1(this.transforms);
        }
        int index = this.spotsTransformsComboBox.getSelectedIndex();
        canvas.selectImageTransformFunctionStep1(index + 1);
    }

    private void detectContours(Experiment exp) {
        BuildSeriesOptions options = this.initDetectOptions(exp);
        ImageTransformOptions transformOptions = new ImageTransformOptions();
        transformOptions.transformOption = options.transform01;
        transformOptions.setSingleThreshold(options.spotThreshold, options.spotThresholdUp);
        ImageTransformInterface transformFunction = options.transform01.getFunction();
        Sequence seq = exp.seqCamData.seq;
        int t = seq.getFirstViewer().getPositionT();
        IcyBufferedImage sourceImage = seq.getImage(t, 0);
        IcyBufferedImage workImage = transformFunction.getTransformedImage(sourceImage, transformOptions);
        for (Spot spot : exp.spotsArray.spotsList) {
            exp.seqCamData.seq.removeROI((ROI)spot.getRoi_in());
            try {
                spot.mask2DSpot = spot.getRoi_in().getBooleanMask2D(0, 0, 1, true);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ROI2DPolygon roi0 = ROI2DMeasures.getContourOfDetectedSpot(workImage, spot, options);
            List listPoints = QuickHull2D.computeConvexEnvelope((List)roi0.getPoints());
            ROI2DPolygon roi_new = new ROI2DPolygon(listPoints);
            roi_new.setName(spot.getRoi_in().getName());
            spot.setRoi_old((ROI2DShape)spot.getRoi_in().getCopy());
            spot.setRoi_in((ROI2DShape)roi_new);
            exp.seqCamData.seq.addROI((ROI)spot.getRoi_in());
        }
    }

    private void replaceRoi(Experiment exp, Spot spot, ROI2D roi_old, ROI2D roi_new) {
        spot.setRoi_old((ROI2DShape)roi_old);
        exp.seqCamData.seq.removeROI((ROI)roi_new);
        exp.seqCamData.seq.removeROI((ROI)roi_old);
        roi_new.setName(roi_old.getName());
        roi_new.setColor(roi_old.getColor());
        spot.setRoi_in((ROI2DShape)roi_new);
        try {
            spot.spotNPixels = (int)roi_new.getNumberOfPoints();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        exp.seqCamData.seq.addROI((ROI)roi_new);
    }

    void cutAndInterpolate(Experiment exp) {
        ROI2D roi = exp.seqCamData.seq.getSelectedROI2D();
        if (roi == null) {
            return;
        }
        for (Spot spot : exp.spotsArray.spotsList) {
            ROI2D spotRoi = spot.getRoi_in();
            try {
                if (!spotRoi.intersects((ROI)roi)) continue;
                ROI newRoi = spotRoi.getSubtraction((ROI)roi);
                this.replaceRoi(exp, spot, spotRoi, (ROI2D)newRoi);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            break;
        }
    }
}

