/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.spotsMeasures;

import icy.gui.util.GuiUtil;
import icy.image.IcyBufferedImage;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.type.collection.array.Array1DUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.SequenceCamData;
import plugins.fmp.multiSPOTS.tools.ROI2D.ROI2DUtilities;
import plugins.fmp.multiSPOTS.tools.polyline.Line2DPlus;
import plugins.kernel.roi.roi2d.ROI2DLine;

public class Adjust
extends JPanel {
    private static final long serialVersionUID = 1756354919434057560L;
    JSpinner jitterJSpinner = new JSpinner(new SpinnerNumberModel(10, 0, 500, 1));
    private JButton adjustButton = new JButton("Align");
    private MultiSPOTS parent0 = null;
    private Line2D refLineUpper = null;
    private Line2D refLineLower = null;
    private ROI2DLine roiRefLineUpper = new ROI2DLine();
    private ROI2DLine roiRefLineLower = new ROI2DLine();

    void init(GridLayout capLayout, MultiSPOTS parent0) {
        this.setLayout(capLayout);
        this.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel(" "), new JLabel("jitter ", 4), this.jitterJSpinner, this.adjustButton}));
        this.parent0 = parent0;
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.adjustButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object o = e.getSource();
                if (o == Adjust.this.adjustButton) {
                    Adjust.this.roisCenterLinestoAllCapillaries();
                }
            }
        });
    }

    private void roisCenterLinestoAllCapillaries() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        SequenceCamData seqCamData = exp.seqCamData;
        this.refLineUpper = this.roiRefLineUpper.getLine();
        this.refLineLower = this.roiRefLineLower.getLine();
        int chan = 0;
        int jitter = (Integer)this.jitterJSpinner.getValue();
        int t = seqCamData.currentFrame;
        seqCamData.seq.setPositionT((long)t);
        IcyBufferedImage vinputImage = seqCamData.seq.getImage(t, 0, chan);
        if (vinputImage == null) {
            System.out.println("Adjust:roisCenterLinestoAllCapillaries() An error occurred while reading image: " + t);
            return;
        }
        int xwidth = vinputImage.getSizeX();
        double[] sourceValues = Array1DUtil.arrayToDoubleArray((Object)vinputImage.getDataXY(0), (boolean)vinputImage.isSignedDataType());
        List<ROI2D> capillaryRois = ROI2DUtilities.getROIs2DContainingString("line", seqCamData.seq);
        for (ROI2D roi : capillaryRois) {
            if (!(roi instanceof ROI2DLine)) continue;
            Line2D line = this.roisCenterLinetoCapillary(sourceValues, xwidth, (ROI2DLine)roi, jitter);
            ((ROI2DLine)roi).setLine(line);
        }
    }

    private Line2D roisCenterLinetoCapillary(double[] sourceValues, int xwidth, ROI2DLine roi, int jitter) {
        int irightb;
        int irighta;
        Line2DPlus line = new Line2DPlus();
        line.setLine(roi.getLine());
        if (!this.refLineUpper.intersectsLine(line)) {
            return null;
        }
        Point2D.Double pti = line.getIntersection(this.refLineUpper);
        double y = pti.getY();
        double x = pti.getX();
        int lowx = (int)x - jitter;
        if (lowx < 0) {
            lowx = 0;
        }
        int ixa = (int)x;
        int iya = (int)y;
        double sumVala = 0.0;
        double[] arrayVala = new double[2 * jitter + 1];
        int iarray = 0;
        int ix = lowx;
        while (ix <= lowx + 2 * jitter) {
            arrayVala[iarray] = sourceValues[iya * xwidth + ix];
            sumVala += arrayVala[iarray];
            ++ix;
            ++iarray;
        }
        double avgVala = sumVala / (double)(2 * jitter + 1);
        int ilefta = 0;
        for (int i = 0; i < 2 * jitter; ++i) {
            if (!(arrayVala[i] < avgVala)) continue;
            ilefta = i;
            break;
        }
        for (int i = irighta = 2 * jitter; i >= 0; --i) {
            if (!(arrayVala[i] < avgVala)) continue;
            irighta = i;
            break;
        }
        if (ilefta > irighta) {
            return null;
        }
        int index = (ilefta + irighta) / 2;
        ixa = lowx + index;
        if (!this.refLineLower.intersectsLine(line)) {
            return null;
        }
        pti = line.getIntersection(this.refLineLower);
        y = pti.getY();
        x = pti.getX();
        lowx = (int)x - jitter;
        if (lowx < 0) {
            lowx = 0;
        }
        int ixb = (int)x;
        int iyb = (int)y;
        double sumValb = 0.0;
        double[] arrayValb = new double[2 * jitter + 1];
        iarray = 0;
        int ix2 = lowx;
        while (ix2 <= lowx + 2 * jitter) {
            arrayValb[iarray] = sourceValues[iyb * xwidth + ix2];
            sumValb += arrayValb[iarray];
            ++ix2;
            ++iarray;
        }
        double avgValb = sumValb / (double)(2 * jitter + 1);
        int ileftb = 0;
        for (int i = 0; i < 2 * jitter; ++i) {
            if (!(arrayValb[i] < avgValb)) continue;
            ileftb = i;
            break;
        }
        for (int i = irightb = 2 * jitter; i >= 0; --i) {
            if (!(arrayValb[i] < avgValb)) continue;
            irightb = i;
            break;
        }
        if (ileftb > irightb) {
            return null;
        }
        index = (ileftb + irightb) / 2;
        ixb = lowx + index;
        double y1 = line.getY1();
        double y2 = line.getY2();
        line.x1 = ixa;
        line.y1 = iya;
        line.x2 = ixb;
        line.y2 = iyb;
        double x1 = line.getXfromY(y1);
        double x2 = line.getXfromY(y2);
        Line2D.Double line_out = new Line2D.Double(x1, y1, x2, y2);
        return line_out;
    }

    void roisDisplayrefBar(boolean display) {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        SequenceCamData seqCamData = exp.seqCamData;
        if (seqCamData == null) {
            return;
        }
        if (display) {
            int seqheight = seqCamData.seq.getHeight();
            int seqwidth = seqCamData.seq.getWidth();
            this.refLineUpper = new Line2D.Double(0.0, seqheight / 3, seqwidth, seqheight / 3);
            this.refLineLower = new Line2D.Double(0.0, 2 * seqheight / 3, seqwidth, 2 * seqheight / 3);
            List<ROI2D> capillaryRois = ROI2DUtilities.getROIs2DContainingString("line", seqCamData.seq);
            Rectangle extRect = new Rectangle(capillaryRois.get(0).getBounds());
            for (ROI2D roi : capillaryRois) {
                Rectangle rect = roi.getBounds();
                extRect.add(rect);
            }
            extRect.grow(extRect.width * 1 / 10, -extRect.height * 2 / 10);
            this.refLineUpper.setLine(extRect.getX(), extRect.getY(), extRect.getX() + extRect.getWidth(), extRect.getY());
            this.refLineLower.setLine(extRect.getX(), extRect.getY() + extRect.getHeight(), extRect.getX() + extRect.getWidth(), extRect.getY() + extRect.getHeight());
            this.roiRefLineUpper.setLine(this.refLineUpper);
            this.roiRefLineLower.setLine(this.refLineLower);
            this.roiRefLineUpper.setName("refBarUpper");
            this.roiRefLineUpper.setColor(Color.YELLOW);
            this.roiRefLineLower.setName("refBarLower");
            this.roiRefLineLower.setColor(Color.YELLOW);
            seqCamData.seq.addROI((ROI)this.roiRefLineUpper);
            seqCamData.seq.addROI((ROI)this.roiRefLineLower);
        } else {
            seqCamData.seq.removeROI((ROI)this.roiRefLineUpper);
            seqCamData.seq.removeROI((ROI)this.roiRefLineLower);
        }
    }
}

