/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.spotsMeasures;

import icy.gui.component.PopupPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.dlg.spotsMeasures.SpotsMeasuresEdit;
import plugins.fmp.multiSPOTS.dlg.spotsMeasures.SpotsMeasuresGraphs;
import plugins.fmp.multiSPOTS.dlg.spotsMeasures.SpotsMeasuresLoadSave;
import plugins.fmp.multiSPOTS.dlg.spotsMeasures.SpotsMeasuresThresholdSimple;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.ExperimentUtils;

public class DlgSpotMeasure_
extends JPanel
implements PropertyChangeListener,
ChangeListener {
    private static final long serialVersionUID = 853047648249832145L;
    public PopupPanel capPopupPanel = null;
    JTabbedPane tabsPane = new JTabbedPane();
    SpotsMeasuresThresholdSimple tabSimpleThreshold = new SpotsMeasuresThresholdSimple();
    SpotsMeasuresEdit tabEdit = new SpotsMeasuresEdit();
    public SpotsMeasuresGraphs tabGraphs = new SpotsMeasuresGraphs();
    public SpotsMeasuresLoadSave tabFile = new SpotsMeasuresLoadSave();
    private int id_threshold = 1;
    private MultiSPOTS parent0 = null;

    public void init(JPanel mainPanel, String string, final MultiSPOTS parent0) {
        this.parent0 = parent0;
        this.capPopupPanel = new PopupPanel(string);
        JPanel capPanel = this.capPopupPanel.getMainPanel();
        capPanel.setLayout(new BorderLayout());
        this.capPopupPanel.collapse();
        mainPanel.add((Component)this.capPopupPanel);
        GridLayout gridLayout = new GridLayout(3, 1);
        int order = 0;
        this.tabSimpleThreshold.init(gridLayout, parent0);
        this.tabSimpleThreshold.addPropertyChangeListener(this);
        this.tabsPane.addTab("Simple threshold", null, this.tabSimpleThreshold, "Measure area using a simple transform and threshold");
        this.id_threshold = order++;
        this.tabEdit.init(gridLayout, parent0);
        this.tabEdit.addPropertyChangeListener(this);
        this.tabsPane.addTab("Edit", null, this.tabEdit, "Edit measures (move/cut/extrapolate)");
        ++order;
        this.tabGraphs.init(gridLayout, parent0);
        this.tabGraphs.addPropertyChangeListener(this);
        this.tabsPane.addTab("Graphs", null, this.tabGraphs, "Display results as a graph");
        ++order;
        this.tabFile.init(gridLayout, parent0);
        this.tabFile.addPropertyChangeListener(this);
        this.tabsPane.addTab("Load/Save", null, this.tabFile, "Load/Save xml file with spots descriptors");
        ++order;
        this.tabsPane.setTabLayoutPolicy(1);
        capPanel.add(this.tabsPane);
        this.tabsPane.addChangeListener(this);
        this.capPopupPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                parent0.mainFrame.revalidate();
                parent0.mainFrame.pack();
                parent0.mainFrame.repaint();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("CAP_ROIS_OPEN")) {
            Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
            if (exp != null) {
                this.displayCapillariesInformation(exp);
                this.tabsPane.setSelectedIndex(this.id_threshold);
                this.parent0.dlgExperiment.tabIntervals.getExptParms(exp);
            }
        } else if (event.getPropertyName().equals("CAP_ROIS_SAVE")) {
            this.tabsPane.setSelectedIndex(this.id_threshold);
        }
    }

    public void displayCapillariesInformation(final Experiment exp) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DlgSpotMeasure_.this.updateDialogs(exp);
                ((DlgSpotMeasure_)DlgSpotMeasure_.this).parent0.dlgExperiment.tabOptions.viewSpotsCheckBox.setSelected(true);
            }
        });
    }

    public void updateDialogs(Experiment exp) {
        if (exp != null) {
            ExperimentUtils.transferCamDataROIStoCapillaries(exp);
            exp.capillaries.desc_old.copy(exp.capillaries.capillariesDescription);
            ExperimentUtils.transferCamDataROIStoSpots(exp);
            exp.spotsArray.desc_old.copy(exp.spotsArray.spotsDescription);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
        int selectedIndex = tabbedPane.getSelectedIndex();
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            boolean displayCapillaries;
            boolean bl = displayCapillaries = selectedIndex == this.id_threshold;
            if (displayCapillaries && exp.capillaries.capillariesList.size() < 1) {
                exp.loadCamDataCapillaries();
            }
            exp.seqCamData.displayROIs(displayCapillaries, "line");
            exp.seqCamData.displayROIs(true, "spots");
        }
    }
}

