/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.series;

import icy.gui.frame.progress.ProgressFrame;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageCursor;
import icy.sequence.Sequence;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.ROI2DAlongT;
import plugins.fmp.multiSPOTS.experiment.SequenceCamData;
import plugins.fmp.multiSPOTS.experiment.Spot;
import plugins.fmp.multiSPOTS.series.BuildSeries;
import plugins.fmp.multiSPOTS.series.ResultsThreshold;
import plugins.fmp.multiSPOTS.tools.ImageTransform.ImageTransformInterface;
import plugins.fmp.multiSPOTS.tools.ImageTransform.ImageTransformOptions;

public class BuildSpotsMeasures
extends BuildSeries {
    public Sequence seqData = new Sequence();
    private Viewer vData = null;
    private ImageTransformOptions transformOptions01 = null;
    ImageTransformInterface transformFunctionSpot = null;
    ImageTransformOptions transformOptions02 = null;
    ImageTransformInterface transformFunctionFly = null;

    @Override
    void analyzeExperiment(Experiment exp) {
        this.loadExperimentDataToMeasureSpots(exp);
        this.openViewers(exp);
        this.getTimeLimitsOfSequence(exp);
        if (this.measureSpots(exp)) {
            this.saveComputation(exp);
        }
        this.closeViewers();
    }

    private boolean loadExperimentDataToMeasureSpots(Experiment exp) {
        boolean flag = exp.loadMCSpots_Only();
        exp.seqCamData.seq = exp.seqCamData.initSequenceFromFirstImage(exp.seqCamData.getImagesList(true));
        return flag;
    }

    private void getTimeLimitsOfSequence(Experiment exp) {
        exp.getFileIntervalsFromSeqCamData();
        exp.loadFileIntervalsFromSeqCamData();
        exp.binDuration_ms = exp.camImageBin_ms;
        System.out.println("sequence bin size = " + exp.binDuration_ms);
        if (this.options.isFrameFixed) {
            exp.binFirst_ms = this.options.t_Ms_First;
            exp.binLast_ms = this.options.t_Ms_Last;
            if (exp.binLast_ms + exp.camImageFirst_ms > exp.camImageLast_ms) {
                exp.binLast_ms = exp.camImageLast_ms - exp.camImageFirst_ms;
            }
        } else {
            exp.binFirst_ms = 0L;
            exp.binLast_ms = exp.camImageLast_ms - exp.camImageFirst_ms;
        }
    }

    private void saveComputation(Experiment exp) {
        String directory;
        if (this.options.doCreateBinDir) {
            exp.setBinSubDirectory(exp.getBinNameFromKymoFrameStep());
        }
        if ((directory = exp.getDirectoryToSaveResults()) == null) {
            return;
        }
        exp.spotsArray.transferSumToSumClean();
        exp.spotsArray.initLevel2DMeasures();
        exp.saveXML_MCExperiment();
        exp.save_SpotsMeasures();
    }

    private boolean measureSpots(final Experiment exp) {
        if (exp.spotsArray.spotsList.size() < 1) {
            System.out.println("DetectAreas:measureAreas Abort (1): nbspots = 0");
            return false;
        }
        this.threadRunning = true;
        this.stopFlag = false;
        exp.build_MsTimeIntervalsArray_From_SeqCamData_FileNamesList();
        Processor processor = new Processor(SystemUtil.getNumberOfCPUs());
        processor.setThreadName("buildSpots");
        processor.setPriority(5);
        int ntasks = exp.spotsArray.spotsList.size();
        ArrayList tasks = new ArrayList(ntasks);
        tasks.clear();
        final int tFirst = (int)exp.frameFirst;
        final int tLast = exp.seqCamData.nTotalFrames;
        this.vData.setTitle(exp.seqCamData.getCSCamFileName() + ": " + tFirst + "-" + tLast);
        final ProgressFrame progressBar1 = new ProgressFrame("Analyze stack");
        this.initMasks2D(exp);
        this.initSpotsDataArrays(exp);
        if (this.transformFunctionSpot == null) {
            this.transformOptions01 = new ImageTransformOptions();
            this.transformOptions01.transformOption = this.options.transform01;
            this.transformOptions01.copyResultsToThe3planes = false;
            this.transformOptions01.setSingleThreshold(this.options.spotThreshold, this.options.spotThresholdUp);
            this.transformFunctionSpot = this.options.transform01.getFunction();
            this.transformOptions02 = new ImageTransformOptions();
            this.transformOptions02.transformOption = this.options.transform02;
            this.transformOptions02.copyResultsToThe3planes = false;
            this.transformFunctionFly = this.options.transform02.getFunction();
        }
        int ti = tFirst;
        while (ti < tLast) {
            if (this.options.concurrentDisplay) {
                IcyBufferedImage sourceImage0 = this.imageIORead(exp.seqCamData.getFileNameFromImageList(ti));
                this.seqData.setImage(0, 0, (BufferedImage)sourceImage0);
                this.vData.setTitle("Frame #" + ti + " /" + tLast);
            }
            final int t = ti++;
            tasks.add(processor.submit(new Runnable(){

                @Override
                public void run() {
                    progressBar1.setMessage("Analyze frame: " + t + "//" + tLast);
                    IcyBufferedImage sourceImage = BuildSpotsMeasures.this.imageIORead(exp.seqCamData.getFileNameFromImageList(t));
                    IcyBufferedImage transformToMeasureArea = BuildSpotsMeasures.this.transformFunctionSpot.getTransformedImage(sourceImage, BuildSpotsMeasures.this.transformOptions01);
                    IcyBufferedImage transformToDetectFly = BuildSpotsMeasures.this.transformFunctionFly.getTransformedImage(sourceImage, BuildSpotsMeasures.this.transformOptions02);
                    IcyBufferedImageCursor cursorToDetectFly = new IcyBufferedImageCursor(transformToDetectFly);
                    IcyBufferedImageCursor cursorToMeasureArea = new IcyBufferedImageCursor(transformToMeasureArea);
                    int ii = t - tFirst;
                    for (Spot spot : exp.spotsArray.spotsList) {
                        ROI2DAlongT roiT = spot.getROIAtT(t);
                        ResultsThreshold results = BuildSpotsMeasures.this.measureSpotOverThreshold(cursorToMeasureArea, cursorToDetectFly, roiT);
                        spot.flyPresent.isPresent[ii] = results.nPoints_fly_present;
                        spot.sum_in.values[ii] = results.sumOverThreshold / (double)results.npoints_in;
                        if (results.nPoints_no_fly == results.npoints_in) continue;
                        spot.sum_in.values[ii] = results.sumTot_no_fly_over_threshold / (double)results.nPoints_no_fly;
                    }
                }
            }));
        }
        this.waitFuturesCompletion(processor, tasks, null);
        progressBar1.close();
        return true;
    }

    private ResultsThreshold measureSpotOverThreshold(IcyBufferedImageCursor cursorToMeasureArea, IcyBufferedImageCursor cursorToDetectFly, ROI2DAlongT roiT) {
        ResultsThreshold result = new ResultsThreshold();
        result.npoints_in = roiT.mask2DPoints_in.length;
        for (int offset = 0; offset < roiT.mask2DPoints_in.length; ++offset) {
            Point pt = roiT.mask2DPoints_in[offset];
            int value = (int)cursorToMeasureArea.get((int)pt.getX(), (int)pt.getY(), 0);
            int value_to_detect_fly = (int)cursorToDetectFly.get((int)pt.getX(), (int)pt.getY(), 0);
            boolean isFlyThere = this.isFlyPresent(value_to_detect_fly);
            if (!isFlyThere) {
                ++result.nPoints_no_fly;
            } else {
                ++result.nPoints_fly_present;
            }
            if (!this.isOverThreshold(value)) continue;
            result.sumOverThreshold += (double)value;
            ++result.nPointsOverThreshold;
            if (isFlyThere) continue;
            result.sumTot_no_fly_over_threshold += (double)value;
        }
        return result;
    }

    private boolean isFlyPresent(double value) {
        boolean flag;
        boolean bl = flag = value > (double)this.options.flyThreshold;
        if (!this.options.flyThresholdUp) {
            flag = !flag;
        }
        return flag;
    }

    private boolean isOverThreshold(double value) {
        boolean flag;
        boolean bl = flag = value > (double)this.options.spotThreshold;
        if (!this.options.spotThresholdUp) {
            flag = !flag;
        }
        return flag;
    }

    private void initSpotsDataArrays(Experiment exp) {
        int nFrames = exp.seqCamData.nTotalFrames - (int)exp.frameFirst;
        for (Spot spot : exp.spotsArray.spotsList) {
            spot.sum_in.values = new double[nFrames];
            spot.sum_clean.values = new double[nFrames];
            spot.flyPresent.isPresent = new int[nFrames];
        }
    }

    private void initMasks2D(Experiment exp) {
        SequenceCamData seqCamData = exp.seqCamData;
        if (seqCamData.seq == null) {
            seqCamData.seq = exp.seqCamData.initSequenceFromFirstImage(exp.seqCamData.getImagesList(true));
        }
        for (Spot spot : exp.spotsArray.spotsList) {
            List<ROI2DAlongT> listRoiT = spot.getROIAlongTList();
            for (ROI2DAlongT roiT : listRoiT) {
                if (roiT.getMask2D_in() != null) continue;
                roiT.buildMask2DFromRoi_in();
            }
        }
    }

    private void closeViewers() {
        this.closeViewer(this.vData);
        this.closeSequence(this.seqData);
    }

    private void openViewers(final Experiment exp) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BuildSpotsMeasures.this.seqData = BuildSpotsMeasures.this.newSequence(exp.seqCamData.getCSCamFileName(), exp.seqCamData.getSeqImage(0, 0));
                    BuildSpotsMeasures.this.vData = new Viewer(BuildSpotsMeasures.this.seqData, true);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

