/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.tools.chart;

import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import icy.gui.viewer.Viewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.tools.toExcel.EnumXLSExportType;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSExport;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSExportOptions;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSResults;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSResultsArray;

public class ChartLevels
extends IcyFrame {
    public JPanel mainChartPanel = null;
    public IcyFrame mainChartFrame = null;
    private MultiSPOTS parent0 = null;
    private Point pt = new Point(0, 0);
    private boolean flagMaxMinSet = false;
    private double globalYMax = 0.0;
    private double globalYMin = 0.0;
    private double globalXMax = 0.0;
    private double ymax = 0.0;
    private double ymin = 0.0;
    private double xmax = 0.0;
    private List<JFreeChart> xyChartList = new ArrayList<JFreeChart>();
    private String title;

    public void createChartPanel(MultiSPOTS parent, String cstitle) {
        this.title = cstitle;
        this.parent0 = parent;
        this.mainChartPanel = new JPanel();
        this.mainChartPanel.setLayout(new BoxLayout(this.mainChartPanel, 2));
        this.mainChartFrame = GuiUtil.generateTitleFrame((String)this.title, (JPanel)new JPanel(), (Dimension)new Dimension(300, 70), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        this.mainChartFrame.add((Component)this.mainChartPanel);
    }

    public void setLocationRelativeToRectangle(Rectangle rectv, Point deltapt) {
        this.pt = new Point(rectv.x + deltapt.x, rectv.y + deltapt.y);
    }

    public void setUpperLeftLocation(Rectangle rectv) {
        this.pt = new Point(rectv.x, rectv.y);
    }

    public void displayData(Experiment exp, EnumXLSExportType option, String title, boolean subtractEvaporation) {
        this.xyChartList.clear();
        this.ymax = 0.0;
        this.ymin = 0.0;
        this.flagMaxMinSet = false;
        List<XYSeriesCollection> xyDataSetList = this.getDataArrays(exp, option, subtractEvaporation);
        int icage = 0;
        NumberAxis yAxis = new NumberAxis("volume (\u00b5l)");
        yAxis.setAutoRangeIncludesZero(false);
        yAxis.setInverted(true);
        CombinedRangeXYPlot combinedXYPlot = new CombinedRangeXYPlot((ValueAxis)yAxis);
        Paint[] color = ChartColor.createDefaultPaintArray();
        for (XYSeriesCollection xySeriesCollection : xyDataSetList) {
            NumberAxis xAxis = new NumberAxis("Cage " + icage);
            XYLineAndShapeRenderer subPlotRenderer = new XYLineAndShapeRenderer(true, false);
            XYPlot subplot = new XYPlot((XYDataset)xySeriesCollection, (ValueAxis)xAxis, null, (XYItemRenderer)subPlotRenderer);
            int icolor = 0;
            int i = 0;
            while (i < xySeriesCollection.getSeriesCount()) {
                if (icolor > color.length) {
                    icolor = 0;
                }
                subPlotRenderer.setSeriesPaint(i, color[icolor]);
                ++i;
                ++icolor;
            }
            subplot.setBackgroundPaint((Paint)Color.LIGHT_GRAY);
            subplot.setDomainGridlinePaint((Paint)Color.WHITE);
            subplot.setRangeGridlinePaint((Paint)Color.WHITE);
            combinedXYPlot.add(subplot);
            ++icage;
        }
        JFreeChart chart = new JFreeChart(title, null, (Plot)combinedXYPlot, true);
        int width = 800;
        int height = 300;
        int minimumDrawWidth = width;
        int minimumDrawHeight = 300;
        int maximumDrawWidth = 800;
        int maximumDrawHeight = 500;
        boolean useBuffer = true;
        ChartPanel panel = new ChartPanel(chart, width, height, minimumDrawWidth, minimumDrawHeight, maximumDrawWidth, maximumDrawHeight, useBuffer, true, true, true, false, true);
        panel.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent e) {
                ChartLevels.this.selectKymoImage(ChartLevels.this.getSelectedCurve(e));
            }

            public void chartMouseMoved(ChartMouseEvent e) {
            }
        });
        this.mainChartPanel.add((Component)panel);
        this.mainChartFrame.pack();
        this.mainChartFrame.setLocation(this.pt);
        this.mainChartFrame.addToDesktopPane();
        this.mainChartFrame.setVisible(true);
    }

    private int getSelectedCurve(ChartMouseEvent e) {
        MouseEvent trigger = e.getTrigger();
        if (trigger.getButton() != 1) {
            return -1;
        }
        JFreeChart chart = e.getChart();
        ChartEntity chartEntity = e.getEntity();
        MouseEvent mouseEvent = e.getTrigger();
        int isel = 0;
        if (chartEntity != null && chartEntity instanceof XYItemEntity) {
            XYItemEntity xyItemEntity = (XYItemEntity)e.getEntity();
            isel += xyItemEntity.getSeriesIndex();
        }
        CombinedRangeXYPlot combinedXYPlot = (CombinedRangeXYPlot)chart.getPlot();
        List subplots = combinedXYPlot.getSubplots();
        ChartPanel panel = (ChartPanel)this.mainChartPanel.getComponent(0);
        PlotRenderingInfo plotInfo = panel.getChartRenderingInfo().getPlotInfo();
        Point2D p = panel.translateScreenToJava2D(mouseEvent.getPoint());
        int subplotindex = plotInfo.getSubplotIndex(p);
        for (int i = 0; i < subplotindex; ++i) {
            isel += ((XYPlot)subplots.get(i)).getSeriesCount();
        }
        return isel;
    }

    private void selectKymoImage(int isel) {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        Viewer v = exp.seqSpotKymos.seq.getFirstViewer();
        if (v != null && isel >= 0) {
            v.setPositionT(isel);
        }
    }

    private List<XYSeriesCollection> getDataArrays(Experiment exp, EnumXLSExportType exportType, boolean subtractEvaporation) {
        XLSResultsArray resultsArray1 = this.getDataAsResultsArray(exp, exportType, subtractEvaporation);
        XLSResultsArray resultsArray2 = null;
        if (exportType == EnumXLSExportType.TOPLEVEL) {
            resultsArray2 = this.getDataAsResultsArray(exp, EnumXLSExportType.BOTTOMLEVEL, subtractEvaporation);
        }
        XYSeriesCollection xyDataset = null;
        int oldcage = -1;
        ArrayList<XYSeriesCollection> xyList = new ArrayList<XYSeriesCollection>();
        for (int iRow = 0; iRow < resultsArray1.size(); ++iRow) {
            XLSResults rowXLSResults1 = resultsArray1.getRow(iRow);
            if (oldcage != rowXLSResults1.cageID) {
                xyDataset = new XYSeriesCollection();
                oldcage = rowXLSResults1.cageID;
                xyList.add(xyDataset);
            }
            XYSeries seriesXY = this.getXYSeries(rowXLSResults1, rowXLSResults1.name.substring(4));
            if (resultsArray2 != null) {
                this.appendDataToXYSeries(seriesXY, resultsArray2.getRow(iRow));
            }
            xyDataset.addSeries(seriesXY);
            this.updateGlobalMaxMin();
        }
        return xyList;
    }

    private XLSResultsArray getDataAsResultsArray(Experiment exp, EnumXLSExportType exportType, boolean subtractEvaporation) {
        XLSExportOptions options = new XLSExportOptions();
        options.buildExcelStepMs = 60000;
        options.subtractT0 = true;
        options.subtractEvaporation = subtractEvaporation;
        XLSExport xlsExport = new XLSExport();
        return xlsExport.getSpotDataFromOneExperiment(exp, exportType, options);
    }

    private void updateGlobalMaxMin() {
        if (!this.flagMaxMinSet) {
            this.globalYMax = this.ymax;
            this.globalYMin = this.ymin;
            this.globalXMax = this.xmax;
            this.flagMaxMinSet = true;
        } else {
            if (this.globalYMax < this.ymax) {
                this.globalYMax = this.ymax;
            }
            if (this.globalYMin >= this.ymin) {
                this.globalYMin = this.ymin;
            }
            if (this.globalXMax < this.xmax) {
                this.globalXMax = this.xmax;
            }
        }
    }

    private XYSeries getXYSeries(XLSResults results, String name) {
        XYSeries seriesXY = new XYSeries((Comparable)((Object)name), false);
        if (results.valuesOut != null && results.valuesOut.length > 0) {
            this.xmax = results.valuesOut.length;
            this.ymin = this.ymax = results.valuesOut[0];
            this.addPointsAndUpdateExtrema(seriesXY, results, 0);
        }
        return seriesXY;
    }

    private void appendDataToXYSeries(XYSeries seriesXY, XLSResults results) {
        if (results.valuesOut != null && results.valuesOut.length > 0) {
            seriesXY.add(Double.NaN, Double.NaN);
            this.addPointsAndUpdateExtrema(seriesXY, results, 0);
        }
    }

    private void addPointsAndUpdateExtrema(XYSeries seriesXY, XLSResults results, int startFrame) {
        int x = 0;
        for (double y : results.valuesOut) {
            seriesXY.add((double)(x + startFrame), y);
            if (this.ymax < y) {
                this.ymax = y;
            }
            if (this.ymin > y) {
                this.ymin = y;
            }
            ++x;
        }
    }
}

