/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.tools.toExcel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import plugins.fmp.multiSPOTS.tools.toExcel.EnumXLSExportType;

public class XLSResults {
    public String name = null;
    String stimulus = null;
    String concentration = null;
    int nadded = 1;
    boolean[] padded_out = null;
    public int dimension = 0;
    public int nflies = 1;
    public int cageID = 0;
    public EnumXLSExportType exportType = null;
    public ArrayList<Double> dataValues = null;
    public double[] valuesOut = null;

    public XLSResults(String name, int nflies, int cageID, EnumXLSExportType exportType) {
        this.name = name;
        this.nflies = nflies;
        this.cageID = cageID;
        this.exportType = exportType;
    }

    public XLSResults(String name, int nflies, int cageID, EnumXLSExportType exportType, int nFrames) {
        this.name = name;
        this.nflies = nflies;
        this.cageID = cageID;
        this.exportType = exportType;
        this.initValuesArray(nFrames);
    }

    void initValuesOutArray(int dimension, Double val) {
        this.dimension = dimension;
        this.valuesOut = new double[dimension];
        Arrays.fill(this.valuesOut, val);
    }

    private void initValuesArray(int dimension) {
        this.dimension = dimension;
        this.valuesOut = new double[dimension];
        Arrays.fill(this.valuesOut, Double.NaN);
        this.padded_out = new boolean[dimension];
        Arrays.fill(this.padded_out, false);
    }

    void clearValues(int fromindex) {
        int toindex = this.valuesOut.length;
        if (fromindex > 0 && fromindex < toindex) {
            Arrays.fill(this.valuesOut, fromindex, toindex, Double.NaN);
            Arrays.fill(this.padded_out, fromindex, toindex, false);
        }
    }

    void clearAll() {
        this.dataValues = null;
        this.valuesOut = null;
        this.nflies = 0;
    }

    public void transferMeasuresToValuesOut(double scalingFactorToPhysicalUnits, EnumXLSExportType xlsExport) {
        if (this.dimension == 0 || this.dataValues == null || this.dataValues.size() < 1) {
            return;
        }
        boolean removeZeros = false;
        int len = Math.min(this.dimension, this.dataValues.size());
        if (removeZeros) {
            for (int i = 0; i < len; ++i) {
                double ivalue = this.dataValues.get(i);
                this.valuesOut[i] = (ivalue == 0.0 ? Double.NaN : ivalue) * scalingFactorToPhysicalUnits;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                this.valuesOut[i] = this.dataValues.get(i) * scalingFactorToPhysicalUnits;
            }
        }
    }

    public void copyValuesOut(XLSResults sourceRow) {
        if (sourceRow.valuesOut.length != this.valuesOut.length) {
            this.dimension = sourceRow.dimension;
            this.valuesOut = new double[this.dimension];
        }
        for (int i = 0; i < this.dimension; ++i) {
            this.valuesOut[i] = sourceRow.valuesOut[i];
        }
    }

    public List<Double> subtractT0() {
        if (this.dataValues == null || this.dataValues.size() < 1) {
            return null;
        }
        double item0 = this.dataValues.get(0);
        for (int index = 0; index < this.dataValues.size(); ++index) {
            double value = this.dataValues.get(index);
            this.dataValues.set(index, value - item0);
        }
        return this.dataValues;
    }

    public List<Double> relativeToT(int t) {
        int index;
        if (this.dataValues == null || this.dataValues.size() < 1) {
            return null;
        }
        double value0 = this.dataValues.get(t);
        if (value0 == 0.0) {
            for (index = 0; index < this.dataValues.size(); ++index) {
                if (!(this.dataValues.get(index) > 0.0)) continue;
                value0 = this.dataValues.get(index);
                break;
            }
        }
        for (index = 0; index < this.dataValues.size(); ++index) {
            double value = this.dataValues.get(index);
            this.dataValues.set(index, (value0 - value) / value0);
        }
        return this.dataValues;
    }

    boolean subtractDeltaT(int arrayStep, int binStep) {
        if (this.valuesOut == null || this.valuesOut.length < 2) {
            return false;
        }
        for (int index = 0; index < this.valuesOut.length; ++index) {
            int timeIndex = index * arrayStep + binStep;
            int indexDelta = timeIndex / arrayStep;
            this.valuesOut[index] = indexDelta < this.valuesOut.length ? this.valuesOut[indexDelta] - this.valuesOut[index] : Double.NaN;
        }
        return true;
    }

    void addDataToValOutEvap(XLSResults result) {
        if (result.valuesOut.length > this.valuesOut.length) {
            System.out.println("XLSResults:addDataToValOutEvap() Error: from len=" + result.valuesOut.length + " to len=" + this.valuesOut.length);
            return;
        }
        for (int i = 0; i < result.valuesOut.length; ++i) {
            int n = i;
            this.valuesOut[n] = this.valuesOut[n] + result.valuesOut[i];
        }
        ++this.nflies;
    }

    void averageEvaporation() {
        if (this.nflies == 0) {
            return;
        }
        for (int i = 0; i < this.valuesOut.length; ++i) {
            this.valuesOut[i] = this.valuesOut[i] / (double)this.nflies;
        }
        this.nflies = 1;
    }

    void subtractEvap(XLSResults evap) {
        if (this.valuesOut == null) {
            return;
        }
        int len = Math.min(this.valuesOut.length, evap.valuesOut.length);
        for (int i = 0; i < len; ++i) {
            int n = i;
            this.valuesOut[n] = this.valuesOut[n] - evap.valuesOut[i];
        }
    }

    void sumValues_out(XLSResults dataToAdd) {
        int len = Math.min(this.valuesOut.length, dataToAdd.valuesOut.length);
        for (int i = 0; i < len; ++i) {
            int n = i;
            this.valuesOut[n] = this.valuesOut[n] + dataToAdd.valuesOut[i];
        }
        ++this.nadded;
    }
}

