/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.kymos;

import icy.file.Saver;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.util.FontUtil;
import icy.image.IcyBufferedImage;
import icy.system.thread.ThreadUtil;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import loci.formats.FormatException;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.ImageFileDescriptor;
import plugins.fmp.multiSPOTS.experiment.SequenceKymos;
import plugins.fmp.multiSPOTS.experiment.Spot;

public class LoadSave
extends JPanel {
    private static final long serialVersionUID = -4381802490262298749L;
    private JButton openButtonKymos = new JButton("Load...");
    private JButton saveButtonKymos = new JButton("Save...");
    private MultiSPOTS parent0 = null;

    void init(GridLayout capLayout, MultiSPOTS parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        JLabel loadsaveText = new JLabel("-> Kymographs (tiff) ", 4);
        loadsaveText.setFont(FontUtil.setStyle((Font)loadsaveText.getFont(), (int)2));
        FlowLayout flowLayout = new FlowLayout(2);
        flowLayout.setVgap(0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(loadsaveText);
        panel1.add(this.openButtonKymos);
        panel1.add(this.saveButtonKymos);
        panel1.validate();
        this.add(panel1);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.openButtonKymos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((LoadSave)LoadSave.this).parent0.expListCombo.getSelectedItem();
                if (exp != null && LoadSave.this.loadDefaultKymos(exp)) {
                    LoadSave.this.firePropertyChange("KYMOS_OPEN", false, true);
                }
            }
        });
        this.saveButtonKymos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((LoadSave)LoadSave.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    String path = exp.getResultsDirectory();
                    LoadSave.this.saveKymographFiles(path);
                    LoadSave.this.firePropertyChange("KYMOS_SAVE", false, true);
                }
            }
        });
    }

    void saveKymographFiles(String directory) {
        ProgressFrame progress = new ProgressFrame("Save kymographs");
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        SequenceKymos seqKymos = exp.seqSpotKymos;
        if (directory == null) {
            directory = exp.getDirectoryToSaveResults();
            try {
                Files.createDirectories(Paths.get(directory, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        String outputpath = directory;
        JFileChooser f = new JFileChooser(outputpath);
        f.setFileSelectionMode(1);
        int returnedval = f.showSaveDialog(null);
        if (returnedval == 0) {
            outputpath = f.getSelectedFile().getAbsolutePath();
            for (int t = 0; t < seqKymos.seq.getSizeT(); ++t) {
                final Spot spot = exp.spotsArray.spotsList.get(t);
                progress.setMessage("Save kymograph file : " + spot.getRoiName());
                spot.spot_filenameTIFF = outputpath + File.separator + spot.getRoiName() + ".tiff";
                final File file = new File(spot.spot_filenameTIFF);
                final IcyBufferedImage image = seqKymos.getSeqImage(t, 0);
                ThreadUtil.bgRun((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Saver.saveImage((IcyBufferedImage)image, (File)file, (boolean)true);
                        }
                        catch (IOException | FormatException e) {
                            e.printStackTrace();
                        }
                        System.out.println("LoadSaveKymos:saveKymographFiles() File " + spot.spot_filenameTIFF + " saved ");
                    }
                });
            }
        }
        progress.close();
    }

    public boolean loadDefaultKymos(Experiment exp) {
        boolean flag = false;
        SequenceKymos seqKymos = exp.seqSpotKymos;
        if (seqKymos == null || exp.spotsArray == null) {
            System.out.println("LoadSaveKymos:loadDefaultKymos() no parent sequence or no capillaries found");
            return flag;
        }
        String localString = this.parent0.expListCombo.stringExpBinSubDirectory;
        if (localString == null) {
            exp.checkKymosDirectory(exp.getBinSubDirectory());
            this.parent0.expListCombo.stringExpBinSubDirectory = exp.getBinSubDirectory();
        } else {
            exp.setBinSubDirectory(localString);
        }
        List<ImageFileDescriptor> myList = exp.seqSpotKymos.loadListOfPotentialKymographsFromSpots(exp.getKymosBinFullDirectory(), exp.spotsArray);
        int nItems = ImageFileDescriptor.getExistingFileNames(myList);
        if (nItems > 0) {
            flag = seqKymos.loadImagesFromList(myList, true);
            this.parent0.dlgKymos.tabDisplay.transferSpotNamesToComboBox(exp);
        } else {
            seqKymos.closeSequence();
        }
        return flag;
    }
}

