/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.spots;

import icy.gui.frame.progress.AnnounceFrame;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.type.geom.Polygon2D;
import icy.type.geom.Polyline2D;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.ExperimentUtils;
import plugins.fmp.multiSPOTS.experiment.SequenceCamData;
import plugins.fmp.multiSPOTS.tools.polyline.PolygonUtilities;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;
import plugins.kernel.roi.roi2d.ROI2DPolygon;

public class CreateSpots
extends JPanel {
    private static final long serialVersionUID = -5257698990389571518L;
    private JButton displayFrameDButton = new JButton("(1) Display frame");
    private JButton createPolylinesButton = new JButton("(2) Generate polylines");
    private JButton createCirclesButton = new JButton("(3) Create circles");
    private JComboBox<String> orientationJCombo = new JComboBox<String>(new String[]{"0\u00b0", "90\u00b0", "180\u00b0", "270\u00b0"});
    private JSpinner nPointsPolylineJSpinner = new JSpinner(new SpinnerNumberModel(2, 2, 500, 1));
    private JSpinner nbFliesPerCageJSpinner = new JSpinner(new SpinnerNumberModel(1, 0, 500, 1));
    private JSpinner pixelRadiusSpinner = new JSpinner(new SpinnerNumberModel(30, 1, 1000, 1));
    private JSpinner nCagesPerRowSpinner = new JSpinner(new SpinnerNumberModel(10, 1, 100, 1));
    private Polygon2D spotsLocationPolygon = null;
    private String[] flyString = new String[]{"fly", "flies"};
    private JLabel flyLabel = new JLabel(this.flyString[0]);
    private JLabel pointsLabel = new JLabel("points at");
    private MultiSPOTS parent0 = null;

    void init(GridLayout capLayout, MultiSPOTS parent0) {
        this.setLayout(capLayout);
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(0);
        JPanel panel0 = new JPanel(flowLayout);
        panel0.add(this.displayFrameDButton);
        panel0.add(this.createPolylinesButton);
        panel0.add(this.createCirclesButton);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.nCagesPerRowSpinner);
        this.nCagesPerRowSpinner.setPreferredSize(new Dimension(60, 20));
        panel1.add(new JLabel("cages with"));
        panel1.add(this.nbFliesPerCageJSpinner);
        this.nbFliesPerCageJSpinner.setPreferredSize(new Dimension(40, 20));
        panel1.add(this.flyLabel);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(new JLabel("Polyline with"));
        panel2.add(this.nPointsPolylineJSpinner);
        this.nPointsPolylineJSpinner.setPreferredSize(new Dimension(40, 20));
        panel2.add(this.pointsLabel);
        panel2.add(this.orientationJCombo);
        this.orientationJCombo.setPreferredSize(new Dimension(50, 20));
        panel2.add(new JLabel("angle; circles"));
        panel2.add(this.pixelRadiusSpinner);
        this.pixelRadiusSpinner.setPreferredSize(new Dimension(40, 20));
        panel2.add(new JLabel("pixel radius"));
        this.add(panel0);
        this.add(panel1);
        this.add(panel2);
        this.defineActionListeners();
        this.parent0 = parent0;
    }

    private void defineActionListeners() {
        this.displayFrameDButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((CreateSpots)CreateSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null && exp.capillaries != null) {
                    Polygon2D extPolygon = exp.capillaries.get2DPolygonEnclosingCapillaries();
                    if (extPolygon == null) {
                        extPolygon = CreateSpots.this.getCapillariesPolygon(exp.seqCamData);
                    }
                    ROI2DPolygon extRect = new ROI2DPolygon(extPolygon);
                    exp.capillaries.deleteAllCapillaries();
                    exp.capillaries.updateCapillariesFromSequence(exp.seqCamData.seq);
                    exp.seqCamData.seq.removeAllROI();
                    String dummyname = "perimeter_enclosing_capillaries";
                    extRect.setName("perimeter_enclosing_capillaries");
                    exp.seqCamData.seq.addROI((ROI)extRect);
                    exp.seqCamData.seq.setSelectedROI((ROI)extRect);
                } else {
                    CreateSpots.this.create2DPolygon();
                }
            }
        });
        this.createPolylinesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateSpots.this.roisGenerateFromPolygon();
                Experiment exp = (Experiment)((CreateSpots)CreateSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    ExperimentUtils.transferCamDataROIStoCapillaries(exp);
                    int nbFliesPerCage = (Integer)CreateSpots.this.nbFliesPerCageJSpinner.getValue();
                    exp.capillaries.initCapillariesWith10Cages(nbFliesPerCage, false);
                }
            }
        });
        this.createCirclesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((CreateSpots)CreateSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    int radius = (Integer)CreateSpots.this.pixelRadiusSpinner.getValue();
                    ExperimentUtils.transformPolygon2DROISintoSpots(exp, radius);
                    ExperimentUtils.transferSpotsToCamData(exp);
                    int nbFliesPerCage = (Integer)CreateSpots.this.nbFliesPerCageJSpinner.getValue();
                    exp.spotsArray.initSpotsWithNFlies(nbFliesPerCage);
                }
            }
        });
        this.nbFliesPerCageJSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int i = (Integer)CreateSpots.this.nbFliesPerCageJSpinner.getValue() > 1 ? 1 : 0;
                CreateSpots.this.flyLabel.setText(CreateSpots.this.flyString[i]);
                CreateSpots.this.nbFliesPerCageJSpinner.requestFocus();
            }
        });
    }

    private void create2DPolygon() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        SequenceCamData seqCamData = exp.seqCamData;
        String dummyname = "perimeter_enclosing_capillaries";
        if (this.isRoiPresent(seqCamData, "perimeter_enclosing_capillaries")) {
            return;
        }
        ROI2DPolygon roi = new ROI2DPolygon(this.getCapillariesPolygon(seqCamData));
        roi.setName("perimeter_enclosing_capillaries");
        seqCamData.seq.addROI((ROI)roi);
        seqCamData.seq.setSelectedROI((ROI)roi);
    }

    private boolean isRoiPresent(SequenceCamData seqCamData, String dummyname) {
        ArrayList listRois = seqCamData.seq.getROI2Ds();
        for (ROI2D roi : listRois) {
            if (!roi.getName().equals(dummyname)) continue;
            return true;
        }
        return false;
    }

    private Polygon2D getCapillariesPolygon(SequenceCamData seqCamData) {
        if (this.spotsLocationPolygon == null) {
            Rectangle rect = seqCamData.seq.getBounds2D();
            ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
            points.add(new Point2D.Double(rect.x + rect.width / 5, rect.y + rect.height / 5));
            points.add(new Point2D.Double(rect.x + rect.width * 4 / 5, rect.y + rect.height / 5));
            points.add(new Point2D.Double(rect.x + rect.width * 4 / 5, rect.y + rect.height * 2 / 3));
            points.add(new Point2D.Double(rect.x + rect.width / 5, rect.y + rect.height * 2 / 3));
            this.spotsLocationPolygon = new Polygon2D(points);
        }
        return this.spotsLocationPolygon;
    }

    private void rotate(Polygon2D roiPolygon) {
        int isel = this.orientationJCombo.getSelectedIndex();
        if (isel == 0) {
            return;
        }
        Polygon2D roiPolygon_orig = (Polygon2D)roiPolygon.clone();
        for (int i = 0; i < roiPolygon.npoints; ++i) {
            int j = (i + isel) % 4;
            roiPolygon.xpoints[j] = roiPolygon_orig.xpoints[i];
            roiPolygon.ypoints[j] = roiPolygon_orig.ypoints[i];
        }
    }

    private void roisGenerateFromPolygon() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        SequenceCamData seqCamData = exp.seqCamData;
        boolean statusGroup2Mode = false;
        int nbcapillaries = 20;
        int width_between_capillaries = 1;
        int width_interval = 0;
        try {
            nbcapillaries = (Integer)this.nCagesPerRowSpinner.getValue();
        }
        catch (Exception e) {
            new AnnounceFrame("Can't interpret one of the ROI parameters value");
        }
        ROI2D roi = seqCamData.seq.getSelectedROI2D();
        if (!(roi instanceof ROI2DPolygon)) {
            new AnnounceFrame("The frame must be a ROI2D POLYGON");
            return;
        }
        this.spotsLocationPolygon = PolygonUtilities.orderVerticesofPolygon(((ROI2DPolygon)roi).getPolygon());
        this.rotate(this.spotsLocationPolygon);
        seqCamData.seq.removeROI((ROI)roi);
        if (statusGroup2Mode) {
            double span = nbcapillaries / 2 * (width_between_capillaries + width_interval) - width_interval;
            for (int i = 0; i < nbcapillaries; i += 2) {
                double span0 = (width_between_capillaries + width_interval) * i / 2;
                this.addROILine(seqCamData, "line" + i / 2 + "L", this.spotsLocationPolygon, span0, span);
                this.addROILine(seqCamData, "line" + i / 2 + "R", this.spotsLocationPolygon, span0 += (double)width_between_capillaries, span);
            }
        } else {
            double span = nbcapillaries - 1;
            for (int i = 0; i < nbcapillaries; ++i) {
                double span0 = width_between_capillaries * i;
                this.addROILine(seqCamData, "line" + String.format("%02d", i), this.spotsLocationPolygon, span0, span);
            }
        }
    }

    private void addROILine(SequenceCamData seqCamData, String name, Polygon2D roiPolygon, double span0, double span) {
        double x0 = roiPolygon.xpoints[0] + (roiPolygon.xpoints[3] - roiPolygon.xpoints[0]) * span0 / span;
        double y0 = roiPolygon.ypoints[0] + (roiPolygon.ypoints[3] - roiPolygon.ypoints[0]) * span0 / span;
        if (x0 < 0.0) {
            x0 = 0.0;
        }
        if (y0 < 0.0) {
            y0 = 0.0;
        }
        double x1 = roiPolygon.xpoints[1] + (roiPolygon.xpoints[2] - roiPolygon.xpoints[1]) * span0 / span;
        double y1 = roiPolygon.ypoints[1] + (roiPolygon.ypoints[2] - roiPolygon.ypoints[1]) * span0 / span;
        int npoints = (Integer)this.nPointsPolylineJSpinner.getValue();
        ROI2DPolyLine roiL1 = new ROI2DPolyLine(this.createPolyline2D(x0, y0, x1, y1, npoints));
        roiL1.setName(name);
        roiL1.setReadOnly(false);
        seqCamData.seq.addROI((ROI)roiL1, true);
    }

    private Polyline2D createPolyline2D(double x0, double y0, double x1, double y1, int npoints) {
        double[] xpoints = new double[npoints];
        double[] ypoints = new double[npoints];
        double deltax = (x1 - x0) / (double)(npoints - 1);
        double deltay = (y1 - y0) / (double)(npoints - 1);
        double x = x0;
        double y = y0;
        xpoints[0] = x0;
        ypoints[0] = y0;
        xpoints[npoints - 1] = x1;
        ypoints[npoints - 1] = y1;
        for (int i = 1; i < npoints - 1; ++i) {
            xpoints[i] = x += deltax;
            ypoints[i] = y += deltay;
        }
        return new Polyline2D(xpoints, ypoints, npoints);
    }
}

