/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.spotsMeasures;

import icy.painter.Overlay;
import icy.util.StringUtil;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.series.BuildSeriesOptions;
import plugins.fmp.multiSPOTS.series.BuildSpotsMeasures;
import plugins.fmp.multiSPOTS.tools.Canvas2D.Canvas2D_2Transforms;
import plugins.fmp.multiSPOTS.tools.ImageTransform.ImageTransformEnums;
import plugins.fmp.multiSPOTS.tools.Overlay.OverlayThreshold;

public class SpotsMeasuresThresholdSimple
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 8921207247623517524L;
    private String detectString = "        Detect     ";
    private JButton detectButton = new JButton(this.detectString);
    private JCheckBox allSeriesCheckBox = new JCheckBox("ALL (current to last)", false);
    private JCheckBox concurrentDisplayCheckBox = new JCheckBox("concurrent display", false);
    private JLabel spotsFilterLabel = new JLabel("Spots filter");
    private String[] directions = new String[]{" threshold >", " threshold <"};
    private ImageTransformEnums[] transforms = new ImageTransformEnums[]{ImageTransformEnums.R_RGB, ImageTransformEnums.G_RGB, ImageTransformEnums.B_RGB, ImageTransformEnums.R2MINUS_GB, ImageTransformEnums.G2MINUS_RB, ImageTransformEnums.B2MINUS_RG, ImageTransformEnums.RGB, ImageTransformEnums.GBMINUS_2R, ImageTransformEnums.RBMINUS_2G, ImageTransformEnums.RGMINUS_2B, ImageTransformEnums.RGB_DIFFS, ImageTransformEnums.H_HSB, ImageTransformEnums.S_HSB, ImageTransformEnums.B_HSB};
    private JComboBox<ImageTransformEnums> spotsTransformsComboBox = new JComboBox<ImageTransformEnums>(this.transforms);
    private JComboBox<String> spotsDirectionComboBox = new JComboBox<String>(this.directions);
    private JSpinner spotsThresholdSpinner = new JSpinner(new SpinnerNumberModel(35, 0, 255, 1));
    private JCheckBox spotsOverlayCheckBox = new JCheckBox("overlay");
    private JToggleButton viewButton1 = new JToggleButton("View");
    private JToggleButton viewButton2 = new JToggleButton("View");
    private JLabel fliesFilterLabel = new JLabel("  Flies filter");
    private JComboBox<ImageTransformEnums> fliesTransformsComboBox = new JComboBox<ImageTransformEnums>(this.transforms);
    private JComboBox<String> fliesDirectionComboBox = new JComboBox<String>(this.directions);
    private JSpinner fliesThresholdSpinner = new JSpinner(new SpinnerNumberModel(50, 0, 255, 1));
    private OverlayThreshold overlayThreshold = null;
    private BuildSpotsMeasures threadDetectLevels = null;
    private MultiSPOTS parent0 = null;

    public void init(GridLayout gridLayout, MultiSPOTS parent0) {
        this.setLayout(gridLayout);
        this.parent0 = parent0;
        FlowLayout layoutLeft = new FlowLayout(0);
        layoutLeft.setVgap(0);
        JPanel panel0 = new JPanel(layoutLeft);
        panel0.add(this.detectButton);
        panel0.add(this.allSeriesCheckBox);
        panel0.add(this.concurrentDisplayCheckBox);
        this.add(panel0);
        JPanel panel1 = new JPanel(layoutLeft);
        panel1.add(this.spotsFilterLabel);
        panel1.add(this.spotsTransformsComboBox);
        panel1.add(this.spotsDirectionComboBox);
        panel1.add(this.spotsThresholdSpinner);
        panel1.add(this.viewButton1);
        panel1.add(this.spotsOverlayCheckBox);
        this.add(panel1);
        JPanel panel2 = new JPanel(layoutLeft);
        panel2.add(this.fliesFilterLabel);
        panel2.add(this.fliesTransformsComboBox);
        panel2.add(this.fliesDirectionComboBox);
        panel2.add(this.fliesThresholdSpinner);
        panel2.add(this.viewButton2);
        this.add(panel2);
        this.spotsTransformsComboBox.setSelectedItem((Object)ImageTransformEnums.RGB_DIFFS);
        this.spotsDirectionComboBox.setSelectedIndex(1);
        this.fliesTransformsComboBox.setSelectedItem((Object)ImageTransformEnums.B_RGB);
        this.fliesDirectionComboBox.setSelectedIndex(0);
        this.declareListeners();
    }

    private void declareListeners() {
        this.spotsOverlayCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Experiment exp = (Experiment)((SpotsMeasuresThresholdSimple)SpotsMeasuresThresholdSimple.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    if (SpotsMeasuresThresholdSimple.this.spotsOverlayCheckBox.isSelected()) {
                        SpotsMeasuresThresholdSimple.this.updateOverlay(exp);
                        SpotsMeasuresThresholdSimple.this.updateOverlayThreshold();
                    } else {
                        SpotsMeasuresThresholdSimple.this.removeOverlay(exp);
                    }
                }
            }
        });
        this.spotsTransformsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((SpotsMeasuresThresholdSimple)SpotsMeasuresThresholdSimple.this).parent0.expListCombo.getSelectedItem();
                if (exp != null && exp.seqSpotKymos != null && SpotsMeasuresThresholdSimple.this.viewButton1.isSelected()) {
                    int index = SpotsMeasuresThresholdSimple.this.spotsTransformsComboBox.getSelectedIndex();
                    Canvas2D_2Transforms canvas = (Canvas2D_2Transforms)exp.seqCamData.seq.getFirstViewer().getCanvas();
                    SpotsMeasuresThresholdSimple.this.updateTransformFunctions1OfCanvas(exp);
                    if (!SpotsMeasuresThresholdSimple.this.viewButton1.isSelected()) {
                        SpotsMeasuresThresholdSimple.this.viewButton1.setSelected(true);
                    }
                    canvas.transformsComboStep1.setSelectedIndex(index + 1);
                    SpotsMeasuresThresholdSimple.this.updateOverlayThreshold();
                }
            }
        });
        this.fliesTransformsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((SpotsMeasuresThresholdSimple)SpotsMeasuresThresholdSimple.this).parent0.expListCombo.getSelectedItem();
                if (exp != null && exp.seqSpotKymos != null && SpotsMeasuresThresholdSimple.this.viewButton2.isSelected()) {
                    int index = SpotsMeasuresThresholdSimple.this.fliesTransformsComboBox.getSelectedIndex();
                    Canvas2D_2Transforms canvas = (Canvas2D_2Transforms)exp.seqCamData.seq.getFirstViewer().getCanvas();
                    SpotsMeasuresThresholdSimple.this.updateTransformFunctions2OfCanvas(exp);
                    if (!SpotsMeasuresThresholdSimple.this.viewButton2.isSelected()) {
                        SpotsMeasuresThresholdSimple.this.viewButton2.setSelected(true);
                    }
                    canvas.transformsComboStep1.setSelectedIndex(index + 1);
                    SpotsMeasuresThresholdSimple.this.updateOverlayThreshold();
                }
            }
        });
        this.spotsDirectionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpotsMeasuresThresholdSimple.this.updateOverlayThreshold();
            }
        });
        this.fliesDirectionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpotsMeasuresThresholdSimple.this.updateOverlayThreshold();
            }
        });
        this.spotsThresholdSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SpotsMeasuresThresholdSimple.this.updateOverlayThreshold();
            }
        });
        this.fliesThresholdSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SpotsMeasuresThresholdSimple.this.updateOverlayThreshold();
            }
        });
        this.viewButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((SpotsMeasuresThresholdSimple)SpotsMeasuresThresholdSimple.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    SpotsMeasuresThresholdSimple.this.displayTransform1(exp);
                }
            }
        });
        this.viewButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((SpotsMeasuresThresholdSimple)SpotsMeasuresThresholdSimple.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    SpotsMeasuresThresholdSimple.this.displayTransform2(exp);
                }
            }
        });
        this.detectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SpotsMeasuresThresholdSimple.this.detectButton.getText().equals(SpotsMeasuresThresholdSimple.this.detectString)) {
                    SpotsMeasuresThresholdSimple.this.startDetection();
                } else {
                    SpotsMeasuresThresholdSimple.this.stopDetection();
                }
            }
        });
    }

    void updateOverlay(Experiment exp) {
        if (exp.seqSpotKymos == null) {
            return;
        }
        if (this.overlayThreshold == null) {
            this.overlayThreshold = new OverlayThreshold(exp.seqCamData.seq);
        } else {
            exp.seqCamData.seq.removeOverlay((Overlay)this.overlayThreshold);
            this.overlayThreshold.setSequence(exp.seqCamData.seq);
        }
        exp.seqCamData.seq.addOverlay((Overlay)this.overlayThreshold);
    }

    void removeOverlay(Experiment exp) {
        if (exp.seqCamData != null && exp.seqCamData.seq != null) {
            exp.seqCamData.seq.removeOverlay((Overlay)this.overlayThreshold);
        }
    }

    void updateOverlayThreshold() {
        if (this.overlayThreshold == null) {
            return;
        }
        ImageTransformEnums transform = ImageTransformEnums.NONE;
        boolean ifGreater = true;
        int threshold = 0;
        if (this.viewButton1.isSelected()) {
            transform = (ImageTransformEnums)((Object)this.spotsTransformsComboBox.getSelectedItem());
            threshold = (Integer)this.spotsThresholdSpinner.getValue();
            ifGreater = this.spotsDirectionComboBox.getSelectedIndex() == 0;
        } else {
            transform = (ImageTransformEnums)((Object)this.fliesTransformsComboBox.getSelectedItem());
            threshold = (Integer)this.fliesThresholdSpinner.getValue();
            ifGreater = this.fliesDirectionComboBox.getSelectedIndex() == 0;
        }
        this.overlayThreshold.setThresholdSingle(threshold, transform, ifGreater);
        this.overlayThreshold.painterChanged();
    }

    void startDetection() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            this.threadDetectLevels = new BuildSpotsMeasures();
            this.threadDetectLevels.options = this.initDetectOptions(exp);
            this.threadDetectLevels.addPropertyChangeListener(this);
            this.threadDetectLevels.execute();
            this.detectButton.setText("STOP");
        }
    }

    private void stopDetection() {
        if (this.threadDetectLevels != null && !this.threadDetectLevels.stopFlag) {
            this.threadDetectLevels.stopFlag = true;
        }
    }

    private BuildSeriesOptions initDetectOptions(Experiment exp) {
        BuildSeriesOptions options = new BuildSeriesOptions();
        options.expList = this.parent0.expListCombo;
        options.expList.index0 = this.parent0.expListCombo.getSelectedIndex();
        options.expList.index1 = this.allSeriesCheckBox.isSelected() ? options.expList.getItemCount() - 1 : this.parent0.expListCombo.getSelectedIndex();
        options.detectAllSeries = this.allSeriesCheckBox.isSelected();
        if (!this.allSeriesCheckBox.isSelected()) {
            options.seriesLast = options.seriesFirst;
        } else {
            options.seriesFirst = 0;
        }
        options.concurrentDisplay = this.concurrentDisplayCheckBox.isSelected();
        options.transform01 = (ImageTransformEnums)((Object)this.spotsTransformsComboBox.getSelectedItem());
        options.spotThresholdUp = this.spotsDirectionComboBox.getSelectedIndex() == 1;
        options.spotThreshold = (Integer)this.spotsThresholdSpinner.getValue();
        options.analyzePartOnly = false;
        options.overlayTransform = (ImageTransformEnums)((Object)this.spotsTransformsComboBox.getSelectedItem());
        options.overlayIfGreater = this.spotsDirectionComboBox.getSelectedIndex() == 1;
        options.overlayThreshold = (Integer)this.spotsThresholdSpinner.getValue();
        options.transform02 = (ImageTransformEnums)((Object)this.fliesTransformsComboBox.getSelectedItem());
        options.flyThreshold = (Integer)this.fliesThresholdSpinner.getValue();
        options.flyThresholdUp = this.fliesDirectionComboBox.getSelectedIndex() == 1;
        return options;
    }

    private void displayTransform1(Experiment exp) {
        boolean displayCheckOverlay = false;
        if (this.viewButton1.isSelected()) {
            this.updateTransformFunctions1OfCanvas(exp);
            displayCheckOverlay = true;
        } else {
            this.removeOverlay(exp);
            this.spotsOverlayCheckBox.setSelected(false);
            Canvas2D_2Transforms canvas = (Canvas2D_2Transforms)exp.seqCamData.seq.getFirstViewer().getCanvas();
            canvas.transformsComboStep1.setSelectedIndex(0);
        }
        this.spotsOverlayCheckBox.setEnabled(displayCheckOverlay);
    }

    private void displayTransform2(Experiment exp) {
        boolean displayCheckOverlay = false;
        if (this.viewButton2.isSelected()) {
            this.updateTransformFunctions2OfCanvas(exp);
            displayCheckOverlay = true;
        } else {
            this.removeOverlay(exp);
            this.spotsOverlayCheckBox.setSelected(false);
            Canvas2D_2Transforms canvas = (Canvas2D_2Transforms)exp.seqCamData.seq.getFirstViewer().getCanvas();
            canvas.transformsComboStep1.setSelectedIndex(0);
        }
        this.spotsOverlayCheckBox.setEnabled(displayCheckOverlay);
    }

    private void updateTransformFunctions1OfCanvas(Experiment exp) {
        Canvas2D_2Transforms canvas = (Canvas2D_2Transforms)exp.seqCamData.seq.getFirstViewer().getCanvas();
        if (canvas.transformsComboStep1.getItemCount() < this.spotsTransformsComboBox.getItemCount() + 1) {
            canvas.updateTransformsComboStep1(this.transforms);
        }
        int index = this.spotsTransformsComboBox.getSelectedIndex();
        canvas.selectImageTransformFunctionStep1(index + 1);
    }

    private void updateTransformFunctions2OfCanvas(Experiment exp) {
        Canvas2D_2Transforms canvas = (Canvas2D_2Transforms)exp.seqCamData.seq.getFirstViewer().getCanvas();
        if (canvas.transformsComboStep1.getItemCount() < this.fliesDirectionComboBox.getItemCount() + 1) {
            canvas.updateTransformsComboStep1(this.transforms);
        }
        int index = this.fliesDirectionComboBox.getSelectedIndex();
        canvas.selectImageTransformFunctionStep1(index + 1);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (StringUtil.equals((String)"thread_ended", (String)evt.getPropertyName())) {
            this.detectButton.setText(this.detectString);
            Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
            if (exp != null) {
                exp.load_SpotsMeasures();
                this.parent0.dlgMeasure.tabGraphs.displayGraphsPanels(exp);
            }
        }
    }
}

