/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.experiment;

import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.type.geom.Polyline2D;
import icy.util.XMLUtil;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multiSPOTS.experiment.CapillaryLevel;
import plugins.fmp.multiSPOTS.experiment.EnumCapillaryMeasures;
import plugins.fmp.multiSPOTS.experiment.ROI2DAlongT;
import plugins.fmp.multiSPOTS.series.BuildSeriesOptions;
import plugins.fmp.multiSPOTS.tools.ROI2D.ROI2DUtilities;
import plugins.fmp.multiSPOTS.tools.toExcel.EnumXLSColumnHeader;
import plugins.fmp.multiSPOTS.tools.toExcel.EnumXLSExportType;
import plugins.kernel.roi.roi2d.ROI2DLine;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;

public class Capillary
implements Comparable<Capillary> {
    private ROI2D roi = null;
    private ArrayList<ROI2DAlongT> roisForKymo = new ArrayList();
    private String kymographName = null;
    public int kymographIndex = -1;
    private String kymographPrefix = null;
    public String version = null;
    public String filenameTIFF = null;
    public ArrayList<int[]> cap_Integer = null;
    public String stimulus = new String("..");
    public String concentration = new String("..");
    public String cageSide = ".";
    public int nFlies = 1;
    public int cageID = 0;
    public double volume = 5.0;
    public int pixels = 5;
    public boolean descriptionOK = false;
    public int versionInfos = 0;
    public BuildSeriesOptions limitsOptions = new BuildSeriesOptions();
    public final String ID_TOPLEVEL = "toplevel";
    public final String ID_BOTTOMLEVEL = "bottomlevel";
    public final String ID_DERIVATIVE = "derivative";
    public CapillaryLevel ptsTop = new CapillaryLevel("toplevel");
    public CapillaryLevel ptsBottom = new CapillaryLevel("bottomlevel");
    public CapillaryLevel ptsDerivative = new CapillaryLevel("derivative");
    public boolean valid = true;
    private final String ID_META = "metaMC";
    private final String ID_NFLIES = "nflies";
    private final String ID_CAGENB = "cage_number";
    private final String ID_CAPVOLUME = "capillaryVolume";
    private final String ID_CAPPIXELS = "capillaryPixels";
    private final String ID_STIML = "stimulus";
    private final String ID_CONCL = "concentration";
    private final String ID_SIDE = "side";
    private final String ID_DESCOK = "descriptionOK";
    private final String ID_VERSIONINFOS = "versionInfos";
    private final String ID_INTERVALS = "INTERVALS";
    private final String ID_NINTERVALS = "nintervals";
    private final String ID_INTERVAL = "interval_";
    private final String ID_INDEXIMAGE = "indexImageMC";
    private final String ID_NAME = "nameMC";
    private final String ID_NAMETIFF = "filenameTIFF";
    private final String ID_VERSION = "version";
    private final String ID_VERSIONNUM = "1.0.0";

    public Capillary(ROI2D roiCapillary) {
        this.roi = roiCapillary;
        this.kymographName = Capillary.replace_LR_with_12(roiCapillary.getName());
    }

    Capillary(String name) {
        this.kymographName = Capillary.replace_LR_with_12(name);
    }

    public Capillary() {
    }

    @Override
    public int compareTo(Capillary o) {
        if (o != null) {
            return this.kymographName.compareTo(o.kymographName);
        }
        return 1;
    }

    public void copy(Capillary cap) {
        this.kymographIndex = cap.kymographIndex;
        this.kymographName = cap.kymographName;
        this.version = cap.version;
        this.roi = (ROI2D)cap.roi.getCopy();
        this.filenameTIFF = cap.filenameTIFF;
        this.stimulus = cap.stimulus;
        this.concentration = cap.concentration;
        this.cageSide = cap.cageSide;
        this.nFlies = cap.nFlies;
        this.cageID = cap.cageID;
        this.volume = cap.volume;
        this.pixels = cap.pixels;
        this.limitsOptions = cap.limitsOptions;
        this.ptsTop.copy(cap.ptsTop);
        this.ptsBottom.copy(cap.ptsBottom);
        this.ptsDerivative.copy(cap.ptsDerivative);
    }

    public String getKymographName() {
        return this.kymographName;
    }

    public void setKymographName(String name) {
        this.kymographName = name;
    }

    public ROI2D getRoi() {
        return this.roi;
    }

    public void setRoi(ROI2D roi) {
        this.roi = roi;
    }

    public void setRoiName(String name) {
        this.roi.setName(name);
    }

    public String getRoiName() {
        return this.roi.getName();
    }

    public String getLast2ofCapillaryName() {
        if (this.roi == null) {
            return "missing";
        }
        return this.roi.getName().substring(this.roi.getName().length() - 2);
    }

    public String getRoiNamePrefix() {
        return this.kymographPrefix;
    }

    public String getCapillarySide() {
        return this.roi.getName().substring(this.roi.getName().length() - 1);
    }

    public static String replace_LR_with_12(String name) {
        String newname = name;
        if (name.contains("R")) {
            newname = name.replace("R", "2");
        } else if (name.contains("L")) {
            newname = name.replace("L", "1");
        }
        return newname;
    }

    public int getCageIndexFromRoiName() {
        String name = this.roi.getName();
        if (!name.contains("line")) {
            return -1;
        }
        return Integer.valueOf(name.substring(4, 5));
    }

    public String getSideDescriptor(EnumXLSExportType xlsExportOption) {
        String value = null;
        this.cageSide = this.getCapillarySide();
        switch (xlsExportOption) {
            case DISTANCE: 
            case ISALIVE: {
                value = this.cageSide + "(L=R)";
                break;
            }
            case TOPLEVELDELTA_LR: 
            case TOPLEVEL_LR: {
                if (this.cageSide.equals("L")) {
                    value = "sum";
                    break;
                }
                value = "PI";
                break;
            }
            case XYIMAGE: 
            case XYTOPCAGE: 
            case XYTIPCAPS: {
                if (this.cageSide.equals("L")) {
                    value = "x";
                    break;
                }
                value = "y";
                break;
            }
            default: {
                value = this.cageSide;
            }
        }
        return value;
    }

    public String getCapillaryField(EnumXLSColumnHeader fieldEnumCode) {
        String stringValue = null;
        switch (fieldEnumCode) {
            case CAP_STIM: {
                stringValue = this.stimulus;
                break;
            }
            case CAP_CONC: {
                stringValue = this.concentration;
                break;
            }
        }
        return stringValue;
    }

    public void setCapillaryField(EnumXLSColumnHeader fieldEnumCode, String stringValue) {
        switch (fieldEnumCode) {
            case CAP_STIM: {
                this.stimulus = stringValue;
                break;
            }
            case CAP_CONC: {
                this.concentration = stringValue;
                break;
            }
        }
    }

    public boolean isThereAnyMeasuresDone(EnumXLSExportType option) {
        boolean yes = false;
        switch (option) {
            case DERIVEDVALUES: {
                yes = this.ptsDerivative.isThereAnyMeasuresDone();
                break;
            }
            case BOTTOMLEVEL: {
                yes = this.ptsBottom.isThereAnyMeasuresDone();
                break;
            }
            default: {
                yes = this.ptsTop.isThereAnyMeasuresDone();
            }
        }
        return yes;
    }

    public ArrayList<Double> getCapillaryMeasuresForXLSPass1(EnumXLSExportType option, long seriesBinMs, long outputBinMs) {
        ArrayList<Double> datai = null;
        switch (option) {
            case DERIVEDVALUES: {
                datai = this.ptsDerivative.getMeasures(seriesBinMs, outputBinMs);
                break;
            }
            case BOTTOMLEVEL: {
                datai = this.ptsBottom.getMeasures(seriesBinMs, outputBinMs);
                break;
            }
            default: {
                datai = this.ptsTop.getMeasures(seriesBinMs, outputBinMs);
            }
        }
        return datai;
    }

    public void cropMeasuresToNPoints(int npoints) {
        if (this.ptsTop.polylineLevel != null) {
            this.ptsTop.cropToNPoints(npoints);
        }
        if (this.ptsBottom.polylineLevel != null) {
            this.ptsBottom.cropToNPoints(npoints);
        }
        if (this.ptsDerivative.polylineLevel != null) {
            this.ptsDerivative.cropToNPoints(npoints);
        }
    }

    public void restoreClippedMeasures() {
        if (this.ptsTop.polylineLevel != null) {
            this.ptsTop.restoreNPoints();
        }
        if (this.ptsBottom.polylineLevel != null) {
            this.ptsBottom.restoreNPoints();
        }
        if (this.ptsDerivative.polylineLevel != null) {
            this.ptsDerivative.restoreNPoints();
        }
    }

    public int getLastMeasure(EnumXLSExportType option) {
        int lastMeasure = 0;
        switch (option) {
            case DERIVEDVALUES: {
                lastMeasure = this.ptsDerivative.getLastMeasure();
                break;
            }
            case BOTTOMLEVEL: {
                lastMeasure = this.ptsBottom.getLastMeasure();
                break;
            }
            default: {
                lastMeasure = this.ptsTop.getLastMeasure();
            }
        }
        return lastMeasure;
    }

    public int getLastDeltaMeasure(EnumXLSExportType option) {
        int lastMeasure = 0;
        switch (option) {
            case DERIVEDVALUES: {
                lastMeasure = this.ptsDerivative.getLastDeltaMeasure();
                break;
            }
            case BOTTOMLEVEL: {
                lastMeasure = this.ptsBottom.getLastDeltaMeasure();
                break;
            }
            default: {
                lastMeasure = this.ptsTop.getLastDeltaMeasure();
            }
        }
        return lastMeasure;
    }

    public int getT0Measure(EnumXLSExportType option) {
        int t0Measure = 0;
        switch (option) {
            case DERIVEDVALUES: {
                t0Measure = this.ptsDerivative.getT0Measure();
                break;
            }
            case BOTTOMLEVEL: {
                t0Measure = this.ptsBottom.getT0Measure();
                break;
            }
            default: {
                t0Measure = this.ptsTop.getT0Measure();
            }
        }
        return t0Measure;
    }

    public List<ROI2D> transferMeasuresToROIs() {
        ArrayList<ROI2D> listrois = new ArrayList<ROI2D>();
        listrois.add(this.measureToRoi(this.ptsTop));
        listrois.add(this.measureToRoi(this.ptsBottom));
        listrois.add(this.measureToRoi(this.ptsDerivative));
        return listrois;
    }

    private ROI2D measureToRoi(CapillaryLevel capLevel) {
        if (capLevel.polylineLevel == null || capLevel.polylineLevel.npoints == 0) {
            return null;
        }
        ROI2DPolyLine roi = new ROI2DPolyLine((Polyline2D)capLevel.polylineLevel);
        String name = this.kymographPrefix + "_" + capLevel.capName;
        roi.setName(name);
        roi.setT(this.kymographIndex);
        if (capLevel.capName.contains("derivative")) {
            roi.setColor(Color.yellow);
            roi.setStroke(1.0);
        }
        return roi;
    }

    public void transferROIsToMeasures(List<ROI> listRois) {
        this.ptsTop.transferROIsToMeasures(listRois);
        this.ptsBottom.transferROIsToMeasures(listRois);
        this.ptsDerivative.transferROIsToMeasures(listRois);
    }

    public boolean loadFromXML_CapillaryOnly(Node node) {
        boolean flag;
        Element nodeMeta = XMLUtil.getElement((Node)node, (String)"metaMC");
        boolean bl = flag = nodeMeta != null;
        if (flag) {
            this.version = XMLUtil.getElementValue((Node)nodeMeta, (String)"version", (String)"0.0.0");
            this.kymographIndex = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"indexImageMC", (int)this.kymographIndex);
            this.kymographName = XMLUtil.getElementValue((Node)nodeMeta, (String)"nameMC", (String)this.kymographName);
            this.filenameTIFF = XMLUtil.getElementValue((Node)nodeMeta, (String)"filenameTIFF", (String)this.filenameTIFF);
            this.descriptionOK = XMLUtil.getElementBooleanValue((Node)nodeMeta, (String)"descriptionOK", (boolean)false);
            this.versionInfos = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"versionInfos", (int)0);
            this.nFlies = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"nflies", (int)this.nFlies);
            this.cageID = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"cage_number", (int)this.cageID);
            this.volume = XMLUtil.getElementDoubleValue((Node)nodeMeta, (String)"capillaryVolume", (double)Double.NaN);
            this.pixels = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"capillaryPixels", (int)5);
            this.stimulus = XMLUtil.getElementValue((Node)nodeMeta, (String)"stimulus", (String)"stimulus");
            this.concentration = XMLUtil.getElementValue((Node)nodeMeta, (String)"concentration", (String)"concentration");
            this.cageSide = XMLUtil.getElementValue((Node)nodeMeta, (String)"side", (String)".");
            this.roi = ROI2DUtilities.loadFromXML_ROI(nodeMeta);
            this.limitsOptions.loadFromXML(nodeMeta);
            this.loadFromXML_intervals(node);
        }
        return flag;
    }

    private boolean loadFromXML_intervals(Node node) {
        this.roisForKymo.clear();
        Element nodeMeta2 = XMLUtil.getElement((Node)node, (String)"INTERVALS");
        if (nodeMeta2 == null) {
            return false;
        }
        int nitems = XMLUtil.getElementIntValue((Node)nodeMeta2, (String)"nintervals", (int)0);
        if (nitems > 0) {
            for (int i = 0; i < nitems; ++i) {
                Element node_i = XMLUtil.setElement((Node)nodeMeta2, (String)("interval_" + i));
                ROI2DAlongT roiInterval = new ROI2DAlongT();
                roiInterval.loadFromXML(node_i);
                this.roisForKymo.add(roiInterval);
                if (i != 0) continue;
                this.roi = this.roisForKymo.get(0).getRoi_in();
            }
        }
        return true;
    }

    public boolean loadFromXML_MeasuresOnly(Node node) {
        String header = this.getLast2ofCapillaryName() + "_";
        boolean result = this.ptsTop.loadCapillaryLimitFromXML(node, "toplevel", header) > 0;
        result |= this.ptsBottom.loadCapillaryLimitFromXML(node, "bottomlevel", header) > 0;
        return result |= this.ptsDerivative.loadCapillaryLimitFromXML(node, "derivative", header) > 0;
    }

    public boolean saveToXML_CapillaryOnly(Node node) {
        Element nodeMeta = XMLUtil.setElement((Node)node, (String)"metaMC");
        if (nodeMeta == null) {
            return false;
        }
        if (this.version == null) {
            this.version = "1.0.0";
        }
        XMLUtil.setElementValue((Node)nodeMeta, (String)"version", (String)this.version);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"indexImageMC", (int)this.kymographIndex);
        XMLUtil.setElementValue((Node)nodeMeta, (String)"nameMC", (String)this.kymographName);
        if (this.filenameTIFF != null) {
            String filename = Paths.get(this.filenameTIFF, new String[0]).getFileName().toString();
            XMLUtil.setElementValue((Node)nodeMeta, (String)"filenameTIFF", (String)filename);
        }
        XMLUtil.setElementBooleanValue((Node)nodeMeta, (String)"descriptionOK", (boolean)this.descriptionOK);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"versionInfos", (int)this.versionInfos);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"nflies", (int)this.nFlies);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"cage_number", (int)this.cageID);
        XMLUtil.setElementDoubleValue((Node)nodeMeta, (String)"capillaryVolume", (double)this.volume);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"capillaryPixels", (int)this.pixels);
        XMLUtil.setElementValue((Node)nodeMeta, (String)"stimulus", (String)this.stimulus);
        XMLUtil.setElementValue((Node)nodeMeta, (String)"side", (String)this.cageSide);
        XMLUtil.setElementValue((Node)nodeMeta, (String)"concentration", (String)this.concentration);
        ROI2DUtilities.saveToXML_ROI(nodeMeta, this.roi);
        boolean flag = this.saveToXML_intervals(node);
        return flag;
    }

    private boolean saveToXML_intervals(Node node) {
        Element nodeMeta2 = XMLUtil.setElement((Node)node, (String)"INTERVALS");
        if (nodeMeta2 == null) {
            return false;
        }
        int nitems = this.roisForKymo.size();
        XMLUtil.setElementIntValue((Node)nodeMeta2, (String)"nintervals", (int)nitems);
        if (nitems > 0) {
            for (int i = 0; i < nitems; ++i) {
                Element node_i = XMLUtil.setElement((Node)nodeMeta2, (String)("interval_" + i));
                this.roisForKymo.get(i).saveToXML(node_i);
            }
        }
        return true;
    }

    public Point2D getCapillaryTipWithinROI2D(ROI2D roi2D) {
        Point2D pt = null;
        if (this.roi instanceof ROI2DPolyLine) {
            Polyline2D line = ((ROI2DPolyLine)this.roi).getPolyline2D();
            int last = line.npoints - 1;
            if (roi2D.contains(line.xpoints[0], line.ypoints[0])) {
                pt = new Point2D.Double(line.xpoints[0], line.ypoints[0]);
            } else if (roi2D.contains(line.xpoints[last], line.ypoints[last])) {
                pt = new Point2D.Double(line.xpoints[last], line.ypoints[last]);
            }
        } else if (this.roi instanceof ROI2DLine) {
            Line2D line = ((ROI2DLine)this.roi).getLine();
            if (roi2D.contains(line.getP1())) {
                pt = line.getP1();
            } else if (roi2D.contains(line.getP2())) {
                pt = line.getP2();
            }
        }
        return pt;
    }

    public Point2D getCapillaryROILowestPoint() {
        Point2D pt = null;
        if (this.roi instanceof ROI2DPolyLine) {
            Polyline2D line = ((ROI2DPolyLine)this.roi).getPolyline2D();
            int last = line.npoints - 1;
            pt = line.ypoints[0] > line.ypoints[last] ? new Point2D.Double(line.xpoints[0], line.ypoints[0]) : new Point2D.Double(line.xpoints[last], line.ypoints[last]);
        } else if (this.roi instanceof ROI2DLine) {
            Line2D line = ((ROI2DLine)this.roi).getLine();
            pt = line.getP1().getY() > line.getP2().getY() ? line.getP1() : line.getP2();
        }
        return pt;
    }

    public Point2D getCapillaryROIFirstPoint() {
        Point2D pt = null;
        if (this.roi instanceof ROI2DPolyLine) {
            Polyline2D line = ((ROI2DPolyLine)this.roi).getPolyline2D();
            pt = new Point2D.Double(line.xpoints[0], line.ypoints[0]);
        } else if (this.roi instanceof ROI2DLine) {
            Line2D line = ((ROI2DLine)this.roi).getLine();
            pt = line.getP1();
        }
        return pt;
    }

    public Point2D getCapillaryROILastPoint() {
        Point2D pt = null;
        if (this.roi instanceof ROI2DPolyLine) {
            Polyline2D line = ((ROI2DPolyLine)this.roi).getPolyline2D();
            int last = line.npoints - 1;
            pt = new Point2D.Double(line.xpoints[last], line.ypoints[last]);
        } else if (this.roi instanceof ROI2DLine) {
            Line2D line = ((ROI2DLine)this.roi).getLine();
            pt = line.getP2();
        }
        return pt;
    }

    public int getCapillaryROILength() {
        Point2D pt1 = this.getCapillaryROIFirstPoint();
        Point2D pt2 = this.getCapillaryROILastPoint();
        double npixels = Math.sqrt((pt2.getY() - pt1.getY()) * (pt2.getY() - pt1.getY()) + (pt2.getX() - pt1.getX()) * (pt2.getX() - pt1.getX()));
        return (int)npixels;
    }

    public void adjustToImageWidth(int imageWidth) {
        this.ptsTop.adjustToImageWidth(imageWidth);
        this.ptsBottom.adjustToImageWidth(imageWidth);
        this.ptsDerivative.adjustToImageWidth(imageWidth);
    }

    public void cropToImageWidth(int imageWidth) {
        this.ptsTop.cropToImageWidth(imageWidth);
        this.ptsBottom.cropToImageWidth(imageWidth);
        this.ptsDerivative.cropToImageWidth(imageWidth);
    }

    public List<ROI2DAlongT> getROIsForKymo() {
        if (this.roisForKymo.size() < 1) {
            this.initROI2DForKymoList();
        }
        return this.roisForKymo;
    }

    public ROI2DAlongT getROI2DKymoAt(int i) {
        if (this.roisForKymo.size() < 1) {
            this.initROI2DForKymoList();
        }
        return this.roisForKymo.get(i);
    }

    public ROI2DAlongT getROI2DKymoAtIntervalT(long t) {
        if (this.roisForKymo.size() < 1) {
            this.initROI2DForKymoList();
        }
        ROI2DAlongT capRoi = null;
        for (ROI2DAlongT item : this.roisForKymo) {
            if (t < item.getT()) break;
            capRoi = item;
        }
        return capRoi;
    }

    public void removeROI2DIntervalStartingAt(long start) {
        ROI2DAlongT itemFound = null;
        for (ROI2DAlongT item : this.roisForKymo) {
            if (start != item.getT()) continue;
            itemFound = item;
        }
        if (itemFound != null) {
            this.roisForKymo.remove(itemFound);
        }
    }

    private void initROI2DForKymoList() {
        this.roisForKymo.add(new ROI2DAlongT(0L, this.roi));
    }

    public void setVolumeAndPixels(double volume, int pixels) {
        this.volume = volume;
        this.pixels = pixels;
        this.descriptionOK = true;
    }

    public String csvExportCapillarySubSectionHeader(String sep) {
        StringBuffer sbf = new StringBuffer();
        sbf.append("#" + sep + "CAPILLARIES,describe each capillary\n");
        List<String> row2 = Arrays.asList("prefix", "kymoIndex", "kymographName", "kymoFile", "cage", "nflies", "volume", "npixel", "stim", "conc", "side");
        sbf.append(String.join((CharSequence)sep, row2));
        sbf.append("\n");
        return sbf.toString();
    }

    public String csvExportCapillaryDescription(String sep) {
        StringBuffer sbf = new StringBuffer();
        if (this.kymographPrefix == null) {
            this.kymographPrefix = this.getLast2ofCapillaryName();
        }
        List<String> row = Arrays.asList(this.kymographPrefix, Integer.toString(this.kymographIndex), this.kymographName, this.filenameTIFF, Integer.toString(this.cageID), Integer.toString(this.nFlies), Double.toString(this.volume), Integer.toString(this.pixels), this.stimulus.replace(sep, "."), this.concentration.replace(sep, "."), this.cageSide.replace(sep, "."));
        sbf.append(String.join((CharSequence)sep, row));
        sbf.append("\n");
        return sbf.toString();
    }

    public String csvExportMeasureSectionHeader(EnumCapillaryMeasures measureType, String sep) {
        StringBuffer sbf = new StringBuffer();
        String explanation1 = "columns=" + sep + "name" + sep + "index" + sep + " npts" + sep + "..,.(xi;yi)\n";
        switch (measureType) {
            case TOPLEVEL: {
                sbf.append("#" + sep + "TOPLEVEL" + sep + explanation1);
                break;
            }
            case BOTTOMLEVEL: {
                sbf.append("#" + sep + "BOTTOMLEVEL" + sep + explanation1);
                break;
            }
            case TOPDERIVATIVE: {
                sbf.append("#" + sep + "TOPDERIVATIVE" + sep + explanation1);
                break;
            }
            default: {
                sbf.append("#" + sep + "UNDEFINED" + sep + "------------\n");
            }
        }
        return sbf.toString();
    }

    public String csvExportCapillaryData(EnumCapillaryMeasures measureType, String sep) {
        StringBuffer sbf = new StringBuffer();
        sbf.append(this.kymographPrefix + sep + this.kymographIndex + sep);
        switch (measureType) {
            case TOPLEVEL: {
                this.ptsTop.cvsExportDataToRow(sbf, sep);
                break;
            }
            case BOTTOMLEVEL: {
                this.ptsBottom.cvsExportDataToRow(sbf, sep);
                break;
            }
            case TOPDERIVATIVE: {
                this.ptsDerivative.cvsExportDataToRow(sbf, sep);
                break;
            }
        }
        sbf.append("\n");
        return sbf.toString();
    }

    public void csvImportCapillaryDescription(String[] data) {
        int i = 0;
        this.kymographPrefix = data[i];
        this.kymographIndex = Integer.valueOf(data[++i]);
        this.kymographName = data[++i];
        this.filenameTIFF = data[++i];
        this.cageID = Integer.valueOf(data[++i]);
        this.nFlies = Integer.valueOf(data[++i]);
        this.volume = Double.valueOf(data[++i]);
        this.pixels = Integer.valueOf(data[++i]);
        this.stimulus = data[++i];
        this.concentration = data[++i];
        this.cageSide = data[++i];
    }

    public void csvImportCapillaryData(EnumCapillaryMeasures measureType, String[] data) {
        switch (measureType) {
            case TOPLEVEL: {
                this.ptsTop.csvImportDataFromRow(data, 2);
                break;
            }
            case BOTTOMLEVEL: {
                this.ptsBottom.csvImportDataFromRow(data, 2);
                break;
            }
            case TOPDERIVATIVE: {
                this.ptsDerivative.csvImportDataFromRow(data, 2);
                break;
            }
        }
    }
}

