/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.experiment;

import icy.image.IcyBufferedImage;
import icy.roi.BooleanMask2D;
import icy.roi.ROI2D;
import icy.util.XMLUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multiSPOTS.experiment.EnumSpotMeasures;
import plugins.fmp.multiSPOTS.experiment.Level2D;
import plugins.fmp.multiSPOTS.experiment.ROI2DAlongT;
import plugins.fmp.multiSPOTS.experiment.SpotMeasure;
import plugins.fmp.multiSPOTS.series.BuildSeriesOptions;
import plugins.fmp.multiSPOTS.tools.ROI2D.ROI2DUtilities;
import plugins.fmp.multiSPOTS.tools.toExcel.EnumXLSColumnHeader;
import plugins.fmp.multiSPOTS.tools.toExcel.EnumXLSExportType;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class Spot
implements Comparable<Spot> {
    private ROI2DShape spotRoi_in = null;
    private ROI2DShape spotRoi_out = null;
    private ROI2DShape spotRoi_old = null;
    private ArrayList<ROI2DAlongT> listRoiAlongT = new ArrayList();
    public BooleanMask2D mask2DSpot = null;
    public int cageIndex = -1;
    public String version = null;
    public String spotStim = new String("..");
    public String spotConc = new String("..");
    public String spotCageSide = ".";
    public int spotNFlies = 1;
    public int spotIndex = 0;
    public double spotVolume = 1.0;
    public int spotNPixels = 1;
    public int radius = 30;
    public boolean descriptionOK = false;
    public int versionInfos = 0;
    public BuildSeriesOptions limitsOptions = new BuildSeriesOptions();
    public int spot_CamData_T = -1;
    public int spot_Kymograph_T = -1;
    public String spot_filenameTIFF = null;
    public IcyBufferedImage spot_Image = null;
    public SpotMeasure sum_in = new SpotMeasure("sum");
    public SpotMeasure sum_clean = new SpotMeasure("clean");
    public SpotMeasure flyPresent = new SpotMeasure("flyPresent");
    public boolean valid = true;
    private final String ID_META = "metaMC";
    private final String ID_NFLIES = "nflies";
    private final String ID_CAGENB = "cage_number";
    private final String ID_SPOTVOLUME = "volume";
    private final String ID_PIXELS = "pixels";
    private final String ID_RADIUS = "radius";
    private final String ID_STIML = "stimulus";
    private final String ID_CONCL = "concentration";
    private final String ID_SIDE = "side";
    private final String ID_DESCOK = "descriptionOK";
    private final String ID_VERSIONINFOS = "versionInfos";
    private final String ID_INTERVALS = "INTERVALS";
    private final String ID_NINTERVALS = "nintervals";
    private final String ID_INTERVAL = "interval_";
    private final String ID_INDEXIMAGE = "indexImageMC";
    private final String ID_VERSION = "version";
    private final String ID_VERSIONNUM = "1.0.0";

    public Spot(ROI2DShape roi) {
        this.spotRoi_in = roi;
    }

    Spot(String name) {
    }

    public Spot() {
    }

    @Override
    public int compareTo(Spot o) {
        if (o != null) {
            return this.spotRoi_in.getName().compareTo(o.spotRoi_in.getName());
        }
        return 1;
    }

    public void copySpot(Spot spotFrom) {
        this.cageIndex = spotFrom.cageIndex;
        this.version = spotFrom.version;
        this.spotRoi_in = (ROI2DShape)spotFrom.spotRoi_in.getCopy();
        this.spotStim = spotFrom.spotStim;
        this.spotConc = spotFrom.spotConc;
        this.spotCageSide = spotFrom.spotCageSide;
        this.spotNFlies = spotFrom.spotNFlies;
        this.spotIndex = spotFrom.spotIndex;
        this.spotVolume = spotFrom.spotVolume;
        this.spotNPixels = spotFrom.spotNPixels;
        this.radius = spotFrom.radius;
        this.limitsOptions = spotFrom.limitsOptions;
        this.sum_in.copyLevel2D(spotFrom.sum_in);
        this.sum_clean.copyLevel2D(spotFrom.sum_clean);
        this.flyPresent.copyLevel2D(spotFrom.flyPresent);
    }

    public ROI2D getRoi_in() {
        return this.spotRoi_in;
    }

    public ROI2D getRoi_old() {
        return this.spotRoi_old;
    }

    public ROI2D getRoi_out() {
        return this.spotRoi_out;
    }

    public void setRoi_in(ROI2DShape roi) {
        this.spotRoi_in = roi;
        this.listRoiAlongT.clear();
    }

    public void setRoi_old(ROI2DShape roi) {
        this.spotRoi_old = roi;
    }

    public void setRoi_out(ROI2DShape roi) {
        this.spotRoi_out = roi;
    }

    public void setRoiName(String name) {
        this.spotRoi_in.setName(name);
    }

    public String getRoiName() {
        return this.spotRoi_in.getName();
    }

    public String getLast2ofSpotName() {
        if (this.spotRoi_in == null) {
            return "missing";
        }
        return this.spotRoi_in.getName().substring(this.spotRoi_in.getName().length() - 2);
    }

    public String getSpotSide() {
        return this.spotRoi_in.getName().substring(this.spotRoi_in.getName().length() - 2);
    }

    public static String xreplace_LR_with_12(String name) {
        String newname = name;
        if (name.contains("R")) {
            newname = name.replace("R", "2");
        } else if (name.contains("L")) {
            newname = name.replace("L", "1");
        }
        return newname;
    }

    public int getCageIndexFromRoiName() {
        String name = this.spotRoi_in.getName();
        if (!name.contains("spot")) {
            return -1;
        }
        return Integer.valueOf(name.substring(4, 6));
    }

    public String getSideDescriptor(EnumXLSExportType xlsExportOption) {
        String value = null;
        this.spotCageSide = this.getSpotSide();
        switch (xlsExportOption) {
            case DISTANCE: 
            case ISALIVE: {
                value = this.spotCageSide + "(T=B)";
                break;
            }
            case TOPLEVELDELTA_LR: 
            case TOPLEVEL_LR: {
                if (this.spotCageSide.equals("00")) {
                    value = "sum";
                    break;
                }
                value = "PI";
                break;
            }
            case XYIMAGE: 
            case XYTOPCAGE: 
            case XYTIPCAPS: {
                if (this.spotCageSide.equals("00")) {
                    value = "x";
                    break;
                }
                value = "y";
                break;
            }
            default: {
                value = this.spotCageSide;
            }
        }
        return value;
    }

    public String getSpotField(EnumXLSColumnHeader fieldEnumCode) {
        String stringValue = null;
        switch (fieldEnumCode) {
            case CAP_STIM: {
                stringValue = this.spotStim;
                break;
            }
            case CAP_CONC: {
                stringValue = this.spotConc;
                break;
            }
        }
        return stringValue;
    }

    public void setSpotField(EnumXLSColumnHeader fieldEnumCode, String stringValue) {
        switch (fieldEnumCode) {
            case CAP_STIM: {
                this.spotStim = stringValue;
                break;
            }
            case CAP_CONC: {
                this.spotConc = stringValue;
                break;
            }
        }
    }

    public Point2D getSpotCenter() {
        Point pt = this.spotRoi_in.getPosition();
        Rectangle rect = this.spotRoi_in.getBounds();
        pt.translate(rect.height / 2, rect.width / 2);
        return pt;
    }

    private SpotMeasure getSpotArea(EnumXLSExportType option) {
        switch (option) {
            case AREA_SUM: 
            case AREA_SUM_LR: {
                return this.sum_in;
            }
            case AREA_SUMCLEAN: 
            case AREA_SUMCLEAN_LR: {
                return this.sum_clean;
            }
            case AREA_FLYPRESENT: {
                return this.flyPresent;
            }
        }
        return null;
    }

    public boolean isThereAnyMeasuresDone(EnumXLSExportType option) {
        SpotMeasure spotArea = this.getSpotArea(option);
        if (spotArea != null) {
            return spotArea.isThereAnyMeasuresDone();
        }
        return false;
    }

    public ArrayList<Double> getSpotMeasuresForXLSPass1(EnumXLSExportType option, long seriesBinMs, long outputBinMs) {
        SpotMeasure spotArea = this.getSpotArea(option);
        if (spotArea != null) {
            return spotArea.getLevel2D_Y_subsampled(seriesBinMs, outputBinMs);
        }
        return null;
    }

    public void cropSpotMeasuresToNPoints(int npoints) {
        this.cropSpotMeasureToNPoints(this.sum_in, npoints);
        this.cropSpotMeasureToNPoints(this.sum_clean, npoints);
        this.cropSpotMeasureToNPoints(this.flyPresent, npoints);
    }

    private void cropSpotMeasureToNPoints(SpotMeasure spotMeasure, int npoints) {
        if (spotMeasure.getLevel2DNPoints() > 0) {
            spotMeasure.cropLevel2DToNPoints(npoints);
        }
    }

    public void restoreClippedSpotMeasures() {
        this.restoreClippedMeasures(this.sum_in);
        this.restoreClippedMeasures(this.sum_clean);
        this.restoreClippedMeasures(this.flyPresent);
    }

    private void restoreClippedMeasures(SpotMeasure spotMeasure) {
        if (spotMeasure.getLevel2DNPoints() > 0) {
            spotMeasure.restoreCroppedLevel2D();
        }
    }

    public void transferROIsMeasuresToLevel2D() {
        this.sum_in.transferROItoLevel2D();
        this.sum_clean.transferROItoLevel2D();
        this.flyPresent.transferROItoLevel2D();
    }

    public boolean loadFromXML_SpotOnly(Node node) {
        boolean flag;
        Element nodeMeta = XMLUtil.getElement((Node)node, (String)"metaMC");
        boolean bl = flag = nodeMeta != null;
        if (flag) {
            this.version = XMLUtil.getElementValue((Node)nodeMeta, (String)"version", (String)"0.0.0");
            this.cageIndex = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"indexImageMC", (int)this.cageIndex);
            this.descriptionOK = XMLUtil.getElementBooleanValue((Node)nodeMeta, (String)"descriptionOK", (boolean)false);
            this.versionInfos = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"versionInfos", (int)0);
            this.spotNFlies = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"nflies", (int)this.spotNFlies);
            this.spotIndex = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"cage_number", (int)this.spotIndex);
            this.spotVolume = XMLUtil.getElementDoubleValue((Node)nodeMeta, (String)"volume", (double)Double.NaN);
            this.spotNPixels = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"pixels", (int)5);
            this.radius = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"radius", (int)30);
            this.spotStim = XMLUtil.getElementValue((Node)nodeMeta, (String)"stimulus", (String)"stimulus");
            this.spotConc = XMLUtil.getElementValue((Node)nodeMeta, (String)"concentration", (String)"concentration");
            this.spotCageSide = XMLUtil.getElementValue((Node)nodeMeta, (String)"side", (String)".");
            this.spotRoi_in = (ROI2DShape)ROI2DUtilities.loadFromXML_ROI(nodeMeta);
            this.limitsOptions.loadFromXML(nodeMeta);
            this.loadFromXML_SpotAlongT(node);
        }
        return flag;
    }

    private boolean loadFromXML_SpotAlongT(Node node) {
        this.listRoiAlongT.clear();
        Element nodeMeta2 = XMLUtil.getElement((Node)node, (String)"INTERVALS");
        if (nodeMeta2 == null) {
            return false;
        }
        int nitems = XMLUtil.getElementIntValue((Node)nodeMeta2, (String)"nintervals", (int)0);
        if (nitems > 0) {
            for (int i = 0; i < nitems; ++i) {
                Element node_i = XMLUtil.setElement((Node)nodeMeta2, (String)("interval_" + i));
                ROI2DAlongT roiInterval = new ROI2DAlongT();
                roiInterval.loadFromXML(node_i);
                this.listRoiAlongT.add(roiInterval);
                if (i != 0) continue;
                this.spotRoi_in = (ROI2DShape)this.listRoiAlongT.get(0).getRoi_in();
            }
        }
        return true;
    }

    public boolean saveToXML_SpotOnly(Node node) {
        Element nodeMeta = XMLUtil.setElement((Node)node, (String)"metaMC");
        if (nodeMeta == null) {
            return false;
        }
        if (this.version == null) {
            this.version = "1.0.0";
        }
        XMLUtil.setElementValue((Node)nodeMeta, (String)"version", (String)this.version);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"indexImageMC", (int)this.cageIndex);
        XMLUtil.setElementBooleanValue((Node)nodeMeta, (String)"descriptionOK", (boolean)this.descriptionOK);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"versionInfos", (int)this.versionInfos);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"nflies", (int)this.spotNFlies);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"cage_number", (int)this.spotIndex);
        XMLUtil.setElementDoubleValue((Node)nodeMeta, (String)"volume", (double)this.spotVolume);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"pixels", (int)this.spotNPixels);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"radius", (int)this.radius);
        XMLUtil.setElementValue((Node)nodeMeta, (String)"stimulus", (String)this.spotStim);
        XMLUtil.setElementValue((Node)nodeMeta, (String)"side", (String)this.spotCageSide);
        XMLUtil.setElementValue((Node)nodeMeta, (String)"concentration", (String)this.spotConc);
        ROI2DUtilities.saveToXML_ROI(nodeMeta, (ROI2D)this.spotRoi_in);
        boolean flag = this.saveToXML_SpotAlongT(node);
        return flag;
    }

    private boolean saveToXML_SpotAlongT(Node node) {
        Element nodeMeta2 = XMLUtil.setElement((Node)node, (String)"INTERVALS");
        if (nodeMeta2 == null) {
            return false;
        }
        int nitems = this.listRoiAlongT.size();
        XMLUtil.setElementIntValue((Node)nodeMeta2, (String)"nintervals", (int)nitems);
        if (nitems > 0) {
            for (int i = 0; i < nitems; ++i) {
                Element node_i = XMLUtil.setElement((Node)nodeMeta2, (String)("interval_" + i));
                this.listRoiAlongT.get(i).saveToXML(node_i);
            }
        }
        return true;
    }

    public List<ROI2DAlongT> getROIAlongTList() {
        if (this.listRoiAlongT.size() < 1) {
            this.initROIAlongTList();
        }
        return this.listRoiAlongT;
    }

    public ROI2DAlongT getROIAtT(long t) {
        if (this.listRoiAlongT.size() < 1) {
            this.initROIAlongTList();
        }
        ROI2DAlongT spotRoi = null;
        for (ROI2DAlongT item : this.listRoiAlongT) {
            if (t < item.getT()) break;
            spotRoi = item;
        }
        return spotRoi;
    }

    public void removeROIAlongTListItem(long t) {
        ROI2DAlongT itemFound = null;
        for (ROI2DAlongT item : this.listRoiAlongT) {
            if (t != item.getT()) continue;
            itemFound = item;
        }
        if (itemFound != null) {
            this.listRoiAlongT.remove(itemFound);
        }
    }

    private void initROIAlongTList() {
        this.listRoiAlongT.add(new ROI2DAlongT(0L, (ROI2D)this.spotRoi_in));
    }

    public void adjustLevel2DMeasuresToImageWidth(int imageWidth) {
        this.sum_in.adjustLevel2DToImageWidth(imageWidth);
        this.sum_clean.adjustLevel2DToImageWidth(imageWidth);
        this.flyPresent.adjustLevel2DToImageWidth(imageWidth);
    }

    public void cropLevel2DMeasuresToImageWidth(int imageWidth) {
        this.sum_in.cropLevel2DToNPoints(imageWidth);
        this.sum_clean.cropLevel2DToNPoints(imageWidth);
        this.flyPresent.cropLevel2DToNPoints(imageWidth);
    }

    public void initLevel2DMeasures() {
        this.sum_in.initLevel2D_fromMeasureValues(this.getRoi_in().getName());
        this.sum_clean.initLevel2D_fromMeasureValues(this.getRoi_in().getName());
        this.flyPresent.initLevel2D_fromBooleans(this.getRoi_in().getName());
    }

    public void buildRunningMedianFromSumLevel2D(int imageHeight) {
        int span = 10;
        if (this.sum_in.values != null) {
            this.sum_clean.buildRunningMedian(span, this.sum_in.values);
        } else {
            this.sum_clean.buildRunningMedian(span, this.sum_in.getLevel2D().ypoints);
        }
        this.sum_clean.initLevel2D_fromMeasureValues(this.sum_clean.getName());
    }

    public List<ROI2D> transferSpotMeasuresToROIs(int imageHeight) {
        ArrayList<ROI2D> measuresRoisList = new ArrayList<ROI2D>();
        if (this.sum_in.getLevel2DNPoints() != 0) {
            measuresRoisList.add((ROI2D)this.sum_in.getROIForImage(this.spotRoi_in.getName(), this.spot_Kymograph_T, imageHeight));
        }
        if (this.sum_clean.getLevel2DNPoints() != 0) {
            measuresRoisList.add((ROI2D)this.sum_clean.getROIForImage(this.spotRoi_in.getName(), this.spot_Kymograph_T, imageHeight));
        }
        if (this.flyPresent.getLevel2DNPoints() != 0) {
            measuresRoisList.add((ROI2D)this.flyPresent.getROIForImage(this.spotRoi_in.getName(), this.spot_Kymograph_T, 10));
        }
        return measuresRoisList;
    }

    public void transferROItoMeasures(ROI2D roi, int imageHeight) {
        String name = roi.getName();
        if (name.contains(this.sum_in.getName())) {
            this.transferROItoMeasureValue(roi, imageHeight, this.sum_in);
        } else if (name.contains(this.sum_clean.getName())) {
            this.transferROItoMeasureValue(roi, imageHeight, this.sum_clean);
        } else if (name.contains(this.flyPresent.getName())) {
            this.transferROItoMeasureBoolean(roi, this.flyPresent);
        }
    }

    private void transferROItoMeasureValue(ROI2D roi, int imageHeight, SpotMeasure spotMeasure) {
        if (roi instanceof ROI2DPolyLine) {
            Level2D level2D = new Level2D(((ROI2DPolyLine)roi).getPolyline2D());
            level2D.multiply_Y(imageHeight);
            spotMeasure.setLevel2D(level2D);
        }
    }

    private void transferROItoMeasureBoolean(ROI2D roi, SpotMeasure spotMeasure) {
        if (roi instanceof ROI2DPolyLine) {
            Level2D level2D = new Level2D(((ROI2DPolyLine)roi).getPolyline2D());
            level2D.threshold_Y(1.0);
            spotMeasure.setLevel2D(level2D);
        }
    }

    public String csvExportSpotArrayHeader(String csvSep) {
        StringBuffer sbf = new StringBuffer();
        sbf.append("#" + csvSep + "SPOTS" + csvSep + "describe each spot\n");
        List<String> row2 = Arrays.asList("index", "name", "cage", "nflies", "volume", "npixel", "radius", "stim", "conc", "side");
        sbf.append(String.join((CharSequence)csvSep, row2));
        sbf.append("\n");
        return sbf.toString();
    }

    public String csvExportDescription(String csvSep) {
        StringBuffer sbf = new StringBuffer();
        List<String> row = Arrays.asList(Integer.toString(this.spotIndex), this.getRoi_in().getName(), Integer.toString(this.cageIndex), Integer.toString(this.spotNFlies), Double.toString(this.spotVolume), Integer.toString(this.spotNPixels), Integer.toString(this.radius), this.spotStim.replace(",", "."), this.spotConc.replace(",", "."), this.spotCageSide.replace(",", "."));
        sbf.append(String.join((CharSequence)csvSep, row));
        sbf.append("\n");
        return sbf.toString();
    }

    public String csvExportMeasures_SectionHeader(EnumSpotMeasures measureType, String csvSep) {
        StringBuffer sbf = new StringBuffer();
        List<String> listExplanation1 = Arrays.asList("\n name", "index", "npts", "yi", "\n");
        String explanation1 = String.join((CharSequence)csvSep, listExplanation1);
        switch (measureType) {
            case AREA_SUM: 
            case AREA_SUMCLEAN: 
            case AREA_FLYPRESENT: 
            case AREA_OUT: 
            case AREA_DIFF: {
                sbf.append("#" + csvSep + measureType.toString() + csvSep + explanation1);
                break;
            }
            default: {
                sbf.append("#" + csvSep + "UNDEFINED" + csvSep + "------------\n");
            }
        }
        return sbf.toString();
    }

    public String csvExportMeasures_OneType(EnumSpotMeasures measureType, String csvSep) {
        StringBuffer sbf = new StringBuffer();
        sbf.append(this.spotRoi_in.getName() + csvSep + this.spotIndex + csvSep);
        switch (measureType) {
            case AREA_SUM: {
                this.sum_in.cvsExportYDataToRow(sbf, csvSep);
                break;
            }
            case AREA_SUMCLEAN: {
                this.sum_clean.cvsExportYDataToRow(sbf, csvSep);
                break;
            }
            case AREA_FLYPRESENT: {
                this.flyPresent.cvsExportYDataToRow(sbf, csvSep);
                break;
            }
        }
        sbf.append("\n");
        return sbf.toString();
    }

    public void csvImportDescription(String[] data, boolean dummyColumn) {
        int i = dummyColumn ? 1 : 0;
        this.spotIndex = Integer.valueOf(data[i]);
        this.spotRoi_in.setName(data[++i]);
        this.cageIndex = Integer.valueOf(data[++i]);
        this.spotNFlies = Integer.valueOf(data[++i]);
        this.spotVolume = Double.valueOf(data[++i]);
        this.spotNPixels = Integer.valueOf(data[++i]);
        this.radius = Integer.valueOf(data[++i]);
        this.spotStim = data[++i];
        this.spotConc = data[++i];
        this.spotCageSide = data[++i];
    }

    public void csvImportMeasures_OneType(EnumSpotMeasures measureType, String[] data, boolean x, boolean y) {
        if (x && y) {
            switch (measureType) {
                case AREA_SUM: {
                    this.sum_in.csvImportXYDataFromRow(data, 2);
                    break;
                }
                case AREA_SUMCLEAN: {
                    this.sum_clean.csvImportXYDataFromRow(data, 2);
                    break;
                }
                case AREA_FLYPRESENT: {
                    this.flyPresent.csvImportXYDataFromRow(data, 2);
                    break;
                }
            }
        } else if (!x && y) {
            switch (measureType) {
                case AREA_SUM: {
                    this.sum_in.csvImportYDataFromRow(data, 2);
                    break;
                }
                case AREA_SUMCLEAN: {
                    this.sum_clean.csvImportYDataFromRow(data, 2);
                    break;
                }
                case AREA_FLYPRESENT: {
                    this.flyPresent.csvImportYDataFromRow(data, 2);
                    break;
                }
            }
        }
    }
}

