/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.experiment;

import icy.type.geom.Polyline2D;
import icy.util.StringUtil;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import plugins.fmp.multiSPOTS.experiment.Level2D;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;

public class SpotMeasure {
    private Level2D level2D = new Level2D();
    private Level2D leve2D_old = new Level2D();
    public double[] values = null;
    public int[] isPresent = null;
    private ROI2DPolyLine roi = null;
    private double factor = 1.0;
    private String name = "noname";

    SpotMeasure(String name) {
        this.setName(name);
    }

    public SpotMeasure(String name, List<Point2D> limit) {
        this.setName(name);
        this.setLevel2D(new Level2D(limit));
    }

    void copyLevel2D(SpotMeasure sourceSpotMeasure) {
        if (sourceSpotMeasure.getLevel2D() != null) {
            this.setLevel2D(sourceSpotMeasure.getLevel2D().clone());
        }
    }

    void clearLevel2D() {
        this.setLevel2D(new Level2D());
    }

    void initLevel2D_fromMeasureValues(String name) {
        this.setName(name);
        int ii_start = 0;
        int ii_end = this.values.length - 1;
        int npoints = this.values.length;
        double[] xpoints = new double[npoints];
        double[] ypoints = new double[npoints];
        int j = 0;
        int i = ii_start;
        while (i < ii_end) {
            xpoints[j] = i;
            ypoints[j] = this.values[j];
            ++i;
            ++j;
        }
        this.setLevel2D(new Level2D(xpoints, ypoints, npoints));
    }

    void initLevel2D_fromBooleans(String name) {
        this.setName(name);
        int xStart = 0;
        int xEnd = this.isPresent.length - 1;
        int npoints = this.isPresent.length;
        double[] xpoints = new double[npoints];
        double[] ypoints = new double[npoints];
        int j = 0;
        int i = xStart;
        while (i < xEnd) {
            xpoints[j] = i;
            ypoints[j] = this.isPresent[j] > 0 ? 1.0 : 0.0;
            ++i;
            ++j;
        }
        this.setLevel2D(new Level2D(xpoints, ypoints, npoints));
    }

    int getLevel2DNPoints() {
        if (this.getLevel2D() == null) {
            return 0;
        }
        return this.getLevel2D().npoints;
    }

    public Level2D getLevel2D() {
        return this.level2D;
    }

    public void setLevel2D(Level2D level2d) {
        this.level2D = level2d;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ROI2DPolyLine getRoi() {
        return this.roi;
    }

    public void setRoi(ROI2DPolyLine roi) {
        this.roi = roi;
    }

    boolean isThereAnyMeasuresDone() {
        return this.getLevel2D() != null && this.getLevel2D().npoints > 0;
    }

    ArrayList<Double> getLevel2D_Y_subsampled(long seriesBinMs, long outputBinMs) {
        if (this.getLevel2D() == null || this.getLevel2D().npoints == 0) {
            return null;
        }
        long maxMs = (long)(this.getLevel2D().ypoints.length - 1) * seriesBinMs;
        long npoints = maxMs / outputBinMs + 1L;
        ArrayList<Double> arrayDouble = new ArrayList<Double>((int)npoints);
        for (double iMs = 0.0; iMs <= (double)maxMs; iMs += (double)outputBinMs) {
            int index = (int)(iMs / (double)seriesBinMs);
            arrayDouble.add(this.getLevel2D().ypoints[index]);
        }
        return arrayDouble;
    }

    List<Double> getLevel2D_Y() {
        if (this.getLevel2D() == null || this.getLevel2D().npoints == 0) {
            return null;
        }
        ArrayList<Double> arrayDouble = new ArrayList<Double>(this.getLevel2D().ypoints.length);
        for (double i : this.getLevel2D().ypoints) {
            arrayDouble.add(i);
        }
        return arrayDouble;
    }

    void adjustLevel2DToImageWidth(int imageWidth) {
        if (this.getLevel2D() == null || this.getLevel2D().npoints == 0) {
            return;
        }
        int npoints = this.getLevel2D().npoints;
        int npoints_old = 0;
        if (this.leve2D_old != null && this.leve2D_old.npoints > npoints) {
            npoints_old = this.leve2D_old.npoints;
        }
        if (npoints == imageWidth || npoints_old == imageWidth) {
            return;
        }
        if (npoints > imageWidth) {
            int newSize = imageWidth;
            if (npoints < npoints_old) {
                newSize = 1 + imageWidth * npoints / npoints_old;
            }
            this.setLevel2D(this.getLevel2D().contractPolylineToNewWidth(newSize));
            if (npoints_old != 0) {
                this.leve2D_old = this.leve2D_old.contractPolylineToNewWidth(imageWidth);
            }
        } else {
            int newSize = imageWidth;
            if (npoints < npoints_old) {
                newSize = imageWidth * npoints / npoints_old;
            }
            this.setLevel2D(this.getLevel2D().expandPolylineToNewWidth(newSize));
            if (npoints_old != 0) {
                this.leve2D_old = this.leve2D_old.expandPolylineToNewWidth(imageWidth);
            }
        }
    }

    void cropLevel2DToNPoints(int npoints) {
        if (npoints >= this.getLevel2D().npoints) {
            return;
        }
        if (this.leve2D_old == null) {
            this.leve2D_old = this.getLevel2D().clone();
        }
        this.setLevel2D(this.getLevel2D().cropPolylineToNewWidth(npoints));
    }

    int restoreCroppedLevel2D() {
        if (this.leve2D_old != null) {
            this.setLevel2D(this.leve2D_old.clone());
        }
        return this.getLevel2D().npoints;
    }

    public ROI2DPolyLine getROIForImage(String name, int t, int imageHeight) {
        this.roi = this.getROI2DFromLevel2D(this.getLevel2D(), imageHeight);
        String roiname = name + "_" + this.getName();
        this.roi.setName(roiname);
        this.roi.setT(t);
        this.setROI2DColorAndStrokeFromName();
        return this.roi;
    }

    private ROI2DPolyLine getROI2DFromLevel2D(Level2D level2D, int imageHeight) {
        Polyline2D polyline = new Polyline2D(level2D.xpoints, level2D.ypoints, level2D.npoints);
        this.factor = (double)imageHeight / level2D.getBounds().getMaxY();
        for (int i = 0; i < level2D.npoints; ++i) {
            polyline.xpoints[i] = level2D.xpoints[i];
            polyline.ypoints[i] = level2D.ypoints[i] * this.factor;
        }
        return new ROI2DPolyLine(polyline);
    }

    public Polyline2D getPolyline2DFromLevel2D(Level2D level2D, int imageHeight) {
        Polyline2D polyline = new Polyline2D(level2D.xpoints, level2D.ypoints, level2D.npoints);
        this.factor = (double)imageHeight / level2D.getBounds().getMaxY();
        for (int i = 0; i < level2D.npoints; ++i) {
            polyline.xpoints[i] = level2D.xpoints[i];
            polyline.ypoints[i] = level2D.ypoints[i] * this.factor;
        }
        return polyline;
    }

    private void setROI2DColorAndStrokeFromName() {
        Color color = null;
        Double stroke = 1.0;
        switch (this.name) {
            case "sum": {
                color = Color.red;
                stroke = 0.5;
                break;
            }
            case "clean": {
                color = Color.green;
                break;
            }
            default: {
                color = Color.blue;
            }
        }
        this.roi.setColor(color);
        this.roi.setStroke(stroke.doubleValue());
    }

    public void transferROItoLevel2D() {
        Polyline2D polyline = this.roi.getPolyline2D();
        if (polyline.npoints != this.level2D.npoints) {
            this.level2D = new Level2D(polyline.npoints);
        }
        for (int i = 0; i < polyline.npoints; ++i) {
            this.level2D.xpoints[i] = polyline.xpoints[i];
            this.level2D.ypoints[i] = polyline.ypoints[i] / this.factor;
        }
    }

    public void buildRunningMedian(int span, double[] yvalues) {
        int nbspan = span / 2;
        int sizeTempArray = nbspan * 2 + 1;
        double[] tempArraySorted = new double[sizeTempArray];
        double[] tempArrayCircular = new double[sizeTempArray];
        int npoints = yvalues.length;
        this.values = new double[npoints];
        int t2 = npoints - 1;
        int t1 = 0;
        while (t1 < nbspan) {
            this.values[t1] = yvalues[t1];
            this.values[t2] = yvalues[t2];
            ++t1;
            --t2;
        }
        for (int t = 0; t < sizeTempArray; ++t) {
            double value;
            tempArrayCircular[t] = value = yvalues[t];
            this.values[t] = value;
        }
        int iarraycircular = sizeTempArray - 1;
        for (int t = nbspan; t < npoints - nbspan; ++t) {
            double newvalue;
            int bin = t + nbspan;
            tempArrayCircular[iarraycircular] = newvalue = yvalues[t];
            tempArraySorted = (double[])tempArrayCircular.clone();
            Arrays.sort(tempArraySorted);
            double median = tempArraySorted[nbspan];
            bin = t;
            this.values[bin] = median;
            if (++iarraycircular < sizeTempArray) continue;
            iarraycircular = 0;
        }
    }

    public boolean cvsExportXYDataToRow(StringBuffer sbf, String sep) {
        int npoints = 0;
        if (this.getLevel2D() != null && this.getLevel2D().npoints > 0) {
            npoints = this.getLevel2D().npoints;
        }
        sbf.append(Integer.toString(npoints) + sep);
        if (npoints > 0) {
            for (int i = 0; i < this.getLevel2D().npoints; ++i) {
                sbf.append(StringUtil.toString((double)this.getLevel2D().xpoints[i]));
                sbf.append(sep);
                sbf.append(StringUtil.toString((double)this.getLevel2D().ypoints[i]));
                sbf.append(sep);
            }
        }
        return true;
    }

    public boolean cvsExportYDataToRow(StringBuffer sbf, String sep) {
        int npoints = 0;
        if (this.getLevel2D() != null && this.getLevel2D().npoints > 0) {
            npoints = this.getLevel2D().npoints;
        }
        sbf.append(Integer.toString(npoints) + sep);
        if (npoints > 0) {
            for (int i = 0; i < this.getLevel2D().npoints; ++i) {
                sbf.append(StringUtil.toString((double)this.getLevel2D().ypoints[i]));
                sbf.append(sep);
            }
        }
        return true;
    }

    public boolean csvImportXYDataFromRow(String[] data, int startAt) {
        if (data.length < startAt) {
            return false;
        }
        int npoints = Integer.valueOf(data[startAt]);
        if (npoints > 0) {
            double[] x = new double[npoints];
            double[] y = new double[npoints];
            int offset = startAt + 1;
            for (int i = 0; i < npoints; ++i) {
                x[i] = Double.valueOf(data[offset]);
                y[i] = Double.valueOf(data[++offset]);
                ++offset;
            }
            this.setLevel2D(new Level2D(x, y, npoints));
        }
        return true;
    }

    public boolean csvImportYDataFromRow(String[] data, int startAt) {
        if (data.length < startAt) {
            return false;
        }
        int npoints = Integer.valueOf(data[startAt]);
        if (npoints > 0) {
            double[] x = new double[npoints];
            double[] y = new double[npoints];
            int offset = startAt + 1;
            for (int i = 0; i < npoints; ++i) {
                x[i] = i;
                y[i] = Double.valueOf(data[offset]);
                ++offset;
            }
            this.setLevel2D(new Level2D(x, y, npoints));
        }
        return true;
    }
}

