/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.tools.ImageTransform.Transforms;

import icy.image.IcyBufferedImage;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import plugins.fmp.multiSPOTS.tools.ImageTransform.ImageTransformFunctionAbstract;
import plugins.fmp.multiSPOTS.tools.ImageTransform.ImageTransformInterface;
import plugins.fmp.multiSPOTS.tools.ImageTransform.ImageTransformOptions;

public class LinearCombination
extends ImageTransformFunctionAbstract
implements ImageTransformInterface {
    double w0 = 1.0;
    double w1 = 1.0;
    double w2 = 1.0;

    public LinearCombination(double w0, double w1, double w2) {
        this.w0 = w0;
        this.w1 = w1;
        this.w2 = w2;
    }

    @Override
    public IcyBufferedImage getTransformedImage(IcyBufferedImage sourceImage, ImageTransformOptions options) {
        return this.functionRGBtoLinearCombination(sourceImage, options.copyResultsToThe3planes);
    }

    protected IcyBufferedImage functionRGBtoLinearCombination(IcyBufferedImage sourceImage, boolean copyResultsTo3Planes) {
        IcyBufferedImage img2 = new IcyBufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 3, sourceImage.getDataType_());
        double[] tabAdd0 = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(0), (boolean)sourceImage.isSignedDataType());
        double[] tabAdd1 = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(1), (boolean)sourceImage.isSignedDataType());
        double[] tabAdd2 = Array1DUtil.arrayToDoubleArray((Object)sourceImage.getDataXY(2), (boolean)sourceImage.isSignedDataType());
        double[] tabResult = (double[])Array1DUtil.createArray((DataType)DataType.DOUBLE, (int)tabAdd0.length);
        for (int i = 0; i < tabResult.length; ++i) {
            double val;
            tabResult[i] = val = tabAdd0[i] * this.w0 + tabAdd1[i] * this.w1 + tabAdd2[i] * this.w2;
        }
        this.copyExGDoubleToIcyBufferedImage(tabResult, img2, copyResultsTo3Planes);
        return img2;
    }
}

