/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.tools.chart;

import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import icy.gui.viewer.Viewer;
import icy.roi.ROI;
import icy.roi.ROI2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.Spot;
import plugins.fmp.multiSPOTS.tools.toExcel.EnumXLSExportType;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSExport;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSExportOptions;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSResults;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSResultsArray;

public class ChartSpots
extends IcyFrame {
    public JPanel mainChartPanel = null;
    public IcyFrame mainChartFrame = null;
    private MultiSPOTS parent0 = null;
    private Point pt = new Point(0, 0);
    private boolean flagMaxMinSet = false;
    private double globalYMax = 0.0;
    private double globalYMin = 0.0;
    private double globalXMax = 0.0;
    private double ymax = 0.0;
    private double ymin = 0.0;
    private double xmax = 0.0;
    private List<JFreeChart> xyChartList = new ArrayList<JFreeChart>();

    public void createChartPanel(MultiSPOTS parent, String cstitle) {
        this.parent0 = parent;
        this.mainChartPanel = new JPanel();
        this.mainChartPanel.setLayout(new BoxLayout(this.mainChartPanel, 2));
        this.mainChartFrame = GuiUtil.generateTitleFrame((String)cstitle, (JPanel)new JPanel(), (Dimension)new Dimension(300, 70), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        this.mainChartFrame.add((Component)this.mainChartPanel);
    }

    public void setLocationRelativeToRectangle(Rectangle rectv, Point deltapt) {
        this.pt = new Point(rectv.x + deltapt.x, rectv.y + deltapt.y);
    }

    public void setUpperLeftLocation(Rectangle rectv) {
        this.pt = new Point(rectv.x, rectv.y);
    }

    public void displayData(final Experiment exp, final XLSExportOptions xlsExportOptions) {
        this.xyChartList.clear();
        this.ymax = 0.0;
        this.ymin = 0.0;
        this.flagMaxMinSet = false;
        List<XYSeriesCollection> xyDataSetList2 = null;
        List<XYSeriesCollection> xyDataSetList = this.getDataArrays(exp, xlsExportOptions);
        if (xlsExportOptions.exportType == EnumXLSExportType.AREA_SUMCLEAN) {
            xlsExportOptions.exportType = EnumXLSExportType.AREA_SUM;
            xyDataSetList2 = this.getDataArrays(exp, xlsExportOptions);
            xlsExportOptions.exportType = EnumXLSExportType.AREA_SUMCLEAN;
        }
        NumberAxis yAxis = new NumberAxis(xlsExportOptions.exportType.toUnit());
        yAxis.setAutoRangeIncludesZero(false);
        CombinedRangeXYPlot combinedXYPlot = new CombinedRangeXYPlot((ValueAxis)yAxis);
        Paint[] color = ChartColor.createDefaultPaintArray();
        int firstSeries = 0;
        int lastSeries = xyDataSetList.size();
        for (int iseries = firstSeries; iseries < lastSeries; ++iseries) {
            XYSeriesCollection xySeriesCollection = xyDataSetList.get(iseries);
            if (xyDataSetList2 != null) {
                XYSeriesCollection xySeriesCollection2 = xyDataSetList2.get(iseries);
                for (int j = 0; j < xySeriesCollection2.getSeriesCount(); ++j) {
                    XYSeries xySeries = xySeriesCollection2.getSeries(j);
                    xySeries.setKey((Comparable)((Object)(xySeries.getKey() + "*")));
                    xySeriesCollection.addSeries(xySeries);
                }
            }
            String[] description = xySeriesCollection.getSeries(0).getDescription().split("_");
            NumberAxis xAxis = new NumberAxis(description[0]);
            XYLineAndShapeRenderer subPlotRenderer = new XYLineAndShapeRenderer(true, false);
            int icolor = 0;
            int maxcolor = 1;
            BasicStroke stroke = new BasicStroke(0.5f, 1, 1, 1.0f, new float[]{2.0f, 4.0f}, 0.0f);
            int i = 0;
            while (i < xySeriesCollection.getSeriesCount()) {
                if (icolor > maxcolor) {
                    icolor += 13;
                    subPlotRenderer.setSeriesStroke(i, (Stroke)stroke);
                }
                subPlotRenderer.setSeriesPaint(i, color[icolor]);
                ++i;
                ++icolor;
            }
            XYPlot subplot = new XYPlot((XYDataset)xySeriesCollection, (ValueAxis)xAxis, null, (XYItemRenderer)subPlotRenderer);
            int nflies = Integer.valueOf(description[1]);
            if (nflies < 1) {
                subplot.setBackgroundPaint((Paint)Color.LIGHT_GRAY);
                subplot.setDomainGridlinePaint((Paint)Color.WHITE);
                subplot.setRangeGridlinePaint((Paint)Color.WHITE);
            } else {
                subplot.setBackgroundPaint((Paint)Color.WHITE);
                subplot.setDomainGridlinePaint((Paint)Color.GRAY);
                subplot.setRangeGridlinePaint((Paint)Color.GRAY);
            }
            combinedXYPlot.add(subplot);
        }
        JFreeChart chart = new JFreeChart(xlsExportOptions.exportType.toTitle(), null, (Plot)combinedXYPlot, true);
        Font font = chart.getTitle().getFont().deriveFont(1, 14.0f);
        chart.getTitle().setFont(font);
        int width = 800;
        int height = 300;
        int minimumDrawWidth = width;
        int minimumDrawHeight = 300;
        int maximumDrawWidth = 800;
        int maximumDrawHeight = 500;
        boolean useBuffer = true;
        ChartPanel panel = new ChartPanel(chart, width, height, minimumDrawWidth, minimumDrawHeight, maximumDrawWidth, maximumDrawHeight, useBuffer, true, true, true, false, true);
        panel.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent e) {
                Spot clikedSpot = ChartSpots.this.getClickedSpot(e);
                ChartSpots.this.selectSpot(exp, clikedSpot);
                ChartSpots.this.selectT(exp, xlsExportOptions, clikedSpot);
                ChartSpots.this.selectKymograph(exp, clikedSpot);
            }

            public void chartMouseMoved(ChartMouseEvent e) {
            }
        });
        this.mainChartPanel.add((Component)panel);
        this.mainChartFrame.pack();
        this.mainChartFrame.setLocation(this.pt);
        this.mainChartFrame.addToDesktopPane();
        this.mainChartFrame.setVisible(true);
    }

    private Spot getClickedSpot(ChartMouseEvent e) {
        int foo;
        MouseEvent trigger = e.getTrigger();
        if (trigger.getButton() != 1) {
            return null;
        }
        JFreeChart chart = e.getChart();
        MouseEvent mouseEvent = e.getTrigger();
        ChartPanel panel = (ChartPanel)this.mainChartPanel.getComponent(0);
        PlotRenderingInfo plotInfo = panel.getChartRenderingInfo().getPlotInfo();
        Point2D pointClicked = panel.translateScreenToJava2D(mouseEvent.getPoint());
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        int subplotindex = plotInfo.getSubplotIndex(pointClicked);
        CombinedRangeXYPlot combinedXYPlot = (CombinedRangeXYPlot)chart.getPlot();
        List subplots = combinedXYPlot.getSubplots();
        Spot spotFound = null;
        String description = null;
        ChartEntity chartEntity = e.getEntity();
        if (chartEntity != null && chartEntity instanceof XYItemEntity) {
            XYItemEntity xyItemEntity = (XYItemEntity)chartEntity;
            int isel = xyItemEntity.getSeriesIndex();
            XYDataset xyDataset = xyItemEntity.getDataset();
            description = (String)((Object)xyDataset.getSeriesKey(isel));
            spotFound = exp.spotsArray.getSpotContainingName(description.substring(0, 5));
            spotFound.spot_CamData_T = xyItemEntity.getItem();
        } else if (subplotindex >= 0) {
            XYDataset xyDataset = ((XYPlot)subplots.get(subplotindex)).getDataset(0);
            description = (String)((Object)xyDataset.getSeriesKey(0));
            spotFound = exp.spotsArray.getSpotContainingName(description.substring(0, 5));
        } else {
            System.out.println("Graph clicked but source not found");
            return null;
        }
        String lastN = description.substring(4, 5);
        try {
            foo = Integer.parseInt(lastN);
        }
        catch (NumberFormatException e1) {
            foo = 0;
        }
        spotFound.spot_Kymograph_T = 2 * spotFound.cageIndex + foo;
        return spotFound;
    }

    private void selectSpot(Experiment exp, Spot spot) {
        Viewer v = exp.seqCamData.seq.getFirstViewer();
        if (v != null && spot != null) {
            ROI2D roi = spot.getRoi_in();
            exp.seqCamData.seq.setFocusedROI((ROI)roi);
        }
    }

    private void selectT(Experiment exp, XLSExportOptions xlsExportOptions, Spot spot) {
        Viewer v = exp.seqCamData.seq.getFirstViewer();
        if (v != null && spot != null && spot.spot_CamData_T > 0) {
            int ii = (int)((long)(spot.spot_CamData_T * xlsExportOptions.buildExcelStepMs) / exp.binDuration_ms);
            v.setPositionT(ii);
        }
    }

    private void selectKymograph(Experiment exp, Spot spot) {
        Viewer v;
        if (exp.seqSpotKymos != null && (v = exp.seqSpotKymos.seq.getFirstViewer()) != null && spot != null) {
            v.setPositionT(spot.spot_Kymograph_T);
        }
    }

    private List<XYSeriesCollection> getDataArrays(Experiment exp, XLSExportOptions xlsExportOptions) {
        XLSResultsArray xlsResultsArray = this.getDataAsResultsArray(exp, xlsExportOptions);
        XYSeriesCollection xySeriesCollection = null;
        int oldcage = -1;
        ArrayList<XYSeriesCollection> xyList = new ArrayList<XYSeriesCollection>();
        for (int iRow = 0; iRow < xlsResultsArray.size(); ++iRow) {
            XLSResults xlsResults = xlsResultsArray.getRow(iRow);
            if (oldcage != xlsResults.cageID) {
                xySeriesCollection = new XYSeriesCollection();
                oldcage = xlsResults.cageID;
                xyList.add(xySeriesCollection);
            }
            XYSeries seriesXY = this.getXYSeries(xlsResults, xlsResults.name.substring(4));
            seriesXY.setDescription("cage " + xlsResults.cageID + "_" + xlsResults.nflies);
            xySeriesCollection.addSeries(seriesXY);
            this.updateGlobalMaxMin();
        }
        return xyList;
    }

    private XLSResultsArray getDataAsResultsArray(Experiment exp, XLSExportOptions xlsExportOptions) {
        XLSExport xlsExport = new XLSExport();
        return xlsExport.getSpotsDataFromOneExperiment(exp, xlsExportOptions);
    }

    private void updateGlobalMaxMin() {
        if (!this.flagMaxMinSet) {
            this.globalYMax = this.ymax;
            this.globalYMin = this.ymin;
            this.globalXMax = this.xmax;
            this.flagMaxMinSet = true;
        } else {
            if (this.globalYMax < this.ymax) {
                this.globalYMax = this.ymax;
            }
            if (this.globalYMin >= this.ymin) {
                this.globalYMin = this.ymin;
            }
            if (this.globalXMax < this.xmax) {
                this.globalXMax = this.xmax;
            }
        }
    }

    private XYSeries getXYSeries(XLSResults results, String name) {
        XYSeries seriesXY = new XYSeries((Comparable)((Object)name), false);
        if (results.valuesOut != null && results.valuesOut.length > 0) {
            this.xmax = results.valuesOut.length;
            this.ymin = this.ymax = results.valuesOut[0];
            this.addPointsAndUpdateExtrema(seriesXY, results, 0);
        }
        return seriesXY;
    }

    private void addPointsAndUpdateExtrema(XYSeries seriesXY, XLSResults results, int startFrame) {
        int x = 0;
        for (double y : results.valuesOut) {
            seriesXY.add((double)(x + startFrame), y);
            if (this.ymax < y) {
                this.ymax = y;
            }
            if (this.ymin > y) {
                this.ymin = y;
            }
            ++x;
        }
    }
}

