/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.tools.toExcel;

import java.awt.Point;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import plugins.fmp.multiSPOTS.experiment.Cage;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.Spot;
import plugins.fmp.multiSPOTS.tools.Comparators;
import plugins.fmp.multiSPOTS.tools.JComponents.JComboBoxExperiment;
import plugins.fmp.multiSPOTS.tools.toExcel.EnumXLSColumnHeader;
import plugins.fmp.multiSPOTS.tools.toExcel.EnumXLSExportType;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSExportOptions;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSResults;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSResultsArray;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSUtils;

public class XLSExport {
    protected XLSExportOptions options = null;
    protected Experiment expAll = null;
    XSSFCellStyle xssfCellStyle_red = null;
    XSSFCellStyle xssfCellStyle_blue = null;
    XSSFFont font_red = null;
    XSSFFont font_blue = null;
    XSSFWorkbook workbook = null;
    JComboBoxExperiment expList = null;

    protected Point writeExperiment_descriptors(Experiment exp, String charSeries, XSSFSheet sheet, Point pt, EnumXLSExportType xlsExportOption) {
        boolean transpose = this.options.transpose;
        int row = pt.y;
        int col0 = pt.x++;
        XLSUtils.setValue(sheet, pt, transpose, "..");
        XLSUtils.setValue(sheet, pt, transpose, "..");
        ++pt.x;
        int colseries = pt.x;
        int len = EnumXLSColumnHeader.values().length;
        for (int i = 0; i < len; ++i) {
            XLSUtils.setValue(sheet, pt, transpose, "--");
            ++pt.x;
        }
        pt.x = colseries;
        String filename = exp.getResultsDirectory();
        if (filename == null) {
            filename = exp.seqCamData.getImagesDirectory();
        }
        Path path = Paths.get(filename, new String[0]);
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        String date = df.format(exp.chainImageFirst_ms);
        String name0 = path.toString();
        int pos = name0.indexOf("cam");
        String cam = "-";
        if (pos > 0) {
            int pos5 = pos + 5;
            if (pos5 >= name0.length()) {
                pos5 = name0.length() - 1;
            }
            cam = name0.substring(pos, pos5);
        }
        String sheetName = sheet.getSheetName();
        int rowmax = -1;
        for (EnumXLSColumnHeader dumb : EnumXLSColumnHeader.values()) {
            if (rowmax >= dumb.getValue()) continue;
            rowmax = dumb.getValue();
        }
        ArrayList<Spot> spotsList = exp.spotsArray.spotsList;
        for (int t = 0; t < spotsList.size(); ++t) {
            Spot spot = (Spot)spotsList.get(t);
            String name = spot.getRoiName();
            int col = this.getRowIndexFromSpotName(name);
            if (col >= 0) {
                pt.x = colseries + col;
            }
            int x = pt.x;
            int y = row;
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.PATH.getValue(), transpose, name0);
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.DATE.getValue(), transpose, date);
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAM.getValue(), transpose, cam);
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.EXP_BOXID.getValue(), transpose, exp.getExperimentField(EnumXLSColumnHeader.EXP_BOXID));
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.EXP_EXPT.getValue(), transpose, exp.getExperimentField(EnumXLSColumnHeader.EXP_EXPT));
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.EXP_STIM.getValue(), transpose, exp.getExperimentField(EnumXLSColumnHeader.EXP_STIM));
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.EXP_CONC.getValue(), transpose, exp.getExperimentField(EnumXLSColumnHeader.EXP_CONC));
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.EXP_STRAIN.getValue(), transpose, exp.getExperimentField(EnumXLSColumnHeader.EXP_STRAIN));
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.EXP_SEX.getValue(), transpose, exp.getExperimentField(EnumXLSColumnHeader.EXP_SEX));
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.EXP_COND1.getValue(), transpose, exp.getExperimentField(EnumXLSColumnHeader.EXP_COND1));
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.EXP_COND2.getValue(), transpose, exp.getExperimentField(EnumXLSColumnHeader.EXP_COND2));
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP_VOLUME.getValue(), transpose, exp.spotsArray.spotsDescription.volume);
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP_PIXELS.getValue(), transpose, exp.spotsArray.spotsDescription.pixels);
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP.getValue(), transpose, spot.getSideDescriptor(xlsExportOption));
            this.outputStimAndConc_according_to_DataOption(sheet, xlsExportOption, spot, transpose, x, y);
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP_CAGEINDEX.getValue(), transpose, spot.cageIndex);
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAGEID.getValue(), transpose, charSeries + spot.cageIndex);
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP_NFLIES.getValue(), transpose, spot.spotNFlies);
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.DUM4.getValue(), transpose, sheetName);
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CHOICE_NOCHOICE.getValue(), transpose, this.desc_getChoiceTestType(spotsList, t));
            if (exp.cages.cagesList.size() <= t / 2) continue;
            Cage cage = exp.cages.cagesList.get(t / 2);
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAGE_STRAIN.getValue(), transpose, cage.strCageStrain);
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAGE_SEX.getValue(), transpose, cage.strCageSex);
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAGE_AGE.getValue(), transpose, cage.cageAge);
            XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAGE_COMMENT.getValue(), transpose, cage.strCageComment);
        }
        pt.x = col0;
        pt.y = rowmax + 1;
        return pt;
    }

    private String desc_getChoiceTestType(List<Spot> spotsList, int t) {
        Spot othercap;
        String otherSide;
        Spot spot = spotsList.get(t);
        String choiceText = "..";
        String side = spot.getSpotSide();
        t = side.contains("00") ? ++t : --t;
        if (t >= 0 && t < spotsList.size() && !(otherSide = (othercap = spotsList.get(t)).getSpotSide()).contains(side)) {
            choiceText = spot.spotStim.equals(othercap.spotStim) && spot.spotConc.equals(othercap.spotConc) ? "no-choice" : "choice";
        }
        return choiceText;
    }

    private void outputStimAndConc_according_to_DataOption(XSSFSheet sheet, EnumXLSExportType xlsExportOption, Spot spot, boolean transpose, int x, int y) {
        switch (xlsExportOption) {
            case TOPLEVEL_LR: 
            case TOPLEVELDELTA_LR: {
                if (spot.getSpotSide().equals("00")) {
                    XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP_STIM.getValue(), transpose, "L+R");
                } else {
                    XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP_STIM.getValue(), transpose, "(L-R)/(L+R)");
                }
                XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP_CONC.getValue(), transpose, spot.spotStim + ": " + spot.spotConc);
                break;
            }
            default: {
                XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP_STIM.getValue(), transpose, spot.spotStim);
                XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP_CONC.getValue(), transpose, spot.spotConc);
            }
        }
    }

    int writeTopRow_descriptors(XSSFSheet sheet) {
        Point pt = new Point(0, 0);
        int x = 0;
        boolean transpose = this.options.transpose;
        int nextcol = -1;
        for (EnumXLSColumnHeader dumb : EnumXLSColumnHeader.values()) {
            XLSUtils.setValue(sheet, x, dumb.getValue(), transpose, dumb.getName());
            if (nextcol >= dumb.getValue()) continue;
            nextcol = dumb.getValue();
        }
        pt.y = nextcol + 1;
        return pt.y;
    }

    void writeTopRow_timeIntervals(XSSFSheet sheet, int row, EnumXLSExportType xlsExport) {
        switch (xlsExport) {
            case AUTOCORREL: 
            case CROSSCORREL: 
            case AUTOCORREL_LR: 
            case CROSSCORREL_LR: {
                this.writeTopRow_timeIntervals_Correl(sheet, row);
                break;
            }
            default: {
                this.writeTopRow_timeIntervals_Default(sheet, row);
            }
        }
    }

    void writeTopRow_timeIntervals_Correl(XSSFSheet sheet, int row) {
        boolean transpose = this.options.transpose;
        Point pt = new Point(0, row);
        for (long interval = (long)(-this.options.nbinscorrelation); interval < (long)this.options.nbinscorrelation; ++interval) {
            int i = (int)interval;
            XLSUtils.setValue(sheet, pt, transpose, "t" + i);
            ++pt.y;
        }
    }

    void writeTopRow_timeIntervals_Default(XSSFSheet sheet, int row) {
        boolean transpose = this.options.transpose;
        Point pt = new Point(0, row);
        long duration = this.expAll.camImageLast_ms - this.expAll.camImageFirst_ms;
        for (long interval = 0L; interval < duration; interval += (long)this.options.buildExcelStepMs) {
            int i = (int)(interval / (long)this.options.buildExcelUnitMs);
            XLSUtils.setValue(sheet, pt, transpose, "t" + i);
            ++pt.y;
        }
    }

    protected int desc_getCageFromSpotRoiName(String name) {
        if (!name.contains("spot")) {
            return -1;
        }
        String num = name.substring(4, 6);
        int numFromName = Integer.valueOf(num);
        return numFromName;
    }

    protected int getRowIndexFromSpotName(String name) {
        if (!name.contains("spot")) {
            return -1;
        }
        String num = name.substring(4, 6);
        int numFromName = Integer.valueOf(num);
        String num2 = name.substring(7, 9);
        int numFromName2 = Integer.valueOf(num2);
        numFromName = numFromName * 2 + numFromName2;
        return numFromName;
    }

    protected int getRowIndexFromCageName(String name) {
        if (!name.contains("cage")) {
            return -1;
        }
        String num = name.substring(4, name.length());
        int numFromName = Integer.valueOf(num);
        return numFromName;
    }

    protected Point getCellXCoordinateFromDataName(XLSResults xlsResults, Point pt_main, int colseries) {
        int col = this.getRowIndexFromSpotName(xlsResults.name);
        if (col >= 0) {
            pt_main.x = colseries + col;
        }
        return pt_main;
    }

    protected int getCageFromKymoFileName(String name) {
        if (!name.contains("line") || !name.contains("spot")) {
            return -1;
        }
        return Integer.valueOf(name.substring(4, 5));
    }

    XSSFWorkbook xlsInitWorkbook() {
        XSSFWorkbook workbook = new XSSFWorkbook();
        workbook.setMissingCellPolicy(Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
        this.xssfCellStyle_red = workbook.createCellStyle();
        this.font_red = workbook.createFont();
        this.font_red.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        this.xssfCellStyle_red.setFont((Font)this.font_red);
        this.xssfCellStyle_blue = workbook.createCellStyle();
        this.font_blue = workbook.createFont();
        this.font_blue.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
        this.xssfCellStyle_blue.setFont((Font)this.font_blue);
        return workbook;
    }

    XSSFSheet xlsInitSheet(String title, EnumXLSExportType xlsExport) {
        XSSFSheet sheet = this.workbook.getSheet(title);
        if (sheet == null) {
            sheet = this.workbook.createSheet(title);
            int row = this.writeTopRow_descriptors(sheet);
            this.writeTopRow_timeIntervals(sheet, row, xlsExport);
        }
        return sheet;
    }

    protected int getDataAndExport(Experiment exp, int col0, String charSeries, EnumXLSExportType exportType) {
        this.options.exportType = exportType;
        XLSResultsArray rowListForOneExp = this.getSpotsDataFromOneExperimentSeries(exp, this.options);
        XSSFSheet sheet = this.xlsInitSheet(exportType.toString(), exportType);
        int colmax = this.xlsExportResultsArrayToSheet(rowListForOneExp, sheet, exportType, col0, charSeries);
        if (this.options.onlyalive) {
            this.trimDeadsFromArrayList(rowListForOneExp, exp);
            sheet = this.xlsInitSheet(exportType.toString() + "_alive", exportType);
            this.xlsExportResultsArrayToSheet(rowListForOneExp, sheet, exportType, col0, charSeries);
        }
        if (this.options.sumPerCage) {
            this.combineDataForOneCage(rowListForOneExp, exp);
            sheet = this.xlsInitSheet(exportType.toString() + "_cage", exportType);
            this.xlsExportResultsArrayToSheet(rowListForOneExp, sheet, exportType, col0, charSeries);
        }
        return colmax;
    }

    private XLSResultsArray getSpotDescriptorsForOneExperiment(Experiment exp, EnumXLSExportType xlsOption) {
        if (this.expAll == null) {
            return null;
        }
        this.expAll.cages.copy(exp.cages);
        this.expAll.spotsArray.copy(exp.spotsArray);
        this.expAll.chainImageFirst_ms = exp.chainImageFirst_ms;
        this.expAll.copyExperimentFields(exp);
        this.expAll.setResultsDirectory(exp.getResultsDirectory());
        Experiment expi = exp.chainToNextExperiment;
        while (expi != null) {
            this.expAll.spotsArray.mergeLists(expi.spotsArray);
            expi = expi.chainToNextExperiment;
        }
        int nFrames = (int)((this.expAll.camImageLast_ms - this.expAll.camImageFirst_ms) / (long)this.options.buildExcelStepMs + 1L);
        int nspots = this.expAll.spotsArray.spotsList.size();
        XLSResultsArray rowListForOneExp = new XLSResultsArray(nspots);
        for (int i = 0; i < nspots; ++i) {
            Spot spot = this.expAll.spotsArray.spotsList.get(i);
            XLSResults rowResults = new XLSResults(spot.getRoiName(), spot.spotNFlies, spot.spotIndex, xlsOption, nFrames);
            rowResults.stimulus = spot.spotStim;
            rowResults.concentration = spot.spotConc;
            rowResults.cageID = spot.cageIndex;
            rowListForOneExp.resultsList.add(rowResults);
        }
        Collections.sort(rowListForOneExp.resultsList, new Comparators.XLSResults_Name_Comparator());
        return rowListForOneExp;
    }

    private XLSResultsArray getSpotsDescriptorsForOneExperiment(Experiment exp, EnumXLSExportType xlsOption) {
        if (this.expAll == null) {
            return null;
        }
        this.expAll.cages.copy(exp.cages);
        this.expAll.spotsArray.copy(exp.spotsArray);
        this.expAll.chainImageFirst_ms = exp.chainImageFirst_ms;
        this.expAll.copyExperimentFields(exp);
        this.expAll.setResultsDirectory(exp.getResultsDirectory());
        Experiment expi = exp.chainToNextExperiment;
        while (expi != null) {
            this.expAll.spotsArray.mergeLists(expi.spotsArray);
            expi = expi.chainToNextExperiment;
        }
        int nFrames = (int)((this.expAll.camImageLast_ms - this.expAll.camImageFirst_ms) / (long)this.options.buildExcelStepMs + 1L);
        int nspots = this.expAll.spotsArray.spotsList.size();
        XLSResultsArray rowListForOneExp = new XLSResultsArray(nspots);
        for (int i = 0; i < nspots; ++i) {
            Spot spot = this.expAll.spotsArray.spotsList.get(i);
            XLSResults rowResults = new XLSResults(spot.getRoiName(), spot.spotNFlies, spot.spotIndex, xlsOption, nFrames);
            rowResults.stimulus = spot.spotStim;
            rowResults.concentration = spot.spotConc;
            rowResults.cageID = spot.cageIndex;
            rowListForOneExp.resultsList.add(rowResults);
        }
        Collections.sort(rowListForOneExp.resultsList, new Comparators.XLSResults_Name_Comparator());
        return rowListForOneExp;
    }

    public XLSResultsArray getSpotDataFromOneExperiment(Experiment exp, EnumXLSExportType exportType, XLSExportOptions options) {
        this.options = options;
        this.expAll = new Experiment();
        this.expAll.camImageLast_ms = exp.camImageLast_ms;
        this.expAll.camImageFirst_ms = exp.camImageFirst_ms;
        return this.getSpotDataFromOneExperimentSeries(exp, exportType);
    }

    public XLSResultsArray getSpotsDataFromOneExperiment(Experiment exp, XLSExportOptions options) {
        this.options = options;
        this.expAll = new Experiment();
        this.expAll.camImageLast_ms = exp.camImageLast_ms;
        this.expAll.camImageFirst_ms = exp.camImageFirst_ms;
        return this.getSpotsDataFromOneExperimentSeries(exp, options);
    }

    private void exportError(Experiment expi, int nOutputFrames) {
        String error = "XLSExport:ExportError() ERROR in " + expi.getResultsDirectory() + "\n nOutputFrames=" + nOutputFrames + " kymoFirstCol_Ms=" + expi.binFirst_ms + " kymoLastCol_Ms=" + expi.binLast_ms;
        System.out.println(error);
    }

    private int getNOutputFrames(Experiment expi) {
        int nOutputFrames = (int)((expi.binLast_ms - expi.binFirst_ms) / (long)this.options.buildExcelStepMs + 1L);
        if (nOutputFrames <= 1) {
            if (expi.seqSpotKymos.imageWidthMax == 0) {
                expi.loadKymographs();
            }
            expi.binLast_ms = expi.binFirst_ms + (long)expi.seqSpotKymos.imageWidthMax * expi.binDuration_ms;
            if (expi.binLast_ms <= 0L) {
                this.exportError(expi, -1);
            }
            if ((nOutputFrames = (int)((expi.binLast_ms - expi.binFirst_ms) / (long)this.options.buildExcelStepMs + 1L)) <= 1) {
                nOutputFrames = expi.seqCamData.nTotalFrames;
                this.exportError(expi, nOutputFrames);
            }
        }
        return nOutputFrames;
    }

    private XLSResultsArray getSpotDataFromOneExperimentSeries(Experiment exp, EnumXLSExportType xlsExportType) {
        XLSResultsArray rowListForOneExp = this.getSpotDescriptorsForOneExperiment(exp, xlsExportType);
        Experiment expi = exp.getFirstChainedExperiment(true);
        while (expi != null) {
            int nOutputFrames = this.getNOutputFrames(expi);
            if (nOutputFrames > 1) {
                XLSResultsArray resultsArrayList = new XLSResultsArray(expi.spotsArray.spotsList.size());
                this.options.compensateEvaporation = false;
                resultsArrayList.getSpotsArrayResults1(expi.spotsArray, nOutputFrames, exp.binDuration_ms, this.options);
                this.addResultsTo_rowsForOneExp(rowListForOneExp, expi, resultsArrayList);
            }
            expi = expi.chainToNextExperiment;
        }
        return rowListForOneExp;
    }

    private XLSResultsArray getSpotsDataFromOneExperimentSeries(Experiment exp, XLSExportOptions options) {
        XLSResultsArray rowListForOneExp = this.getSpotsDescriptorsForOneExperiment(exp, options.exportType);
        Experiment expi = exp.getFirstChainedExperiment(true);
        while (expi != null) {
            int nOutputFrames = this.getNOutputFrames(expi);
            if (nOutputFrames > 1) {
                XLSResultsArray resultsArrayList = new XLSResultsArray(expi.spotsArray.spotsList.size());
                options.compensateEvaporation = false;
                resultsArrayList.getSpotsArrayResults1(expi.spotsArray, nOutputFrames, exp.binDuration_ms, options);
                this.addResultsTo_rowsForOneExp(rowListForOneExp, expi, resultsArrayList);
            }
            expi = expi.chainToNextExperiment;
        }
        return rowListForOneExp;
    }

    private XLSResults getResultsArrayWithThatName(String testname, XLSResultsArray resultsArrayList) {
        XLSResults resultsFound = null;
        for (XLSResults results : resultsArrayList.resultsList) {
            if (!results.name.equals(testname)) continue;
            resultsFound = results;
            break;
        }
        return resultsFound;
    }

    private void addResultsTo_rowsForOneExp(XLSResultsArray rowListForOneExp, Experiment expi, XLSResultsArray resultsArrayList) {
        if (resultsArrayList.resultsList.size() < 1) {
            return;
        }
        EnumXLSExportType xlsoption = resultsArrayList.getRow((int)0).exportType;
        long offsetChain = expi.camImageFirst_ms - expi.chainImageFirst_ms;
        long start_Ms = expi.binFirst_ms + offsetChain;
        long end_Ms = expi.binLast_ms + offsetChain;
        if (this.options.fixedIntervals) {
            if (start_Ms < this.options.startAll_Ms) {
                start_Ms = this.options.startAll_Ms;
            }
            if (start_Ms > expi.camImageLast_ms) {
                return;
            }
            if (end_Ms > this.options.endAll_Ms) {
                end_Ms = this.options.endAll_Ms;
            }
            if (end_Ms > expi.camImageFirst_ms) {
                return;
            }
        }
        long from_first_Ms = start_Ms - offsetChain;
        long from_lastMs = end_Ms - offsetChain;
        int to_first_index = (int)(start_Ms / (long)this.options.buildExcelStepMs);
        int to_nvalues = (int)((end_Ms - start_Ms) / (long)this.options.buildExcelStepMs) + 1;
        block3: for (int iRow = 0; iRow < rowListForOneExp.size(); ++iRow) {
            double dvalue;
            XLSResults row = rowListForOneExp.getRow(iRow);
            XLSResults results = this.getResultsArrayWithThatName(row.name, resultsArrayList);
            if (results != null && results.valuesOut != null) {
                int from_i;
                dvalue = 0.0;
                switch (xlsoption) {
                    case TOPLEVEL_LR: 
                    case TOPLEVELDELTA_LR: 
                    case TOPLEVEL: 
                    case TOPLEVELDELTA: {
                        if (!this.options.collateSeries || !this.options.padIntervals || expi.chainToPreviousExperiment == null) break;
                        dvalue = this.padWithLastPreviousValue(row, to_first_index);
                        break;
                    }
                }
                int icolTo = 0;
                if (this.options.collateSeries || this.options.absoluteTime) {
                    icolTo = to_first_index;
                }
                long fromTime = from_first_Ms;
                while (fromTime <= from_lastMs && (from_i = (int)Math.round((double)(fromTime - from_first_Ms) / (double)this.options.buildExcelStepMs)) < results.valuesOut.length) {
                    if (from_i >= 0) {
                        double value = results.valuesOut[from_i] + dvalue;
                        if (icolTo >= row.valuesOut.length) continue block3;
                        row.valuesOut[icolTo] = value;
                    }
                    fromTime += (long)this.options.buildExcelStepMs;
                    ++icolTo;
                }
                continue;
            }
            if (!this.options.collateSeries || !this.options.padIntervals || expi.chainToPreviousExperiment == null) continue;
            dvalue = this.padWithLastPreviousValue(row, to_first_index);
            int tofirst = to_first_index;
            int tolast = tofirst + to_nvalues;
            if (tolast > row.valuesOut.length) {
                tolast = row.valuesOut.length;
            }
            for (int toi = tofirst; toi < tolast; ++toi) {
                row.valuesOut[toi] = dvalue;
            }
        }
    }

    private double padWithLastPreviousValue(XLSResults row, long to_first_index) {
        double dvalue = 0.0;
        if (to_first_index >= (long)row.valuesOut.length) {
            return dvalue;
        }
        int index = this.getIndexOfFirstNonEmptyValueBackwards(row, to_first_index);
        if (index >= 0) {
            dvalue = row.valuesOut[index];
            int i = index + 1;
            while ((long)i < to_first_index) {
                row.valuesOut[i] = dvalue;
                row.padded_out[i] = true;
                ++i;
            }
        }
        return dvalue;
    }

    private int getIndexOfFirstNonEmptyValueBackwards(XLSResults row, long fromindex) {
        int ifrom;
        int index = -1;
        for (int i = ifrom = (int)fromindex; i >= 0; --i) {
            if (Double.isNaN(row.valuesOut[i])) continue;
            index = i;
            break;
        }
        return index;
    }

    private void trimDeadsFromArrayList(XLSResultsArray rowListForOneExp, Experiment exp) {
        for (Cage cage : exp.cages.cagesList) {
            String roiname = cage.cageRoi2D.getName();
            if (roiname.length() < 4 || !roiname.substring(0, 4).contains("cage")) continue;
            String cagenumberString = roiname.substring(4);
            int cagenumber = Integer.valueOf(cagenumberString);
            int ilastalive = 0;
            if (cage.cageNFlies > 0) {
                Experiment expi = exp;
                while (expi.chainToNextExperiment != null && expi.chainToNextExperiment.cages.isFlyAlive(cagenumber)) {
                    expi = expi.chainToNextExperiment;
                }
                int lastIntervalFlyAlive = expi.cages.getLastIntervalFlyAlive(cagenumber);
                int lastMinuteAlive = (int)((long)lastIntervalFlyAlive * expi.camImageBin_ms + (expi.camImageFirst_ms - this.expAll.camImageFirst_ms));
                ilastalive = (int)((long)lastMinuteAlive / this.expAll.binDuration_ms);
            }
            if (ilastalive > 0) {
                ++ilastalive;
            }
            for (int iRow = 0; iRow < rowListForOneExp.size(); ++iRow) {
                XLSResults row = rowListForOneExp.getRow(iRow);
                if (this.desc_getCageFromSpotRoiName(row.name) != cagenumber) continue;
                row.clearValues(ilastalive);
            }
        }
    }

    private void combineDataForOneCage(XLSResultsArray rowListForOneExp, Experiment exp) {
        for (int iRow0 = 0; iRow0 < rowListForOneExp.size(); ++iRow0) {
            XLSResults row_master = rowListForOneExp.getRow(iRow0);
            if (row_master.nflies == 0 || row_master.valuesOut == null) continue;
            for (int iRow = 0; iRow < rowListForOneExp.size(); ++iRow) {
                XLSResults row = rowListForOneExp.getRow(iRow);
                if (row.nflies == 0 || row.valuesOut == null || row.cageID != row_master.cageID || row.name.equals(row_master.name) || !row.stimulus.equals(row_master.stimulus) || !row.concentration.equals(row_master.concentration)) continue;
                row_master.sumValues_out(row);
                row.clearAll();
            }
        }
    }

    private int xlsExportResultsArrayToSheet(XLSResultsArray rowListForOneExp, XSSFSheet sheet, EnumXLSExportType xlsExportOption, int col0, String charSeries) {
        Point pt = new Point(col0, 0);
        this.writeExperiment_descriptors(this.expAll, charSeries, sheet, pt, xlsExportOption);
        pt = this.writeExperiment_data(rowListForOneExp, sheet, pt);
        return pt.x;
    }

    private Point writeExperiment_data(XLSResultsArray rowListForOneExp, XSSFSheet sheet, Point pt_main) {
        int rowSeries = pt_main.x + 2;
        int column_dataArea = pt_main.y;
        Point pt = new Point(pt_main);
        this.writeExperiment_data_simpleRows(rowListForOneExp, sheet, column_dataArea, rowSeries, pt);
        pt_main.x = pt.x + 1;
        return pt_main;
    }

    private void writeExperiment_data_simpleRows(XLSResultsArray rowListForOneExp, XSSFSheet sheet, int column_dataArea, int rowSeries, Point pt) {
        for (int iRow = 0; iRow < rowListForOneExp.size(); ++iRow) {
            XLSResults row = rowListForOneExp.getRow(iRow);
            this.writeRow(sheet, column_dataArea, rowSeries, pt, row);
        }
    }

    private void writeRow(XSSFSheet sheet, int column_dataArea, int rowSeries, Point pt, XLSResults row) {
        int i_from;
        boolean transpose = this.options.transpose;
        pt.y = column_dataArea;
        int col = this.getRowIndexFromSpotName(row.name);
        pt.x = rowSeries + col;
        if (row.valuesOut == null) {
            return;
        }
        long coltime = this.expAll.camImageFirst_ms;
        while (coltime < this.expAll.camImageLast_ms && (i_from = (int)((coltime - this.expAll.camImageFirst_ms) / (long)this.options.buildExcelStepMs)) < row.valuesOut.length) {
            double value = row.valuesOut[i_from];
            if (!Double.isNaN(value)) {
                XLSUtils.setValue(sheet, pt, transpose, value);
                if (i_from < row.padded_out.length && row.padded_out[i_from]) {
                    XLSUtils.getCell(sheet, pt, transpose).setCellStyle((CellStyle)this.xssfCellStyle_red);
                }
            }
            coltime += (long)this.options.buildExcelStepMs;
            ++pt.y;
        }
        ++pt.x;
    }
}

