/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.easyclemv0;

import Jama.Matrix;
import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.file.Saver;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.preferences.ApplicationPreferences;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.system.thread.ThreadUtil;
import icy.type.DataType;
import icy.util.XMLUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarSequence;
import plugins.perrine.easyclemv0.ImageTransformer;
import plugins.perrine.easyclemv0.SimilarityTransformation3D;
import plugins.perrine.easyclemv0.Stack3DVTKTransformer;
import vtk.vtkDataArray;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkDoubleArray;
import vtk.vtkFloatArray;
import vtk.vtkImageData;
import vtk.vtkImageReslice;
import vtk.vtkIntArray;
import vtk.vtkMatrix4x4;
import vtk.vtkPointData;
import vtk.vtkPoints;
import vtk.vtkShortArray;
import vtk.vtkThinPlateSplineTransform;
import vtk.vtkTransform;
import vtk.vtkUnsignedCharArray;
import vtk.vtkUnsignedIntArray;
import vtk.vtkUnsignedShortArray;

public class ApplyTransformation
extends EzPlug
implements Block {
    EzVarSequence source = new EzVarSequence("Select Source Image (will be transformed from xml file)");
    private EzVarFile xmlFile = new EzVarFile("Xml file containing list of transformation", ApplicationPreferences.getPreferences().node("frame/imageLoader").get("path", "."));
    private int extentx;
    private int extenty;
    private int extentz;
    private double spacingx;
    private double spacingy;
    private double spacingz;
    vtkDataSet[] imageData;
    private double Inputspacingx;
    private double Inputspacingy;
    private double Inputspacingz;
    private Runnable transformer;
    private VarSequence out = new VarSequence("output sequence", null);
    private int auto;

    protected void initialize() {
        EzLabel textinfo = new EzLabel("Please select the image on which you want to apply a transformation, and the xml file containing the transformations (likely your file name _transfo.xml)");
        String varName = "Xml file containing list of transformation";
        this.xmlFile = this.source.getValue() != null ? new EzVarFile(varName, ((Sequence)this.source.getValue()).getFilename()) : new EzVarFile(varName, ApplicationPreferences.getPreferences().node("frame/imageLoader").get("path", "."));
        this.addEzComponent((EzComponent)textinfo);
        this.addEzComponent((EzComponent)this.source);
        this.addEzComponent((EzComponent)this.xmlFile);
    }

    protected void execute() {
        final Sequence sourceseq = (Sequence)this.source.getValue();
        if (sourceseq == null) {
            MessageDialog.showDialog((String)"Please make sure that your image is opened");
            return;
        }
        final Document document = XMLUtil.loadDocument((File)((File)this.xmlFile.getValue()));
        this.transformer = new Runnable(){

            @Override
            public void run() {
                IcyCanvas sourcecanvas;
                ProgressFrame progress;
                Element root = XMLUtil.getRootElement((Document)document);
                ArrayList transfoArrayList = XMLUtil.getElements((Node)root, (String)"pointspairsinphysicalcoordinates");
                if (transfoArrayList.size() > 0) {
                    ProgressFrame progress2 = new ProgressFrame("Applying the NON RIGID transformation...");
                    progress2.setLength(10.0);
                    ApplyTransformation.this.ApplynonrigidTransformation(document);
                    MessageDialog.showDialog((String)"Non rigid transform as been applied");
                    sourceseq.setFilename(sourceseq.getFilename() + " (non rigidly transformed)");
                    System.out.println("Transformed Image will be saved as " + sourceseq.getFilename());
                    File file = new File(sourceseq.getFilename());
                    boolean multipleFiles = false;
                    boolean showProgress = true;
                    Saver.save((Sequence)sourceseq, (File)file, (boolean)multipleFiles, (boolean)showProgress);
                    progress2.setPosition(10.0);
                    progress2.close();
                    return;
                }
                ArrayList transfoElementArrayList = XMLUtil.getElements((Node)root, (String)"MatrixTransformation");
                if (transfoElementArrayList.size() == 0) {
                    ArrayList newsizeelement = XMLUtil.getElements((Node)root, (String)"TargetSize");
                    if (newsizeelement.size() == 0) {
                        new AnnounceFrame("Please check the CONSOLE panel output");
                        System.out.println("You have likely chosen a wrong file, it should be suffixed with _transfo.xml, not only .xml");
                        System.out.println("You had selected " + ((File)ApplyTransformation.this.xmlFile.getValue()).getPath());
                        return;
                    }
                    new AnnounceFrame("Please check the CONSOLE panel output");
                    System.out.println("You have selected " + ((File)ApplyTransformation.this.xmlFile.getValue()).getPath());
                    System.out.println("This transformation file does not contain any transform Matrix. It means that you asked for showing the ROI on the original source image.");
                    System.out.println("This ROI should be still here, open the target image and update transformation.");
                    return;
                }
                Element newsizeelement = (Element)XMLUtil.getElements((Node)root, (String)"TargetSize").get(0);
                int width = XMLUtil.getAttributeIntValue((Element)newsizeelement, (String)"width", (int)-1);
                int height = XMLUtil.getAttributeIntValue((Element)newsizeelement, (String)"height", (int)-1);
                int recenter = XMLUtil.getAttributeIntValue((Element)newsizeelement, (String)"recenter", (int)0);
                double targetsx = XMLUtil.getAttributeDoubleValue((Element)newsizeelement, (String)"sx", (double)-1.0);
                double targetsy = XMLUtil.getAttributeDoubleValue((Element)newsizeelement, (String)"sy", (double)-1.0);
                double targetsz = XMLUtil.getAttributeDoubleValue((Element)newsizeelement, (String)"sz", (double)-1.0);
                int nbz = XMLUtil.getAttributeIntValue((Element)newsizeelement, (String)"nz", (int)-1);
                ApplyTransformation.this.auto = XMLUtil.getAttributeIntValue((Element)newsizeelement, (String)"auto", (int)0);
                Matrix CombinedTransfo = ApplyTransformation.this.getCombinedTransfo(document);
                if (ApplyTransformation.this.auto == 1) {
                    ProgressFrame progress3 = new ProgressFrame("Applying transform from AUTOFINDER");
                    ApplyTransformation.this.Inputspacingx = ((Sequence)ApplyTransformation.this.source.getValue()).getPixelSizeX();
                    ApplyTransformation.this.Inputspacingy = ((Sequence)ApplyTransformation.this.source.getValue()).getPixelSizeY();
                    ApplyTransformation.this.Inputspacingz = ((Sequence)ApplyTransformation.this.source.getValue()).getPixelSizeZ();
                    ApplyTransformation.this.ApplyautoTransform(CombinedTransfo, width, height, nbz, targetsx, targetsy, targetsz);
                    progress3.close();
                    return;
                }
                if (nbz == -1) {
                    progress = new ProgressFrame("Applying 2D RIGID transformation...");
                    ImageTransformer mytransformer = new ImageTransformer();
                    mytransformer.setImageSource((Sequence)ApplyTransformation.this.source.getValue());
                    mytransformer.setParameters(CombinedTransfo);
                    mytransformer.setDestinationsize(width, height);
                    mytransformer.run();
                    progress.close();
                    if (targetsx != -1.0) {
                        ((Sequence)ApplyTransformation.this.source.getValue()).setPixelSizeX(targetsx);
                        ((Sequence)ApplyTransformation.this.source.getValue()).setPixelSizeY(targetsy);
                        ((Sequence)ApplyTransformation.this.source.getValue()).setPixelSizeZ(targetsz);
                    }
                } else {
                    progress = new ProgressFrame("Applying 3D RIGID transformation...");
                    SimilarityTransformation3D transfo = ApplyTransformation.this.getCombinedTransfo3D(document);
                    Matrix transfomat = transfo.getMatrix();
                    Stack3DVTKTransformer transfoimage3D = new Stack3DVTKTransformer();
                    transfoimage3D.setImageSource((Sequence)ApplyTransformation.this.source.getValue(), transfo.getorisizex(), transfo.getorisizey(), transfo.getorisizez());
                    transfoimage3D.setDestinationsize(width, height, nbz, targetsx, targetsy, targetsz, recenter);
                    transfoimage3D.setParameters(transfomat, transfo.getscalex(), transfo.getscalez());
                    transfoimage3D.run();
                    progress.close();
                }
                if (!ApplyTransformation.this.isHeadLess() && (sourcecanvas = ((Sequence)ApplyTransformation.this.source.getValue()).getFirstViewer().getCanvas()) instanceof IcyCanvas2D) {
                    ((IcyCanvas2D)sourcecanvas).fitCanvasToImage();
                }
                sourceseq.setFilename(sourceseq.getFilename() + " (transformed)");
                sourceseq.setName(sourceseq.getName() + " (transformed)");
                File file = new File(sourceseq.getFilename());
                boolean multipleFiles = false;
                boolean showProgress = true;
                System.out.println("Transformed Image will be saved as " + sourceseq.getFilename());
                Saver.save((Sequence)sourceseq, (File)file, (boolean)multipleFiles, (boolean)showProgress);
                if (!ApplyTransformation.this.isHeadLess()) {
                    MessageDialog.showDialog((String)"Transformation have been applied. Image has been renamed and saved, use this one for going on with your alignments");
                }
            }
        };
        if (!this.isHeadLess()) {
            ThreadUtil.bgRun((Runnable)this.transformer);
        } else {
            ThreadUtil.invokeNow((Runnable)this.transformer);
            if (this.auto != 1) {
                this.out.setValue(sourceseq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ApplyautoTransform(Matrix combinedTransfo, int w, int h, int nbz, double targetsx, double targetsy, double targetsz) {
        int nbc = ((Sequence)this.source.getValue()).getSizeC();
        this.imageData = new vtkDataSet[nbc];
        vtkTransform myvtkcombinedTransfo = new vtkTransform();
        vtkMatrix4x4 myvtkmatrix = new vtkMatrix4x4();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                myvtkmatrix.SetElement(i, j, combinedTransfo.get(i, j));
            }
        }
        myvtkcombinedTransfo.SetMatrix(myvtkmatrix);
        for (int c = 0; c < nbc; ++c) {
            this.converttoVtkImageData(c);
            vtkImageReslice ImageReslice = new vtkImageReslice();
            ImageReslice.SetInputData((vtkDataObject)this.imageData[c]);
            ImageReslice.SetOutputDimensionality(3);
            ImageReslice.SetOutputOrigin(0.0, 0.0, 0.0);
            ImageReslice.SetOutputSpacing(targetsx, targetsy, targetsz);
            if (nbz < 0) {
                nbz = 1;
            }
            ImageReslice.SetOutputExtent(0, w - 1, 0, h - 1, 0, nbz - 1);
            ImageReslice.SetResliceTransform(myvtkcombinedTransfo.GetInverse());
            ImageReslice.SetInterpolationModeToLinear();
            ImageReslice.Update();
            this.imageData[c] = ImageReslice.GetOutput();
        }
        int nbt = ((Sequence)this.source.getValue()).getSizeT();
        DataType datatype = ((Sequence)this.source.getValue()).getDataType_();
        try {
            Sequence sequence2 = SequenceUtil.getCopy((Sequence)((Sequence)this.source.getValue()));
            sequence2.beginUpdate();
            sequence2.removeAllImages();
            try {
                switch (datatype) {
                    case UBYTE: {
                        for (int t = 0; t < nbt; ++t) {
                            for (int z = 0; z < nbz; ++z) {
                                IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                                for (int c = 0; c < nbc; ++c) {
                                    vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                    byte[] inData = ((vtkUnsignedCharArray)myvtkarray).GetJavaArray();
                                    byte[] outData = new byte[w * h];
                                    for (int i = 0; i < h; ++i) {
                                        for (int j = 0; j < w; ++j) {
                                            outData[i * w + j] = inData[z * w * h + i * w + j];
                                        }
                                    }
                                    image.setDataXYAsByte(c, outData);
                                }
                                sequence2.setImage(t, z, (BufferedImage)image);
                            }
                        }
                        break;
                    }
                    case BYTE: {
                        for (int t = 0; t < nbt; ++t) {
                            for (int z = 0; z < nbz; ++z) {
                                IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                                for (int c = 0; c < nbc; ++c) {
                                    vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                    byte[] inData = ((vtkUnsignedCharArray)myvtkarray).GetJavaArray();
                                    byte[] outData = new byte[w * h];
                                    for (int i = 0; i < h; ++i) {
                                        for (int j = 0; j < w; ++j) {
                                            outData[i * w + j] = inData[z * w * h + i * w + j];
                                        }
                                    }
                                    image.setDataXYAsByte(c, outData);
                                }
                                sequence2.setImage(t, z, (BufferedImage)image);
                            }
                        }
                        break;
                    }
                    case USHORT: {
                        for (int t = 0; t < nbt; ++t) {
                            for (int z = 0; z < nbz; ++z) {
                                IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                                for (int c = 0; c < nbc; ++c) {
                                    vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                    short[] inData = ((vtkUnsignedShortArray)myvtkarray).GetJavaArray();
                                    short[] outData = new short[w * h];
                                    for (int i = 0; i < h; ++i) {
                                        for (int j = 0; j < w; ++j) {
                                            outData[i * w + j] = inData[z * w * h + i * w + j];
                                        }
                                    }
                                    image.setDataXYAsShort(c, outData);
                                }
                                sequence2.setImage(t, z, (BufferedImage)image);
                            }
                        }
                        break;
                    }
                    case SHORT: {
                        for (int t = 0; t < nbt; ++t) {
                            for (int z = 0; z < nbz; ++z) {
                                IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                                for (int c = 0; c < nbc; ++c) {
                                    vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                    short[] inData = ((vtkShortArray)myvtkarray).GetJavaArray();
                                    short[] outData = new short[w * h];
                                    for (int i = 0; i < h; ++i) {
                                        for (int j = 0; j < w; ++j) {
                                            outData[i * w + j] = inData[z * w * h + i * w + j];
                                        }
                                    }
                                    image.setDataXYAsShort(c, outData);
                                }
                                sequence2.setImage(t, z, (BufferedImage)image);
                            }
                        }
                        break;
                    }
                    case INT: {
                        for (int t = 0; t < nbt; ++t) {
                            for (int z = 0; z < nbz; ++z) {
                                IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                                for (int c = 0; c < nbc; ++c) {
                                    vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                    int[] inData = ((vtkIntArray)myvtkarray).GetJavaArray();
                                    int[] outData = new int[w * h];
                                    for (int i = 0; i < h; ++i) {
                                        for (int j = 0; j < w; ++j) {
                                            outData[i * w + j] = inData[z * w * h + i * w + j];
                                        }
                                    }
                                    image.setDataXYAsInt(c, outData);
                                }
                                sequence2.setImage(t, z, (BufferedImage)image);
                            }
                        }
                        break;
                    }
                    case UINT: {
                        for (int t = 0; t < nbt; ++t) {
                            for (int z = 0; z < nbz; ++z) {
                                IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                                for (int c = 0; c < nbc; ++c) {
                                    vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                    int[] inData = ((vtkUnsignedIntArray)myvtkarray).GetJavaArray();
                                    int[] outData = new int[w * h];
                                    for (int i = 0; i < h; ++i) {
                                        for (int j = 0; j < w; ++j) {
                                            outData[i * w + j] = inData[z * w * h + i * w + j];
                                        }
                                    }
                                    image.setDataXYAsInt(c, outData);
                                }
                                sequence2.setImage(t, z, (BufferedImage)image);
                            }
                        }
                        break;
                    }
                    case FLOAT: {
                        for (int t = 0; t < nbt; ++t) {
                            for (int z = 0; z < nbz; ++z) {
                                IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                                for (int c = 0; c < nbc; ++c) {
                                    vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                    float[] inData = ((vtkFloatArray)myvtkarray).GetJavaArray();
                                    float[] outData = new float[w * h];
                                    for (int i = 0; i < h; ++i) {
                                        for (int j = 0; j < w; ++j) {
                                            outData[i * w + j] = inData[z * w * h + i * w + j];
                                        }
                                    }
                                    image.setDataXYAsFloat(c, outData);
                                }
                                sequence2.setImage(t, z, (BufferedImage)image);
                            }
                        }
                        break;
                    }
                    case DOUBLE: {
                        for (int t = 0; t < nbt; ++t) {
                            for (int z = 0; z < nbz; ++z) {
                                IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                                for (int c = 0; c < nbc; ++c) {
                                    vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                    double[] inData = ((vtkDoubleArray)myvtkarray).GetJavaArray();
                                    double[] outData = new double[w * h];
                                    for (int i = 0; i < h; ++i) {
                                        for (int j = 0; j < w; ++j) {
                                            outData[i * w + j] = inData[z * w * h + i * w + j];
                                        }
                                    }
                                    image.setDataXYAsDouble(c, outData);
                                }
                                sequence2.setImage(t, z, (BufferedImage)image);
                            }
                        }
                        break;
                    }
                }
                sequence2.setPixelSizeX(targetsx);
                sequence2.setPixelSizeY(targetsy);
                sequence2.setPixelSizeZ(targetsz);
            }
            finally {
                sequence2.endUpdate();
            }
            if (!this.isHeadLess()) {
                this.addSequence(sequence2);
            }
            sequence2.setName(((Sequence)this.source.getValue()).getName() + "Transformed");
            if (this.isHeadLess()) {
                this.out.setValue(sequence2);
            }
            System.out.println("have been applied");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private SimilarityTransformation3D getCombinedTransfo3D(Document document) {
        Element root = XMLUtil.getRootElement((Document)document);
        ArrayList transfoElementArrayList = XMLUtil.getElements((Node)root, (String)"MatrixTransformation");
        ArrayList<Matrix> listoftransfo = new ArrayList<Matrix>();
        boolean firsttime = true;
        double orisizex = ((Sequence)this.source.getValue()).getPixelSizeX();
        double orisizey = ((Sequence)this.source.getValue()).getPixelSizeY();
        double orisizez = ((Sequence)this.source.getValue()).getPixelSizeZ();
        for (Element transfoElement : transfoElementArrayList) {
            double[][] m = new double[4][4];
            if (firsttime) {
                orisizex = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"formerpixelsizeX", (double)0.0);
                orisizey = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"formerpixelsizeY", (double)0.0);
                orisizez = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"formerpixelsizeZ", (double)0.0);
                firsttime = false;
            }
            m[0][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m00", (double)0.0);
            m[0][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m01", (double)0.0);
            m[0][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m02", (double)0.0);
            m[0][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m03", (double)0.0);
            m[1][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m10", (double)0.0);
            m[1][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m11", (double)0.0);
            m[1][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m12", (double)0.0);
            m[1][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m13", (double)0.0);
            m[2][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m20", (double)0.0);
            m[2][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m21", (double)0.0);
            m[2][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m22", (double)0.0);
            m[2][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m23", (double)0.0);
            m[3][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m30", (double)0.0);
            m[3][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m31", (double)0.0);
            m[3][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m32", (double)0.0);
            m[3][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m33", (double)0.0);
            Matrix T = new Matrix(m);
            listoftransfo.add(T);
        }
        Matrix CombinedTransfo = Matrix.identity((int)4, (int)4);
        for (int i = 0; i < listoftransfo.size(); ++i) {
            CombinedTransfo = ((Matrix)listoftransfo.get(i)).times(CombinedTransfo);
        }
        SimilarityTransformation3D resulttransfo = new SimilarityTransformation3D(CombinedTransfo, orisizex, orisizey, orisizez);
        return resulttransfo;
    }

    private vtkPoints[] getLandmarks(Document document) {
        Element root = XMLUtil.getRootElement((Document)document);
        ArrayList transfoElementArrayList = XMLUtil.getElements((Node)root, (String)"pointspairsinphysicalcoordinates");
        vtkPoints lmsource = new vtkPoints();
        vtkPoints lmtarget = new vtkPoints();
        for (Element transfoElement : transfoElementArrayList) {
            double[] pointsource = new double[]{XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"xsource", (double)0.0), XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"ysource", (double)0.0), XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"zsource", (double)0.0)};
            lmsource.InsertNextPoint(pointsource);
            double[] pointtarget = new double[]{XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"xtarget", (double)0.0), XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"ytarget", (double)0.0), XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"ztarget", (double)0.0)};
            lmtarget.InsertNextPoint(pointtarget);
        }
        vtkPoints[] pointspairs = new vtkPoints[]{lmsource, lmtarget};
        Element transfoinfo = (Element)XMLUtil.getElements((Node)root, (String)"transfoelements").get(0);
        this.extentx = XMLUtil.getAttributeIntValue((Element)transfoinfo, (String)"extentx", (int)0);
        this.extenty = XMLUtil.getAttributeIntValue((Element)transfoinfo, (String)"extenty", (int)0);
        this.extentz = XMLUtil.getAttributeIntValue((Element)transfoinfo, (String)"extentz", (int)0);
        this.spacingx = XMLUtil.getAttributeDoubleValue((Element)transfoinfo, (String)"sx", (double)0.0);
        this.spacingy = XMLUtil.getAttributeDoubleValue((Element)transfoinfo, (String)"sy", (double)0.0);
        this.spacingz = XMLUtil.getAttributeDoubleValue((Element)transfoinfo, (String)"sz", (double)0.0);
        this.Inputspacingx = XMLUtil.getAttributeDoubleValue((Element)transfoinfo, (String)"ix", (double)0.0);
        this.Inputspacingy = XMLUtil.getAttributeDoubleValue((Element)transfoinfo, (String)"iy", (double)0.0);
        this.Inputspacingz = XMLUtil.getAttributeDoubleValue((Element)transfoinfo, (String)"iz", (double)0.0);
        int npoints = XMLUtil.getAttributeIntValue((Element)transfoinfo, (String)"Npoints", (int)0);
        System.out.println("For info " + npoints + " have been loaded.");
        return pointspairs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ApplynonrigidTransformation(Document document) {
        vtkPoints[] pointspairs = this.getLandmarks(document);
        vtkThinPlateSplineTransform myvtkTransform = new vtkThinPlateSplineTransform();
        myvtkTransform.SetSourceLandmarks(pointspairs[0]);
        myvtkTransform.SetTargetLandmarks(pointspairs[1]);
        myvtkTransform.SetBasisToR2LogR();
        int nbc = ((Sequence)this.source.getValue()).getSizeC();
        this.imageData = new vtkDataSet[nbc];
        for (int c = 0; c < ((Sequence)this.source.getValue()).getSizeC(); ++c) {
            this.converttoVtkImageData(c);
            vtkImageReslice ImageReslice = new vtkImageReslice();
            ImageReslice.SetInputData((vtkDataObject)this.imageData[c]);
            ImageReslice.SetOutputDimensionality(3);
            ImageReslice.SetOutputOrigin(0.0, 0.0, 0.0);
            ImageReslice.SetOutputSpacing(this.spacingx, this.spacingy, this.spacingz);
            ImageReslice.SetOutputExtent(0, this.extentx, 0, this.extenty, 0, this.extentz);
            ImageReslice.SetResliceTransform(myvtkTransform.GetInverse());
            ImageReslice.SetInterpolationModeToLinear();
            ImageReslice.Update();
            this.imageData[c] = ImageReslice.GetOutput();
        }
        int nbt = ((Sequence)this.source.getValue()).getSizeT();
        int nbz = this.extentz + 1;
        int w = this.extentx + 1;
        int h = this.extenty + 1;
        DataType datatype = ((Sequence)this.source.getValue()).getDataType_();
        ((Sequence)this.source.getValue()).beginUpdate();
        ((Sequence)this.source.getValue()).removeAllImages();
        try {
            switch (datatype) {
                case UBYTE: {
                    for (int t = 0; t < nbt; ++t) {
                        for (int z = 0; z < nbz; ++z) {
                            IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                            for (int c = 0; c < nbc; ++c) {
                                vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                byte[] inData = ((vtkUnsignedCharArray)myvtkarray).GetJavaArray();
                                byte[] outData = new byte[w * h];
                                for (int i = 0; i < h; ++i) {
                                    for (int j = 0; j < w; ++j) {
                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                    }
                                }
                                image.setDataXYAsByte(c, outData);
                            }
                            ((Sequence)this.source.getValue()).setImage(t, z, (BufferedImage)image);
                        }
                    }
                    break;
                }
                case BYTE: {
                    for (int t = 0; t < nbt; ++t) {
                        for (int z = 0; z < nbz; ++z) {
                            IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                            for (int c = 0; c < nbc; ++c) {
                                vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                byte[] inData = ((vtkUnsignedCharArray)myvtkarray).GetJavaArray();
                                byte[] outData = new byte[w * h];
                                for (int i = 0; i < h; ++i) {
                                    for (int j = 0; j < w; ++j) {
                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                    }
                                }
                                image.setDataXYAsByte(c, outData);
                            }
                            ((Sequence)this.source.getValue()).setImage(t, z, (BufferedImage)image);
                        }
                    }
                    break;
                }
                case USHORT: {
                    for (int t = 0; t < nbt; ++t) {
                        for (int z = 0; z < nbz; ++z) {
                            IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                            for (int c = 0; c < nbc; ++c) {
                                vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                short[] inData = ((vtkUnsignedShortArray)myvtkarray).GetJavaArray();
                                short[] outData = new short[w * h];
                                for (int i = 0; i < h; ++i) {
                                    for (int j = 0; j < w; ++j) {
                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                    }
                                }
                                image.setDataXYAsShort(c, outData);
                            }
                            ((Sequence)this.source.getValue()).setImage(t, z, (BufferedImage)image);
                        }
                    }
                    break;
                }
                case UINT: {
                    for (int t = 0; t < nbt; ++t) {
                        for (int z = 0; z < nbz; ++z) {
                            IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                            for (int c = 0; c < nbc; ++c) {
                                vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                int[] inData = ((vtkUnsignedIntArray)myvtkarray).GetJavaArray();
                                int[] outData = new int[w * h];
                                for (int i = 0; i < h; ++i) {
                                    for (int j = 0; j < w; ++j) {
                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                    }
                                }
                                image.setDataXYAsInt(c, outData);
                            }
                            ((Sequence)this.source.getValue()).setImage(t, z, (BufferedImage)image);
                        }
                    }
                    break;
                }
                case INT: {
                    for (int t = 0; t < nbt; ++t) {
                        for (int z = 0; z < nbz; ++z) {
                            IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                            for (int c = 0; c < nbc; ++c) {
                                vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                int[] inData = ((vtkIntArray)myvtkarray).GetJavaArray();
                                int[] outData = new int[w * h];
                                for (int i = 0; i < h; ++i) {
                                    for (int j = 0; j < w; ++j) {
                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                    }
                                }
                                image.setDataXYAsInt(c, outData);
                            }
                            ((Sequence)this.source.getValue()).setImage(t, z, (BufferedImage)image);
                        }
                    }
                    break;
                }
                case SHORT: {
                    for (int t = 0; t < nbt; ++t) {
                        for (int z = 0; z < nbz; ++z) {
                            IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                            for (int c = 0; c < nbc; ++c) {
                                vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                short[] inData = ((vtkShortArray)myvtkarray).GetJavaArray();
                                short[] outData = new short[w * h];
                                for (int i = 0; i < h; ++i) {
                                    for (int j = 0; j < w; ++j) {
                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                    }
                                }
                                image.setDataXYAsShort(c, outData);
                            }
                            ((Sequence)this.source.getValue()).setImage(t, z, (BufferedImage)image);
                        }
                    }
                    break;
                }
                case FLOAT: {
                    for (int t = 0; t < nbt; ++t) {
                        for (int z = 0; z < nbz; ++z) {
                            IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                            for (int c = 0; c < nbc; ++c) {
                                vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                float[] inData = ((vtkFloatArray)myvtkarray).GetJavaArray();
                                float[] outData = new float[w * h];
                                for (int i = 0; i < h; ++i) {
                                    for (int j = 0; j < w; ++j) {
                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                    }
                                }
                                image.setDataXYAsFloat(c, outData);
                            }
                            ((Sequence)this.source.getValue()).setImage(t, z, (BufferedImage)image);
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    for (int t = 0; t < nbt; ++t) {
                        for (int z = 0; z < nbz; ++z) {
                            IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                            for (int c = 0; c < nbc; ++c) {
                                vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                double[] inData = ((vtkDoubleArray)myvtkarray).GetJavaArray();
                                double[] outData = new double[w * h];
                                for (int i = 0; i < h; ++i) {
                                    for (int j = 0; j < w; ++j) {
                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                    }
                                }
                                image.setDataXYAsDouble(c, outData);
                            }
                            ((Sequence)this.source.getValue()).setImage(t, z, (BufferedImage)image);
                        }
                    }
                    break;
                }
                default: {
                    System.err.println("unknown data format");
                }
            }
            ((Sequence)this.source.getValue()).setPixelSizeX(this.spacingx);
            ((Sequence)this.source.getValue()).setPixelSizeY(this.spacingy);
            ((Sequence)this.source.getValue()).setPixelSizeZ(this.spacingz);
        }
        finally {
            ((Sequence)this.source.getValue()).endUpdate();
        }
    }

    private void converttoVtkImageData(int posC) {
        vtkPointData pointData;
        Sequence sequence2 = (Sequence)this.source.getValue();
        if (this.source.getValue() == null) {
            return;
        }
        int sizeX = sequence2.getSizeX();
        int sizeY = sequence2.getSizeY();
        int sizeZ = sequence2.getSizeZ();
        DataType dataType = sequence2.getDataType_();
        int posT = !this.isHeadLess() ? sequence2.getFirstViewer().getPositionT() : 0;
        vtkImageData newImageData = new vtkImageData();
        newImageData.SetDimensions(sizeX, sizeY, sizeZ);
        newImageData.SetSpacing(this.Inputspacingx, this.Inputspacingy, this.Inputspacingz);
        switch (dataType) {
            case UBYTE: {
                newImageData.AllocateScalars(3, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkUnsignedCharArray)array).SetJavaArray(((Sequence)this.source.getValue()).getDataCopyCXYZAsByte(posT));
                    break;
                }
                ((vtkUnsignedCharArray)array).SetJavaArray(((Sequence)this.source.getValue()).getDataCopyXYZAsByte(posT, posC));
                break;
            }
            case BYTE: {
                newImageData.AllocateScalars(3, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkUnsignedCharArray)array).SetJavaArray(((Sequence)this.source.getValue()).getDataCopyCXYZAsByte(posT));
                    break;
                }
                ((vtkUnsignedCharArray)array).SetJavaArray(((Sequence)this.source.getValue()).getDataCopyXYZAsByte(posT, posC));
                break;
            }
            case USHORT: {
                newImageData.AllocateScalars(5, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkUnsignedShortArray)array).SetJavaArray(((Sequence)this.source.getValue()).getDataCopyCXYZAsShort(posT));
                    break;
                }
                ((vtkUnsignedShortArray)array).SetJavaArray(((Sequence)this.source.getValue()).getDataCopyXYZAsShort(posT, posC));
                break;
            }
            case SHORT: {
                newImageData.AllocateScalars(4, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkShortArray)array).SetJavaArray(((Sequence)this.source.getValue()).getDataCopyCXYZAsShort(posT));
                    break;
                }
                ((vtkShortArray)array).SetJavaArray(((Sequence)this.source.getValue()).getDataCopyXYZAsShort(posT, posC));
                break;
            }
            case UINT: {
                newImageData.AllocateScalars(7, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkUnsignedIntArray)array).SetJavaArray(((Sequence)this.source.getValue()).getDataCopyCXYZAsInt(posT));
                    break;
                }
                ((vtkUnsignedIntArray)array).SetJavaArray(((Sequence)this.source.getValue()).getDataCopyXYZAsInt(posT, posC));
                break;
            }
            case INT: {
                newImageData.AllocateScalars(6, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkIntArray)array).SetJavaArray(((Sequence)this.source.getValue()).getDataCopyCXYZAsInt(posT));
                    break;
                }
                ((vtkIntArray)array).SetJavaArray(((Sequence)this.source.getValue()).getDataCopyXYZAsInt(posT, posC));
                break;
            }
            case FLOAT: {
                newImageData.AllocateScalars(10, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkFloatArray)array).SetJavaArray(((Sequence)this.source.getValue()).getDataCopyCXYZAsFloat(posT));
                    break;
                }
                ((vtkFloatArray)array).SetJavaArray(((Sequence)this.source.getValue()).getDataCopyXYZAsFloat(posT, posC));
                break;
            }
            case DOUBLE: {
                newImageData.AllocateScalars(11, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkDoubleArray)array).SetJavaArray(((Sequence)this.source.getValue()).getDataCopyCXYZAsDouble(posT));
                    break;
                }
                ((vtkDoubleArray)array).SetJavaArray(((Sequence)this.source.getValue()).getDataCopyXYZAsDouble(posT, posC));
                break;
            }
            default: {
                newImageData.SetDimensions(1, 1, 1);
                newImageData.SetSpacing(((Sequence)this.source.getValue()).getPixelSizeX(), ((Sequence)this.source.getValue()).getPixelSizeY(), ((Sequence)this.source.getValue()).getPixelSizeZ());
                newImageData.SetNumberOfScalarComponents(1, null);
                newImageData.SetExtent(0, 0, 0, 0, 0, 0);
                newImageData.AllocateScalars(null);
            }
        }
        if (this.imageData[posC] != null && (pointData = this.imageData[posC].GetPointData()) != null) {
            vtkDataArray dataArray = pointData.GetScalars();
            if (dataArray != null) {
                dataArray.Delete();
            }
            pointData.Delete();
            this.imageData[posC].ReleaseData();
            this.imageData[posC].Delete();
        }
        this.imageData[posC] = newImageData;
    }

    public void clean() {
    }

    public Matrix getCombinedTransfo(Document document) {
        Element root = XMLUtil.getRootElement((Document)document);
        ArrayList transfoElementArrayList = XMLUtil.getElements((Node)root, (String)"MatrixTransformation");
        ArrayList<Matrix> listoftransfo = new ArrayList<Matrix>();
        for (Element transfoElement : transfoElementArrayList) {
            double[][] m = new double[4][4];
            m[0][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m00", (double)0.0);
            m[0][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m01", (double)0.0);
            m[0][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m02", (double)0.0);
            m[0][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m03", (double)0.0);
            m[1][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m10", (double)0.0);
            m[1][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m11", (double)0.0);
            m[1][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m12", (double)0.0);
            m[1][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m13", (double)0.0);
            m[2][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m20", (double)0.0);
            m[2][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m21", (double)0.0);
            m[2][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m22", (double)0.0);
            m[2][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m23", (double)0.0);
            m[3][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m30", (double)0.0);
            m[3][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m31", (double)0.0);
            m[3][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m32", (double)0.0);
            m[3][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m33", (double)0.0);
            Matrix T = new Matrix(m);
            listoftransfo.add(T);
        }
        Matrix CombinedTransfo = Matrix.identity((int)4, (int)4);
        for (int i = 0; i < listoftransfo.size(); ++i) {
            CombinedTransfo = ((Matrix)listoftransfo.get(i)).times(CombinedTransfo);
        }
        return CombinedTransfo;
    }

    public Document getdocumentTitle() {
        Document document = XMLUtil.loadDocument((File)((File)this.xmlFile.getValue()));
        return document;
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("Input Image", (Var)this.source.getVariable());
        inputMap.add("Imput XML File", this.xmlFile.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("Transformed Sequence", (Var)this.out);
    }
}

