/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.easyclemv0;

import Jama.Matrix;
import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.file.Saver;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.ToolTipFrame;
import icy.preferences.ApplicationPreferences;
import icy.sequence.Sequence;
import icy.util.XMLUtil;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.perrine.easyclemv0.ImageTransformer;
import plugins.perrine.easyclemv0.SimilarityTransformation3D;
import plugins.perrine.easyclemv0.Stack3DVTKTransformer;

public class ApplyTransfotoScaledImage
extends EzPlug {
    EzVarSequence source;
    private EzVarFile xmlFile;
    private EzVarInteger sourcebinning;
    private EzVarInteger targetbinning;

    protected void initialize() {
        new ToolTipFrame("<html><br>If you have worked on a resized (reduced) version of source and <br> of target image for time and memory purpose, <br> the transfo computed from this reduced image will be rescale to fit the original size<br> of your source and target images<br><b> Source binning </b> is the reduced scale for source that you used to compute the transfo, <br><b> Target binning </b> is the reduced scale for target that you used to compute the transfo,  <br>Example : you have processed reduced size source of 512*512 of a 2048x2048 original source file <br>and a reduced size target of 512*512 of a 4096x4096 original target file <br>Source binning will be 4 (2048/ 512) and target binning will be 8 (4096 / 512)</html>");
        this.source = new EzVarSequence("Select Source Image Full Size (will be transformed from xml file)");
        String varName = "Xml file containing list of transformation (computed on reduced images)";
        this.xmlFile = this.source.getValue() != null ? new EzVarFile(varName, ((Sequence)this.source.getValue()).getFilename()) : new EzVarFile(varName, ApplicationPreferences.getPreferences().node("frame/imageLoader").get("path", "."));
        this.sourcebinning = new EzVarInteger("Source Binning ", 1, 100, 1);
        this.targetbinning = new EzVarInteger("Target Binning ", 1, 100, 1);
        this.addEzComponent((EzComponent)this.source);
        this.addEzComponent((EzComponent)this.xmlFile);
        this.addEzComponent((EzComponent)this.sourcebinning);
        this.addEzComponent((EzComponent)this.targetbinning);
    }

    protected void execute() {
        double targetsz;
        double targetsy;
        double targetsx;
        Sequence sourceseq = (Sequence)this.source.getValue();
        if (sourceseq == null) {
            MessageDialog.showDialog((String)"Please make sure that your image is opened");
            return;
        }
        Document document = XMLUtil.loadDocument((File)((File)this.xmlFile.getValue()));
        Element root = XMLUtil.getRootElement((Document)document);
        try {
            Element newsizeelement = (Element)XMLUtil.getElements((Node)root, (String)"TargetSize").get(0);
            int width = XMLUtil.getAttributeIntValue((Element)newsizeelement, (String)"width", (int)-1);
            int height = XMLUtil.getAttributeIntValue((Element)newsizeelement, (String)"height", (int)-1);
            targetsx = XMLUtil.getAttributeDoubleValue((Element)newsizeelement, (String)"sx", (double)-1.0);
            targetsy = XMLUtil.getAttributeDoubleValue((Element)newsizeelement, (String)"sy", (double)-1.0);
            targetsz = XMLUtil.getAttributeDoubleValue((Element)newsizeelement, (String)"sz", (double)-1.0);
            int nbz = XMLUtil.getAttributeIntValue((Element)newsizeelement, (String)"nz", (int)-1);
            double scalesource = 1.0 / (double)((Integer)this.sourcebinning.getValue()).intValue();
            double scaletarget = 1.0 / (double)((Integer)this.targetbinning.getValue()).intValue();
            width *= ((Integer)this.targetbinning.getValue()).intValue();
            height *= ((Integer)this.targetbinning.getValue()).intValue();
            Matrix CombinedTransfo = this.getCombinedTransfo(document, scalesource, scaletarget);
            if (nbz == -1) {
                ImageTransformer mytransformer = new ImageTransformer();
                mytransformer.setImageSource((Sequence)this.source.getValue());
                mytransformer.setParameters(CombinedTransfo);
                mytransformer.setDestinationsize(width, height);
                mytransformer.run();
            } else {
                SimilarityTransformation3D transfo = this.getCombinedTransfo3D(document, scalesource, scaletarget);
                Matrix transfomat = transfo.getMatrix();
                Stack3DVTKTransformer transfoimage3D = new Stack3DVTKTransformer();
                transfoimage3D.setImageSource((Sequence)this.source.getValue(), transfo.getorisizex(), transfo.getorisizey(), transfo.getorisizez());
                transfoimage3D.setDestinationsize(width, height, nbz, targetsx, targetsy, targetsz);
                transfoimage3D.setParameters(transfomat, transfo.getscalex(), transfo.getscalez());
                transfoimage3D.run();
            }
        }
        catch (Exception e) {
            new AnnounceFrame("Do not forget to load the xml file", 5);
            return;
        }
        IcyCanvas sourcecanvas = ((Sequence)this.source.getValue()).getFirstViewer().getCanvas();
        if (sourcecanvas instanceof IcyCanvas2D) {
            ((IcyCanvas2D)sourcecanvas).fitCanvasToImage();
        }
        sourceseq.setFilename(sourceseq.getFilename() + " (transformed)");
        sourceseq.setName(sourceseq.getName() + " (transformed)");
        sourceseq.setPixelSizeX(targetsx * 1.0 / (double)((Integer)this.targetbinning.getValue()).intValue());
        sourceseq.setPixelSizeY(targetsy * 1.0 / (double)((Integer)this.targetbinning.getValue()).intValue());
        sourceseq.setPixelSizeZ(targetsz);
        File file = new File(sourceseq.getFilename());
        boolean multipleFiles = false;
        boolean showProgress = true;
        System.out.println("Save as" + sourceseq.getFilename());
        Saver.save((Sequence)sourceseq, (File)file, (boolean)multipleFiles, (boolean)showProgress);
        MessageDialog.showDialog((String)"Transformation have been applied. Image has been renamed and saved, use this one for going on with your alignments");
    }

    private SimilarityTransformation3D getCombinedTransfo3D(Document document, double sourcescale, double targetscale) {
        Element root = XMLUtil.getRootElement((Document)document);
        ArrayList transfoElementArrayList = XMLUtil.getElements((Node)root, (String)"MatrixTransformation");
        ArrayList<Matrix> listoftransfo = new ArrayList<Matrix>();
        Matrix ScaleSourcetransfo = Matrix.identity((int)4, (int)4).times(sourcescale);
        ScaleSourcetransfo.set(3, 3, 1.0);
        ScaleSourcetransfo.set(2, 2, 1.0);
        Matrix Scaletargettransfo = Matrix.identity((int)4, (int)4).times(1.0 / targetscale);
        Scaletargettransfo.set(3, 3, 1.0);
        Scaletargettransfo.set(2, 2, 1.0);
        double orisizex = ((Sequence)this.source.getValue()).getPixelSizeX();
        double orisizey = ((Sequence)this.source.getValue()).getPixelSizeY();
        double orisizez = ((Sequence)this.source.getValue()).getPixelSizeZ();
        Element transfoElementf = (Element)transfoElementArrayList.get(0);
        double orisizexbinned = XMLUtil.getAttributeDoubleValue((Element)transfoElementf, (String)"formerpixelsizeX", (double)0.0);
        if (orisizex == orisizexbinned && sourcescale != 1.0) {
            listoftransfo.add(ScaleSourcetransfo);
            System.out.println("Warning something strange happened to your metadata. Check your binned metadata and these one.");
        }
        for (Element transfoElement : transfoElementArrayList) {
            double[][] m = new double[4][4];
            m[0][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m00", (double)0.0);
            m[0][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m01", (double)0.0);
            m[0][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m02", (double)0.0);
            m[0][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m03", (double)0.0);
            m[1][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m10", (double)0.0);
            m[1][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m11", (double)0.0);
            m[1][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m12", (double)0.0);
            m[1][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m13", (double)0.0);
            m[2][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m20", (double)0.0);
            m[2][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m21", (double)0.0);
            m[2][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m22", (double)0.0);
            m[2][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m23", (double)0.0);
            m[3][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m30", (double)0.0);
            m[3][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m31", (double)0.0);
            m[3][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m32", (double)0.0);
            m[3][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m33", (double)0.0);
            Matrix T = new Matrix(m);
            listoftransfo.add(T);
        }
        listoftransfo.add(Scaletargettransfo);
        Matrix CombinedTransfo = Matrix.identity((int)4, (int)4);
        for (int i = 0; i < listoftransfo.size(); ++i) {
            CombinedTransfo = ((Matrix)listoftransfo.get(i)).times(CombinedTransfo);
        }
        SimilarityTransformation3D resulttransfo = new SimilarityTransformation3D(CombinedTransfo, orisizex, orisizey, orisizez);
        return resulttransfo;
    }

    public void clean() {
    }

    public Matrix getCombinedTransfo(Document document, double sourcescale, double targetscale) {
        Element root = XMLUtil.getRootElement((Document)document);
        ArrayList transfoElementArrayList = XMLUtil.getElements((Node)root, (String)"MatrixTransformation");
        ArrayList<Matrix> listoftransfo = new ArrayList<Matrix>();
        Matrix ScaleSourcetransfo = Matrix.identity((int)4, (int)4).times(1.0 * sourcescale);
        ScaleSourcetransfo.set(3, 3, 1.0);
        ScaleSourcetransfo.set(2, 2, 1.0);
        Matrix Scaletargettransfo = Matrix.identity((int)4, (int)4).times(1.0 / targetscale);
        Scaletargettransfo.set(3, 3, 1.0);
        Scaletargettransfo.set(2, 2, 1.0);
        listoftransfo.add(ScaleSourcetransfo);
        for (Element transfoElement : transfoElementArrayList) {
            double[][] m = new double[4][4];
            m[0][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m00", (double)0.0);
            m[0][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m01", (double)0.0);
            m[0][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m02", (double)0.0);
            m[0][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m03", (double)0.0);
            m[1][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m10", (double)0.0);
            m[1][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m11", (double)0.0);
            m[1][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m12", (double)0.0);
            m[1][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m13", (double)0.0);
            m[2][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m20", (double)0.0);
            m[2][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m21", (double)0.0);
            m[2][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m22", (double)0.0);
            m[2][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m23", (double)0.0);
            m[3][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m30", (double)0.0);
            m[3][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m31", (double)0.0);
            m[3][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m32", (double)0.0);
            m[3][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m33", (double)0.0);
            Matrix T = new Matrix(m);
            listoftransfo.add(T);
        }
        listoftransfo.add(Scaletargettransfo);
        Matrix CombinedTransfo = Matrix.identity((int)4, (int)4);
        for (int i = 0; i < listoftransfo.size(); ++i) {
            CombinedTransfo = ((Matrix)listoftransfo.get(i)).times(CombinedTransfo);
        }
        return CombinedTransfo;
    }

    public Document getdocumentTitle() {
        Document document = XMLUtil.loadDocument((File)((File)this.xmlFile.getValue()));
        return document;
    }
}

