/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.easyclemv0;

import Jama.Matrix;
import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.ToolTipFrame;
import icy.gui.util.FontUtil;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.image.lut.LUT;
import icy.main.Icy;
import icy.painter.Overlay;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import icy.sequence.SequenceUtil;
import icy.system.thread.ThreadUtil;
import icy.type.DataType;
import icy.type.point.Point5D;
import icy.util.XMLUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.adufour.ezplug.EzButton;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.kernel.roi.descriptor.measure.ROIMassCenterDescriptorsPlugin;
import plugins.kernel.roi.roi2d.plugin.ROI2DPointPlugin;
import plugins.kernel.roi.roi3d.ROI3DPoint;
import plugins.kernel.roi.roi3d.plugin.ROI3DPointPlugin;
import plugins.perrine.easyclemv0.GuiCLEMButtonApply;
import plugins.perrine.easyclemv0.GuiCLEMButtonPreprocess;
import plugins.perrine.easyclemv0.GuiCLEMButtons;
import plugins.perrine.easyclemv0.GuiCLEMButtons2;
import plugins.perrine.easyclemv0.ImageTransformer;
import plugins.perrine.easyclemv0.MonitorTargetPoint;
import plugins.perrine.easyclemv0.PPPoint3D;
import plugins.perrine.easyclemv0.PointsPair;
import plugins.perrine.easyclemv0.PointsPair3D;
import plugins.perrine.easyclemv0.SimilarityRegistrationAnalytic;
import plugins.perrine.easyclemv0.SimilarityRegistrationAnalytic3D;
import plugins.perrine.easyclemv0.SimilarityTransformation2D;
import plugins.perrine.easyclemv0.SimilarityTransformation3D;
import plugins.perrine.easyclemv0.Stack3DVTKTransformer;
import plugins.perrine.easyclemv0.TargetRegistrationErrorMap;
import plugins.perrine.easyclemv0.advancedmodules;

public class EasyCLEMv0
extends EzPlug
implements EzStoppable,
SequenceListener {
    private ActionListener actionbutton = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (EasyCLEMv0.this.source.getValue() != null) {
                for (PluginDescriptor pluginDescriptor : PluginLoader.getPlugins()) {
                    if (pluginDescriptor.getSimpleClassName().compareToIgnoreCase("TransformBasedonCameraView") != 0) continue;
                    PluginLauncher.start((PluginDescriptor)pluginDescriptor);
                }
            } else {
                MessageDialog.showDialog((String)"Source was closed. Please open one and try again");
            }
        }
    };
    EzButton prealign = new EzButton("I want to prealign (rotate in 3D) my data)", this.actionbutton);
    boolean stopFlag = true;
    Vector<PointsPair> fiducialsvector;
    Vector<PointsPair3D> fiducialsvector3D;
    Vector<PointsPair3D> fiducialsvector3Dinum;
    double[][] targetpoints;
    double[][] sourcepoints;
    List<Double> listoftrevalues;
    List<Double> listofNvalues;
    private Runnable transformer;
    private boolean flagReadyToMove;
    private boolean done;
    File XMLFile;
    private Overlay myoverlaysource;
    private Overlay myoverlaytarget;
    Overlay myoverlaypredictederror;
    Overlay myoverlayerror;
    private Overlay messageSource;
    private Overlay messageTarget;
    boolean nonrigid;
    static String[] listofRegistrationchoice = new String[]{"From Live to EM", "From Section to EM", "From Live to Section"};
    EzVarBoolean showgrid = new EzVarBoolean(" Show grid deformation", false);
    EzVarText choiceinputsection = new EzVarText("I want to compute the transformation in:", new String[]{"2D (X,Y,[T])", "2D but let me update myself", "3D (X,Y,Z,[T])", "3D but let me update myself", "non rigid (2D or 3D)"}, 0, Boolean.valueOf(false));
    EzLabel versioninfo = new EzLabel("Version " + this.getDescriptor().getVersion());
    EzVarSequence target = new EzVarSequence("Select image that will not be modified (likely EM)");
    EzVarSequence source = new EzVarSequence("Select image that will be transformed and resized (likely FM)");
    EzGroup grp = new EzGroup("Images to process", new EzComponent[]{this.source, this.target});
    Sequence copysource;
    Sequence backupsource;
    double bucalibx;
    double bucaliby;
    double bucalibz;
    protected boolean predictederrorselected = false;
    protected boolean overlayerrorselected = false;
    boolean mode3D = false;
    private boolean pause = false;
    private Color[] Colortab;
    boolean monitor = false;
    public int xtarget;
    public int ytarget;
    public boolean waitfortarget = false;
    public boolean monitortargetonsource = false;
    protected boolean checkgrid = false;
    private GuiCLEMButtons2 rigidspecificbutton;

    private void plotarrow(double x1, double y1, double x2, double y2, double l, double w, Graphics2D g) {
        double[] dArray = new double[]{x2 - x1, y2 - y1};
        double[] ab = dArray;
        double norm = Math.sqrt(ab[0] * ab[0] + ab[1] * ab[1]);
        if (norm > l) {
            int[] t = new int[]{(int)Math.rint(ab[0] * (l / norm)), (int)Math.rint(ab[1] * (l / norm))};
            double[] r = new double[]{ab[1], -ab[0]};
            norm = Math.sqrt(r[0] * r[0] + r[1] * r[1]);
            r[0] = (int)Math.rint(r[0] / norm * (w / 2.0));
            r[1] = (int)Math.rint(r[1] / norm * (w / 2.0));
            double[][] tri = new double[][]{{x2, x2 - (double)t[0] + r[0], x2 - (double)t[0] - r[0], x2}, {y2, y2 - (double)t[1] + r[1], y2 - (double)t[1] - r[1], y2}};
            Line2D.Double l1 = new Line2D.Double(x1, y1, x2, y2);
            g.draw(l1);
            GeneralPath filledPolygon = new GeneralPath(0, 3);
            filledPolygon.moveTo(tri[0][0], tri[1][0]);
            for (int index = 1; index < 3; ++index) {
                filledPolygon.lineTo(tri[0][index], tri[1][index]);
            }
            filledPolygon.closePath();
            g.fill(filledPolygon);
            g.draw(filledPolygon);
        }
    }

    protected void initialize() {
        this.Colortab = new Color[9];
        this.Colortab[0] = Color.RED;
        this.Colortab[1] = Color.YELLOW;
        this.Colortab[2] = Color.PINK;
        this.Colortab[3] = Color.GREEN;
        this.Colortab[4] = Color.BLUE;
        this.Colortab[5] = Color.CYAN;
        this.Colortab[6] = Color.LIGHT_GRAY;
        this.Colortab[7] = Color.MAGENTA;
        this.Colortab[8] = Color.ORANGE;
        new ToolTipFrame("<html><br> Press Play when ready. <br> <li> Add point (2D or 3D ROI) on target image only.</li> <br> <li> Drag the point in Source, and RIGHT CLICK. Then add point again on target. <br> <li> If you add a point on source image instead (called point2D), delete it, <br> and select the ROI Point to add a point from Target</li> <br> <li> You can also prepare pair of points before , <br> by making sure they will have the same name in both images.</li><br> <li> Do not forget that the transformation will be automatically saved <br> and that you can apply to any image with the same original or a rescaled dimension.</li><br> <li> When working in 3D mode, make sure metadata (pixel size) are correctly calibrated, see Sequence Properties.</li> </html>", "startmessage");
        this.addEzComponent((EzComponent)this.versioninfo);
        this.addEzComponent((EzComponent)this.choiceinputsection);
        this.addEzComponent((EzComponent)this.showgrid);
        this.addEzComponent((EzComponent)this.prealign);
        this.prealign.setToolTipText("Volume can be turned in order to generate a new and still calibrated stack");
        this.choiceinputsection.addVisibilityTriggerTo((EzComponent)this.prealign, (Object[])new String[]{"3D (X,Y,Z,[T])", "3D but let me update myself"});
        this.addComponent(new GuiCLEMButtonPreprocess(this));
        this.addComponent(new GuiCLEMButtonApply(this));
        this.addComponent(new advancedmodules(this));
        this.addEzComponent((EzComponent)this.grp);
        this.choiceinputsection.setToolTipText("2D transform will be only in the plane XY but can be applied to all dimensions.\n WARNING make sure to have the metadata correctly set in 3D");
        this.choiceinputsection.addVisibilityTriggerTo((EzComponent)this.showgrid, (Object[])new String[]{"non rigid (2D or 3D)"});
        this.addComponent(new GuiCLEMButtons(this));
        this.rigidspecificbutton = new GuiCLEMButtons2(this);
        this.addComponent(this.rigidspecificbutton);
        this.listoftrevalues = new ArrayList<Double>();
        this.listofNvalues = new ArrayList<Double>();
        this.transformer = new Runnable(){

            @Override
            public void run() {
                if (!EasyCLEMv0.this.stopFlag) {
                    EasyCLEMv0.this.GetSourcePointsfromROI();
                    EasyCLEMv0.this.GetTargetPointsfromROI();
                    if (EasyCLEMv0.this.sourcepoints.length == EasyCLEMv0.this.targetpoints.length) {
                        if (!EasyCLEMv0.this.mode3D) {
                            EasyCLEMv0.this.fiducialsvector = EasyCLEMv0.this.createVectorfromdoublearray(EasyCLEMv0.this.sourcepoints, EasyCLEMv0.this.targetpoints);
                            EasyCLEMv0.this.fiducialsvector3D = new Vector();
                        } else {
                            EasyCLEMv0.this.fiducialsvector3D = EasyCLEMv0.this.createVectorfromdoublearray3D(EasyCLEMv0.this.sourcepoints, EasyCLEMv0.this.targetpoints);
                            EasyCLEMv0.this.fiducialsvector = new Vector();
                        }
                    } else {
                        boolean removed = false;
                        ArrayList listroi = ((Sequence)EasyCLEMv0.this.source.getValue()).getROIs();
                        for (ROI roi : listroi) {
                            if (roi.getName().contains("Point2D")) {
                                ((Sequence)EasyCLEMv0.this.source.getValue()).removeROI(roi);
                                removed = true;
                            }
                            if (!roi.getName().contains("Point3D")) continue;
                            ((Sequence)EasyCLEMv0.this.source.getValue()).removeROI(roi);
                            removed = true;
                        }
                        listroi = ((Sequence)EasyCLEMv0.this.target.getValue()).getROIs();
                        for (ROI roi : listroi) {
                            if (roi.getName().contains("Point2D")) {
                                ((Sequence)EasyCLEMv0.this.target.getValue()).removeROI(roi);
                                removed = true;
                            }
                            if (!roi.getName().contains("Point3D")) continue;
                            ((Sequence)EasyCLEMv0.this.target.getValue()).removeROI(roi);
                            removed = true;
                        }
                        EasyCLEMv0.this.GetSourcePointsfromROI();
                        EasyCLEMv0.this.GetTargetPointsfromROI();
                        if (removed) {
                            new AnnounceFrame("All points named Point2D or Point3D and likely not added by you have been removed. Re click now on \"apply transform\"");
                        }
                        if (EasyCLEMv0.this.sourcepoints.length != EasyCLEMv0.this.targetpoints.length) {
                            MessageDialog.showDialog((String)"Number of points", (String)"The number of points of ROI in source and target image are different. \n Check your ROI points and update transfo ");
                        }
                        Icy.getMainInterface().setSelectedTool(ROI2DPointPlugin.class.getName());
                        return;
                    }
                    int z = ((Sequence)EasyCLEMv0.this.source.getValue()).getFirstViewer().getPositionZ();
                    ROI roi = (ROI)((Sequence)EasyCLEMv0.this.source.getValue()).getROIs().get(((Sequence)EasyCLEMv0.this.source.getValue()).getROIs().size() - 1);
                    if (roi != null) {
                        Point5D pos = roi.getPosition5D();
                        pos.setZ((double)z);
                        roi.setPosition5D(pos);
                        if (!EasyCLEMv0.this.pause) {
                            EasyCLEMv0.this.ComputeTransfo();
                        } else {
                            new AnnounceFrame("You are in pause mode, click on update transfo", 3);
                            Icy.getMainInterface().setSelectedTool(ROI2DPointPlugin.class.getName());
                        }
                    }
                }
            }
        };
    }

    Vector<PointsPair3D> createVectorfromdoublearray3D(double[][] sourcepoints2, double[][] targetpoints2) {
        Vector<PointsPair3D> points = new Vector<PointsPair3D>();
        if (sourcepoints2.length == targetpoints2.length) {
            for (int i = 0; i < sourcepoints2.length; ++i) {
                points.addElement(new PointsPair3D(new PPPoint3D(sourcepoints2[i][0], sourcepoints2[i][1], sourcepoints2[i][2]), new PPPoint3D(targetpoints2[i][0], targetpoints2[i][1], targetpoints2[i][2])));
            }
        }
        return points;
    }

    Vector<PointsPair> createVectorfromdoublearray(double[][] sourcepoints2, double[][] targetpoints2) {
        Vector<PointsPair> points = new Vector<PointsPair>();
        if (targetpoints2.length == sourcepoints2.length) {
            for (int i = 0; i < sourcepoints2.length; ++i) {
                points.addElement(new PointsPair(new Point2D.Double(sourcepoints2[i][0], sourcepoints2[i][1]), new Point2D.Double(targetpoints2[i][0], targetpoints2[i][1])));
            }
        }
        return points;
    }

    private void ReOrder(ArrayList<ROI> listfiducials) {
        boolean permut;
        int longueur = listfiducials.size();
        do {
            permut = false;
            for (int i = 0; i < longueur - 1; ++i) {
                if (listfiducials.get(i).getName().compareTo(listfiducials.get(i + 1).getName()) <= 0) continue;
                ROI tampon = listfiducials.get(i);
                listfiducials.set(i, listfiducials.get(i + 1));
                listfiducials.set(i + 1, tampon);
                permut = true;
            }
        } while (permut);
    }

    void GetTargetPointsfromROI() {
        int i;
        if (this.target.getValue() == null) {
            MessageDialog.showDialog((String)"Make sure target image is openned");
            return;
        }
        ((Sequence)this.target.getValue()).removeListener((SequenceListener)this);
        ArrayList listfiducials = ((Sequence)this.target.getValue()).getROIs();
        for (i = 0; i < listfiducials.size(); ++i) {
            ROI roi = (ROI)listfiducials.get(i);
            if (roi.getClassName() == "plugins.kernel.roi.roi3d.ROI3DPoint") continue;
            ROI3DPoint roi3D = new ROI3DPoint(roi.getPosition5D());
            roi3D.setName(roi.getName());
            roi3D.setColor(roi.getColor());
            roi3D.setStroke(roi.getStroke());
            listfiducials.set(i, roi3D);
        }
        ((Sequence)this.target.getValue()).removeAllROI();
        ((Sequence)this.target.getValue()).addROIs((Collection)listfiducials, false);
        this.ReOrder(listfiducials);
        this.targetpoints = new double[listfiducials.size()][3];
        i = -1;
        for (ROI roi : listfiducials) {
            ++i;
            Point5D p3D = null;
            try {
                p3D = ROIMassCenterDescriptorsPlugin.computeMassCenter((ROI)roi);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (roi.getClassName() == "plugins.kernel.roi.roi3d.ROI3DPoint") {
                p3D = roi.getPosition5D();
            }
            if (Double.isNaN(p3D.getX())) {
                p3D = roi.getPosition5D();
            }
            this.targetpoints[i][0] = p3D.getX();
            this.targetpoints[i][1] = p3D.getY();
            this.targetpoints[i][2] = p3D.getZ();
            this.targetpoints[i][2] = p3D.getZ();
        }
        ((Sequence)this.target.getValue()).addListener((SequenceListener)this);
    }

    void GetSourcePointsfromROI() {
        int i;
        if (this.source.getValue() == null) {
            MessageDialog.showDialog((String)"Make sure source image is openned");
            return;
        }
        ((Sequence)this.source.getValue()).removeListener((SequenceListener)this);
        ArrayList listfiducials = ((Sequence)this.source.getValue()).getROIs();
        for (i = 0; i < listfiducials.size(); ++i) {
            ROI roi = (ROI)listfiducials.get(i);
            if (roi.getClassName() == "plugins.kernel.roi.roi3d.ROI3DPoint") continue;
            ROI3DPoint roi3D = new ROI3DPoint(roi.getPosition5D());
            roi3D.setName(roi.getName());
            roi3D.setColor(roi.getColor());
            roi3D.setStroke(roi.getStroke());
            listfiducials.set(i, roi3D);
        }
        ((Sequence)this.source.getValue()).removeAllROI();
        ((Sequence)this.source.getValue()).addROIs((Collection)listfiducials, false);
        this.ReOrder(listfiducials);
        this.sourcepoints = new double[listfiducials.size()][3];
        i = -1;
        for (ROI roi : listfiducials) {
            ++i;
            Point5D p3D = null;
            try {
                p3D = ROIMassCenterDescriptorsPlugin.computeMassCenter((ROI)roi);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (roi.getClassName() == "plugins.kernel.roi.roi3d.ROI3DPoint") {
                p3D = roi.getPosition5D();
            }
            if (Double.isNaN(p3D.getX())) {
                p3D = roi.getPosition5D();
            }
            this.sourcepoints[i][0] = p3D.getX();
            this.sourcepoints[i][1] = p3D.getY();
            this.sourcepoints[i][2] = p3D.getZ();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() {
        Sequence sourceseq;
        this.stopFlag = false;
        this.flagReadyToMove = false;
        Sequence targetseq = (Sequence)this.target.getValue();
        if (targetseq == (sourceseq = (Sequence)this.source.getValue())) {
            MessageDialog.showDialog((String)"You have selected the same sequence for target sequence and source sequence. \n Check the IMAGES to PROCESS selection");
            return;
        }
        if (sourceseq == null) {
            MessageDialog.showDialog((String)"No sequence selected for Source. \n Check the IMAGES to PROCESS selection");
            return;
        }
        if (targetseq == null) {
            MessageDialog.showDialog((String)"No sequence selected for Target. \n Check the IMAGES to PROCESS selection");
            return;
        }
        this.GetSourcePointsfromROI();
        this.GetTargetPointsfromROI();
        this.choiceinputsection.setEnabled(false);
        if (this.choiceinputsection.getValue() == "3D (X,Y,Z,[T])") {
            this.nonrigid = false;
            this.mode3D = true;
            this.pause = false;
        }
        if (this.choiceinputsection.getValue() == "2D but let me update myself") {
            this.mode3D = false;
            this.nonrigid = false;
            this.pause = true;
        }
        if (this.choiceinputsection.getValue() == "2D (X,Y,[T])") {
            this.mode3D = false;
            this.pause = false;
            this.nonrigid = false;
        }
        if (this.choiceinputsection.getValue() == "3D but let me update myself") {
            this.mode3D = true;
            this.pause = true;
            this.nonrigid = false;
        }
        if (this.choiceinputsection.getValue() == "non rigid (2D or 3D)") {
            this.checkgrid = (Boolean)this.showgrid.getValue();
            this.pause = true;
            this.mode3D = false;
            this.nonrigid = true;
            this.rigidspecificbutton.removespecificrigidbutton();
        }
        if (this.mode3D) {
            IcyBufferedImage image;
            int z;
            int t;
            new AnnounceFrame("Computation will be done in 3D, it can lead to instability in case of planar transformation", 5);
            Sequence tmp = null;
            if (sourceseq.getDataType_().getBitSize() != 8) {
                try {
                    tmp = SequenceUtil.convertToType((Sequence)sourceseq, (DataType)DataType.UBYTE, (boolean)true);
                    sourceseq.beginUpdate();
                    sourceseq.removeAllImages();
                    try {
                        for (t = 0; t < tmp.getSizeT(); ++t) {
                            for (z = 0; z < tmp.getSizeZ(); ++z) {
                                image = tmp.getImage(t, z);
                                sourceseq.setImage(t, z, (BufferedImage)image);
                            }
                        }
                    }
                    finally {
                        sourceseq.endUpdate();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (targetseq.getDataType_().getBitSize() != 8) {
                try {
                    tmp = SequenceUtil.convertToType((Sequence)targetseq, (DataType)DataType.UBYTE, (boolean)true);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                targetseq.beginUpdate();
                targetseq.removeAllImages();
                try {
                    for (t = 0; t < tmp.getSizeT(); ++t) {
                        for (z = 0; z < tmp.getSizeZ(); ++z) {
                            image = tmp.getImage(t, z);
                            targetseq.setImage(t, z, (BufferedImage)image);
                        }
                    }
                }
                finally {
                    targetseq.endUpdate();
                }
            }
            targetseq.setAutoUpdateChannelBounds(true);
            sourceseq.setAutoUpdateChannelBounds(true);
            new AnnounceFrame("Warning:" + ((Sequence)this.target.getValue()).getName() + "and " + ((Sequence)this.source.getValue()).getName() + " have been converted to 8 bytes (to save memory in 3D)", 5);
            if (sourceseq.getSizeZ() == 1) {
                sourceseq.setPixelSizeZ(targetseq.getPixelSizeZ());
            }
        }
        Icy.getMainInterface().setSelectedTool(ROI2DPointPlugin.class.getName());
        if (sourceseq == null) {
            return;
        }
        try {
            this.backupsource = SequenceUtil.getCopy((Sequence)sourceseq);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.bucalibx = this.backupsource.getPixelSizeX();
        this.bucaliby = this.backupsource.getPixelSizeY();
        this.bucalibz = this.backupsource.getPixelSizeZ();
        this.myoverlaysource = new VisiblepointsOverlay();
        this.myoverlaytarget = new VisiblepointsOverlay();
        this.myoverlayerror = new ErrorinPositionOverlay();
        this.myoverlaypredictederror = new PredictedErrorinPositionOverlay();
        this.messageSource = new MessageOverlay("SourceImage: will be transformed. Do not add point here but drag the points added from target");
        this.messageTarget = new MessageOverlay("Target Message: add Roi points here");
        sourceseq.addOverlay(this.messageSource);
        targetseq.addOverlay(this.messageTarget);
        sourceseq.addOverlay(this.myoverlaysource);
        targetseq.addOverlay(this.myoverlaytarget);
        if (this.predictederrorselected) {
            ((Sequence)this.source.getValue()).addOverlay(this.myoverlaypredictederror);
        }
        if (this.overlayerrorselected) {
            ((Sequence)this.source.getValue()).addOverlay(this.myoverlayerror);
        }
        sourceseq.setName(sourceseq.getName() + " (transformed)");
        String name = sourceseq.getFilename() + "_transfo.xml";
        this.XMLFile = new File(name);
        sourceseq.setFilename(sourceseq.getName() + ".tif");
        Document myXMLdoc = XMLUtil.createDocument((boolean)true);
        Element transfoElement = XMLUtil.addElement((Node)myXMLdoc.getDocumentElement(), (String)"TargetSize");
        XMLUtil.setAttributeIntValue((Element)transfoElement, (String)"width", (int)((Sequence)this.target.getValue()).getWidth());
        XMLUtil.setAttributeIntValue((Element)transfoElement, (String)"height", (int)((Sequence)this.target.getValue()).getHeight());
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"sx", (double)((Sequence)this.target.getValue()).getPixelSizeX());
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"sy", (double)((Sequence)this.target.getValue()).getPixelSizeY());
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"sz", (double)((Sequence)this.target.getValue()).getPixelSizeZ());
        if (this.mode3D) {
            XMLUtil.setAttributeIntValue((Element)transfoElement, (String)"nz", (int)((Sequence)this.target.getValue()).getSizeZ());
        }
        if (!this.XMLFile.exists()) {
            try {
                this.XMLFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        XMLUtil.saveDocument((Document)myXMLdoc, (File)this.XMLFile);
        System.out.println("Transformation will be saved as " + this.XMLFile.getPath());
        new AnnounceFrame("Select point on image" + ((Sequence)this.target.getValue()).getName() + ", then drag it on source image and RIGHT CLICK", 5);
        while (!this.stopFlag) {
            ThreadUtil.sleep((int)10);
        }
        targetseq.removeListener((SequenceListener)this);
        sourceseq.removeListener((SequenceListener)this);
        System.out.println("Listeners off now");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ComputeTransfo() {
        if (this.fiducialsvector.size() > 2 || this.fiducialsvector3D.size() > 3) {
            Object newtransfo;
            Object meanfiducialsalgo;
            Object combinedtransfobefore;
            double back_up_pixelsizex = ((Sequence)this.source.getValue()).getPixelSizeX();
            double back_up_pixelsizey = ((Sequence)this.source.getValue()).getPixelSizeY();
            double back_up_pixelsizez = ((Sequence)this.source.getValue()).getPixelSizeZ();
            ((Sequence)this.source.getValue()).setAutoUpdateChannelBounds(false);
            ((Sequence)this.source.getValue()).beginUpdate();
            ((Sequence)this.source.getValue()).removeAllImages();
            if (this.backupsource == null) {
                MessageDialog.showDialog((String)"Please press the Play button to initialize process first");
                return;
            }
            try {
                for (int t = 0; t < this.backupsource.getSizeT(); ++t) {
                    for (int z = 0; z < this.backupsource.getSizeZ(); ++z) {
                        ((Sequence)this.source.getValue()).setImage(t, z, (BufferedImage)this.backupsource.getImage(t, z));
                    }
                }
            }
            finally {
                ((Sequence)this.source.getValue()).endUpdate();
            }
            Document document = XMLUtil.loadDocument((File)this.XMLFile);
            SimilarityTransformation2D lasttransfo = null;
            if (!this.mode3D) {
                combinedtransfobefore = this.getCombinedTransfo(document);
                meanfiducialsalgo = new SimilarityRegistrationAnalytic();
                newtransfo = ((SimilarityRegistrationAnalytic)meanfiducialsalgo).apply(this.fiducialsvector);
                lasttransfo = newtransfo;
                double dx = ((SimilarityTransformation2D)newtransfo).getdx();
                double dy = ((SimilarityTransformation2D)newtransfo).getdy();
                double scale = ((SimilarityTransformation2D)newtransfo).getscale();
                Matrix transfo = ((SimilarityTransformation2D)newtransfo).getMatrix();
                this.writeTransfo(transfo, this.fiducialsvector.size());
                transfo = transfo.times((Matrix)combinedtransfobefore);
                ImageTransformer mytransformer = new ImageTransformer();
                mytransformer.setImageSource((Sequence)this.source.getValue());
                mytransformer.setParameters(transfo);
                mytransformer.setDestinationsize(((Sequence)this.target.getValue()).getWidth(), ((Sequence)this.target.getValue()).getHeight());
                mytransformer.run();
                double pixelsizexum = ((Sequence)this.target.getValue()).getPixelSizeX();
                double pixelsizeyum = ((Sequence)this.target.getValue()).getPixelSizeY();
                ((Sequence)this.source.getValue()).setPixelSizeX(pixelsizexum);
                ((Sequence)this.source.getValue()).setPixelSizeY(pixelsizeyum);
                double angleyz = Math.atan2(transfo.get(2, 1), transfo.get(2, 2));
                double anglexz = Math.atan2(-transfo.get(2, 0), Math.sqrt(transfo.get(2, 1) * transfo.get(2, 1) + transfo.get(2, 2) * transfo.get(2, 2)));
                double anglexy = Math.atan2(transfo.get(1, 0), transfo.get(0, 0));
                angleyz = (double)Math.round(Math.toDegrees(angleyz) * 1000.0) / 1000.0;
                anglexz = (double)Math.round(Math.toDegrees(anglexz) * 1000.0) / 1000.0;
                anglexy = (double)Math.round(Math.toDegrees(anglexy) * 1000.0) / 1000.0;
                double dxt = (double)Math.round(transfo.get(3, 0) * 1000.0) / 1000.0;
                double dyt = (double)Math.round(transfo.get(3, 1) * 1000.0) / 1000.0;
                dx = (double)Math.round(dx * 1000.0) / 1000.0;
                dy = (double)Math.round(dy * 1000.0) / 1000.0;
                scale = (double)Math.round(scale * 1000.0) / 1000.0;
                System.out.println("Total computed Translation x " + dxt + " Total Translation y " + dyt + " angle Oz (in degrees) " + anglexy + " Scale " + scale);
                this.updateSourcePoints2D((SimilarityTransformation2D)newtransfo);
                this.updateRoi();
                new AnnounceFrame("Transformation Updated", 5);
            } else if (!this.testcoplanarity(this.fiducialsvector3D) || this.fiducialsvector3D.size() >= 6) {
                combinedtransfobefore = this.getCombinedTransfo3D(document);
                meanfiducialsalgo = new SimilarityRegistrationAnalytic3D();
                newtransfo = ((SimilarityRegistrationAnalytic3D)meanfiducialsalgo).apply(this.fiducialsvector3D, back_up_pixelsizex, back_up_pixelsizey, back_up_pixelsizez, ((Sequence)this.target.getValue()).getPixelSizeX(), ((Sequence)this.target.getValue()).getPixelSizeY(), ((Sequence)this.target.getValue()).getPixelSizeZ());
                Matrix transfo = ((SimilarityTransformation3D)newtransfo).getMatrix();
                if (transfo.get(2, 2) != 0.0) {
                    this.writeTransfo3D((SimilarityTransformation3D)newtransfo, this.fiducialsvector3D.size());
                    transfo = transfo.times(((SimilarityTransformation3D)combinedtransfobefore).getMatrix());
                    Stack3DVTKTransformer transfoimage3D = new Stack3DVTKTransformer();
                    transfoimage3D.setImageSource((Sequence)this.source.getValue(), ((SimilarityTransformation3D)combinedtransfobefore).getorisizex(), ((SimilarityTransformation3D)combinedtransfobefore).getorisizey(), ((SimilarityTransformation3D)combinedtransfobefore).getorisizez());
                    transfoimage3D.setDestinationsize(((Sequence)this.target.getValue()).getSizeX(), ((Sequence)this.target.getValue()).getSizeY(), ((Sequence)this.target.getValue()).getSizeZ(), ((Sequence)this.target.getValue()).getPixelSizeX(), ((Sequence)this.target.getValue()).getPixelSizeY(), ((Sequence)this.target.getValue()).getPixelSizeZ());
                    transfoimage3D.setParameters(transfo, ((SimilarityTransformation3D)newtransfo).getscalex(), ((SimilarityTransformation3D)newtransfo).getscalez());
                    transfoimage3D.run();
                    this.updateSourcePoints3D((SimilarityTransformation3D)newtransfo);
                    this.updateRoi();
                    double angleyz = Math.atan2(transfo.get(2, 1), transfo.get(2, 2));
                    double anglexz = Math.atan2(-transfo.get(2, 0), Math.sqrt(transfo.get(2, 1) * transfo.get(2, 1) + transfo.get(2, 2) * transfo.get(2, 2)));
                    double anglexy = Math.atan2(transfo.get(1, 0), transfo.get(0, 0));
                    angleyz = (double)Math.round(Math.toDegrees(angleyz) * 1000.0) / 1000.0;
                    anglexz = (double)Math.round(Math.toDegrees(anglexz) * 1000.0) / 1000.0;
                    anglexy = (double)Math.round(Math.toDegrees(anglexy) * 1000.0) / 1000.0;
                    double dxt = (double)Math.round(transfo.get(0, 3) * 1000.0) / 1000.0;
                    double dyt = (double)Math.round(transfo.get(1, 3) * 1000.0) / 1000.0;
                    double dzt = (double)Math.round(transfo.get(2, 3) * 1000.0) / 1000.0;
                    double scalexy = (double)Math.round(((SimilarityTransformation3D)newtransfo).getscalex() * 1000.0) / 1000.0;
                    double scalez = (double)Math.round(((SimilarityTransformation3D)newtransfo).getscalez() * 1000.0) / 1000.0;
                    System.out.println("Total computed Translation x: " + dxt + "  y:" + dyt + "z: " + dzt + " angle Oz: " + anglexy + " angle Oy: " + anglexz + " angle Ox: " + angleyz + " Scale xy (in physical unit): " + scalexy + " Scale z:  " + scalez);
                    new AnnounceFrame("Transformation Updated", 5);
                }
            } else {
                System.out.println("Instability: One more point");
                new AnnounceFrame("The position of the points does not allow a correct 3D transform. \n You need at least 2 points in separate z (slice). \n You may want to consider a 2D transform (it will still transform the full stack).");
            }
            if (this.monitor) {
                TargetRegistrationErrorMap ComputeFRE = new TargetRegistrationErrorMap();
                ComputeFRE.ReadFiducials((Sequence)this.target.getValue());
                double[] f = ComputeFRE.PreComputeTRE();
                double FLEmax = this.maxdifferrorinnm();
                System.out.println("Max localization error FLE estimated " + FLEmax + " nm");
                if (this.monitortargetonsource) {
                    Point2D.Double testPoint = new Point2D.Double(this.xtarget, this.ytarget);
                    lasttransfo.apply(testPoint);
                    this.xtarget = (int)((Point2D)testPoint).getX();
                    this.ytarget = (int)((Point2D)testPoint).getY();
                }
                double diameter = ComputeFRE.ComputeTRE(FLEmax, this.xtarget, this.ytarget, 0, f);
                this.listofNvalues.add(this.listofNvalues.size(), Double.valueOf(this.targetpoints.length));
                this.listoftrevalues.add(this.listoftrevalues.size(), diameter);
                double[][] TREValues = new double[this.listofNvalues.size()][2];
                for (int i = 0; i < this.listofNvalues.size(); ++i) {
                    TREValues[i][0] = this.listofNvalues.get(i);
                    TREValues[i][1] = this.listoftrevalues.get(i);
                    System.out.println("N=" + TREValues[i][0] + ", TRE=" + TREValues[i][1]);
                }
                MonitorTargetPoint.UpdatePoint(TREValues);
            }
        } else {
            System.out.println("One more point");
            if (this.mode3D) {
                new AnnounceFrame("No transformation will be computed with less than 4 points. You have placed " + this.fiducialsvector3D.size() + " points", 2);
            } else {
                new AnnounceFrame("No transformation will be computed with less than 3 points. You have placed " + this.fiducialsvector.size() + " points", 2);
            }
        }
        if (this.mode3D) {
            Icy.getMainInterface().setSelectedTool(ROI3DPointPlugin.class.getName());
        } else {
            Icy.getMainInterface().setSelectedTool(ROI2DPointPlugin.class.getName());
        }
        ((Sequence)this.source.getValue()).getFirstViewer().getLutViewer().setAutoBound(false);
    }

    private boolean testcoplanarity(Vector<PointsPair3D> fiducialsvector3d2) {
        boolean testsource = true;
        boolean testtarget = true;
        double zsource = fiducialsvector3d2.get((int)0).first.getZ();
        for (int i = 1; i < fiducialsvector3d2.size(); ++i) {
            PointsPair3D currentpair = fiducialsvector3d2.get(i);
            if (currentpair.first.getZ() == zsource) continue;
            testsource = false;
            break;
        }
        double ztarget = fiducialsvector3d2.get((int)0).second.getZ();
        for (int i = 1; i < fiducialsvector3d2.size(); ++i) {
            PointsPair3D currentpair = fiducialsvector3d2.get(i);
            if (currentpair.second.getZ() == ztarget) continue;
            testtarget = false;
            break;
        }
        return testsource || testtarget;
    }

    private void writeTransfo3D(SimilarityTransformation3D newtransfo, int order) {
        Matrix transfo = newtransfo.getMatrix();
        Document document = XMLUtil.loadDocument((File)this.XMLFile);
        Element transfoElement = XMLUtil.addElement((Node)document.getDocumentElement(), (String)"MatrixTransformation");
        XMLUtil.setAttributeIntValue((Element)transfoElement, (String)"order", (int)order);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m00", (double)transfo.get(0, 0));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m01", (double)transfo.get(0, 1));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m02", (double)transfo.get(0, 2));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m03", (double)transfo.get(0, 3));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m10", (double)transfo.get(1, 0));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m11", (double)transfo.get(1, 1));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m12", (double)transfo.get(1, 2));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m13", (double)transfo.get(1, 3));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m20", (double)transfo.get(2, 0));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m21", (double)transfo.get(2, 1));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m22", (double)transfo.get(2, 2));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m23", (double)transfo.get(2, 3));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m30", (double)0.0);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m31", (double)0.0);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m32", (double)0.0);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m33", (double)1.0);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"formerpixelsizeX", (double)newtransfo.getorisizex());
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"formerpixelsizeY", (double)newtransfo.getorisizey());
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"formerpixelsizeZ", (double)newtransfo.getorisizez());
        XMLUtil.setAttributeValue((Element)transfoElement, (String)"process_date", (String)new Date().toString());
        XMLUtil.saveDocument((Document)document, (File)this.XMLFile);
        System.out.println("Saved as" + this.XMLFile.getPath());
    }

    SimilarityTransformation3D getCombinedTransfo3D(Document document) {
        double orisizex = ((Sequence)this.source.getValue()).getPixelSizeX();
        double orisizey = ((Sequence)this.source.getValue()).getPixelSizeY();
        double orisizez = ((Sequence)this.source.getValue()).getPixelSizeZ();
        if (this.XMLFile == null) {
            System.out.println("XMLFile Not created yet, return identity");
            Matrix CombinedTransfo = Matrix.identity((int)4, (int)4);
            SimilarityTransformation3D resulttransfo = new SimilarityTransformation3D(CombinedTransfo, orisizex, orisizey, orisizez);
            return resulttransfo;
        }
        if (document == null) {
            System.out.println("XMLFile Not created yet, return identity");
            Matrix CombinedTransfo = Matrix.identity((int)4, (int)4);
            SimilarityTransformation3D resulttransfo = new SimilarityTransformation3D(CombinedTransfo, orisizex, orisizey, orisizez);
            return resulttransfo;
        }
        Element root = XMLUtil.getRootElement((Document)document);
        ArrayList transfoElementArrayList = XMLUtil.getElements((Node)root, (String)"MatrixTransformation");
        ArrayList<Matrix> listoftransfo = new ArrayList<Matrix>();
        boolean firsttime = true;
        for (Element transfoElement : transfoElementArrayList) {
            double[][] m = new double[4][4];
            if (firsttime) {
                orisizex = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"formerpixelsizeX", (double)0.0);
                orisizey = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"formerpixelsizeY", (double)0.0);
                orisizez = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"formerpixelsizeZ", (double)0.0);
                firsttime = false;
            }
            m[0][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m00", (double)0.0);
            m[0][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m01", (double)0.0);
            m[0][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m02", (double)0.0);
            m[0][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m03", (double)0.0);
            m[1][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m10", (double)0.0);
            m[1][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m11", (double)0.0);
            m[1][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m12", (double)0.0);
            m[1][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m13", (double)0.0);
            m[2][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m20", (double)0.0);
            m[2][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m21", (double)0.0);
            m[2][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m22", (double)0.0);
            m[2][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m23", (double)0.0);
            m[3][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m30", (double)0.0);
            m[3][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m31", (double)0.0);
            m[3][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m32", (double)0.0);
            m[3][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m33", (double)0.0);
            Matrix T = new Matrix(m);
            listoftransfo.add(T);
        }
        Matrix CombinedTransfo = Matrix.identity((int)4, (int)4);
        for (int i = 0; i < listoftransfo.size(); ++i) {
            CombinedTransfo = ((Matrix)listoftransfo.get(i)).times(CombinedTransfo);
        }
        SimilarityTransformation3D resulttransfo = new SimilarityTransformation3D(CombinedTransfo, orisizex, orisizey, orisizez);
        return resulttransfo;
    }

    void updateSourcePoints3D(SimilarityTransformation3D newtransfo) {
        for (int i = 0; i < this.sourcepoints.length; ++i) {
            PPPoint3D testPoint = new PPPoint3D(this.sourcepoints[i][0], this.sourcepoints[i][1], this.sourcepoints[i][2]);
            newtransfo.apply(testPoint);
            this.sourcepoints[i][0] = testPoint.getX() / ((Sequence)this.source.getValue()).getPixelSizeX();
            this.sourcepoints[i][1] = testPoint.getY() / ((Sequence)this.source.getValue()).getPixelSizeY();
            this.sourcepoints[i][2] = testPoint.getZ() / ((Sequence)this.source.getValue()).getPixelSizeZ();
        }
    }

    private void writeTransfo(Matrix transfo, int order) {
        Document document = XMLUtil.loadDocument((File)this.XMLFile);
        if (document == null) {
            MessageDialog.showDialog((String)("The document where to write the transfo could not be loaded:  \n " + this.XMLFile.getPath() + "\n Check if the source image was saved on disk first, /n and if you have writing rights on the directory mentionned above"), (int)3);
            return;
        }
        Element transfoElement = XMLUtil.addElement((Node)document.getDocumentElement(), (String)"MatrixTransformation");
        XMLUtil.setAttributeIntValue((Element)transfoElement, (String)"order", (int)order);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m00", (double)transfo.get(0, 0));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m01", (double)transfo.get(0, 1));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m02", (double)transfo.get(0, 2));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m03", (double)transfo.get(0, 3));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m10", (double)transfo.get(1, 0));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m11", (double)transfo.get(1, 1));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m12", (double)transfo.get(1, 2));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m13", (double)transfo.get(1, 3));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m20", (double)transfo.get(2, 0));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m21", (double)transfo.get(2, 1));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m22", (double)transfo.get(2, 2));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m23", (double)transfo.get(2, 3));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m30", (double)0.0);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m31", (double)0.0);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m32", (double)0.0);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m33", (double)1.0);
        XMLUtil.setAttributeValue((Element)transfoElement, (String)"process_date", (String)new Date().toString());
        XMLUtil.saveDocument((Document)document, (File)this.XMLFile);
        System.out.println("Transformation matrix as been saved as " + this.XMLFile.getPath());
        System.out.println("If there is no path indicated, it means it is in your ICY installation path");
    }

    private void updateSourcePoints2D(SimilarityTransformation2D newtransfo) {
        for (int i = 0; i < this.sourcepoints.length; ++i) {
            Point2D.Double testPoint = new Point2D.Double(this.sourcepoints[i][0], this.sourcepoints[i][1]);
            newtransfo.apply(testPoint);
            this.sourcepoints[i][0] = ((Point2D)testPoint).getX();
            this.sourcepoints[i][1] = ((Point2D)testPoint).getY();
        }
    }

    void updateRoi() {
        ArrayList listfiducials = ((Sequence)this.source.getValue()).getROIs();
        this.ReOrder(listfiducials);
        int i = -1;
        for (ROI roi : listfiducials) {
            Point5D position = roi.getPosition5D();
            position.setX(this.sourcepoints[++i][0]);
            position.setY(this.sourcepoints[i][1]);
            position.setZ(this.sourcepoints[i][2]);
            roi.setPosition5D(position);
            System.out.println(roi.getName() + " " + this.sourcepoints[i][0] + " " + this.sourcepoints[i][1] + " " + this.sourcepoints[i][2]);
        }
    }

    public void clean() {
    }

    public void sequenceChanged(SequenceEvent event) {
        if (!this.stopFlag) {
            if (event.getSequence() == this.target.getValue() && event.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_ROI && event.getType() == SequenceEvent.SequenceEventType.ADDED) {
                ((Sequence)this.target.getValue()).removeListener((SequenceListener)this);
                this.flagReadyToMove = false;
                double z = ((Sequence)this.target.getValue()).getFirstViewer().getPositionZ();
                ROI roi = (ROI)event.getSource();
                Point5D pos = roi.getPosition5D();
                pos.setZ(z);
                roi.setPosition5D(pos);
                int colornb = (int)Math.round(Math.random() * (double)this.Colortab.length);
                if (colornb > 8) {
                    colornb = 8;
                }
                System.out.println("Selected color" + colornb);
                roi.setColor(this.Colortab[colornb]);
                roi.setName("Point " + ((Sequence)this.target.getValue()).getROIs().size());
                ROI roisource = roi.getCopy();
                if (this.source.getValue() == null) {
                    new AnnounceFrame("You've closed the source image");
                    return;
                }
                int zs = ((Sequence)this.source.getValue()).getFirstViewer().getPositionZ();
                Point5D pos2 = roisource.getPosition5D();
                pos2.setZ((double)zs);
                roisource.setPosition5D(pos2);
                if (((Sequence)this.source.getValue()).getWidth() != ((Sequence)this.target.getValue()).getWidth() || ((Sequence)this.source.getValue()).getHeight() != ((Sequence)this.target.getValue()).getHeight()) {
                    Point5D position = (Point5D)pos.clone();
                    position.setLocation((double)(((Sequence)this.source.getValue()).getWidth() / 2), (double)(((Sequence)this.source.getValue()).getHeight() / 2), (double)((Sequence)this.source.getValue()).getFirstViewer().getPositionZ(), (double)((Sequence)this.source.getValue()).getFirstViewer().getPositionT(), pos.getC());
                    roisource.setPosition5D(position);
                }
                System.out.println("Adding Roi Landmark " + ((Sequence)this.target.getValue()).getROIs().size() + " on source");
                roisource.setName("Point " + ((Sequence)this.target.getValue()).getROIs().size());
                ((Sequence)this.source.getValue()).removeListener((SequenceListener)this);
                ((Sequence)this.source.getValue()).addROI(roisource);
                roisource.setStroke(9.0);
                roisource.setFocused(false);
                this.flagReadyToMove = true;
                this.done = false;
                ((Sequence)this.source.getValue()).addListener((SequenceListener)this);
            }
            if (this.flagReadyToMove && event.getSequence() == this.source.getValue() && event.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_ROI && event.getType() == SequenceEvent.SequenceEventType.CHANGED) {
                boolean test = ((ROI)event.getSource()).isSelected() || ((ROI)event.getSource()).isFocused();
                ThreadUtil.sleep((int)10);
                if (test) {
                    ThreadUtil.sleep((int)1);
                } else {
                    ((Sequence)this.target.getValue()).addListener((SequenceListener)this);
                    ((Sequence)this.source.getValue()).removeListener((SequenceListener)this);
                    if (!this.done) {
                        ThreadUtil.bgRunSingle((Runnable)this.transformer);
                        this.done = true;
                    }
                }
            }
        }
    }

    public void sequenceClosed(Sequence sequence) {
    }

    public Matrix getCombinedTransfo(Document document) {
        ArrayList transfoElementArrayList;
        if (this.XMLFile == null) {
            System.out.println("XMLFile Not created yet, return identity");
            return Matrix.identity((int)4, (int)4);
        }
        if (document == null) {
            System.out.println("XMLFile Not created yet, return identity");
            return Matrix.identity((int)4, (int)4);
        }
        Element root = XMLUtil.getRootElement((Document)document);
        if (root == null) {
            new AnnounceFrame("Could not find " + this.XMLFile.getName() + ". Check the CONSOLE output.", 5);
            System.out.println("The file " + this.XMLFile.getName() + "was not found , check that you have writing right in the directory");
            System.out.println("If no directory for this file is indicated, check that you have writing rights to the ICY directory (ex: C:/ICY)");
            System.out.println("Reminder: as indicated on ICY download webpage, ICY should not be copy under the Program files directory");
        }
        if ((transfoElementArrayList = XMLUtil.getElements((Node)root, (String)"MatrixTransformation")) == null) {
            new AnnounceFrame("You have likely chosen a wrong file, it should be suffixed with _transfo.xml, not only .xml", 5);
        }
        ArrayList<Matrix> listoftransfo = new ArrayList<Matrix>();
        for (Element transfoElement : transfoElementArrayList) {
            double[][] m = new double[4][4];
            m[0][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m00", (double)0.0);
            m[0][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m01", (double)0.0);
            m[0][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m02", (double)0.0);
            m[0][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m03", (double)0.0);
            m[1][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m10", (double)0.0);
            m[1][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m11", (double)0.0);
            m[1][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m12", (double)0.0);
            m[1][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m13", (double)0.0);
            m[2][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m20", (double)0.0);
            m[2][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m21", (double)0.0);
            m[2][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m22", (double)0.0);
            m[2][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m23", (double)0.0);
            m[3][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m30", (double)0.0);
            m[3][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m31", (double)0.0);
            m[3][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m32", (double)0.0);
            m[3][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m33", (double)0.0);
            Matrix T = new Matrix(m);
            listoftransfo.add(T);
        }
        Matrix CombinedTransfo = Matrix.identity((int)4, (int)4);
        for (int i = 0; i < listoftransfo.size(); ++i) {
            CombinedTransfo = ((Matrix)listoftransfo.get(i)).times(CombinedTransfo);
        }
        return CombinedTransfo;
    }

    public void stopExecution() {
        this.stopFlag = true;
        try {
            Object combinedtransfobefore;
            this.choiceinputsection.setEnabled(true);
            this.rigidspecificbutton.reshowspecificrigidbutton();
            Document document = XMLUtil.loadDocument((File)this.XMLFile);
            if (!this.mode3D && !this.nonrigid) {
                combinedtransfobefore = this.getCombinedTransfo(document);
                System.out.println("Here is transformation resulting from combined operation (between Play and Stop):");
                combinedtransfobefore.print(3, 2);
                double scale_x = Math.sqrt(Math.pow(combinedtransfobefore.get(0, 0), 2.0) + Math.pow(combinedtransfobefore.get(0, 1), 2.0));
                System.out.println("Estimated Scaling :" + (double)Math.round(scale_x * 100.0) / 100.0);
            }
            if (this.mode3D && !this.nonrigid) {
                combinedtransfobefore = this.getCombinedTransfo3D(document);
                System.out.println("Here is transformation resulting from combined operation (between Play and Stop):");
                ((SimilarityTransformation3D)combinedtransfobefore).getMatrix().print(3, 2);
            }
            if (this.source.getValue() != null) {
                ((Sequence)this.source.getValue()).removeListener((SequenceListener)this);
            }
            if (this.target.getValue() != null) {
                ((Sequence)this.target.getValue()).removeListener((SequenceListener)this);
            }
            ThreadUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (EasyCLEMv0.this.source.getValue() != null && EasyCLEMv0.this.target.getValue() != null) {
                        int c;
                        int c2;
                        Sequence Result1 = SequenceUtil.extractSlice((Sequence)((Sequence)EasyCLEMv0.this.source.getValue()), (int)((Sequence)EasyCLEMv0.this.source.getValue()).getFirstViewer().getPositionZ());
                        Result1 = SequenceUtil.extractFrame((Sequence)Result1, (int)((Sequence)EasyCLEMv0.this.source.getValue()).getFirstViewer().getPositionT());
                        LUT sourcelut = ((Sequence)EasyCLEMv0.this.source.getValue()).getFirstViewer().getLut();
                        int sourcenchannel = ((Sequence)EasyCLEMv0.this.source.getValue()).getSizeC();
                        LUT targetlut = ((Sequence)EasyCLEMv0.this.target.getValue()).getFirstViewer().getLut();
                        int targetnchannel = ((Sequence)EasyCLEMv0.this.target.getValue()).getSizeC();
                        Sequence Result2 = null;
                        Result2 = ((Sequence)EasyCLEMv0.this.target.getValue()).getSizeZ() >= ((Sequence)EasyCLEMv0.this.source.getValue()).getSizeZ() ? SequenceUtil.extractSlice((Sequence)((Sequence)EasyCLEMv0.this.target.getValue()), (int)((Sequence)EasyCLEMv0.this.source.getValue()).getFirstViewer().getPositionZ()) : SequenceUtil.extractSlice((Sequence)((Sequence)EasyCLEMv0.this.target.getValue()), (int)((Sequence)EasyCLEMv0.this.target.getValue()).getFirstViewer().getPositionZ());
                        Result2 = SequenceUtil.extractFrame((Sequence)Result2, (int)((Sequence)EasyCLEMv0.this.target.getValue()).getFirstViewer().getPositionT());
                        Result2.dataChanged();
                        try {
                            if (Result1.getDataType_() != Result2.getDataType_()) {
                                Result2 = SequenceUtil.convertToType((Sequence)Result2, (DataType)Result1.getDataType_(), (boolean)true);
                            }
                            Result2.dataChanged();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        Sequence[] sequences = new Sequence[Result1.getSizeC() + Result2.getSizeC()];
                        try {
                            for (c2 = 0; c2 < Result1.getSizeC(); ++c2) {
                                sequences[c2] = SequenceUtil.extractChannel((Sequence)Result1, (int)c2);
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        try {
                            for (c2 = Result1.getSizeC(); c2 < Result1.getSizeC() + Result2.getSizeC(); ++c2) {
                                sequences[c2] = SequenceUtil.extractChannel((Sequence)Result2, (int)(c2 - Result1.getSizeC()));
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        boolean fillEmpty = false;
                        boolean rescale = false;
                        int[] channels = new int[sequences.length];
                        Sequence Result = SequenceUtil.concatC((Sequence[])sequences, (int[])channels, (boolean)fillEmpty, (boolean)rescale, null);
                        Viewer vout = new Viewer(Result);
                        Result.setName("Overlayed");
                        for (c = 0; c < sourcenchannel; ++c) {
                            vout.getLut().getLutChannel(c).getColorMap().copyFrom(sourcelut.getLutChannel(c).getColorMap());
                        }
                        for (c = 0; c < targetnchannel; ++c) {
                            vout.getLut().getLutChannel(sourcenchannel + c).getColorMap().copyFrom(targetlut.getLutChannel(c).getColorMap());
                        }
                        if (EasyCLEMv0.this.mode3D) {
                            new AnnounceFrame("Only the current z have been overlayed. Use the Merge Channel option if you want to create an overlay of the full stacks", 5);
                        } else {
                            new AnnounceFrame("The current views of both source and target image have been overlayed. Save it if you want to keep it. No further transform was done", 5);
                        }
                        ((Sequence)EasyCLEMv0.this.source.getValue()).removeOverlay(EasyCLEMv0.this.myoverlaysource);
                        ((Sequence)EasyCLEMv0.this.source.getValue()).removeOverlay(EasyCLEMv0.this.messageSource);
                        ((Sequence)EasyCLEMv0.this.target.getValue()).removeOverlay(EasyCLEMv0.this.myoverlaytarget);
                        ((Sequence)EasyCLEMv0.this.target.getValue()).removeOverlay(EasyCLEMv0.this.messageTarget);
                        ((Sequence)EasyCLEMv0.this.source.getValue()).removeOverlay(EasyCLEMv0.this.myoverlayerror);
                        ((Sequence)EasyCLEMv0.this.source.getValue()).removeOverlay(EasyCLEMv0.this.myoverlaypredictederror);
                        EasyCLEMv0.this.checknonRigid();
                    }
                }
            });
        }
        catch (Exception e) {
            System.out.println("byebye");
        }
    }

    private void checknonRigid() {
        if (!this.nonrigid && this.sourcepoints != null) {
            boolean needed = this.CheckTREvsFRE();
            if (needed) {
                if (this.sourcepoints.length > 4) {
                    MessageDialog.showDialog((String)" Based on the discrepancy between observed error and predicted error, \n computed from the landmark configuration you have used,\n Either this image DOES require deformable registration, Either at least one landmark is (really) badly placed.\n You can use the \"show difference in position\" to detect it. \n Check the position of your landmarks pair,\n select \"Non Rigid Correction\" in the list of transform, \n and click on update transform", (int)3);
                }
            } else if (this.sourcepoints.length > 4) {
                MessageDialog.showDialog((String)"Apparently this image does not required deformable registration, at least in the area where points where placed \n if you want to reach a better accuracy in the alignment, add more points.", (int)3);
            }
        }
    }

    public double maxdifferrorinnm() {
        if (this.sourcepoints == null) {
            System.err.println("Please initialize EasyClem first by pressing the Play button");
            return 0.0;
        }
        if (this.sourcepoints.length < 5) {
            double error = Math.max(((Sequence)this.source.getValue()).getPixelSizeX(), ((Sequence)this.target.getValue()).getPixelSizeX());
            error = 20.0 * error * 1000.0;
            error = Math.max(200.0, error);
            error = Math.min(1000.0, error);
            return error;
        }
        double error = 200.0;
        if (this.sourcepoints != null && this.targetpoints.length == this.sourcepoints.length) {
            if (!this.mode3D) {
                this.fiducialsvector = this.createVectorfromdoublearray(this.sourcepoints, this.targetpoints);
                double newerror = 0.0;
                for (int index = 0; index < this.fiducialsvector.size(); ++index) {
                    newerror += this.fiducialsvector.get(index).getDiffinpixels() * ((Sequence)this.source.getValue()).getPixelSizeX() * 1000.0;
                }
                if ((newerror /= (double)this.fiducialsvector.size()) > error) {
                    error = newerror;
                }
            } else {
                this.fiducialsvector3D = this.createVectorfromdoublearray3D(this.sourcepoints, this.targetpoints);
                double newerror = 0.0;
                for (int index = 0; index < this.fiducialsvector3D.size(); ++index) {
                    newerror = Math.sqrt(this.fiducialsvector3D.get(index).getDiffx_squared_inpixels() * ((Sequence)this.source.getValue()).getPixelSizeX() * 1000.0 + this.fiducialsvector3D.get(index).getDiffy_squared_inpixels() * ((Sequence)this.source.getValue()).getPixelSizeY() * 1000.0 + this.fiducialsvector3D.get(index).getDiffz_squared_inpixels() * ((Sequence)this.source.getValue()).getPixelSizeZ() * 1000.0);
                }
                if ((newerror /= (double)this.fiducialsvector3D.size()) > error) {
                    error = newerror;
                }
            }
        }
        return error;
    }

    private boolean CheckTREvsFRE() {
        boolean check;
        block4: {
            check = false;
            double error = 0.0;
            double predictederror = 0.0;
            double FLEmax = this.maxdifferrorinnm();
            System.out.println("Max localization error FLE estimated " + FLEmax + " nm");
            TargetRegistrationErrorMap ComputeFRE = new TargetRegistrationErrorMap();
            ComputeFRE.ReadFiducials((Sequence)this.target.getValue());
            double[] f = ComputeFRE.PreComputeTRE();
            this.GetSourcePointsfromROI();
            this.GetTargetPointsfromROI();
            if (this.sourcepoints == null && this.targetpoints == null || this.targetpoints.length != this.sourcepoints.length) break block4;
            if (!this.mode3D) {
                ArrayList listfiducials = ((Sequence)this.source.getValue()).getROIs();
                this.ReOrder(listfiducials);
                this.fiducialsvector = this.createVectorfromdoublearray(this.sourcepoints, this.targetpoints);
                for (int index = 0; index < this.fiducialsvector.size(); ++index) {
                    error = this.fiducialsvector.get(index).getDiffinpixels();
                    String name = ((ROI)listfiducials.get(index)).getName();
                    error = error * ((Sequence)this.source.getValue()).getPixelSizeX() * 1000.0;
                    predictederror = ComputeFRE.ComputeTRE(FLEmax, (int)this.fiducialsvector.get((int)index).first.getX(), (int)this.fiducialsvector.get((int)index).first.getY(), 0, f);
                    System.out.println(name + " Discrepancy in nm: " + error + "vs Predicted error in nm: " + predictederror);
                    if (!(error > predictederror)) continue;
                    check = true;
                }
            } else {
                this.fiducialsvector3D = this.createVectorfromdoublearray3D(this.sourcepoints, this.targetpoints);
                for (int index = 0; index < this.fiducialsvector3D.size(); ++index) {
                    error = Math.sqrt(Math.pow((this.fiducialsvector3D.get(index).getfirstxinpixels() - this.fiducialsvector3D.get(index).getsecondxinpixels()) * ((Sequence)this.source.getValue()).getPixelSizeX(), 2.0) + Math.pow((this.fiducialsvector3D.get(index).getfirstyinpixels() - this.fiducialsvector3D.get(index).getsecondyinpixels()) * ((Sequence)this.source.getValue()).getPixelSizeY(), 2.0) + Math.pow((this.fiducialsvector3D.get(index).getfirstzinpixels() - this.fiducialsvector3D.get(index).getsecondzinpixels()) * ((Sequence)this.source.getValue()).getPixelSizeZ(), 2.0));
                    predictederror = ComputeFRE.ComputeTRE(FLEmax, (int)this.fiducialsvector3D.get(index).getfirstxinpixels(), (int)this.fiducialsvector3D.get(index).getfirstyinpixels(), (int)this.fiducialsvector3D.get(index).getfirstzinpixels(), f);
                    System.out.println("Point " + (index + 1) + "Discrepancy in nm: " + (error *= 1000.0) + "vs Predicted error in nm: " + predictederror);
                    if (!(error > predictederror)) continue;
                    check = true;
                }
            }
        }
        return check;
    }

    public static void main(String[] args) {
        Icy.main((String[])args);
        PluginLauncher.start((PluginDescriptor)PluginLoader.getPlugin((String)EasyCLEMv0.class.getName()));
    }

    private class MessageOverlay
    extends Overlay {
        String mytext;

        public MessageOverlay(String text) {
            super("Message");
            this.mytext = text;
        }

        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D && g != null) {
                g.setColor(Color.RED);
                g.setStroke(new BasicStroke(5.0f));
                Font f = g.getFont();
                f = FontUtil.setName((Font)f, (String)"Arial");
                f = FontUtil.setSize((Font)f, (int)((int)canvas.canvasToImageLogDeltaX(20)));
                g.setFont(f);
                g.drawString(this.mytext, 10, (int)canvas.canvasToImageLogDeltaX(50));
            }
        }
    }

    private class PredictedErrorinPositionOverlay
    extends Overlay {
        public PredictedErrorinPositionOverlay() {
            super("Predicted Error from point configuration");
        }

        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D && g != null) {
                TargetRegistrationErrorMap ComputeFRE = new TargetRegistrationErrorMap();
                ComputeFRE.ReadFiducials(sequence);
                double xsource = sequence.getPixelSizeX();
                double[] f = ComputeFRE.PreComputeTRE();
                ArrayList listfiducials = sequence.getROIs();
                for (ROI roi : listfiducials) {
                    Point5D p3D = null;
                    try {
                        p3D = ROIMassCenterDescriptorsPlugin.computeMassCenter((ROI)roi);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (Double.isNaN(p3D.getX())) {
                        p3D = roi.getPosition5D();
                    }
                    int x = (int)Math.round(p3D.getX());
                    int y = (int)Math.round(p3D.getY());
                    g.setColor(Color.ORANGE);
                    g.setStroke(new BasicStroke(5.0f));
                    double FLEmax = EasyCLEMv0.this.maxdifferrorinnm();
                    double diameter = ComputeFRE.ComputeTRE(FLEmax, x, y, 0, f);
                    diameter = diameter * 2.0 / (1000.0 * xsource);
                    x = (int)Math.round(p3D.getX() - diameter / 2.0);
                    y = (int)Math.round(p3D.getY() - diameter / 2.0);
                    g.drawOval(x, y, (int)Math.round(diameter), (int)Math.round(diameter));
                }
            }
        }
    }

    private class ErrorinPositionOverlay
    extends Overlay {
        public ErrorinPositionOverlay() {
            super("Difference in position");
        }

        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            block4: {
                if (!(canvas instanceof IcyCanvas2D) || g == null || EasyCLEMv0.this.sourcepoints == null && EasyCLEMv0.this.targetpoints == null) break block4;
                if (!EasyCLEMv0.this.mode3D) {
                    EasyCLEMv0.this.fiducialsvector = EasyCLEMv0.this.createVectorfromdoublearray(EasyCLEMv0.this.sourcepoints, EasyCLEMv0.this.targetpoints);
                    for (int index = 0; index < EasyCLEMv0.this.fiducialsvector.size(); ++index) {
                        g.setStroke(new BasicStroke((int)canvas.canvasToImageLogDeltaX(5)));
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g.setColor(Color.RED);
                        double error = EasyCLEMv0.this.fiducialsvector.get(index).getDiffinpixels();
                        double l = error / 4.0;
                        double w = 3.0;
                        EasyCLEMv0.this.plotarrow(EasyCLEMv0.this.fiducialsvector.get(index).getfirstxinpixels(), EasyCLEMv0.this.fiducialsvector.get(index).getfirstyinpixels(), EasyCLEMv0.this.fiducialsvector.get(index).getsecondxinpixels(), EasyCLEMv0.this.fiducialsvector.get(index).getsecondyinpixels(), l, w, g);
                    }
                } else {
                    EasyCLEMv0.this.fiducialsvector3D = EasyCLEMv0.this.createVectorfromdoublearray3D(EasyCLEMv0.this.sourcepoints, EasyCLEMv0.this.targetpoints);
                    for (int index = 0; index < EasyCLEMv0.this.fiducialsvector3D.size(); ++index) {
                        g.setColor(Color.RED);
                        double error = EasyCLEMv0.this.fiducialsvector3D.get(index).getDiffinpixels();
                        g.drawOval((int)Math.round(EasyCLEMv0.this.fiducialsvector3D.get((int)index).first.getX() - error), (int)Math.round(EasyCLEMv0.this.fiducialsvector3D.get((int)index).first.getY() - error), (int)Math.round(error * 2.0), (int)Math.round(error * 2.0));
                    }
                }
            }
        }
    }

    private class VisiblepointsOverlay
    extends Overlay {
        public VisiblepointsOverlay() {
            super("Visible points");
        }

        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D && g != null) {
                ArrayList listfiducials = sequence.getROIs();
                for (ROI roi : listfiducials) {
                    Point5D p3D = null;
                    try {
                        p3D = ROIMassCenterDescriptorsPlugin.computeMassCenter((ROI)roi);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (Double.isNaN(p3D.getX())) {
                        p3D = roi.getPosition5D();
                    }
                    g.setColor(Color.BLACK);
                    g.setStroke(new BasicStroke(5.0f));
                    Font f = g.getFont();
                    f = FontUtil.setName((Font)f, (String)"Arial");
                    f = FontUtil.setSize((Font)f, (int)((int)canvas.canvasToImageLogDeltaX(20)));
                    g.setFont(f);
                    g.drawString(roi.getName(), (float)p3D.getX(), (float)p3D.getY());
                    g.setColor(Color.YELLOW);
                    g.drawString(roi.getName(), (float)p3D.getX() + 1.0f, (float)p3D.getY() + 1.0f);
                }
            }
        }
    }
}

