/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.easyclemv0;

import Jama.Matrix;
import com.google.common.io.Files;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.AnnounceFrame;
import icy.main.Icy;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.point.Point5D;
import icy.util.XMLUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.kernel.roi.roi2d.plugin.ROI2DPointPlugin;
import plugins.perrine.easyclemv0.EasyCLEMv0;
import plugins.perrine.easyclemv0.ImageTransformer;
import plugins.perrine.easyclemv0.NonRigidTranformationVTK;
import plugins.perrine.easyclemv0.SimilarityTransformation3D;
import plugins.perrine.easyclemv0.Stack3DVTKTransformer;

public class GuiCLEMButtons
extends JPanel {
    private static final long serialVersionUID = 1L;
    EasyCLEMv0 matiteclasse;

    public GuiCLEMButtons(EasyCLEMv0 matiteclasse) {
        this.matiteclasse = matiteclasse;
        JButton btnNewButton = new JButton("Update Transformation");
        btnNewButton.setToolTipText("Press this button if you have moved the points, prepared set of points, \n or obtained some black part of the image. This will refresh it");
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (GuiCLEMButtons.this.matiteclasse.source.getValue() == null || GuiCLEMButtons.this.matiteclasse.target.getValue() == null) {
                    MessageDialog.showDialog((String)"Make sure source and target image are openned and selected");
                    return;
                }
                GuiCLEMButtons.this.matiteclasse.GetSourcePointsfromROI();
                GuiCLEMButtons.this.matiteclasse.GetTargetPointsfromROI();
                if (GuiCLEMButtons.this.matiteclasse.sourcepoints.length != GuiCLEMButtons.this.matiteclasse.targetpoints.length) {
                    ArrayList listroi = ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).getROIs();
                    for (ROI roi : listroi) {
                        if (!roi.getName().contains("Point2D")) continue;
                        ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).removeROI(roi);
                    }
                    listroi = ((Sequence)GuiCLEMButtons.this.matiteclasse.target.getValue()).getROIs();
                    for (ROI roi : listroi) {
                        if (!roi.getName().contains("Point2D")) continue;
                        ((Sequence)GuiCLEMButtons.this.matiteclasse.target.getValue()).removeROI(roi);
                    }
                    new AnnounceFrame("Warning: not the same number of point on both image. Nothing done", 5);
                    Icy.getMainInterface().setSelectedTool(ROI2DPointPlugin.class.getName());
                } else if (!GuiCLEMButtons.this.matiteclasse.nonrigid) {
                    if (GuiCLEMButtons.this.matiteclasse.sourcepoints.length == 0) {
                        MessageDialog.showDialog((String)"No Roi on source image. Create ROI");
                        return;
                    }
                    if (GuiCLEMButtons.this.matiteclasse.targetpoints.length == 0) {
                        MessageDialog.showDialog((String)"No Roi on target image. Create ROIs");
                        return;
                    }
                    if (!GuiCLEMButtons.this.matiteclasse.mode3D) {
                        GuiCLEMButtons.this.matiteclasse.fiducialsvector = GuiCLEMButtons.this.matiteclasse.createVectorfromdoublearray(GuiCLEMButtons.this.matiteclasse.sourcepoints, GuiCLEMButtons.this.matiteclasse.targetpoints);
                        GuiCLEMButtons.this.matiteclasse.fiducialsvector3D = new Vector();
                    } else {
                        GuiCLEMButtons.this.matiteclasse.fiducialsvector3D = GuiCLEMButtons.this.matiteclasse.createVectorfromdoublearray3D(GuiCLEMButtons.this.matiteclasse.sourcepoints, GuiCLEMButtons.this.matiteclasse.targetpoints);
                        GuiCLEMButtons.this.matiteclasse.fiducialsvector = new Vector();
                    }
                    ThreadUtil.bgRun((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            GuiCLEMButtons.this.matiteclasse.ComputeTransfo();
                        }
                    });
                } else {
                    ThreadUtil.bgRun((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            NonRigidTranformationVTK nrtransfo = new NonRigidTranformationVTK();
                            nrtransfo.setImageSourceandpoints(GuiCLEMButtons.this.matiteclasse.checkgrid, (Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue(), GuiCLEMButtons.this.matiteclasse.sourcepoints);
                            nrtransfo.setImageTargetandpoints((Sequence)GuiCLEMButtons.this.matiteclasse.target.getValue(), GuiCLEMButtons.this.matiteclasse.targetpoints);
                            nrtransfo.run();
                            GuiCLEMButtons.this.matiteclasse.updateRoi();
                        }
                    });
                }
            }
        });
        JButton btnNewButton2 = new JButton("Clear all landmarks points");
        btnNewButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (GuiCLEMButtons.this.matiteclasse.source.getValue() == null || GuiCLEMButtons.this.matiteclasse.target.getValue() == null) {
                    MessageDialog.showDialog((String)"Make sure source and target image are openned and selected");
                    return;
                }
                new AnnounceFrame("All ROIs have been deleted from images " + ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).getName() + " and " + ((Sequence)GuiCLEMButtons.this.matiteclasse.target.getValue()).getName(), 5);
                this.saveROI((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue());
                this.deleteROI((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue());
                this.saveROI((Sequence)GuiCLEMButtons.this.matiteclasse.target.getValue());
                this.deleteROI((Sequence)GuiCLEMButtons.this.matiteclasse.target.getValue());
            }

            private void saveROI(Sequence value) {
                Document doc;
                ArrayList rois = value.getROIs();
                if (rois.size() > 0 && (doc = XMLUtil.createDocument((boolean)true)) != null) {
                    ROI.saveROIsToXML((Node)XMLUtil.getRootElement((Document)doc), (List)rois);
                    System.out.println("ROIS saved before in " + value.getFilename() + "_ROIsavedBeforeClearLandmarks.xml\n Use Load Roi(s) if needed in ROI top menu");
                    XMLUtil.saveDocument((Document)doc, (String)(value.getFilename() + "_ROIsavedBeforeClearLandmarks.xml"));
                }
            }

            private void deleteROI(Sequence value) {
                value.removeAllROI(true);
            }
        });
        JButton btnButtonUndo = new JButton("Undo last point");
        btnButtonUndo.setToolTipText("Press this button to cancel the last point edition you have done, it will reverse to the previous state of your image");
        btnButtonUndo.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (GuiCLEMButtons.this.matiteclasse.source.getValue() == null || GuiCLEMButtons.this.matiteclasse.target.getValue() == null) {
                    MessageDialog.showDialog((String)"Make sure source and target image are openned and selected");
                    return;
                }
                boolean sorted = true;
                List listRoisource = ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).getROIs(sorted);
                if (!GuiCLEMButtons.this.matiteclasse.mode3D && listRoisource.size() > 2 || GuiCLEMButtons.this.matiteclasse.mode3D && listRoisource.size() > 3) {
                    Matrix backto_ori;
                    Matrix correctedtransfo;
                    List listRoitarget = ((Sequence)GuiCLEMButtons.this.matiteclasse.target.getValue()).getROIs(sorted);
                    ROI roitoremove = (ROI)listRoisource.get(listRoisource.size() - 1);
                    roitoremove.remove();
                    if (listRoitarget.size() >= listRoisource.size()) {
                        ROI roitoremovet = (ROI)listRoitarget.get(listRoisource.size() - 1);
                        roitoremovet.remove();
                    }
                    Document document = XMLUtil.loadDocument((File)GuiCLEMButtons.this.matiteclasse.XMLFile);
                    double orisizex = ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).getPixelSizeX();
                    double orisizey = ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).getPixelSizeY();
                    double orisizez = ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).getPixelSizeZ();
                    ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).beginUpdate();
                    ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).removeAllImages();
                    if (GuiCLEMButtons.this.matiteclasse.backupsource == null) {
                        MessageDialog.showDialog((String)"Argh.");
                        return;
                    }
                    try {
                        for (int t = 0; t < GuiCLEMButtons.this.matiteclasse.backupsource.getSizeT(); ++t) {
                            for (int z = 0; z < GuiCLEMButtons.this.matiteclasse.backupsource.getSizeZ(); ++z) {
                                ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).setImage(t, z, (BufferedImage)GuiCLEMButtons.this.matiteclasse.backupsource.getImage(t, z));
                            }
                        }
                    }
                    finally {
                        ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).endUpdate();
                    }
                    if (!GuiCLEMButtons.this.matiteclasse.mode3D) {
                        correctedtransfo = GuiCLEMButtons.this.matiteclasse.getCombinedTransfo(document);
                        backto_ori = correctedtransfo.inverse();
                        GuiCLEMButtons.this.updatemyRoi2Dposition(listRoisource, backto_ori);
                    } else {
                        correctedtransfo = GuiCLEMButtons.this.matiteclasse.getCombinedTransfo3D(document).getMatrix();
                        backto_ori = correctedtransfo.inverse();
                        SimilarityTransformation3D reversetransfo = new SimilarityTransformation3D(backto_ori, orisizex, orisizey, orisizez);
                        ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).setPixelSizeX(GuiCLEMButtons.this.matiteclasse.bucalibx);
                        ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).setPixelSizeY(GuiCLEMButtons.this.matiteclasse.bucaliby);
                        ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).setPixelSizeZ(GuiCLEMButtons.this.matiteclasse.bucalibz);
                        GuiCLEMButtons.this.matiteclasse.updateSourcePoints3D(reversetransfo);
                        GuiCLEMButtons.this.matiteclasse.updateRoi();
                    }
                    Element root = XMLUtil.getRootElement((Document)document);
                    ArrayList transfoElementArrayList = XMLUtil.getElements((Node)root, (String)"MatrixTransformation");
                    int maxorder = 0;
                    int order = 0;
                    for (Element transfoElement : transfoElementArrayList) {
                        order = XMLUtil.getAttributeIntValue((Element)transfoElement, (String)"order", (int)0);
                        if (maxorder >= order) continue;
                        maxorder = order;
                    }
                    for (Element transfoElement : transfoElementArrayList) {
                        order = XMLUtil.getAttributeIntValue((Element)transfoElement, (String)"order", (int)0);
                        if (maxorder != order) continue;
                        Node parent = transfoElement.getParentNode();
                        parent.removeChild(transfoElement);
                        parent.normalize();
                    }
                    transfoElementArrayList = XMLUtil.getElements((Node)root, (String)"MatrixTransformation");
                    for (Element transfoElement : transfoElementArrayList) {
                        order = XMLUtil.getAttributeIntValue((Element)transfoElement, (String)"order", (int)0);
                    }
                    XMLUtil.saveDocument((Document)document, (File)GuiCLEMButtons.this.matiteclasse.XMLFile);
                    System.out.println("Saved as" + GuiCLEMButtons.this.matiteclasse.XMLFile.getPath());
                    Element newsizeelement = (Element)XMLUtil.getElements((Node)root, (String)"TargetSize").get(0);
                    int width = XMLUtil.getAttributeIntValue((Element)newsizeelement, (String)"width", (int)-1);
                    int height = XMLUtil.getAttributeIntValue((Element)newsizeelement, (String)"height", (int)-1);
                    int nbz = XMLUtil.getAttributeIntValue((Element)newsizeelement, (String)"nz", (int)-1);
                    Matrix CombinedTransfo = GuiCLEMButtons.this.matiteclasse.getCombinedTransfo(document);
                    if (nbz == -1) {
                        ImageTransformer mytransformer = new ImageTransformer();
                        mytransformer.setImageSource((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue());
                        mytransformer.setParameters(CombinedTransfo);
                        if (transfoElementArrayList.size() > 0) {
                            mytransformer.setDestinationsize(width, height);
                            mytransformer.run();
                            listRoisource = ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).getROIs(sorted);
                            GuiCLEMButtons.this.updatemyRoi2Dposition(listRoisource, CombinedTransfo);
                        } else {
                            ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).setPixelSizeX(GuiCLEMButtons.this.matiteclasse.bucalibx);
                            ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).setPixelSizeY(GuiCLEMButtons.this.matiteclasse.bucaliby);
                            ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).setPixelSizeZ(GuiCLEMButtons.this.matiteclasse.bucalibz);
                        }
                    } else {
                        SimilarityTransformation3D transfo = GuiCLEMButtons.this.matiteclasse.getCombinedTransfo3D(document);
                        if (transfoElementArrayList.size() > 0) {
                            double targetsx = XMLUtil.getAttributeDoubleValue((Element)newsizeelement, (String)"sx", (double)-1.0);
                            double targetsy = XMLUtil.getAttributeDoubleValue((Element)newsizeelement, (String)"sy", (double)-1.0);
                            double targetsz = XMLUtil.getAttributeDoubleValue((Element)newsizeelement, (String)"sz", (double)-1.0);
                            Matrix transfomat = transfo.getMatrix();
                            Stack3DVTKTransformer transfoimage3D = new Stack3DVTKTransformer();
                            transfoimage3D.setImageSource((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue(), transfo.getorisizex(), transfo.getorisizey(), transfo.getorisizez());
                            transfoimage3D.setDestinationsize(width, height, nbz, targetsx, targetsy, targetsz);
                            transfoimage3D.setParameters(transfomat, transfo.getscalex(), transfo.getscalez());
                            transfoimage3D.run();
                            GuiCLEMButtons.this.matiteclasse.updateSourcePoints3D(transfo);
                            GuiCLEMButtons.this.matiteclasse.updateRoi();
                        } else {
                            ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).setPixelSizeX(GuiCLEMButtons.this.matiteclasse.bucalibx);
                            ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).setPixelSizeY(GuiCLEMButtons.this.matiteclasse.bucaliby);
                            ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).setPixelSizeZ(GuiCLEMButtons.this.matiteclasse.bucalibz);
                        }
                    }
                } else {
                    new AnnounceFrame("Nothing to undo", 5);
                }
            }
        });
        JButton btnButtonshowPoints = new JButton("Show ROIs on original source image");
        btnButtonshowPoints.setToolTipText("Show the original source Image, with the points selected shown (save the source image to save the ROIs)");
        btnButtonshowPoints.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (GuiCLEMButtons.this.matiteclasse.source.getValue() == null || GuiCLEMButtons.this.matiteclasse.target.getValue() == null) {
                    MessageDialog.showDialog((String)"Make sure source and target image are openned and selected");
                    return;
                }
                boolean sorted = true;
                List listRoisource = ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).getROIs(sorted);
                if (!GuiCLEMButtons.this.matiteclasse.mode3D && listRoisource.size() > 2 || GuiCLEMButtons.this.matiteclasse.mode3D && listRoisource.size() > 3) {
                    Matrix backto_ori;
                    Matrix correctedtransfo;
                    Document document = XMLUtil.loadDocument((File)GuiCLEMButtons.this.matiteclasse.XMLFile);
                    double orisizex = ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).getPixelSizeX();
                    double orisizey = ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).getPixelSizeY();
                    double orisizez = ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).getPixelSizeZ();
                    ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).beginUpdate();
                    ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).removeAllImages();
                    if (GuiCLEMButtons.this.matiteclasse.backupsource == null) {
                        MessageDialog.showDialog((String)"argh.");
                        return;
                    }
                    try {
                        for (int t = 0; t < GuiCLEMButtons.this.matiteclasse.backupsource.getSizeT(); ++t) {
                            for (int z = 0; z < GuiCLEMButtons.this.matiteclasse.backupsource.getSizeZ(); ++z) {
                                ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).setImage(t, z, (BufferedImage)GuiCLEMButtons.this.matiteclasse.backupsource.getImage(t, z));
                            }
                        }
                    }
                    finally {
                        ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).endUpdate();
                    }
                    if (!GuiCLEMButtons.this.matiteclasse.mode3D) {
                        correctedtransfo = GuiCLEMButtons.this.matiteclasse.getCombinedTransfo(document);
                        backto_ori = correctedtransfo.inverse();
                        GuiCLEMButtons.this.updatemyRoi2Dposition(listRoisource, backto_ori);
                        ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).setPixelSizeX(GuiCLEMButtons.this.matiteclasse.bucalibx);
                        ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).setPixelSizeY(GuiCLEMButtons.this.matiteclasse.bucaliby);
                        ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).setPixelSizeZ(GuiCLEMButtons.this.matiteclasse.bucalibz);
                    } else {
                        correctedtransfo = GuiCLEMButtons.this.matiteclasse.getCombinedTransfo3D(document).getMatrix();
                        backto_ori = correctedtransfo.inverse();
                        SimilarityTransformation3D reversetransfo = new SimilarityTransformation3D(backto_ori, orisizex, orisizey, orisizez);
                        ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).setPixelSizeX(GuiCLEMButtons.this.matiteclasse.bucalibx);
                        ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).setPixelSizeY(GuiCLEMButtons.this.matiteclasse.bucaliby);
                        ((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue()).setPixelSizeZ(GuiCLEMButtons.this.matiteclasse.bucalibz);
                        GuiCLEMButtons.this.matiteclasse.updateSourcePoints3D(reversetransfo);
                        GuiCLEMButtons.this.matiteclasse.updateRoi();
                    }
                    File dest = new File(GuiCLEMButtons.this.matiteclasse.XMLFile.getPath() + "_" + LocalDateTime.now().getDayOfMonth() + "_" + LocalDateTime.now().getMonth() + "_" + LocalDateTime.now().getHour() + LocalDateTime.now().getMinute() + "_back-up.xml");
                    System.out.println("A back up of your transfo has been saved as" + GuiCLEMButtons.this.matiteclasse.XMLFile.getPath() + "_" + LocalDateTime.now().getDayOfMonth() + "_" + LocalDateTime.now().getMonth() + "_" + LocalDateTime.now().getHour() + LocalDateTime.now().getMinute() + "_back-up.xml");
                    try {
                        Files.copy((File)GuiCLEMButtons.this.matiteclasse.XMLFile, (File)dest);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    Document myXMLdoc = XMLUtil.createDocument((boolean)true);
                    Element transfoElement = XMLUtil.addElement((Node)myXMLdoc.getDocumentElement(), (String)"TargetSize");
                    XMLUtil.setAttributeIntValue((Element)transfoElement, (String)"width", (int)((Sequence)GuiCLEMButtons.this.matiteclasse.target.getValue()).getWidth());
                    XMLUtil.setAttributeIntValue((Element)transfoElement, (String)"height", (int)((Sequence)GuiCLEMButtons.this.matiteclasse.target.getValue()).getHeight());
                    if (GuiCLEMButtons.this.matiteclasse.mode3D) {
                        XMLUtil.setAttributeIntValue((Element)transfoElement, (String)"nz", (int)((Sequence)GuiCLEMButtons.this.matiteclasse.target.getValue()).getSizeZ());
                        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"sx", (double)((Sequence)GuiCLEMButtons.this.matiteclasse.target.getValue()).getPixelSizeX());
                        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"sy", (double)((Sequence)GuiCLEMButtons.this.matiteclasse.target.getValue()).getPixelSizeY());
                        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"sz", (double)((Sequence)GuiCLEMButtons.this.matiteclasse.target.getValue()).getPixelSizeZ());
                    }
                    XMLUtil.saveDocument((Document)myXMLdoc, (File)GuiCLEMButtons.this.matiteclasse.XMLFile);
                    System.out.println("Saved as" + GuiCLEMButtons.this.matiteclasse.XMLFile.getPath());
                    this.saveRois((Sequence)GuiCLEMButtons.this.matiteclasse.source.getValue());
                    this.saveRois((Sequence)GuiCLEMButtons.this.matiteclasse.target.getValue());
                }
            }

            private void saveRois(Sequence value) {
                Document doc;
                ArrayList rois = value.getROIs();
                if (rois.size() > 0 && (doc = XMLUtil.createDocument((boolean)true)) != null) {
                    ROI.saveROIsToXML((Node)XMLUtil.getRootElement((Document)doc), (List)rois);
                    System.out.println("ROIS saved before in " + value.getFilename() + "_ROIsavedwhenshowonoriginaldata.xml\n Use Load Roi(s) if needed in ROI top menu");
                    XMLUtil.saveDocument((Document)doc, (String)(value.getFilename() + "_ROIsavedwhenshowonoriginaldata.xml"));
                }
            }
        });
        this.add(btnNewButton);
        this.add(btnNewButton2);
        this.add(btnButtonUndo);
        this.add(btnButtonshowPoints);
    }

    protected void updatemyRoi2Dposition(List<ROI> listRoisource, Matrix matrixtobeapplied) {
        for (int i = 0; i < listRoisource.size(); ++i) {
            ROI roi = listRoisource.get(i);
            Point5D pnt = roi.getPosition5D();
            double newX = matrixtobeapplied.get(0, 3) + matrixtobeapplied.get(0, 0) * pnt.getX() + matrixtobeapplied.get(0, 1) * pnt.getY();
            double newY = matrixtobeapplied.get(1, 3) + matrixtobeapplied.get(1, 0) * pnt.getX() + matrixtobeapplied.get(1, 1) * pnt.getY();
            pnt.setX(newX);
            pnt.setY(newY);
            roi.setPosition5D(pnt);
        }
        this.matiteclasse.GetSourcePointsfromROI();
    }
}

