/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.easyclemv0;

import Jama.Matrix;
import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.math.Scaler;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.type.DataType;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class ImageTransformer
implements Runnable {
    AffineTransform transform = new AffineTransform();
    BufferedImage image;
    double[] matrix;
    private Sequence sequence;
    private BufferedImage imageDest;
    private DataType oriType;

    public void setImageSource(Sequence value) {
        this.sequence = value;
        this.oriType = value.getDataType_();
    }

    public void setParameters(Matrix Transfo) {
        if (Transfo.getRowDimension() == 4) {
            this.transform = new AffineTransform(Transfo.get(0, 0), Transfo.get(1, 0), Transfo.get(0, 1), Transfo.get(1, 1), Transfo.get(0, 3), Transfo.get(1, 3));
        }
    }

    public void setParameters(double dx, double dy, double S, double C, double scale) {
        this.transform = new AffineTransform(scale * C, scale * S, -scale * S, C * scale, dx, dy);
    }

    public void setDestinationsize(int width, int height) {
        this.imageDest = new BufferedImage(width, height, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        System.out.println("I will apply transfo now");
        int nbt = this.sequence.getSizeT();
        int nbz = this.sequence.getSizeZ();
        try {
            Sequence newseq = SequenceUtil.getCopy((Sequence)this.sequence);
            this.sequence.beginUpdate();
            this.sequence.removeAllImages();
            ProgressFrame progress = new ProgressFrame("Applying the transformation...");
            progress.setLength((double)(nbt * nbz));
            try {
                for (int t = 0; t < nbt; ++t) {
                    for (int z = 0; z < nbz; ++z) {
                        IcyBufferedImage image = this.transformIcyImage(newseq, t, z);
                        this.sequence.setImage(t, z, (BufferedImage)image);
                        progress.setPosition((double)(1 * (z + t * nbz)));
                    }
                }
            }
            finally {
                this.sequence.endUpdate();
            }
            progress.close();
            System.out.println("have been aplied");
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    private IcyBufferedImage transformIcyImage(Sequence seq, int t, int z) {
        int nbChannels = seq.getSizeC();
        IcyBufferedImage imagetobemodified = seq.getImage(t, z);
        IcyBufferedImage imagetobekept = new IcyBufferedImage(this.imageDest.getWidth(), this.imageDest.getHeight(), imagetobemodified.getSizeC(), imagetobemodified.getDataType_());
        for (int c = 0; c < nbChannels; ++c) {
            int y;
            int x;
            if (imagetobemodified.getImage(c).getDataType_().getBitSize() == 16) {
                IcyBufferedImage tmp = IcyBufferedImageUtil.convertToType((IcyBufferedImage)imagetobemodified.getImage(c), (DataType)DataType.INT, (boolean)false);
                tmp.dataChanged();
                this.image = new BufferedImage(imagetobemodified.getWidth(), imagetobemodified.getHeight(), 2);
                if (imagetobemodified.isSignedDataType()) {
                    for (x = 0; x < this.image.getWidth(); ++x) {
                        for (y = 0; y < this.image.getHeight(); ++y) {
                            this.image.setRGB(x, y, -(tmp.getDataAsInt(x, y, 0) + Short.MAX_VALUE));
                        }
                    }
                } else {
                    for (x = 0; x < this.image.getWidth(); ++x) {
                        for (int y2 = 0; y2 < this.image.getHeight(); ++y2) {
                            this.image.setRGB(x, y2, -tmp.getDataAsInt(x, y2, 0));
                        }
                    }
                }
            } else {
                try {
                    this.image = IcyBufferedImageUtil.toBufferedImage((IcyBufferedImage)imagetobemodified.getImage(c), (int)2);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.imageDest = new BufferedImage(imagetobekept.getWidth(), imagetobekept.getHeight(), 2);
            Graphics2D g2d = this.imageDest.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.drawImage(this.image, this.transform, null);
            g2d.dispose();
            if (imagetobemodified.getImage(c).getDataType_().getBitSize() == 16) {
                if (imagetobemodified.isSignedDataType()) {
                    for (x = 0; x < this.imageDest.getWidth(); ++x) {
                        for (y = 0; y < this.imageDest.getHeight(); ++y) {
                            imagetobekept.setData(x, y, c, (double)(-this.imageDest.getRGB(x, y) - Short.MAX_VALUE));
                        }
                    }
                } else {
                    for (x = 0; x < this.imageDest.getWidth(); ++x) {
                        for (y = 0; y < this.imageDest.getHeight(); ++y) {
                            imagetobekept.setData(x, y, c, (double)(-this.imageDest.getRGB(x, y)));
                        }
                    }
                }
                imagetobekept.dataChanged();
                continue;
            }
            IcyBufferedImage icyImage = IcyBufferedImage.createFrom((BufferedImage)this.imageDest);
            if (icyImage.getDataType_() != this.oriType) {
                double[] boundsDst = imagetobemodified.getImage(c).getChannelsGlobalBounds();
                Scaler scaler = new Scaler(0.0, 255.0, boundsDst[0], boundsDst[1], false);
                IcyBufferedImage tmp = IcyBufferedImageUtil.convertToType((IcyBufferedImage)icyImage, (DataType)this.oriType, (Scaler)scaler);
                tmp.dataChanged();
                imagetobekept.copyData((BufferedImage)tmp, 0, c);
                imagetobekept.dataChanged();
                continue;
            }
            IcyBufferedImage tmp = IcyBufferedImageUtil.getCopy((IcyBufferedImage)icyImage);
            tmp.dataChanged();
            imagetobekept.copyData((BufferedImage)tmp, 0, c);
            imagetobekept.dataChanged();
        }
        return imagetobekept;
    }
}

