/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.easyclemv0;

import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.ToolTipFrame;
import icy.preferences.ApplicationPreferences;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.type.point.Point5D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.Var;
import plugins.kernel.roi.roi3d.ROI3DPoint;

public class ImportRoiPointsFromFile
extends EzPlug
implements Block {
    private EzVarSequence source = new EzVarSequence("sequence");
    private EzVarFile csvfile = new EzVarFile(" csv file)", ApplicationPreferences.getPreferences().node("frame/imageLoader").get("path", "."));
    private double converttopixelXY;
    private double converttopixelZ;
    private EzVarText choiceinputsection = new EzVarText("Unit of the points in csv file", new String[]{"millimeters", "micrometers", "nanometers", "pixels"}, 2, Boolean.valueOf(false));
    private EzVarText choicefileformat = new EzVarText("csv file content looks like:", new String[]{"x;y;z", "x,y,z"}, 1, Boolean.valueOf(false));
    private EzVarBoolean choicez = new EzVarBoolean("Z in Slice # (as from IJ/Fiji, starts at 1)", false);

    public void clean() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() {
        Sequence sourceseq = (Sequence)this.source.getValue();
        String unit = (String)this.choiceinputsection.getValue();
        if (unit == "millimeters") {
            this.converttopixelXY = sourceseq.getPixelSizeX() / 1000.0;
            this.converttopixelZ = sourceseq.getPixelSizeZ() / 1000.0;
        }
        if (unit == "nanometers") {
            this.converttopixelXY = sourceseq.getPixelSizeX() * 1000.0;
            this.converttopixelZ = sourceseq.getPixelSizeZ() * 1000.0;
        }
        if (unit == "micrometers") {
            this.converttopixelXY = sourceseq.getPixelSizeX();
            this.converttopixelZ = sourceseq.getPixelSizeZ();
        }
        if (unit == "pixels") {
            this.converttopixelXY = 1.0;
            this.converttopixelZ = 1.0;
        }
        if (sourceseq == null) {
            MessageDialog.showDialog((String)"Please make sure that your image is opened");
            return;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader((File)this.csvfile.getValue()));
            String cvsSplitBy = ";";
            if (this.choicefileformat.getValue() == "x,y,z") {
                cvsSplitBy = ",";
            }
            int index = 1;
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    String[] coordinates = line.split(cvsSplitBy);
                    System.out.println("x= " + coordinates[0] + "  y=" + coordinates[1] + " z=" + coordinates[2]);
                    double x = Double.parseDouble(coordinates[0]) / this.converttopixelXY;
                    double y = Double.parseDouble(coordinates[1]) / this.converttopixelXY;
                    double z = Double.parseDouble(coordinates[2]) / this.converttopixelZ;
                    if (((Boolean)this.choicez.getValue()).booleanValue()) {
                        System.out.println("z is assumed to be in slice number, will be converted to z-1 ");
                        System.out.println(" Example (IJ starting slice numering at 1, starting at 0 in Icy)");
                        boolean offset = true;
                        z = Double.parseDouble(coordinates[2]) - (double)offset;
                    }
                    ROI3DPoint roi = new ROI3DPoint();
                    Point5D position = roi.getPosition5D();
                    position.setX(x);
                    position.setY(y);
                    position.setZ(z);
                    roi.setPosition5D(position);
                    roi.setName("Point " + index);
                    roi.setShowName(true);
                    ((Sequence)this.source.getValue()).addROI((ROI)roi);
                    ++index;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                MessageDialog.showDialog((String)"check the format of your file \n (open it in text editor):\n It should be x;y;z or x,y,z \n and that you have selected the right format");
                e.printStackTrace();
            }
            MessageDialog.showDialog((String)("Number of Roi added: " + --index));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void initialize() {
        new ToolTipFrame("<html><br>This will load Rois to the image and numbered them in line order. <br>File should be in ascii format (txt or csv for example), with one point per line and <br>a semi column separator. No header.<br> x1;y1;z1<br> x2;y2;z2 <br> Use Excel for example to edit your file and save your excel file as .csv semi colum <br>Do the same with source and target image and you are ready to apply the transform of your choice<br> If \"z in slice number\" is checked, z is assumed to be in slice number, and will be converted to z-1  <br> assuming a starting slice numbered at 1 in IJ, starting at 0 in Icy)</html>", "importmessage");
        String varName = "Please select the ROI file (csv format)";
        this.csvfile = this.source.getValue() != null ? new EzVarFile(varName, ((Sequence)this.source.getValue()).getFilename()) : new EzVarFile(varName, ApplicationPreferences.getPreferences().node("frame/imageLoader").get("path", "."));
        this.addEzComponent((EzComponent)this.csvfile);
        this.addEzComponent((EzComponent)this.choiceinputsection);
        this.addEzComponent((EzComponent)this.choicefileformat);
        this.addEzComponent((EzComponent)this.choicez);
        this.addEzComponent((EzComponent)this.source);
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("Sequence to process", (Var)this.source.getVariable());
        inputMap.add("CSV File to import", this.csvfile.getVariable());
        inputMap.add("unit", this.choiceinputsection.getVariable());
        inputMap.add("format", this.choicefileformat.getVariable());
        inputMap.add("z fiji", this.choicez.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("sequence with Rois", (Var)this.source.getVariable());
    }
}

