/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.easyclemv0;

import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import icy.plugin.abstract_.PluginActionable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleInsets;

public class MonitorTargetPoint
extends PluginActionable {
    private static XYSeries yintervalseries;
    JPanel mainPanel = GuiUtil.generatePanel((String)"Graph");
    IcyFrame mainFrame = GuiUtil.generateTitleFrame((String)"Target Registration Error (predicted)", (JPanel)this.mainPanel, (Dimension)new Dimension(300, 100), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
    private int N;
    private static JFreeChart jfreechart;

    private static XYDataset createDataset(int N) {
        yintervalseries = new XYSeries((Comparable)((Object)"TRE in nm"));
        for (int i = 1; i <= N; ++i) {
            yintervalseries.add((double)i, i);
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(yintervalseries);
        return dataset;
    }

    private void createChart(XYDataset xydataset) {
        jfreechart = ChartFactory.createXYLineChart("Predicted Error on monitored target", "Number of points used for the registration", "TRE", xydataset, PlotOrientation.VERTICAL, true, false, false);
        jfreechart.setBackgroundPaint(Color.white);
        XYPlot xyplot = (XYPlot)jfreechart.getPlot();
        xyplot.setInsets(new RectangleInsets(5.0, 5.0, 5.0, 20.0));
        xyplot.setBackgroundPaint(Color.lightGray);
        xyplot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        xyplot.setDomainGridlinePaint(Color.white);
        xyplot.setRangeGridlinePaint(Color.white);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesPaint(0, Color.RED);
        renderer.setSeriesStroke(0, new BasicStroke(4.0f));
        xyplot.setRenderer(renderer);
        NumberAxis numberaxis = (NumberAxis)xyplot.getRangeAxis();
        numberaxis.setAutoRangeIncludesZero(true);
        numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
    }

    public void run() {
        this.N = 0;
        XYDataset dataset = MonitorTargetPoint.createDataset(this.N);
        this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(jfreechart);
        chartPanel.setFillZoomRectangle(true);
        chartPanel.setMouseWheelEnabled(true);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.mainPanel.add(chartPanel);
        this.mainFrame.pack();
        this.addIcyFrame(this.mainFrame);
        this.mainFrame.setVisible(true);
        this.mainFrame.center();
        this.mainFrame.requestFocus();
    }

    public void addPoint(double newvalue) {
        ++this.N;
        yintervalseries.add((double)this.N, newvalue);
        XYPlot xyplot = (XYPlot)jfreechart.getPlot();
        NumberAxis numberaxis = (NumberAxis)xyplot.getRangeAxis();
        numberaxis.setAutoRangeIncludesZero(false);
        numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
    }

    public static void UpdatePoint(double[][] newvalues) {
        yintervalseries.clear();
        for (int i = 0; i < newvalues.length; ++i) {
            yintervalseries.add(newvalues[i][0], newvalues[i][1]);
            XYPlot xyplot = (XYPlot)jfreechart.getPlot();
            NumberAxis numberaxis = (NumberAxis)xyplot.getRangeAxis();
            numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            numberaxis.setAutoRangeIncludesZero(false);
        }
    }
}

