/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.easyclemv0;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.Enumeration;
import java.util.Vector;
import plugins.perrine.easyclemv0.PointsPair;
import plugins.perrine.easyclemv0.SimilarityTransformation2D;

public class SimilarityRegistrationAnalytic {
    public SimilarityTransformation2D apply(Vector<PointsPair> fiducials) {
        double smeanx = 0.0;
        double smeany = 0.0;
        double tmeanx = 0.0;
        double tmeany = 0.0;
        Enumeration<PointsPair> fiducialsE = fiducials.elements();
        while (fiducialsE.hasMoreElements()) {
            PointsPair pair = fiducialsE.nextElement();
            smeanx += pair.first.getX();
            smeany += pair.first.getY();
            tmeanx += pair.second.getX();
            tmeany += pair.second.getY();
        }
        int numPoints = fiducials.size();
        smeanx /= (double)numPoints;
        smeany /= (double)numPoints;
        tmeanx /= (double)numPoints;
        tmeany /= (double)numPoints;
        fiducialsE = fiducials.elements();
        while (fiducialsE.hasMoreElements()) {
            PointsPair pair = fiducialsE.nextElement();
            pair.first.setLocation(pair.first.getX() - smeanx, pair.first.getY() - smeany);
            pair.second.setLocation(pair.second.getX() - tmeanx, pair.second.getY() - tmeany);
        }
        double meanlengthfirst = 0.0;
        double meanlengthsecond = 0.0;
        fiducialsE = fiducials.elements();
        while (fiducialsE.hasMoreElements()) {
            PointsPair pair = fiducialsE.nextElement();
            double normfirstsquared = pair.first.getX() * pair.first.getX() + pair.first.getY() * pair.first.getY();
            double normsecondsquared = pair.second.getX() * pair.second.getX() + pair.second.getY() * pair.second.getY();
            meanlengthfirst += normfirstsquared;
            meanlengthsecond += normsecondsquared;
        }
        double scale = Math.sqrt(meanlengthsecond / meanlengthfirst);
        Matrix R = Matrix.identity((int)3, (int)3);
        if (fiducials.size() > 2) {
            fiducialsE = fiducials.elements();
            Matrix M = new Matrix(3, 3, 0.0);
            while (fiducialsE.hasMoreElements()) {
                PointsPair pair = fiducialsE.nextElement();
                Matrix Rs = new Matrix(3, 1);
                Matrix Rp = new Matrix(3, 1);
                Rs.set(0, 0, pair.first.getX());
                Rs.set(1, 0, pair.first.getY());
                Rs.set(2, 0, 1.0);
                Rp.set(0, 0, pair.second.getX());
                Rp.set(1, 0, pair.second.getY());
                Rp.set(2, 0, 1.0);
                M.plusEquals(Rp.times(Rs.transpose()));
            }
            Matrix Q = M.transpose().times(M);
            EigenvalueDecomposition evd = Q.eig();
            Matrix v = evd.getV();
            Matrix d = evd.getD();
            for (int r = 0; r < d.getRowDimension(); ++r) {
                for (int c = 0; c < d.getColumnDimension(); ++c) {
                    if (!(d.get(r, c) > 0.0)) continue;
                    d.set(r, c, 1.0 / Math.sqrt(d.get(r, c)));
                }
            }
            Matrix invsquareRootQ = v.times(d.times(v.transpose()));
            R = M.times(invsquareRootQ);
        }
        double[][] vals = new double[][]{{tmeanx}, {tmeany}, {1.0}};
        Matrix vecmeantarget = new Matrix((double[][])vals);
        double[][] valss = new double[][]{{smeanx}, {smeany}, {1.0}};
        Matrix vecmeansource = new Matrix((double[][])valss);
        Matrix T = vecmeantarget.minus(R.times(vecmeansource).times(scale));
        System.out.println("R is :");
        R.print(1, 5);
        System.out.println("T is : ");
        T.print(1, 5);
        System.out.println("Scale is " + scale);
        return new SimilarityTransformation2D(T, R, scale);
    }

    public SimilarityTransformation2D applynomessage(Vector<PointsPair> fiducials) {
        double smeanx = 0.0;
        double smeany = 0.0;
        double tmeanx = 0.0;
        double tmeany = 0.0;
        Enumeration<PointsPair> fiducialsE = fiducials.elements();
        while (fiducialsE.hasMoreElements()) {
            PointsPair pair = fiducialsE.nextElement();
            smeanx += pair.first.getX();
            smeany += pair.first.getY();
            tmeanx += pair.second.getX();
            tmeany += pair.second.getY();
        }
        int numPoints = fiducials.size();
        smeanx /= (double)numPoints;
        smeany /= (double)numPoints;
        tmeanx /= (double)numPoints;
        tmeany /= (double)numPoints;
        fiducialsE = fiducials.elements();
        while (fiducialsE.hasMoreElements()) {
            PointsPair pair = fiducialsE.nextElement();
            pair.first.setLocation(pair.first.getX() - smeanx, pair.first.getY() - smeany);
            pair.second.setLocation(pair.second.getX() - tmeanx, pair.second.getY() - tmeany);
        }
        double meanlengthfirst = 0.0;
        double meanlengthsecond = 0.0;
        fiducialsE = fiducials.elements();
        while (fiducialsE.hasMoreElements()) {
            PointsPair pair = fiducialsE.nextElement();
            double normfirstsquared = pair.first.getX() * pair.first.getX() + pair.first.getY() * pair.first.getY();
            double normsecondsquared = pair.second.getX() * pair.second.getX() + pair.second.getY() * pair.second.getY();
            meanlengthfirst += normfirstsquared;
            meanlengthsecond += normsecondsquared;
        }
        double scale = Math.sqrt(meanlengthsecond / meanlengthfirst);
        Matrix R = Matrix.identity((int)3, (int)3);
        if (fiducials.size() > 2) {
            fiducialsE = fiducials.elements();
            Matrix M = new Matrix(3, 3, 0.0);
            while (fiducialsE.hasMoreElements()) {
                PointsPair pair = fiducialsE.nextElement();
                Matrix Rs = new Matrix(3, 1);
                Matrix Rp = new Matrix(3, 1);
                Rs.set(0, 0, pair.first.getX());
                Rs.set(1, 0, pair.first.getY());
                Rs.set(2, 0, 1.0);
                Rp.set(0, 0, pair.second.getX());
                Rp.set(1, 0, pair.second.getY());
                Rp.set(2, 0, 1.0);
                M.plusEquals(Rp.times(Rs.transpose()));
            }
            Matrix Q = M.transpose().times(M);
            EigenvalueDecomposition evd = Q.eig();
            Matrix v = evd.getV();
            Matrix d = evd.getD();
            for (int r = 0; r < d.getRowDimension(); ++r) {
                for (int c = 0; c < d.getColumnDimension(); ++c) {
                    if (!(d.get(r, c) > 0.0)) continue;
                    d.set(r, c, 1.0 / Math.sqrt(d.get(r, c)));
                }
            }
            Matrix invsquareRootQ = v.times(d.times(v.transpose()));
            R = M.times(invsquareRootQ);
        }
        double[][] vals = new double[][]{{tmeanx}, {tmeany}, {1.0}};
        Matrix vecmeantarget = new Matrix((double[][])vals);
        double[][] valss = new double[][]{{smeanx}, {smeany}, {1.0}};
        Matrix vecmeansource = new Matrix((double[][])valss);
        Matrix T = vecmeantarget.minus(R.times(vecmeansource).times(scale));
        return new SimilarityTransformation2D(T, R, scale);
    }
}

