/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.easyclemv0;

import icy.gui.frame.IcyFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.frame.progress.ToolTipFrame;
import icy.gui.util.GuiUtil;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.type.point.Point5D;
import java.awt.Dimension;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JPanel;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.kernel.roi.roi3d.ROI3DPoint;
import plugins.perrine.easyclemv0.TargetRegistrationErrorMap;

public class StudyLandmarksConfagainstN
extends EzPlug
implements EzStoppable {
    private EzVarSequence source;
    EzVarDouble uFLE = new EzVarDouble("Fiducial localisation error in nm", 200.0, 10.0, 10000.0, 10.0);
    EzVarDouble Nvalue = new EzVarDouble("max N Value to be tested", 20.0, 4.0, 10000.0, 10.0);
    EzVarInteger simulnumber = new EzVarInteger("Nb MonteCarlo Simulations", 100, 10, 10000, 10);
    EzVarInteger radius = new EzVarInteger("Radius in nanometers", 1000, 0, 1000000, 10);
    EzVarFile savedfile = new EzVarFile("Indicate the csv file to create to save the results", ".");
    Sequence target;
    EzVarText choiceinputsection = new EzVarText("I want to study the transformation in:", new String[]{"Rigid (or affine)", "non Rigid)"}, 0, Boolean.valueOf(false));
    private double[][] sourcepoints;
    boolean stopflag;
    Random generator = new Random();
    JPanel mainPanel = GuiUtil.generatePanel((String)"Graph");
    IcyFrame mainFrame = GuiUtil.generateTitleFrame((String)"Real configuration Error MC Simulations", (JPanel)this.mainPanel, (Dimension)new Dimension(300, 100), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
    private Sequence sourceseq;

    public void clean() {
    }

    protected void execute() {
        this.mainPanel = GuiUtil.generatePanel((String)"Graph");
        this.mainFrame = GuiUtil.generateTitleFrame((String)"test plot", (JPanel)this.mainPanel, (Dimension)new Dimension(300, 100), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        this.stopflag = false;
        this.sourceseq = (Sequence)this.source.getValue();
        if (this.sourceseq == null) {
            new AnnounceFrame("Open an image with Rois on it first !!!");
            return;
        }
        if (this.sourceseq.getROIs().size() < 2) {
            new AnnounceFrame("Open an image with Rois on it first !!!");
            return;
        }
        Point5D.Double targetpoint = new Point5D.Double();
        Point5D.Double centerpoint = new Point5D.Double();
        ArrayList listr = this.sourceseq.getROIs();
        boolean targetnotfound = true;
        boolean centernotfound = true;
        for (ROI roi : listr) {
            System.out.println(roi.getName());
            if (roi.getName().matches("Target")) {
                targetpoint = roi.getPosition5D();
                targetnotfound = false;
            }
            if (!roi.getName().matches("Center")) continue;
            centerpoint = roi.getPosition5D();
            centernotfound = false;
        }
        if (targetnotfound) {
            new AnnounceFrame("No roi point named \"Target\", check case as well");
            return;
        }
        if (centernotfound) {
            new AnnounceFrame("No roi point named \"Center\", check case as well");
            return;
        }
        ProgressFrame myprogressbar = new ProgressFrame("Computing simulations...");
        myprogressbar.setLength((double)((Integer)this.simulnumber.getValue()).intValue());
        ArrayList<double[]> mydata = new ArrayList<double[]>();
        for (int mc = 1; mc < (Integer)this.simulnumber.getValue() + 1; ++mc) {
            int n = 4;
            while ((double)n < (Double)this.Nvalue.getValue() + 1.0) {
                int fle = 10;
                while ((double)fle < (Double)this.uFLE.getValue() + 1.0) {
                    this.CreateSourcePoint((Point5D)centerpoint, (Integer)this.radius.getValue(), n);
                    if (n == 20) {
                        this.DisplayPointRois(this.sourcepoints);
                        this.RemoveRoibytCenterandTarget();
                    }
                    myprogressbar.setPosition((double)mc);
                    double tre = this.CheckTRE((Point5D)targetpoint, this.sourcepoints, fle);
                    double[] datasetelement = new double[]{n, mc, fle, tre};
                    mydata.add(datasetelement);
                    fle += 50;
                }
                n += 2;
            }
        }
        myprogressbar.close();
        try {
            FileWriter write = new FileWriter(((File)this.savedfile.getValue()).getAbsolutePath());
            write.append("n;mc;fle;tre;\n");
            for (int i = 0; i < mydata.size(); ++i) {
                double[] tt = (double[])mydata.get(i);
                write.append(tt[0] + ";" + tt[1] + ";" + tt[2] + ";" + tt[3] + "\n");
            }
            write.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Done");
        new AnnounceFrame("Done");
    }

    private void CreateSourcePoint(Point5D centerpoint, int radius, int n) {
        this.sourcepoints = new double[n][3];
        for (int i = 0; i < n; ++i) {
            this.sourcepoints[i][0] = centerpoint.getX() * ((Sequence)this.source.getValue()).getPixelSizeX() * 1000.0 + this.generator.nextGaussian() * (double)(radius / 3);
            this.sourcepoints[i][1] = centerpoint.getY() * ((Sequence)this.source.getValue()).getPixelSizeY() * 1000.0 + this.generator.nextGaussian() * (double)(radius / 3);
            this.sourcepoints[i][2] = 0.0;
        }
    }

    private void DisplayPointRois(double[][] sourcepoints2) {
        double sizex = ((Sequence)this.source.getValue()).getPixelSizeX() * 1000.0;
        double sizez = ((Sequence)this.source.getValue()).getPixelSizeZ() * 1000.0;
        for (int i = 0; i < sourcepoints2.length; ++i) {
            ROI3DPoint newroi = new ROI3DPoint(sourcepoints2[i][0] / sizex, sourcepoints2[i][1] / sizex, sourcepoints2[i][2] / sizez);
            ((Sequence)this.source.getValue()).addROI((ROI)newroi);
        }
    }

    private void RemoveRoibytCenterandTarget() {
        ArrayList roilist = ((Sequence)this.source.getValue()).getROIs();
        for (ROI roi : roilist) {
            if (roi.getName().matches("Target") || roi.getName().matches("Center")) continue;
            ((Sequence)this.source.getValue()).removeROI(roi);
        }
    }

    protected void initialize() {
        EzLabel textinfo1 = new EzLabel("Simulate the influence of different configutation of points centered on Center, on Target point");
        new ToolTipFrame("<html><br> An Image with a ROI named <b>Center</b> and another named <b>Target</b><br>have to be openned.<br> The value of N and FLE will be tested up to the number indicated. <br> Points will be randomly set within the indicated radius<br> No graphic will be displayed, but all simulations will be saved in the file indicated (CSV format)</html>");
        this.source = new EzVarSequence("Select Image to test with Target and ROI ");
        this.addEzComponent((EzComponent)this.source);
        this.addEzComponent((EzComponent)this.uFLE);
        this.addEzComponent((EzComponent)this.Nvalue);
        this.addEzComponent((EzComponent)this.simulnumber);
        this.addEzComponent((EzComponent)this.radius);
        this.addEzComponent((EzComponent)textinfo1);
        this.addEzComponent((EzComponent)this.savedfile);
    }

    private double CheckTRE(Point5D targetpoint, double[][] sourcepoints2, int fle) {
        double predictederror = 0.0;
        TargetRegistrationErrorMap ComputeFRE = new TargetRegistrationErrorMap();
        ComputeFRE.ReadFiducials(sourcepoints2, (Sequence)this.source.getValue());
        double[] f = ComputeFRE.PreComputeTRE();
        predictederror = ComputeFRE.ComputeTRE(fle, (int)targetpoint.getX(), (int)targetpoint.getY(), 0, f);
        return predictederror;
    }

    public void stopExecution() {
        this.stopflag = true;
    }
}

