/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.easyclemv0;

import icy.canvas.IcyCanvas;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.type.point.Point5D;
import icy.util.XMLUtil;
import icy.vtk.IcyVtkPanel;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import plugins.kernel.canvas.VtkCanvas;
import plugins.kernel.roi.roi2d.ROI2DPoint;
import vtk.vtkActor;
import vtk.vtkLinearTransform;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;
import vtk.vtkSphereSource;
import vtk.vtkTransform;

public class myRoi3D
extends ROI2DPoint {
    public static final String ID_Zd = "zd";
    public static final String ID_Z = "z";
    public static final String ID_T = "t";
    public static final String ID_C = "c";
    protected double zd;

    protected myROI3DPointPainter createPainter() {
        return new myROI3DPointPainter();
    }

    public static List<myRoi3D> getROI3DList(List<ROI> rois) {
        ArrayList<myRoi3D> result = new ArrayList<myRoi3D>();
        for (ROI roi : rois) {
            if (!(roi instanceof myRoi3D)) continue;
            result.add((myRoi3D)roi);
        }
        return result;
    }

    public String getROIClassName() {
        return myRoi3D.class.getName();
    }

    public final int getDimension3() {
        return 3;
    }

    public double getZd() {
        return this.zd;
    }

    public void setZd(double value) {
        double v = value == Double.MIN_VALUE ? -1.0 : value;
        if (this.zd != v) {
            this.zd = v;
            this.roiChanged(false);
        }
    }

    public Point5D getPosition5D() {
        Point5D.Double pt = new Point5D.Double(this.getPosition2D().getX(), this.getPosition2D().getY(), this.getZd(), (double)this.getT(), (double)this.getC());
        return pt;
    }

    public void setPosition5D(Point5D position) {
        this.beginUpdate();
        try {
            this.setZ((int)Math.round(position.getZ()));
            this.setZd(position.getZ());
            this.setT((int)position.getT());
            this.setC((int)position.getC());
            this.setPosition2D(position.toPoint2D());
        }
        finally {
            this.endUpdate();
        }
    }

    public boolean loadFromXML(Node node) {
        this.beginUpdate();
        try {
            if (!super.loadFromXML(node)) {
                boolean bl = false;
                return bl;
            }
            this.setZd(XMLUtil.getElementDoubleValue((Node)node, (String)ID_Zd, (double)0.0));
            this.setZ(XMLUtil.getElementIntValue((Node)node, (String)ID_Z, (int)-1));
            this.setT(XMLUtil.getElementIntValue((Node)node, (String)ID_T, (int)-1));
            this.setC(XMLUtil.getElementIntValue((Node)node, (String)ID_C, (int)-1));
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    public boolean saveToXML(Node node) {
        if (!super.saveToXML(node)) {
            return false;
        }
        XMLUtil.setElementDoubleValue((Node)node, (String)ID_Zd, (double)this.getZd());
        XMLUtil.setElementIntValue((Node)node, (String)ID_Z, (int)this.getZ());
        XMLUtil.setElementIntValue((Node)node, (String)ID_T, (int)this.getT());
        XMLUtil.setElementIntValue((Node)node, (String)ID_C, (int)this.getC());
        return true;
    }

    public myRoi3D(Point2D pos) {
        super(pos);
    }

    public myRoi3D(Point5D pt) {
        this(pt.toPoint2D());
        this.zd = pt.getZ();
        this.z = (int)pt.getZ();
        this.setC((int)pt.getC());
        this.setT((int)pt.getT());
    }

    public myRoi3D(ROI roi) {
        this(roi.getPosition5D());
        this.setColor(roi.getColor());
        this.setName(roi.getName());
        this.setStroke(this.getStroke() * 2.0);
    }

    public myRoi3D(double x, double y, double z) {
        this(new Point2D.Double(x, y));
        this.zd = z;
        this.z = (int)z;
    }

    public myRoi3D() {
        this((Point5D)new Point5D.Double());
    }

    public class myROI3DPointPainter
    extends ROI2DPoint.ROI2DPointPainter {
        vtkSphereSource vtkSource;

        public myROI3DPointPainter() {
            super((ROI2DPoint)myRoi3D.this);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (this.vtkSource != null) {
                this.vtkSource.Delete();
            }
        }

        public void mouseMove(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            super.mouseMove(e, imagePoint, canvas);
            if (myRoi3D.this.hasSelectedPoint()) {
                myRoi3D.this.setFocused(true);
            }
        }

        protected void initVtkObjects() {
            this.vtkSource = new vtkSphereSource();
            this.vtkSource.SetRadius(this.getStroke());
            this.vtkSource.SetThetaResolution(12);
            this.vtkSource.SetPhiResolution(12);
            this.polyMapper = new vtkPolyDataMapper();
            this.polyMapper.SetInputConnection(this.vtkSource.GetOutputPort());
            this.actor = new vtkActor();
            this.actor.SetMapper((vtkMapper)this.polyMapper);
            Color col = this.getColor();
            this.actor.GetProperty().SetColor((double)col.getRed() / 255.0, (double)col.getGreen() / 255.0, (double)col.getBlue() / 255.0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void rebuildVtkObjects() {
            VtkCanvas canvas = (VtkCanvas)this.canvas3d.get();
            if (canvas == null) {
                return;
            }
            IcyVtkPanel vtkPanel = canvas.getVtkPanel();
            if (vtkPanel == null) {
                return;
            }
            Sequence seq = canvas.getSequence();
            if (seq == null) {
                return;
            }
            Point2D pos = myRoi3D.this.getPoint();
            double curZ = myRoi3D.this.getZd();
            if (curZ == -1.0) {
                curZ = (double)seq.getSizeZ() / 2.0;
            }
            vtkPanel.lock();
            try {
                this.vtkSource.SetRadius(this.getStroke());
                this.vtkSource.SetCenter(pos.getX(), pos.getY(), curZ * (this.scaling[2] / this.scaling[1]));
                vtkTransform correctsphere = new vtkTransform();
                correctsphere.Scale(1.0, 1.0, this.scaling[1] / this.scaling[2]);
                this.actor.SetUserTransform((vtkLinearTransform)correctsphere);
                this.polyMapper.Update();
                this.actor.SetScale(this.scaling);
            }
            finally {
                vtkPanel.unlock();
            }
            this.painterChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateVtkDisplayProperties() {
            if (this.actor != null) {
                IcyVtkPanel vtkPanel;
                VtkCanvas cnv = (VtkCanvas)this.canvas3d.get();
                Color col = this.getDisplayColor();
                double r = (double)col.getRed() / 255.0;
                double g = (double)col.getGreen() / 255.0;
                double b = (double)col.getBlue() / 255.0;
                IcyVtkPanel icyVtkPanel = vtkPanel = cnv != null ? cnv.getVtkPanel() : null;
                if (vtkPanel != null) {
                    vtkPanel.lock();
                    try {
                        this.actor.GetProperty().SetColor(r, g, b);
                    }
                    finally {
                        vtkPanel.unlock();
                    }
                } else {
                    this.actor.GetProperty().SetColor(r, g, b);
                }
                this.painterChanged();
            }
        }
    }
}

