/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLBuffer;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLKernel;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLPlatform;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.PlatformUtils;
import java.nio.ByteOrder;
import org.bridj.Pointer;

class ByteOrderHack {
    public static final boolean hackEnabled = "1".equals(System.getenv("JAVACL_GUESS_ENDIANNESS")) || "true".equals(System.getProperty("javacl.guessEndianness"));

    ByteOrderHack() {
    }

    public static ByteOrder guessByteOrderNeededForBuffers(CLDevice device) {
        CLPlatform platform = device.getPlatform();
        PlatformUtils.PlatformKind knownPlatform = PlatformUtils.guessPlatformKind(platform);
        if (!hackEnabled || knownPlatform != PlatformUtils.PlatformKind.AMDApp) {
            return device.getByteOrder();
        }
        return ByteOrderHack.checkByteOrderNeededForBuffers(device);
    }

    public static ByteOrder checkByteOrderNeededForBuffers(CLDevice device) {
        CLContext context = JavaCL.createContext(null, device);
        CLQueue queue = context.createDefaultQueue(new CLDevice.QueueProperties[0]);
        try {
            int otherIndex;
            ByteOrder otherOrder;
            int index;
            ByteOrder order;
            boolean littleOk;
            int n = 16;
            String testValueStr = "123456789f";
            float testValue = Float.parseFloat(testValueStr);
            boolean BIG_INDEX = false;
            boolean LITTLE_INDEX = true;
            Pointer<Float> inPtr = Pointer.allocateFloats(n);
            inPtr.order(ByteOrder.BIG_ENDIAN).set(0L, Float.valueOf(testValue));
            inPtr.order(ByteOrder.LITTLE_ENDIAN).set(1L, Float.valueOf(testValue));
            CLBuffer inOut = context.createFloatBuffer(CLMem.Usage.InputOutput, inPtr);
            CLBuffer success = context.createIntBuffer(CLMem.Usage.Output, n);
            String src = "__kernel void compare_endiannesses(__global float *inout, __global int *success) {\nsize_t i = get_global_id(0);\nsuccess[i] = (inout[i] == " + testValueStr + ");\n" + "inout[i] = " + testValueStr + ";\n" + "}";
            CLKernel test = context.createProgram(src).createKernel("compare_endiannesses", new Object[0]);
            test.setArgs(inOut, success);
            test.enqueueNDRange(queue, new int[]{n}, new int[]{1}, new CLEvent[0]);
            Pointer<Integer> successPtr = Pointer.allocateInts(n);
            success.read(queue, successPtr, true, new CLEvent[0]);
            Pointer<Float> outPtr = Pointer.allocateFloats(n);
            inOut.read(queue, outPtr, true, new CLEvent[0]);
            boolean bigOk = successPtr.get(0L) != 0;
            boolean bl = littleOk = successPtr.get(1L) != 0;
            if (bigOk) {
                order = ByteOrder.BIG_ENDIAN;
                index = 0;
                otherOrder = ByteOrder.LITTLE_ENDIAN;
                otherIndex = 1;
            } else {
                order = ByteOrder.LITTLE_ENDIAN;
                index = 1;
                otherOrder = ByteOrder.BIG_ENDIAN;
                otherIndex = 0;
            }
            float value = outPtr.order(order).get(index).floatValue();
            float otherValue = outPtr.order(otherOrder).get(otherIndex).floatValue();
            if (JavaCL.debug) {
                System.out.println("[" + device + "] Endianness test: bigOk = " + bigOk + ", littleOk = " + littleOk + "; value = " + value + ", otherValue = " + otherValue);
            }
            if (!(bigOk ^ littleOk)) {
                throw new RuntimeException("[" + device + "] Endianness check failed, kernel recognized both endiannesses...");
            }
            if (value != testValue || otherValue == testValue) {
                throw new RuntimeException("[" + device + "] Endianness double-check failed, expected " + testValue + " and found " + value + " instead for endianness " + order + " (otherValue = " + otherValue + " for " + otherOrder + ")");
            }
            ByteOrder byteOrder = order;
            return byteOrder;
        }
        catch (Throwable ex) {
            throw new RuntimeException("[" + device + "] Endianness check failed: " + ex, ex);
        }
        finally {
            queue.release();
            context.release();
        }
    }
}

