/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.filtering;

import icy.sequence.Sequence;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import plugins.adufour.filtering.ConvolutionException;
import plugins.adufour.filtering.FilterToolbox;
import plugins.adufour.vars.lang.VarBoolean;

public class Convolution1D {
    public static void convolve(Sequence sequence, Sequence kernel1D_X, Sequence kernel1D_Y, Sequence kernel1D_Z) throws ConvolutionException {
        Convolution1D.convolve(sequence, kernel1D_X, kernel1D_Y, kernel1D_Z, 1, new VarBoolean("stop", false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convolve(Sequence sequence, Sequence kernel1D_X, Sequence kernel1D_Y, Sequence kernel1D_Z, int nbIter, VarBoolean stopFlag) throws ConvolutionException {
        if (kernel1D_X == null && kernel1D_Y == null && kernel1D_Z == null) {
            throw new IllegalArgumentException("Invalid argument: provide at least one non-null kernel");
        }
        if (kernel1D_X != null) {
            if (kernel1D_X.getSizeY() > 1 || kernel1D_X.getSizeZ() > 1) {
                throw new IllegalArgumentException("kernel along X is not 1D");
            }
            if (kernel1D_X.getSizeX() % 2 == 0) {
                throw new IllegalArgumentException("kernel along X has even size");
            }
            if (kernel1D_X.getSizeC() != 1 && kernel1D_X.getSizeC() != sequence.getSizeC()) {
                throw new IllegalArgumentException("kernel along X has " + kernel1D_X.getSizeC() + " channels");
            }
        }
        if (kernel1D_Y != null) {
            if (kernel1D_Y.getSizeY() > 1 || kernel1D_Y.getSizeZ() > 1) {
                throw new IllegalArgumentException("kernel along Y is not 1D");
            }
            if (kernel1D_Y.getSizeX() % 2 == 0) {
                throw new IllegalArgumentException("kernel along Y has even size");
            }
            if (kernel1D_Y.getSizeC() != 1 && kernel1D_Y.getSizeC() != sequence.getSizeC()) {
                throw new IllegalArgumentException("kernel along Y has " + kernel1D_Y.getSizeC() + " channels");
            }
        }
        if (kernel1D_Z != null) {
            if (kernel1D_Z.getSizeY() > 1 || kernel1D_Z.getSizeZ() > 1) {
                throw new IllegalArgumentException("kernel along Z is not 1D");
            }
            if (kernel1D_Z.getSizeX() % 2 == 0) {
                throw new IllegalArgumentException("kernel along Z has even size");
            }
            if (kernel1D_Z.getSizeC() != 1 && kernel1D_Z.getSizeC() != sequence.getSizeC()) {
                throw new IllegalArgumentException("kernel along Z has " + kernel1D_Z.getSizeC() + " channels");
            }
        }
        double[] kernelX = null;
        double[] kernelY = null;
        double[] kernelZ = null;
        DataType type = sequence.getDataType_();
        double[][] z_xy = new double[sequence.getSizeZ()][sequence.getSizeX() * sequence.getSizeY()];
        sequence.beginUpdate();
        try {
            for (int t = 0; t < sequence.getSizeT(); ++t) {
                for (int c = 0; c < sequence.getSizeC(); ++c) {
                    if (kernel1D_X != null) {
                        kernelX = kernel1D_X.getDataXYAsDouble(Math.min(t, kernel1D_X.getSizeT() - 1), 0, Math.min(c, kernel1D_X.getSizeC() - 1));
                    }
                    if (kernel1D_Y != null) {
                        kernelY = kernel1D_Y.getDataXYAsDouble(Math.min(t, kernel1D_Y.getSizeT() - 1), 0, Math.min(c, kernel1D_Y.getSizeC() - 1));
                    }
                    if (kernel1D_Z != null) {
                        kernelZ = kernel1D_Z.getDataXYAsDouble(Math.min(t, kernel1D_Z.getSizeT() - 1), 0, Math.min(c, kernel1D_Z.getSizeC() - 1));
                    }
                    for (int i = 0; i < nbIter; ++i) {
                        int z;
                        for (z = 0; z < sequence.getSizeZ(); ++z) {
                            Array1DUtil.arrayToDoubleArray((Object)sequence.getDataXY(t, z, c), (double[])z_xy[z], (boolean)type.isSigned());
                        }
                        Convolution1D.convolve(z_xy, sequence.getSizeX(), sequence.getSizeY(), kernelX, kernelY, kernelZ);
                        for (z = 0; z < sequence.getSizeZ(); ++z) {
                            Object dest = sequence.getDataXY(t, z, c);
                            Array1DUtil.doubleArrayToSafeArray((double[])z_xy[z], (Object)dest, (boolean)type.isSigned());
                            sequence.setDataXY(t, z, c, dest);
                        }
                        if (!((Boolean)stopFlag.getValue()).booleanValue()) continue;
                        return;
                    }
                }
            }
        }
        finally {
            sequence.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convolve(Sequence sequence, double[] kernelX, double[] kernelY, double[] kernelZ) throws IllegalArgumentException, ConvolutionException {
        if (kernelX == null && kernelY == null && kernelZ == null) {
            throw new IllegalArgumentException("Invalid argument: provide at least one non-null kernel");
        }
        if (kernelX != null && kernelX.length % 2 == 0) {
            throw new IllegalArgumentException("Invalid argument: kernel along X has even size");
        }
        if (kernelY != null && kernelY.length % 2 == 0) {
            throw new IllegalArgumentException("Invalid argument: kernel along Y has even size");
        }
        if (kernelZ != null && kernelZ.length % 2 == 0) {
            throw new IllegalArgumentException("Invalid argument: kernel along Z has even size");
        }
        DataType type = sequence.getDataType_();
        double[][] z_xy = new double[sequence.getSizeZ()][sequence.getSizeX() * sequence.getSizeY()];
        sequence.beginUpdate();
        try {
            for (int t = 0; t < sequence.getSizeT(); ++t) {
                for (int c = 0; c < sequence.getSizeC(); ++c) {
                    int z;
                    for (z = 0; z < sequence.getSizeZ(); ++z) {
                        Array1DUtil.arrayToDoubleArray((Object)sequence.getDataXY(t, z, c), (double[])z_xy[z], (boolean)type.isSigned());
                    }
                    Convolution1D.convolve(z_xy, sequence.getSizeX(), sequence.getSizeY(), kernelX, kernelY, kernelZ);
                    for (z = 0; z < sequence.getSizeZ(); ++z) {
                        Object dest = sequence.getDataXY(t, z, c);
                        Array1DUtil.doubleArrayToSafeArray((double[])z_xy[z], (Object)dest, (boolean)type.isSigned());
                        sequence.setDataXY(t, z, c, dest);
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    return;
                }
            }
        }
        finally {
            sequence.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convolve(double[][] array, int imageWidth, int imageHeight, double[] kernelX, double[] kernelY, double[] kernelZ) throws ConvolutionException {
        Processor service = new Processor(SystemUtil.getAvailableProcessors() * 2);
        int sliceSize = array[0].length;
        double[][] temp = new double[array.length][sliceSize];
        try {
            if (array.length == 1) {
                if (kernelX == null) {
                    Convolution1D.convolve1D((ExecutorService)service, array, temp, imageWidth, imageHeight, kernelY, FilterToolbox.Axis.Y);
                    for (int z = 0; z < array.length; ++z) {
                        System.arraycopy(temp[z], 0, array[z], 0, sliceSize);
                    }
                } else if (kernelY == null) {
                    Convolution1D.convolve1D((ExecutorService)service, array, temp, imageWidth, imageHeight, kernelX, FilterToolbox.Axis.X);
                    for (int z = 0; z < array.length; ++z) {
                        System.arraycopy(temp[z], 0, array[z], 0, sliceSize);
                    }
                } else {
                    Convolution1D.convolve1D((ExecutorService)service, array, temp, imageWidth, imageHeight, kernelX, FilterToolbox.Axis.X);
                    Convolution1D.convolve1D((ExecutorService)service, temp, array, imageWidth, imageHeight, kernelY, FilterToolbox.Axis.Y);
                }
            } else if (kernelX == null) {
                if (kernelY == null) {
                    Convolution1D.convolve1D((ExecutorService)service, array, temp, imageWidth, imageHeight, kernelZ, FilterToolbox.Axis.Z);
                    for (int z = 0; z < array.length; ++z) {
                        System.arraycopy(temp[z], 0, array[z], 0, sliceSize);
                    }
                } else if (kernelZ == null) {
                    Convolution1D.convolve1D((ExecutorService)service, array, temp, imageWidth, imageHeight, kernelY, FilterToolbox.Axis.Y);
                    for (int z = 0; z < array.length; ++z) {
                        System.arraycopy(temp[z], 0, array[z], 0, sliceSize);
                    }
                } else {
                    Convolution1D.convolve1D((ExecutorService)service, array, temp, imageWidth, imageHeight, kernelY, FilterToolbox.Axis.Y);
                    Convolution1D.convolve1D((ExecutorService)service, temp, array, imageWidth, imageHeight, kernelZ, FilterToolbox.Axis.Z);
                }
            } else if (kernelY == null) {
                if (kernelZ == null) {
                    Convolution1D.convolve1D((ExecutorService)service, array, temp, imageWidth, imageHeight, kernelX, FilterToolbox.Axis.X);
                    for (int z = 0; z < array.length; ++z) {
                        System.arraycopy(temp[z], 0, array[z], 0, sliceSize);
                    }
                } else {
                    Convolution1D.convolve1D((ExecutorService)service, array, temp, imageWidth, imageHeight, kernelX, FilterToolbox.Axis.X);
                    Convolution1D.convolve1D((ExecutorService)service, temp, array, imageWidth, imageHeight, kernelZ, FilterToolbox.Axis.Z);
                }
            } else if (kernelZ == null) {
                Convolution1D.convolve1D((ExecutorService)service, array, temp, imageWidth, imageHeight, kernelX, FilterToolbox.Axis.X);
                Convolution1D.convolve1D((ExecutorService)service, temp, array, imageWidth, imageHeight, kernelY, FilterToolbox.Axis.Y);
            } else {
                Convolution1D.convolve1D((ExecutorService)service, array, temp, imageWidth, imageHeight, kernelX, FilterToolbox.Axis.X);
                Convolution1D.convolve1D((ExecutorService)service, temp, array, imageWidth, imageHeight, kernelY, FilterToolbox.Axis.Y);
                Convolution1D.convolve1D((ExecutorService)service, array, temp, imageWidth, imageHeight, kernelZ, FilterToolbox.Axis.Z);
                for (int z = 0; z < array.length; ++z) {
                    System.arraycopy(temp[z], 0, array[z], 0, sliceSize);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        finally {
            service.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convolve1D(double[][] input, double[][] output, int width, int height, double[] kernel, FilterToolbox.Axis axis) throws ConvolutionException {
        Processor service = new Processor(SystemUtil.getAvailableProcessors() * 2);
        try {
            Convolution1D.convolve1D((ExecutorService)service, input, output, width, height, kernel, axis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        finally {
            service.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void convolve1D(ExecutorService service, final double[][] input, double[][] output, final int width, final int height, final double[] kernel, FilterToolbox.Axis axis) throws ConvolutionException, InterruptedException, ExecutionException {
        try {
            final int sliceSize = input[0].length;
            final int kRadius = (kernel.length - 1) / 2;
            switch (axis) {
                case X: {
                    ArrayList tasks = new ArrayList(input.length);
                    for (int z = 0; z < input.length; ++z) {
                        final double[] dArray = input[z];
                        final double[] dArray2 = output[z];
                        tasks.add(service.submit(new Runnable(){

                            @Override
                            public void run() {
                                int xy = 0;
                                for (int y = 0; y < height; ++y) {
                                    int kOffset;
                                    int kIndex;
                                    double value;
                                    int x = 0;
                                    int xStartOffset = xy;
                                    int xEndOffset = xy + width - 1;
                                    while (x < kRadius) {
                                        double value2 = 0.0;
                                        int kIndex2 = 0;
                                        int kOffset2 = -kRadius;
                                        while (kOffset2 <= kRadius) {
                                            int inOffset = xy + kOffset2;
                                            if (inOffset < xStartOffset) {
                                                inOffset = xStartOffset + (xStartOffset - inOffset);
                                            }
                                            value2 += dArray[inOffset] * kernel[kIndex2];
                                            ++kOffset2;
                                            ++kIndex2;
                                        }
                                        dArray2[xy] = value2;
                                        ++x;
                                        ++xy;
                                    }
                                    int eastBorder = width - kRadius;
                                    while (x < eastBorder) {
                                        value = 0.0;
                                        kIndex = 0;
                                        kOffset = -kRadius;
                                        while (kOffset <= kRadius) {
                                            value += dArray[xy + kOffset] * kernel[kIndex];
                                            ++kOffset;
                                            ++kIndex;
                                        }
                                        dArray2[xy] = value;
                                        ++x;
                                        ++xy;
                                    }
                                    while (x < width) {
                                        value = 0.0;
                                        kIndex = 0;
                                        kOffset = -kRadius;
                                        while (kOffset <= kRadius) {
                                            int inOffset = xy + kOffset;
                                            if (inOffset >= xEndOffset) {
                                                inOffset = xEndOffset - (inOffset - xEndOffset);
                                            }
                                            value += dArray[inOffset] * kernel[kIndex];
                                            ++kOffset;
                                            ++kIndex;
                                        }
                                        dArray2[xy] = value;
                                        ++x;
                                        ++xy;
                                    }
                                }
                            }
                        }));
                    }
                    for (Future future : tasks) {
                        future.get();
                    }
                    break;
                }
                case Y: {
                    void var11_23;
                    final int kRadiusY = kRadius * width;
                    ArrayList tasks = new ArrayList(input.length);
                    boolean bl = false;
                    while (var11_23 < input.length) {
                        final double[] dArray = input[var11_23];
                        final double[] out = output[var11_23];
                        tasks.add(service.submit(new Runnable(){

                            @Override
                            public void run() {
                                int x;
                                int kOffset;
                                int kIndex;
                                double value;
                                int y;
                                int xy = 0;
                                for (y = 0; y < kRadius; ++y) {
                                    int x2 = 0;
                                    while (x2 < width) {
                                        int yStartOffset = x2;
                                        value = 0.0;
                                        kIndex = 0;
                                        kOffset = -kRadiusY;
                                        while (kOffset <= kRadiusY) {
                                            int inOffset = xy + kOffset;
                                            if (inOffset < 0) {
                                                inOffset = yStartOffset - inOffset;
                                            }
                                            value += dArray[inOffset] * kernel[kIndex];
                                            kOffset += width;
                                            ++kIndex;
                                        }
                                        out[xy] = value;
                                        ++x2;
                                        ++xy;
                                    }
                                }
                                int southBorder = height - kRadius;
                                while (y < southBorder) {
                                    x = 0;
                                    while (x < width) {
                                        value = 0.0;
                                        kIndex = 0;
                                        kOffset = -kRadiusY;
                                        while (kOffset <= kRadiusY) {
                                            value += dArray[xy + kOffset] * kernel[kIndex];
                                            kOffset += width;
                                            ++kIndex;
                                        }
                                        out[xy] = value;
                                        ++x;
                                        ++xy;
                                    }
                                    ++y;
                                }
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        int yEndOffset = sliceSize - width + x;
                                        double value2 = 0.0;
                                        int kIndex2 = 0;
                                        int kOffset2 = -kRadiusY;
                                        while (kOffset2 <= kRadiusY) {
                                            int inOffset = xy + kOffset2;
                                            if (inOffset >= sliceSize) {
                                                inOffset = yEndOffset - (inOffset - yEndOffset);
                                            }
                                            value2 += dArray[inOffset] * kernel[kIndex2];
                                            kOffset2 += width;
                                            ++kIndex2;
                                        }
                                        out[xy] = value2;
                                        ++x;
                                        ++xy;
                                    }
                                    ++y;
                                }
                            }
                        }));
                        ++var11_23;
                    }
                    for (Future future : tasks) {
                        future.get();
                    }
                    break;
                }
                case Z: {
                    ArrayList tasks = new ArrayList(input.length);
                    int z = 0;
                    while (z < kRadius) {
                        final double[] dArray = output[z];
                        final int n = z++;
                        tasks.add(service.submit(new Runnable(){

                            @Override
                            public void run() {
                                int xy = 0;
                                for (int y = 0; y < height; ++y) {
                                    int x = 0;
                                    while (x < width) {
                                        double value = 0.0;
                                        int kIndex = 0;
                                        int kOffset = -kRadius;
                                        while (kOffset <= kRadius) {
                                            int inSlice = n + kOffset;
                                            if (inSlice < 0) {
                                                inSlice = -inSlice;
                                            }
                                            value += input[inSlice][xy] * kernel[kIndex];
                                            ++kOffset;
                                            ++kIndex;
                                        }
                                        dArray[xy] = value;
                                        ++x;
                                        ++xy;
                                    }
                                }
                            }
                        }));
                    }
                    int n = input.length - kRadius;
                    while (z < n) {
                        final double[] dArray = output[z];
                        final int slice = z++;
                        tasks.add(service.submit(new Runnable(){

                            @Override
                            public void run() {
                                int xy = 0;
                                for (int y = 0; y < height; ++y) {
                                    int x = 0;
                                    while (x < width) {
                                        double value = 0.0;
                                        int kIndex = 0;
                                        int kOffset = -kRadius;
                                        while (kOffset <= kRadius) {
                                            value += input[slice + kOffset][xy] * kernel[kIndex];
                                            ++kOffset;
                                            ++kIndex;
                                        }
                                        dArray[xy] = value;
                                        ++x;
                                        ++xy;
                                    }
                                }
                            }
                        }));
                    }
                    final int n2 = input.length - 1;
                    while (z < input.length) {
                        final double[] out = output[z];
                        final int n3 = z++;
                        tasks.add(service.submit(new Runnable(){

                            @Override
                            public void run() {
                                int xy = 0;
                                for (int y = 0; y < height; ++y) {
                                    int x = 0;
                                    while (x < width) {
                                        double value = 0.0;
                                        int kIndex = 0;
                                        int kOffset = -kRadius;
                                        while (kOffset <= kRadius) {
                                            int inSlice = n3 + kOffset;
                                            if (inSlice >= input.length) {
                                                inSlice = n2 - (inSlice - n2);
                                            }
                                            value += input[inSlice][xy] * kernel[kIndex];
                                            ++kOffset;
                                            ++kIndex;
                                        }
                                        out[xy] = value;
                                        ++x;
                                        ++xy;
                                    }
                                }
                            }
                        }));
                    }
                    for (Future future : tasks) {
                        future.get();
                    }
                    break;
                }
            }
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ArrayIndexOutOfBoundsException) {
                throw new ConvolutionException("Filter size is too large along " + axis.name(), e);
            }
            throw e;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ConvolutionException("Filter size is too large along " + axis.name(), e);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }
}

