/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.filtering;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.DataType;
import plugins.adufour.filtering.IKernel;

public enum Kernels1D implements IKernel
{
    GRADIENT(new double[]{-0.5, 0.0, 0.5}, false),
    CUSTOM_GAUSSIAN(null, true),
    CUSTOM(null, true);

    private double[] data;
    private boolean isSeparable;

    private Kernels1D(double[] data, boolean isSeparable) {
        this.data = data;
        this.isSeparable = isSeparable;
    }

    public boolean isSeparable() {
        return this.isSeparable;
    }

    @Override
    public Sequence toSequence() {
        IcyBufferedImage kernelImage = new IcyBufferedImage(this.data.length, 1, 1, DataType.DOUBLE);
        kernelImage.setDataXYAsDouble(0, this.data);
        Sequence kernel = new Sequence(kernelImage);
        kernel.setName(this.toString());
        return kernel;
    }

    @Override
    public double[] getData() {
        return this.data;
    }

    public Kernels1D createGaussianKernel1D(double sigma) {
        if (sigma < 1.0E-10) {
            this.data = new double[]{1.0};
            return this;
        }
        double sigma2 = sigma * sigma;
        int k = (int)Math.ceil(sigma * 3.0);
        int width = 2 * k + 1;
        this.data = new double[width];
        for (int i = -k; i <= k; ++i) {
            this.data[i + k] = 1.0 / (Math.sqrt(Math.PI * 2) * sigma * Math.exp((double)(i * i) / sigma2 * 0.5));
        }
        Kernels1D.normalize(this.data);
        return this;
    }

    public Kernels1D createCustomKernel1D(double[] data, boolean isNormalized) {
        this.data = new double[data.length];
        System.arraycopy(data, 0, this.data, 0, data.length);
        if (!isNormalized) {
            Kernels1D.normalize(this.data);
        }
        return this;
    }

    private static double[] normalize(double[] data) {
        double accu = 0.0;
        for (double d : data) {
            accu += d;
        }
        if (accu != 1.0 && accu != 0.0) {
            int i = 0;
            while (i < data.length) {
                int n = i++;
                data[n] = data[n] / accu;
            }
        }
        return data;
    }
}

