/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.filtering;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.type.DataType;
import plugins.adufour.filtering.IKernel;

public enum Kernels2D implements IKernel
{
    LAPLACE(3, 3, new double[]{0.0, 1.0, 0.0, 1.0, -4.0, 1.0, 0.0, 1.0, 0.0}),
    PREWITT_X(3, 3, new double[]{1.0, 1.0, 1.0, 0.0, 0.0, 0.0, -1.0, -1.0, -1.0}),
    PREWITT_Y(3, 3, new double[]{-1.0, 0.0, 1.0, -1.0, 0.0, 1.0, -1.0, 0.0, 1.0}),
    SOBEL_X(3, 3, new double[]{1.0, 2.0, 1.0, 0.0, 0.0, 0.0, -1.0, -2.0, -1.0}),
    SOBEL_Y(3, 3, new double[]{-1.0, 0.0, 1.0, -2.0, 0.0, 2.0, -1.0, 0.0, 1.0}),
    KIRSCH_NORTH(3, 3, new double[]{5.0, 5.0, 5.0, -3.0, 0.0, -3.0, -3.0, -3.0, -3.0}),
    KIRSCH_NORTHEAST(3, 3, new double[]{-3.0, 5.0, 5.0, -3.0, 0.0, 5.0, -3.0, -3.0, -3.0}),
    KIRSCH_EAST(3, 3, new double[]{-3.0, -3.0, 5.0, -3.0, 0.0, 5.0, -3.0, -3.0, 5.0}),
    KIRSCH_SOUTHEAST(3, 3, new double[]{-3.0, -3.0, -3.0, -3.0, 0.0, 5.0, -3.0, 5.0, 5.0}),
    KIRSCH_SOUTH(3, 3, new double[]{-3.0, -3.0, -3.0, -3.0, 0.0, -3.0, 5.0, 5.0, 5.0}),
    KIRSCH_SOUTHWEST(3, 3, new double[]{-3.0, -3.0, -3.0, 5.0, 0.0, -3.0, 5.0, 5.0, -3.0}),
    KIRSCH_WEST(3, 3, new double[]{5.0, -3.0, -3.0, 5.0, 0.0, -3.0, 5.0, -3.0, -3.0}),
    KIRSCH_NORTHWEST(3, 3, new double[]{5.0, 5.0, -3.0, 5.0, 0.0, -3.0, -3.0, -3.0, -3.0}),
    CUSTOM_GABOR(0, 0, null),
    CUSTOM(0, 0, null),
    CUSTOM_SEQUENCE(0, 0, null);

    private int width;
    private int height;
    private double[] data;

    private Kernels2D(int width, int height, double[] data) {
        this.width = width;
        this.height = height;
        if (data != null) {
            this.data = Kernels2D.normalize(data);
        }
    }

    public Kernels2D createGaborKernel2D(double sigma, double k_x, double k_y, boolean isSymmetric) {
        int k = (int)Math.floor(sigma * 3.0);
        this.width = 2 * k + 1;
        this.height = 2 * k + 1;
        this.data = new double[this.width * this.height];
        if (isSymmetric) {
            for (int i = -k; i <= k; ++i) {
                for (int j = -k; j <= k; ++j) {
                    this.data[i + k + (j + k) * this.width] = Math.cos(k_x * (double)i + k_y * (double)j) * Math.exp((double)(-0.5f * (float)(i * i + j * j)) / (sigma * sigma));
                }
            }
        } else {
            for (int i = -k; i <= k; ++i) {
                for (int j = -k; j <= k; ++j) {
                    this.data[i + k + (j + k) * this.width] = Math.sin(k_x * (double)i + k_y * (double)j) * Math.exp((double)(-0.5f * (float)(i * i + j * j)) / (sigma * sigma));
                }
            }
        }
        Kernels2D.normalize(this.data);
        return this;
    }

    public Kernels2D createCustomKernel2D(double[][] kernel, boolean isNormalized) {
        this.width = kernel.length;
        this.height = kernel[0].length;
        this.data = new double[this.width * this.height];
        int offset = 0;
        for (double[] line : kernel) {
            System.arraycopy(line, 0, this.data, offset, line.length);
            offset += line.length;
        }
        if (!isNormalized) {
            Kernels2D.normalize(this.data);
        }
        return this;
    }

    public Kernels2D createCustomKernel2D(double[] kernel, int width, int height, boolean isNormalized) {
        this.width = width;
        this.height = height;
        this.data = new double[width * height];
        System.arraycopy(kernel, 0, this.data, 0, kernel.length);
        if (!isNormalized) {
            Kernels2D.normalize(this.data);
        }
        return this;
    }

    public Kernels2D createCustomKernel2D(Sequence kernel2D, int t, int z, int c) {
        this.width = kernel2D.getSizeX();
        this.height = kernel2D.getSizeY();
        if (this.width % 2 == 0 || this.height % 2 == 0) {
            throw new IllegalArgumentException("Kernel sequence must have odd dimensions");
        }
        this.data = SequenceUtil.convertToType((Sequence)kernel2D, (DataType)DataType.DOUBLE, (boolean)false).getDataXYAsDouble(t, z, c);
        Kernels2D.normalize(this.data);
        return this;
    }

    private static double[] normalize(double[] data) {
        double sum = 0.0;
        for (double d : data) {
            sum += d;
        }
        if (sum != 1.0 && sum != 0.0) {
            int i = 0;
            while (i < data.length) {
                int n = i++;
                data[n] = data[n] / sum;
            }
        }
        return data;
    }

    @Override
    public Sequence toSequence() {
        IcyBufferedImage kernelImage = new IcyBufferedImage(this.width, this.height, 1, DataType.DOUBLE);
        kernelImage.setDataXYAsDouble(0, this.data);
        Sequence kernel = new Sequence(kernelImage);
        kernel.setName(this.toString());
        return kernel;
    }

    @Override
    public double[] getData() {
        return this.data;
    }
}

