/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.filtering;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.util.OMEUtil;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import loci.formats.meta.MetadataRetrieve;
import plugins.adufour.filtering.Filter;

public abstract class SelectionFilter
extends Filter {
    abstract double process(double var1, double[] var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence filterSquare(Sequence sequence, int ... radius) {
        int kHeight;
        Sequence out = new Sequence(OMEUtil.createOMEMetadata((MetadataRetrieve)sequence.getMetadata()));
        out.setName(sequence.getName() + "_" + this.getDescriptor().getName());
        this.stopFlag.setValue((Object)false);
        this.progress.setValue((Object)0.0);
        if (radius.length == 0) {
            throw new IllegalArgumentException("Provide at least one filter radius");
        }
        final int width = sequence.getSizeX();
        int height = sequence.getSizeY();
        int depth = sequence.getSizeZ();
        int channels = sequence.getSizeC();
        final DataType type = sequence.getDataType_();
        final boolean signed = sequence.isSignedDataType();
        final double taskIncrement = 1.0 / (double)(height * depth * channels * sequence.getSizeT());
        final int kWidth = radius[0];
        int n = kHeight = radius.length == 1 ? kWidth : radius[1];
        int kDepth = radius.length == 1 ? kWidth : (radius.length == 2 ? 0 : radius[2]);
        final Object[] in_Z_XY = new Object[depth];
        final double[] cache = new double[width * height];
        ArrayList<Future> tasks = new ArrayList<Future>(height);
        block7: for (int t = 0; t < sequence.getSizeT(); ++t) {
            for (int z = 0; z < depth; ++z) {
                out.setImage(t, z, (BufferedImage)new IcyBufferedImage(width, height, channels, type));
            }
            for (int c = 0; c < channels; ++c) {
                int z;
                for (z = 0; z < depth; ++z) {
                    in_Z_XY[z] = sequence.getImage(t, z, c).getDataXY(0);
                }
                for (z = 0; z < depth; ++z) {
                    final int minZinclusive = Math.max(z - kDepth, 0);
                    final int maxZexclusive = Math.min(z + kDepth + 1, depth);
                    final Object _inXY = in_Z_XY[z];
                    final Object _outXY = out.getDataXY(t, z, c);
                    tasks.clear();
                    for (int y = 0; y < height; ++y) {
                        final int line = y;
                        final int minYinclusive = Math.max(y - kHeight, 0);
                        final int maxYexclusive = Math.min(y + kHeight + 1, height);
                        final int lineOffset = y * width;
                        final int maxNeighbors = (1 + (maxZexclusive - minZinclusive) * 2) * (1 + (maxYexclusive - minYinclusive) * 2) * (1 + kWidth * 2);
                        tasks.add(service.submit(new Runnable(){

                            @Override
                            public void run() {
                                double[] neighborhood = new double[maxNeighbors];
                                int outXY = lineOffset;
                                int x = 0;
                                while (x < width) {
                                    double currentPixel = Array1DUtil.getValue((Object)_inXY, (int)outXY, (DataType)type);
                                    int localNeighborHoodSize = 0;
                                    int minXinclusive = Math.max(x - kWidth, 0);
                                    int maxXexclusive = Math.min(x + kWidth + 1, width);
                                    for (int inZ = minZinclusive; inZ < maxZexclusive; ++inZ) {
                                        Object neighborSlice = in_Z_XY[inZ];
                                        for (int inY = minYinclusive; inY < maxYexclusive; ++inY) {
                                            int inXY = inY * width + minXinclusive;
                                            int inX = minXinclusive;
                                            while (inX < maxXexclusive) {
                                                neighborhood[localNeighborHoodSize] = Array1DUtil.getValue((Object)neighborSlice, (int)inXY, (DataType)type);
                                                ++inX;
                                                ++inXY;
                                                ++localNeighborHoodSize;
                                            }
                                        }
                                    }
                                    cache[outXY] = SelectionFilter.this.process(currentPixel, neighborhood, localNeighborHoodSize);
                                    ++x;
                                    ++outXY;
                                }
                                Array1DUtil.doubleArrayToSafeArray((double[])cache, (int)lineOffset, (Object)_outXY, (int)lineOffset, (int)width, (boolean)signed);
                                if (line % 3 == 0) {
                                    SelectionFilter.this.progress.setValue((Object)(SelectionFilter.this.progress.getValue() + taskIncrement * 3.0));
                                }
                            }
                        }));
                        if (((Boolean)this.stopFlag.getValue()).booleanValue()) break;
                    }
                    try {
                        for (Future f : tasks) {
                            f.get();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        Sequence sequence2 = out;
                        return sequence2;
                    }
                    catch (ExecutionException e) {
                        Thread.currentThread().interrupt();
                        Sequence sequence3 = out;
                        return sequence3;
                    }
                    finally {
                        out.setDataXY(t, z, c, _outXY);
                    }
                    if (((Boolean)this.stopFlag.getValue()).booleanValue()) break block7;
                }
            }
        }
        return out;
    }
}

