/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.easyclemv0;

import Jama.Matrix;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.util.GuiUtil;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.type.point.Point5D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleInsets;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.kernel.roi.descriptor.measure.ROIMassCenterDescriptorsPlugin;
import plugins.perrine.easyclemv0.PPPoint3D;
import plugins.perrine.easyclemv0.PointsPair;
import plugins.perrine.easyclemv0.PointsPair3D;
import plugins.perrine.easyclemv0.SimilarityRegistrationAnalytic;
import plugins.perrine.easyclemv0.SimilarityRegistrationAnalytic3D;
import plugins.perrine.easyclemv0.SimilarityTransformation2D;
import plugins.perrine.easyclemv0.SimilarityTransformation3D;
import plugins.perrine.easyclemv0.TargetRegistrationErrorMap;

public class ComputeLeaveOneOut
extends EzPlug {
    private EzVarSequence source;
    private EzVarSequence target;
    Sequence backupsource;
    EzVarText choiceinputsection = new EzVarText("I want to study the transformation in:", new String[]{"Rigid (or affine)", "non Rigid)"}, 0, Boolean.valueOf(false));
    private double[][] sourcepoints;
    private double[][] targetpoints;
    private double[][] backuptargetpoints;
    private double[][] backupsourcepoints;
    private boolean mode3D = false;
    private Vector<PointsPair> fiducialsvector;
    private Vector<PointsPair3D> fiducialsvector3D;
    private ArrayList<ROI> backuproitarget;
    private ArrayList<ROI> backuproisource;
    private XYSeries curve = new XYSeries((Comparable)((Object)"TRE vs Discrepancy"));
    JPanel mainPanel = GuiUtil.generatePanel((String)"Graph");
    IcyFrame mainFrame = GuiUtil.generateTitleFrame((String)"Target Registration Error (predicted)", (JPanel)this.mainPanel, (Dimension)new Dimension(300, 100), (boolean)true, (boolean)true, (boolean)true, (boolean)true);

    public void clean() {
    }

    protected void execute() {
        try {
            this.backupsource = SequenceUtil.getCopy((Sequence)((Sequence)this.source.getValue()));
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        this.GetTargetPointsfromROI();
        this.GetSourcePointsfromROI();
        this.backuproitarget = ((Sequence)this.target.getValue()).getROIs();
        this.backuproisource = ((Sequence)this.source.getValue()).getROIs();
        this.backuptargetpoints = this.targetpoints;
        this.backupsourcepoints = this.sourcepoints;
        if (this.sourcepoints.length != this.targetpoints.length) {
            System.out.println("source points different from target point");
            return;
        }
        if (!this.mode3D) {
            this.fiducialsvector = this.createVectorfromdoublearray(this.sourcepoints, this.targetpoints);
            this.fiducialsvector3D = new Vector();
        } else {
            this.fiducialsvector3D = this.createVectorfromdoublearray3D(this.sourcepoints, this.targetpoints);
            this.fiducialsvector = new Vector();
        }
        this.ComputeTransfo();
        this.CheckTREvsFRE();
        for (int p = 0; p < this.backupsourcepoints.length; ++p) {
            ((Sequence)this.target.getValue()).removeAllROI();
            ((Sequence)this.source.getValue()).removeAllROI();
            ((Sequence)this.target.getValue()).addROIs(this.backuproitarget, false);
            ((Sequence)this.source.getValue()).addROIs(this.backuproisource, false);
            ArrayList<ROI> listfiducialst = this.backuproitarget;
            this.ReOrder(listfiducialst);
            ArrayList<ROI> listfiducialss = this.backuproisource;
            this.ReOrder(listfiducialss);
            ((Sequence)this.target.getValue()).removeROI(listfiducialst.get(p));
            ((Sequence)this.source.getValue()).removeROI(listfiducialss.get(p));
            this.GetTargetPointsfromROI();
            this.GetSourcePointsfromROI();
            if (!this.mode3D) {
                this.fiducialsvector = this.createVectorfromdoublearray(this.sourcepoints, this.targetpoints);
                this.fiducialsvector3D = new Vector();
            } else {
                this.fiducialsvector3D = this.createVectorfromdoublearray3D(this.sourcepoints, this.targetpoints);
                this.fiducialsvector = new Vector();
            }
            SimilarityTransformation2D newtransfo = this.ComputeTransfo();
            this.CheckTREvsFRE();
            Point2D.Double testPoint = new Point2D.Double(this.backupsourcepoints[p][0], this.backupsourcepoints[p][1]);
            newtransfo.apply(testPoint);
            PointsPair outpoint = new PointsPair(new Point2D.Double(this.backupsourcepoints[p][0], this.backupsourcepoints[p][1]), new Point2D.Double(this.backuptargetpoints[p][0], this.backuptargetpoints[p][1]));
            this.CheckTREvsFRE(outpoint, listfiducialst.get(p).getName());
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(this.curve);
        JFreeChart jfreechart = ComputeLeaveOneOut.CreateChart(dataset);
        ChartPanel chartPanel = new ChartPanel(jfreechart);
        chartPanel.setFillZoomRectangle(true);
        chartPanel.setMouseWheelEnabled(true);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.mainPanel.add(chartPanel);
        this.mainFrame.pack();
        this.addIcyFrame(this.mainFrame);
        this.mainFrame.setVisible(true);
        this.mainFrame.center();
        this.mainFrame.requestFocus();
    }

    private static JFreeChart CreateChart(XYSeriesCollection dataset) {
        JFreeChart chart = ChartFactory.createXYLineChart("TRE vs Discrepancy ", "TRE in nm", "Discrepancy in nm", dataset, PlotOrientation.VERTICAL, false, true, false);
        chart.setBackgroundPaint(Color.white);
        XYPlot xyplot = (XYPlot)chart.getPlot();
        xyplot.setInsets(new RectangleInsets(5.0, 5.0, 5.0, 20.0));
        xyplot.setBackgroundPaint(Color.lightGray);
        xyplot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        xyplot.setDomainGridlinePaint(Color.white);
        xyplot.setRangeGridlinePaint(Color.white);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesPaint(0, Color.RED);
        renderer.setSeriesStroke(0, new BasicStroke(4.0f));
        renderer.setSeriesLinesVisible(0, false);
        xyplot.setRenderer(renderer);
        NumberAxis numberaxis = (NumberAxis)xyplot.getRangeAxis();
        numberaxis.setAutoRangeIncludesZero(true);
        numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return chart;
    }

    protected void initialize() {
        EzLabel textinfo1 = new EzLabel("Give information about error computation, usind leave one out as well.");
        this.source = new EzVarSequence("Select Source Image ");
        this.target = new EzVarSequence("Select Target Image ");
        this.addEzComponent((EzComponent)this.source);
        this.addEzComponent((EzComponent)this.target);
        this.addEzComponent((EzComponent)textinfo1);
        this.addEzComponent((EzComponent)this.choiceinputsection);
    }

    void GetTargetPointsfromROI() {
        ArrayList listfiducials = ((Sequence)this.target.getValue()).getROIs();
        this.ReOrder(listfiducials);
        this.targetpoints = new double[listfiducials.size()][3];
        int i = -1;
        for (ROI roi : listfiducials) {
            ++i;
            Point5D p3D = null;
            try {
                p3D = ROIMassCenterDescriptorsPlugin.computeMassCenter((ROI)roi);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (roi.getClassName() == "plugins.kernel.roi.roi3d.ROI3DPoint") {
                p3D = roi.getPosition5D();
            }
            if (Double.isNaN(p3D.getX())) {
                p3D = roi.getPosition5D();
            }
            this.targetpoints[i][0] = p3D.getX();
            this.targetpoints[i][1] = p3D.getY();
            this.targetpoints[i][2] = p3D.getZ();
            this.targetpoints[i][2] = p3D.getZ();
        }
    }

    void GetSourcePointsfromROI() {
        if (this.source.getValue() == null) {
            MessageDialog.showDialog((String)"Make sure source image is openned");
            return;
        }
        ArrayList listfiducials = ((Sequence)this.source.getValue()).getROIs();
        this.ReOrder(listfiducials);
        this.sourcepoints = new double[listfiducials.size()][3];
        int i = -1;
        for (ROI roi : listfiducials) {
            ++i;
            Point5D p3D = null;
            try {
                p3D = ROIMassCenterDescriptorsPlugin.computeMassCenter((ROI)roi);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (roi.getClassName() == "plugins.kernel.roi.roi3d.ROI3DPoint") {
                p3D = roi.getPosition5D();
            }
            if (Double.isNaN(p3D.getX())) {
                p3D = roi.getPosition5D();
            }
            this.sourcepoints[i][0] = p3D.getX();
            this.sourcepoints[i][1] = p3D.getY();
            this.sourcepoints[i][2] = p3D.getZ();
        }
    }

    private void ReOrder(ArrayList<ROI> listfiducials) {
        boolean permut;
        int longueur = listfiducials.size();
        do {
            permut = false;
            for (int i = 0; i < longueur - 1; ++i) {
                if (listfiducials.get(i).getName().compareTo(listfiducials.get(i + 1).getName()) <= 0) continue;
                ROI tampon = listfiducials.get(i);
                listfiducials.set(i, listfiducials.get(i + 1));
                listfiducials.set(i + 1, tampon);
                permut = true;
            }
        } while (permut);
    }

    SimilarityTransformation2D ComputeTransfo() {
        SimilarityTransformation2D newtransfo = null;
        if (this.fiducialsvector.size() > 2 || this.fiducialsvector3D.size() > 3) {
            double back_up_pixelsizex = ((Sequence)this.source.getValue()).getPixelSizeX();
            double back_up_pixelsizey = ((Sequence)this.source.getValue()).getPixelSizeY();
            double back_up_pixelsizez = ((Sequence)this.source.getValue()).getPixelSizeZ();
            if (!this.mode3D) {
                SimilarityRegistrationAnalytic meanfiducialsalgo = new SimilarityRegistrationAnalytic();
                newtransfo = meanfiducialsalgo.apply(this.fiducialsvector);
                double pixelsizexum = ((Sequence)this.target.getValue()).getPixelSizeX();
                double pixelsizeyum = ((Sequence)this.target.getValue()).getPixelSizeY();
                ((Sequence)this.source.getValue()).setPixelSizeX(pixelsizexum);
                ((Sequence)this.source.getValue()).setPixelSizeY(pixelsizeyum);
                this.updateSourcePoints2D(newtransfo);
                this.updateRoi();
            } else if (!this.testcoplanarity(this.fiducialsvector3D) || this.fiducialsvector3D.size() >= 6) {
                SimilarityRegistrationAnalytic3D meanfiducialsalgo = new SimilarityRegistrationAnalytic3D();
                SimilarityTransformation3D newtransfo3 = meanfiducialsalgo.apply(this.fiducialsvector3D, back_up_pixelsizex, back_up_pixelsizey, back_up_pixelsizez, ((Sequence)this.target.getValue()).getPixelSizeX(), ((Sequence)this.target.getValue()).getPixelSizeY(), ((Sequence)this.target.getValue()).getPixelSizeZ());
                Matrix transfo = newtransfo3.getMatrix();
                if (transfo.get(2, 2) != 0.0) {
                    this.updateSourcePoints3D(newtransfo3);
                    this.updateRoi();
                }
            } else {
                System.out.println("Instability: One more point");
                new AnnounceFrame("The position of the points does not allow a correct 3D transform. \n You need at least 2 points in separate z (slice). \n You may want to consider a 2D transform (it will still transform the full stack).");
            }
        } else {
            System.out.println("One more point");
            if (this.mode3D) {
                new AnnounceFrame("No transformation will be computed with less than 4 points. You have placed " + this.fiducialsvector3D.size() + " points", 2);
            } else {
                new AnnounceFrame("No transformation will be computed with less than 3 points. You have placed " + this.fiducialsvector.size() + " points", 2);
            }
        }
        return newtransfo;
    }

    Vector<PointsPair> createVectorfromdoublearray(double[][] sourcepoints2, double[][] targetpoints2) {
        Vector<PointsPair> points = new Vector<PointsPair>();
        if (targetpoints2.length == sourcepoints2.length) {
            for (int i = 0; i < sourcepoints2.length; ++i) {
                points.addElement(new PointsPair(new Point2D.Double(sourcepoints2[i][0], sourcepoints2[i][1]), new Point2D.Double(targetpoints2[i][0], targetpoints2[i][1])));
            }
        }
        return points;
    }

    Vector<PointsPair3D> createVectorfromdoublearray3D(double[][] sourcepoints2, double[][] targetpoints2) {
        Vector<PointsPair3D> points = new Vector<PointsPair3D>();
        for (int i = 0; i < sourcepoints2.length; ++i) {
            points.addElement(new PointsPair3D(new PPPoint3D(sourcepoints2[i][0], sourcepoints2[i][1], sourcepoints2[i][2]), new PPPoint3D(targetpoints2[i][0], targetpoints2[i][1], targetpoints2[i][2])));
        }
        return points;
    }

    private void updateSourcePoints2D(SimilarityTransformation2D newtransfo) {
        for (int i = 0; i < this.sourcepoints.length; ++i) {
            Point2D.Double testPoint = new Point2D.Double(this.sourcepoints[i][0], this.sourcepoints[i][1]);
            newtransfo.apply(testPoint);
            this.sourcepoints[i][0] = ((Point2D)testPoint).getX();
            this.sourcepoints[i][1] = ((Point2D)testPoint).getY();
        }
    }

    void updateRoi() {
        ArrayList listfiducials = ((Sequence)this.source.getValue()).getROIs();
        this.ReOrder(listfiducials);
        int i = -1;
        for (ROI roi : listfiducials) {
            Point5D position = roi.getPosition5D();
            position.setX(this.sourcepoints[++i][0]);
            position.setY(this.sourcepoints[i][1]);
            position.setZ(this.sourcepoints[i][2]);
            roi.setPosition5D(position);
        }
    }

    private boolean testcoplanarity(Vector<PointsPair3D> fiducialsvector3d2) {
        boolean testsource = true;
        boolean testtarget = true;
        double zsource = fiducialsvector3d2.get((int)0).first.getZ();
        for (int i = 1; i < fiducialsvector3d2.size(); ++i) {
            PointsPair3D currentpair = fiducialsvector3d2.get(i);
            if (currentpair.first.getZ() == zsource) continue;
            testsource = false;
            break;
        }
        double ztarget = fiducialsvector3d2.get((int)0).second.getZ();
        for (int i = 1; i < fiducialsvector3d2.size(); ++i) {
            PointsPair3D currentpair = fiducialsvector3d2.get(i);
            if (currentpair.second.getZ() == ztarget) continue;
            testtarget = false;
            break;
        }
        return testsource || testtarget;
    }

    void updateSourcePoints3D(SimilarityTransformation3D newtransfo) {
        for (int i = 0; i < this.sourcepoints.length; ++i) {
            PPPoint3D testPoint = new PPPoint3D(this.sourcepoints[i][0], this.sourcepoints[i][1], this.sourcepoints[i][2]);
            newtransfo.apply(testPoint);
            this.sourcepoints[i][0] = testPoint.getX() / ((Sequence)this.source.getValue()).getPixelSizeX();
            this.sourcepoints[i][1] = testPoint.getY() / ((Sequence)this.source.getValue()).getPixelSizeY();
            this.sourcepoints[i][2] = testPoint.getZ() / ((Sequence)this.source.getValue()).getPixelSizeZ();
        }
    }

    private boolean CheckTREvsFRE() {
        boolean check;
        block4: {
            check = false;
            double error = 0.0;
            double predictederror = 0.0;
            double FLEmax = this.maxdifferrorinnm();
            System.out.println("Max localization error FLE " + FLEmax + " nm");
            TargetRegistrationErrorMap ComputeFRE = new TargetRegistrationErrorMap();
            ComputeFRE.ReadFiducials((Sequence)this.target.getValue());
            double[] f = ComputeFRE.PreComputeTRE();
            if (this.sourcepoints == null && this.targetpoints == null) break block4;
            if (!this.mode3D) {
                ArrayList listfiducials = ((Sequence)this.source.getValue()).getROIs();
                this.ReOrder(listfiducials);
                this.fiducialsvector = this.createVectorfromdoublearray(this.sourcepoints, this.targetpoints);
                for (int index = 0; index < this.fiducialsvector.size(); ++index) {
                    error = this.fiducialsvector.get(index).getDiffinpixels();
                    String name = ((ROI)listfiducials.get(index)).getName();
                    error = error * ((Sequence)this.source.getValue()).getPixelSizeX() * 1000.0;
                    predictederror = ComputeFRE.ComputeTRE(FLEmax, (int)this.fiducialsvector.get((int)index).first.getX(), (int)this.fiducialsvector.get((int)index).first.getY(), 0, f);
                    System.out.println(name + " Discrepancy in nm: " + error + "vs Predicted error in nm: " + predictederror);
                    if (!(error > predictederror)) continue;
                    check = true;
                }
            } else {
                this.fiducialsvector3D = this.createVectorfromdoublearray3D(this.sourcepoints, this.targetpoints);
                for (int index = 0; index < this.fiducialsvector3D.size(); ++index) {
                    error = Math.sqrt(Math.pow((this.fiducialsvector3D.get(index).getfirstxinpixels() - this.fiducialsvector3D.get(index).getsecondxinpixels()) * ((Sequence)this.source.getValue()).getPixelSizeX(), 2.0) + Math.pow((this.fiducialsvector3D.get(index).getfirstyinpixels() - this.fiducialsvector3D.get(index).getsecondyinpixels()) * ((Sequence)this.source.getValue()).getPixelSizeY(), 2.0) + Math.pow((this.fiducialsvector3D.get(index).getfirstzinpixels() - this.fiducialsvector3D.get(index).getsecondzinpixels()) * ((Sequence)this.source.getValue()).getPixelSizeZ(), 2.0));
                    predictederror = ComputeFRE.ComputeTRE(FLEmax, (int)this.fiducialsvector3D.get(index).getfirstxinpixels(), (int)this.fiducialsvector3D.get(index).getfirstyinpixels(), (int)this.fiducialsvector3D.get(index).getfirstzinpixels(), f);
                    System.out.println("Point " + (index + 1) + "Discrepancy in nm: " + (error *= 1000.0) + "vs Predicted error in nm: " + predictederror);
                    if (!(error > predictederror)) continue;
                    check = true;
                }
            }
        }
        return check;
    }

    private boolean CheckTREvsFRE(PointsPair leftpoint, String name) {
        boolean check = false;
        double error = 0.0;
        double predictederror = 0.0;
        double FLEmax = this.maxdifferrorinnm();
        System.out.println("Left Point: Max localization error FLE " + FLEmax + " nm");
        TargetRegistrationErrorMap ComputeFRE = new TargetRegistrationErrorMap();
        ComputeFRE.ReadFiducials((Sequence)this.target.getValue());
        double[] f = ComputeFRE.PreComputeTRE();
        error = leftpoint.getDiffinpixels();
        error = error * ((Sequence)this.source.getValue()).getPixelSizeX() * 1000.0;
        predictederror = ComputeFRE.ComputeTRE(FLEmax, (int)leftpoint.first.getX(), (int)leftpoint.first.getY(), 0, f);
        System.out.println(name + " Discrepancy in nm: " + error + "vs Predicted error in nm: " + predictederror);
        this.curve.add(predictederror, error);
        return check;
    }

    public double maxdifferrorinnm() {
        if (this.sourcepoints.length < 5) {
            double error = Math.max(((Sequence)this.source.getValue()).getPixelSizeX(), ((Sequence)this.target.getValue()).getPixelSizeX());
            error = 4.0 * error * 1000.0;
            return error;
        }
        double error = 200.0;
        if (this.sourcepoints != null && this.targetpoints.length == this.sourcepoints.length) {
            if (!this.mode3D) {
                this.fiducialsvector = this.createVectorfromdoublearray(this.sourcepoints, this.targetpoints);
                double newerror = 0.0;
                for (int index = 0; index < this.fiducialsvector.size(); ++index) {
                    newerror += this.fiducialsvector.get(index).getDiffinpixels() * ((Sequence)this.source.getValue()).getPixelSizeX() * 1000.0;
                }
                if ((newerror /= (double)this.fiducialsvector.size()) > error) {
                    error = newerror;
                }
            } else {
                this.fiducialsvector3D = this.createVectorfromdoublearray3D(this.sourcepoints, this.targetpoints);
                double newerror = 0.0;
                for (int index = 0; index < this.fiducialsvector3D.size(); ++index) {
                    newerror = this.fiducialsvector3D.get(index).getDiffinpixels() * ((Sequence)this.source.getValue()).getPixelSizeX() * 1000.0;
                }
                if ((newerror /= (double)this.fiducialsvector.size()) > error) {
                    error = newerror;
                }
            }
        }
        return error;
    }
}

