/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.easyclemv0;

import Jama.Matrix;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.frame.progress.ToolTipFrame;
import icy.gui.util.GuiUtil;
import icy.main.Icy;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.type.point.Point5D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.BoxAndWhiskerToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import org.jfree.ui.RectangleInsets;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.kernel.roi.roi3d.ROI3DPoint;
import plugins.perrine.easyclemv0.PPPoint3D;
import plugins.perrine.easyclemv0.PointsPair;
import plugins.perrine.easyclemv0.PointsPair3D;
import plugins.perrine.easyclemv0.SimilarityRegistrationAnalytic;
import plugins.perrine.easyclemv0.SimilarityRegistrationAnalytic3D;
import plugins.perrine.easyclemv0.SimilarityTransformation2D;
import plugins.perrine.easyclemv0.SimilarityTransformation3D;
import plugins.perrine.easyclemv0.TargetRegistrationErrorMap;
import vtk.vtkAbstractTransform;
import vtk.vtkDataObject;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkThinPlateSplineTransform;
import vtk.vtkTransformPolyDataFilter;
import vtk.vtkVertexGlyphFilter;

public class MonteCarloTREStudy_Validation
extends EzPlug
implements EzStoppable {
    private EzVarSequence source;
    EzVarBoolean withFLE = new EzVarBoolean("Including target localisation error", false);
    EzVarDouble uFLE = new EzVarDouble("Fiducial localisation error in nm", 200.0, 0.0, 1.0E7, 10.0);
    EzVarInteger simulnumber = new EzVarInteger("Nb MonteCarlo Simulations", 100, 10, 10000, 10);
    Sequence target;
    EzVarText choiceinputsection = new EzVarText("I want to study the transformation in:", new String[]{"Rigid and prediction", "compare with non Rigid"}, 0, Boolean.valueOf(false));
    private double[][] sourcepoints;
    private double[][] targetpoints;
    private double[][] backuptargetpoints;
    private double[][] backupsourcepoints;
    private boolean mode3D = false;
    private Vector<PointsPair> fiducialsvector;
    private Vector<PointsPair3D> fiducialsvector3D;
    private ArrayList<ROI> backuproitarget;
    private ArrayList<ROI> backuproisource;
    boolean stopflag;
    Random generator = new Random();
    JPanel mainPanel;
    IcyFrame mainFrame;
    private YIntervalSeries curve1;
    private YIntervalSeries curve2;
    private YIntervalSeries curve3;
    private String namep;
    private Sequence sourceseq;
    private FileWriter write;

    public void clean() {
    }

    private vtkPoints createvtkpoints(double[][] points, double sizex, double sizey, double sizez) {
        vtkPoints mypoints = new vtkPoints();
        mypoints.SetNumberOfPoints((long)points.length);
        for (int i = 0; i < points.length; ++i) {
            mypoints.SetPoint((long)i, points[i][0] * sizex, points[i][1] * sizey, 0.0);
        }
        return mypoints;
    }

    protected double computenonrigid(double[][] lmsourcepts, double[][] lmtargetpts, Point2D test, double[] targetpoint) {
        vtkPoints lmsource = this.createvtkpoints(lmsourcepts, this.sourceseq.getPixelSizeX(), this.sourceseq.getPixelSizeY(), this.sourceseq.getPixelSizeZ());
        vtkPoints lmtarget = this.createvtkpoints(lmtargetpts, this.sourceseq.getPixelSizeX(), this.sourceseq.getPixelSizeY(), this.sourceseq.getPixelSizeZ());
        vtkThinPlateSplineTransform myvtkTransform = new vtkThinPlateSplineTransform();
        myvtkTransform.SetSourceLandmarks(lmsource);
        myvtkTransform.SetTargetLandmarks(lmtarget);
        myvtkTransform.SetBasisToR2LogR();
        vtkTransformPolyDataFilter tr = new vtkTransformPolyDataFilter();
        vtkPolyData mypoints = new vtkPolyData();
        vtkPoints mytestpoint = new vtkPoints();
        mytestpoint.SetNumberOfPoints(1L);
        mytestpoint.SetPoint(0L, test.getX() * this.sourceseq.getPixelSizeX(), test.getY() * this.sourceseq.getPixelSizeY(), 0.0);
        mypoints.SetPoints(mytestpoint);
        vtkVertexGlyphFilter vertexfilter = new vtkVertexGlyphFilter();
        vertexfilter.SetInputData((vtkDataObject)mypoints);
        vtkPolyData sourcepolydata = new vtkPolyData();
        vertexfilter.Update();
        sourcepolydata.ShallowCopy((vtkDataObject)vertexfilter.GetOutput());
        tr.SetInputData((vtkDataObject)sourcepolydata);
        tr.SetTransform((vtkAbstractTransform)myvtkTransform);
        tr.Update();
        vtkPolyData modifiedpoints = tr.GetOutput();
        double distanceinum = Math.sqrt(Math.pow(modifiedpoints.GetPoint(0L)[0] - targetpoint[0] * this.sourceseq.getPixelSizeX(), 2.0) + Math.pow(modifiedpoints.GetPoint(0L)[1] - targetpoint[1] * this.sourceseq.getPixelSizeY(), 2.0));
        return distanceinum * 1000.0;
    }

    protected void execute() {
        boolean nonrigid = false;
        if (((String)this.choiceinputsection.getValue()).contains("compare with non Rigid")) {
            nonrigid = true;
        }
        this.stopflag = false;
        this.sourceseq = (Sequence)this.source.getValue();
        if (this.sourceseq == null) {
            new AnnounceFrame("Open an image with Rois on it first !!!");
            return;
        }
        if (this.sourceseq.getROIs().size() < 4) {
            new AnnounceFrame("Open an image with Rois on it first !!!");
            return;
        }
        try {
            this.target = SequenceUtil.getCopy((Sequence)this.sourceseq);
            Icy.getMainInterface().addSequence(this.target);
            ArrayList listr = this.sourceseq.getROIs();
            int k = 0;
            for (ROI roi : listr) {
                roi.setName("Point " + ++k);
                this.target.addROI(roi.getCopy());
            }
            this.GetTargetPointsfromROI();
            this.GetSourcePointsfromROI();
            if (this.sourcepoints.length != this.targetpoints.length) {
                System.out.println("source points different from target point");
                return;
            }
            this.curve1 = new YIntervalSeries((Comparable)((Object)"Discrepancy"));
            this.curve2 = new YIntervalSeries((Comparable)((Object)"Predicted Error"));
            if (nonrigid) {
                this.curve3 = new YIntervalSeries((Comparable)((Object)"Non rigid discrepancy"));
            }
            this.backuproitarget = new ArrayList();
            this.backuproisource = new ArrayList();
            this.backuptargetpoints = new double[this.targetpoints.length][3];
            this.backupsourcepoints = new double[this.sourcepoints.length][3];
            for (int i = 0; i < this.targetpoints.length; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.backuptargetpoints[i][j] = this.targetpoints[i][j];
                    this.backupsourcepoints[i][j] = this.sourcepoints[i][j];
                }
                ROI3DPoint tmproit = new ROI3DPoint(((ROI)this.target.getROIs().get(i)).getPosition5D());
                tmproit.setName(((ROI)this.target.getROIs().get(i)).getName());
                if (tmproit.getPosition5D().getZ() < 0.0) {
                    tmproit.getPosition5D().setZ(0.0);
                }
                this.backuproitarget.add((ROI)tmproit);
                ROI3DPoint tmprois = new ROI3DPoint(((ROI)this.sourceseq.getROIs().get(i)).getPosition5D());
                tmprois.setName(((ROI)this.sourceseq.getROIs().get(i)).getName());
                if (tmprois.getPosition5D().getZ() < 0.0) {
                    tmprois.getPosition5D().setZ(0.0);
                }
                this.backuproisource.add((ROI)tmprois);
            }
            if (!this.mode3D) {
                this.fiducialsvector = this.createVectorfromdoublearray(this.sourcepoints, this.targetpoints);
                this.fiducialsvector3D = new Vector();
            } else {
                this.fiducialsvector3D = this.createVectorfromdoublearray3D(this.sourcepoints, this.targetpoints);
                this.fiducialsvector = new Vector();
            }
            this.ComputeTransfo(true);
            this.CheckTREvsFRE();
            double FLE = (Double)this.uFLE.getValue();
            int nbsimul = (Integer)this.simulnumber.getValue();
            ProgressFrame myprogressbar = new ProgressFrame("Computing simulations...");
            myprogressbar.setLength((double)(nbsimul * this.backupsourcepoints.length));
            myprogressbar.setPosition(0.0);
            DefaultBoxAndWhiskerCategoryDataset dataset2 = new DefaultBoxAndWhiskerCategoryDataset();
            try {
                if (!nonrigid) {
                    this.write = new FileWriter("TREVALIDATION.csv");
                    this.write.append("name;p;mc;dist;tre_measured;tre_predicted\n");
                } else {
                    this.write = new FileWriter("TREVALIDATIONwithnorigid.csv");
                    this.write.append("name;p;mc;dist;tre_measured;tre_predicted;tre_nonrigid\n");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (int p = 0; p < this.backupsourcepoints.length && !this.stopflag; ++p) {
                int i;
                ArrayList<double[]> datap = new ArrayList<double[]>();
                ArrayList<double[]> datanr = new ArrayList<double[]>();
                for (int mc = 0; mc < nbsimul; ++mc) {
                    myprogressbar.setPosition((double)(p * nbsimul + mc));
                    ArrayList<ROI3DPoint> tmpcopyroisource = new ArrayList<ROI3DPoint>();
                    ArrayList<ROI3DPoint> tmpcopyroitarget = new ArrayList<ROI3DPoint>();
                    for (int i2 = 0; i2 < this.backupsourcepoints.length; ++i2) {
                        ROI3DPoint tmproit = new ROI3DPoint(this.backuproitarget.get(i2).getPosition5D());
                        tmproit.setName(this.backuproitarget.get(i2).getName());
                        if (tmproit.getPosition5D().getZ() < 0.0) {
                            tmproit.getPosition5D().setZ(0.0);
                        }
                        tmpcopyroisource.add(tmproit);
                        ROI3DPoint tmprois = new ROI3DPoint(this.backuproisource.get(i2).getPosition5D());
                        tmprois.setName(this.backuproisource.get(i2).getName());
                        if (tmprois.getPosition5D().getZ() < 0.0) {
                            tmprois.getPosition5D().setZ(0.0);
                        }
                        tmpcopyroitarget.add(tmprois);
                    }
                    if (this.stopflag) break;
                    this.target.removeAllROI();
                    this.sourceseq.removeAllROI();
                    this.target.addROIs(tmpcopyroitarget, false);
                    this.sourceseq.addROIs(tmpcopyroisource, false);
                    this.shakeRois(this.target, FLE * 2.0);
                    this.shakeRois(this.sourceseq, FLE * 2.0);
                    ArrayList listfiducialst = this.target.getROIs();
                    this.ReOrder(listfiducialst);
                    ArrayList listfiducialss = this.sourceseq.getROIs();
                    this.ReOrder(listfiducialss);
                    this.namep = ((ROI)listfiducialst.get(p)).getName();
                    this.target.removeROI((ROI)listfiducialst.get(p));
                    this.sourceseq.removeROI((ROI)listfiducialss.get(p));
                    this.GetTargetPointsfromROI();
                    this.GetSourcePointsfromROI();
                    if (!this.mode3D) {
                        this.fiducialsvector = this.createVectorfromdoublearray(this.sourcepoints, this.targetpoints);
                        this.fiducialsvector3D = new Vector();
                    } else {
                        this.fiducialsvector3D = this.createVectorfromdoublearray3D(this.sourcepoints, this.targetpoints);
                        this.fiducialsvector = new Vector();
                    }
                    if (nonrigid) {
                        Point2D testPointnr = new Point2D.Double(this.backupsourcepoints[p][0], this.backupsourcepoints[p][1]);
                        if (((Boolean)this.withFLE.getValue()).booleanValue()) {
                            testPointnr = this.shakeOnePoint(this.sourceseq, FLE * 2.0, testPointnr);
                        }
                        double tre_nr = this.computenonrigid(this.sourcepoints, this.targetpoints, testPointnr, this.backuptargetpoints[p]);
                        double[] tre_nnr = new double[]{tre_nr};
                        datanr.add(tre_nnr);
                    }
                    SimilarityTransformation2D newtransfo = this.ComputeTransfo(false);
                    Point2D testPoint = new Point2D.Double(this.backupsourcepoints[p][0], this.backupsourcepoints[p][1]);
                    if (((Boolean)this.withFLE.getValue()).booleanValue()) {
                        testPoint = this.shakeOnePoint(this.sourceseq, FLE * 2.0, testPoint);
                    }
                    newtransfo.apply(testPoint);
                    PointsPair outpoint = new PointsPair(testPoint, new Point2D.Double(this.backuptargetpoints[p][0], this.backuptargetpoints[p][1]));
                    this.CheckTREvsFREmc(outpoint, ((ROI)listfiducialst.get(p)).getName(), datap);
                }
                double averageerror = 0.0;
                double maxerror = 0.0;
                double minerror = 1000.0;
                double averagepredictederror = 0.0;
                double averagedist = 0.0;
                double maxperror = 0.0;
                double minperror = 1000.0;
                double averageerrornr = 0.0;
                double maxerrornr = 0.0;
                double minerrornr = 1000.0;
                ArrayList<Double> list = new ArrayList<Double>();
                ArrayList<Double> list2 = new ArrayList<Double>();
                ArrayList<Double> listnr = new ArrayList<Double>();
                for (i = 0; i < datap.size(); ++i) {
                    averageerror += ((double[])datap.get(i))[1];
                    averagepredictederror += ((double[])datap.get(i))[0];
                    maxperror = Math.max(maxperror, ((double[])datap.get(i))[0]);
                    maxerror = Math.max(maxerror, ((double[])datap.get(i))[1]);
                    minperror = Math.min(minperror, ((double[])datap.get(i))[0]);
                    minerror = Math.min(minerror, ((double[])datap.get(i))[1]);
                    averagedist += ((double[])datap.get(i))[2];
                    list.add(((double[])datap.get(i))[1]);
                    list2.add(((double[])datap.get(i))[0]);
                    if (!nonrigid) continue;
                    listnr.add(((double[])datanr.get(i))[0]);
                    averageerrornr += ((double[])datanr.get(i))[0];
                    maxerrornr = Math.max(maxerrornr, ((double[])datanr.get(i))[0]);
                    minerrornr = Math.min(minerrornr, ((double[])datanr.get(i))[0]);
                }
                this.curve1.add(averagedist /= (double)datap.size(), averageerror /= (double)datap.size(), minerror, maxerror);
                this.curve2.add(averagedist, averagepredictederror /= (double)datap.size(), minperror, maxperror);
                dataset2.add(list, (Comparable)((Object)"Left one out discrepancy (Ground truth TRE)"), (Comparable)((Object)("ROI " + this.namep)));
                dataset2.add(list2, (Comparable)((Object)"Predicted TRE "), (Comparable)((Object)("ROI " + this.namep)));
                if (nonrigid) {
                    this.curve3.add(averagedist, averageerrornr /= (double)datanr.size(), minerrornr, maxerrornr);
                    dataset2.add(listnr, (Comparable)((Object)"Left one out discrepancy with Non Rigid transfo"), (Comparable)((Object)("ROI " + this.namep)));
                }
                try {
                    for (i = 0; i < datap.size(); ++i) {
                        double[] tt = (double[])datap.get(i);
                        if (!nonrigid) {
                            this.write.append(this.namep + ";" + p + ";" + i + ";" + tt[2] + ";" + tt[1] + ";" + tt[0] + "\n");
                            continue;
                        }
                        this.write.append(this.namep + ";" + p + ";" + i + ";" + tt[2] + ";" + tt[1] + ";" + tt[0] + ";" + ((double[])datanr.get(i))[0] + "\n");
                    }
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                this.write.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.target.removeAllROI();
            this.sourceseq.removeAllROI();
            this.target.addROIs(this.backuproitarget, false);
            this.sourceseq.addROIs(this.backuproisource, false);
            YIntervalSeriesCollection dataset = new YIntervalSeriesCollection();
            dataset.addSeries(this.curve1);
            dataset.addSeries(this.curve2);
            if (nonrigid) {
                dataset.addSeries(this.curve3);
            }
            JFreeChart jfreechart = MonteCarloTREStudy_Validation.CreateChart(dataset, nbsimul, FLE);
            ChartPanel chartPanel = new ChartPanel(jfreechart);
            chartPanel.setFillZoomRectangle(true);
            chartPanel.setMouseWheelEnabled(true);
            chartPanel.setPreferredSize(new Dimension(500, 270));
            this.mainPanel = GuiUtil.generatePanel((String)"Graph");
            this.mainFrame = GuiUtil.generateTitleFrame((String)"Real configuration Error MC Simulations", (JPanel)this.mainPanel, (Dimension)new Dimension(300, 100), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
            this.mainPanel.add(chartPanel);
            this.mainFrame.pack();
            this.addIcyFrame(this.mainFrame);
            this.mainFrame.setVisible(true);
            this.mainFrame.center();
            this.mainFrame.requestFocus();
            this.WhiskerPlot(dataset2);
            myprogressbar.close();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void WhiskerPlot(DefaultBoxAndWhiskerCategoryDataset dataset2) {
        CategoryAxis xAxis = new CategoryAxis("Left Out Point");
        NumberAxis yAxis = new NumberAxis("in nanometers");
        yAxis.setAutoRangeIncludesZero(true);
        BoxAndWhiskerRenderer renderer = new BoxAndWhiskerRenderer();
        renderer.setFillBox(true);
        renderer.setMeanVisible(true);
        renderer.setBaseToolTipGenerator(new BoxAndWhiskerToolTipGenerator());
        CategoryPlot plot = new CategoryPlot(dataset2, xAxis, yAxis, renderer);
        plot.setDomainGridlinesVisible(true);
        plot.setRangePannable(true);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        JFreeChart chart2 = new JFreeChart("Discrepancy distribution for TRE per ROI", JFreeChart.DEFAULT_TITLE_FONT, plot, true);
        ChartPanel chartPanel = new ChartPanel(chart2);
        chartPanel.setPreferredSize(new Dimension(450, 270));
        this.mainPanel.add(chartPanel);
    }

    private Point2D shakeOnePoint(Sequence seq, double FLE, Point2D point) {
        double FLEp = FLE / (seq.getPixelSizeX() * 1000.0);
        double higher = Math.sqrt(FLEp * FLEp / 3.0);
        point.setLocation(point.getX() + this.generator.nextGaussian() * (higher / 2.0), point.getY() + this.generator.nextGaussian() * (higher / 2.0));
        return point;
    }

    private void shakeRois(Sequence seq, double FLE) {
        ArrayList listfiducials = seq.getROIs();
        double FLEp = FLE / (seq.getPixelSizeX() * 1000.0);
        double FLEpz = FLE / (seq.getPixelSizeZ() * 1000.0);
        double higher = Math.sqrt(FLEp * FLEp / 3.0);
        double lowerz = -FLEpz;
        double higherz = FLEpz;
        for (ROI roi : listfiducials) {
            Point5D position = roi.getPosition5D();
            position.setX(position.getX() + this.generator.nextGaussian() * (higher / 2.0));
            position.setY(position.getY() + this.generator.nextGaussian() * (higher / 2.0));
            if (this.mode3D) {
                position.setZ(position.getZ() + Math.random() * (higherz - lowerz) + lowerz);
            } else {
                position.setZ(0.0);
            }
            roi.setPosition5D(position);
        }
    }

    private static JFreeChart CreateChart(YIntervalSeriesCollection dataset, int mc, double fle) {
        JFreeChart chart = ChartFactory.createXYLineChart("Discrepancy vs error for " + mc + "  simulations, FLE= " + fle + "nm", "Distance from the center of gravity for the point removed ", "in nm", dataset, PlotOrientation.VERTICAL, true, true, false);
        chart.setBackgroundPaint(Color.white);
        XYPlot xyplot = (XYPlot)chart.getPlot();
        xyplot.setInsets(new RectangleInsets(5.0, 5.0, 5.0, 20.0));
        xyplot.setBackgroundPaint(Color.lightGray);
        xyplot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        xyplot.setDomainGridlinePaint(Color.white);
        xyplot.setRangeGridlinePaint(Color.white);
        DeviationRenderer deviationrenderer = new DeviationRenderer(true, false);
        deviationrenderer.setSeriesStroke(0, new BasicStroke(3.0f, 1, 1));
        deviationrenderer.setSeriesShapesVisible(0, true);
        deviationrenderer.setSeriesShapesVisible(1, true);
        deviationrenderer.setSeriesStroke(1, new BasicStroke(3.0f, 1, 1));
        deviationrenderer.setSeriesFillPaint(0, new Color(255, 200, 200));
        deviationrenderer.setSeriesFillPaint(1, new Color(200, 200, 255));
        xyplot.setRenderer(deviationrenderer);
        NumberAxis numberaxis = (NumberAxis)xyplot.getRangeAxis();
        numberaxis.setAutoRangeIncludesZero(true);
        numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return chart;
    }

    protected void initialize() {
        EzLabel textinfo1 = new EzLabel("Give information about error computation, usind leave one out as well.");
        new ToolTipFrame("<html><br>This plugin compute from a set of matching points: <br> <li> The accuracy with Monte Carlo Simulations <br>(moving randomly all points around their initial position with the FLE error),<br>  of the registration error of a point against its target position<br> when the point is left OUT the set of point for the registration (i.e N-1 points are used)</li><br><li> The predicted average  error on the same point, computed <b>without any ground truth</b></li> <br><b> FLE </b> is the localization error you ca expect, i.e basically the resolution of your image <br>(around 400 nm i Fluoresence for exemple),  <br>ROI Points should have similar names in both source and target image, such as Point 1, Point 2,..)</html>");
        this.source = new EzVarSequence("Select Image with Roi sets ");
        this.addEzComponent((EzComponent)this.source);
        this.addEzComponent((EzComponent)this.uFLE);
        this.addEzComponent((EzComponent)this.simulnumber);
        this.addEzComponent((EzComponent)textinfo1);
        this.addEzComponent((EzComponent)this.choiceinputsection);
        this.addEzComponent((EzComponent)this.withFLE);
    }

    void GetTargetPointsfromROI() {
        ArrayList listfiducials = this.target.getROIs();
        this.ReOrder(listfiducials);
        this.targetpoints = new double[listfiducials.size()][3];
        int i = -1;
        for (ROI roi : listfiducials) {
            Point5D p3D = roi.getPosition5D();
            this.targetpoints[++i][0] = p3D.getX();
            this.targetpoints[i][1] = p3D.getY();
            this.targetpoints[i][2] = p3D.getZ();
            if (!(this.targetpoints[i][2] < 0.0)) continue;
            this.targetpoints[i][2] = 0.0;
        }
    }

    void GetSourcePointsfromROI() {
        if (this.sourceseq == null) {
            MessageDialog.showDialog((String)"Make sure source image is openned");
            return;
        }
        ArrayList listfiducials = this.sourceseq.getROIs();
        this.ReOrder(listfiducials);
        this.sourcepoints = new double[listfiducials.size()][3];
        int i = -1;
        for (ROI roi : listfiducials) {
            Point5D p3D = roi.getPosition5D();
            this.sourcepoints[++i][0] = p3D.getX();
            this.sourcepoints[i][1] = p3D.getY();
            this.sourcepoints[i][2] = p3D.getZ();
            if (!(this.sourcepoints[i][2] < 0.0)) continue;
            this.sourcepoints[i][2] = 0.0;
        }
    }

    private void ReOrder(ArrayList<ROI> listfiducials) {
        boolean permut;
        int longueur = listfiducials.size();
        do {
            permut = false;
            for (int i = 0; i < longueur - 1; ++i) {
                if (listfiducials.get(i).getName().compareTo(listfiducials.get(i + 1).getName()) <= 0) continue;
                ROI tampon = listfiducials.get(i);
                listfiducials.set(i, listfiducials.get(i + 1));
                listfiducials.set(i + 1, tampon);
                permut = true;
            }
        } while (permut);
    }

    SimilarityTransformation2D ComputeTransfo(boolean message) {
        SimilarityTransformation2D newtransfo = null;
        if (this.fiducialsvector.size() > 2 || this.fiducialsvector3D.size() > 3) {
            double back_up_pixelsizex = this.sourceseq.getPixelSizeX();
            double back_up_pixelsizey = this.sourceseq.getPixelSizeY();
            double back_up_pixelsizez = this.sourceseq.getPixelSizeZ();
            if (!this.mode3D) {
                SimilarityRegistrationAnalytic meanfiducialsalgo = new SimilarityRegistrationAnalytic();
                newtransfo = message ? meanfiducialsalgo.apply(this.fiducialsvector) : meanfiducialsalgo.applynomessage(this.fiducialsvector);
                double pixelsizexum = this.target.getPixelSizeX();
                double pixelsizeyum = this.target.getPixelSizeY();
                this.sourceseq.setPixelSizeX(pixelsizexum);
                this.sourceseq.setPixelSizeY(pixelsizeyum);
                this.updateSourcePoints2D(newtransfo);
                this.updateRoi();
            } else if (!this.testcoplanarity(this.fiducialsvector3D) || this.fiducialsvector3D.size() >= 6) {
                SimilarityRegistrationAnalytic3D meanfiducialsalgo = new SimilarityRegistrationAnalytic3D();
                SimilarityTransformation3D newtransfo3 = meanfiducialsalgo.apply(this.fiducialsvector3D, back_up_pixelsizex, back_up_pixelsizey, back_up_pixelsizez, this.target.getPixelSizeX(), this.target.getPixelSizeY(), this.target.getPixelSizeZ());
                Matrix transfo = newtransfo3.getMatrix();
                if (transfo.get(2, 2) != 0.0) {
                    this.updateSourcePoints3D(newtransfo3);
                    this.updateRoi();
                }
            } else {
                System.out.println("Instability: One more point");
                new AnnounceFrame("The position of the points does not allow a correct 3D transform. \n You need at least 2 points in separate z (slice). \n You may want to consider a 2D transform (it will still transform the full stack).");
            }
        } else {
            System.out.println("One more point");
            if (this.mode3D) {
                new AnnounceFrame("No transformation will be computed with less than 4 points. You have placed " + this.fiducialsvector3D.size() + " points", 2);
            } else {
                new AnnounceFrame("No transformation will be computed with less than 3 points. You have placed " + this.fiducialsvector.size() + " points", 2);
            }
        }
        return newtransfo;
    }

    Vector<PointsPair> createVectorfromdoublearray(double[][] sourcepoints2, double[][] targetpoints2) {
        Vector<PointsPair> points = new Vector<PointsPair>();
        if (targetpoints2.length == sourcepoints2.length) {
            for (int i = 0; i < sourcepoints2.length; ++i) {
                points.addElement(new PointsPair(new Point2D.Double(sourcepoints2[i][0], sourcepoints2[i][1]), new Point2D.Double(targetpoints2[i][0], targetpoints2[i][1])));
            }
        }
        return points;
    }

    Vector<PointsPair3D> createVectorfromdoublearray3D(double[][] sourcepoints2, double[][] targetpoints2) {
        Vector<PointsPair3D> points = new Vector<PointsPair3D>();
        for (int i = 0; i < sourcepoints2.length; ++i) {
            points.addElement(new PointsPair3D(new PPPoint3D(sourcepoints2[i][0], sourcepoints2[i][1], sourcepoints2[i][2]), new PPPoint3D(targetpoints2[i][0], targetpoints2[i][1], targetpoints2[i][2])));
        }
        return points;
    }

    private void updateSourcePoints2D(SimilarityTransformation2D newtransfo) {
        for (int i = 0; i < this.sourcepoints.length; ++i) {
            Point2D.Double testPoint = new Point2D.Double(this.sourcepoints[i][0], this.sourcepoints[i][1]);
            newtransfo.apply(testPoint);
            this.sourcepoints[i][0] = ((Point2D)testPoint).getX();
            this.sourcepoints[i][1] = ((Point2D)testPoint).getY();
        }
    }

    void updateRoi() {
        ArrayList listfiducials = this.sourceseq.getROIs();
        this.ReOrder(listfiducials);
        int i = -1;
        for (ROI roi : listfiducials) {
            Point5D position = roi.getPosition5D();
            position.setX(this.sourcepoints[++i][0]);
            position.setY(this.sourcepoints[i][1]);
            position.setZ(this.sourcepoints[i][2]);
            roi.setPosition5D(position);
        }
    }

    private boolean testcoplanarity(Vector<PointsPair3D> fiducialsvector3d2) {
        boolean testsource = true;
        boolean testtarget = true;
        double zsource = fiducialsvector3d2.get((int)0).first.getZ();
        for (int i = 1; i < fiducialsvector3d2.size(); ++i) {
            PointsPair3D currentpair = fiducialsvector3d2.get(i);
            if (currentpair.first.getZ() == zsource) continue;
            testsource = false;
            break;
        }
        double ztarget = fiducialsvector3d2.get((int)0).second.getZ();
        for (int i = 1; i < fiducialsvector3d2.size(); ++i) {
            PointsPair3D currentpair = fiducialsvector3d2.get(i);
            if (currentpair.second.getZ() == ztarget) continue;
            testtarget = false;
            break;
        }
        return testsource || testtarget;
    }

    void updateSourcePoints3D(SimilarityTransformation3D newtransfo) {
        for (int i = 0; i < this.sourcepoints.length; ++i) {
            PPPoint3D testPoint = new PPPoint3D(this.sourcepoints[i][0], this.sourcepoints[i][1], this.sourcepoints[i][2]);
            newtransfo.apply(testPoint);
            this.sourcepoints[i][0] = testPoint.getX() / this.sourceseq.getPixelSizeX();
            this.sourcepoints[i][1] = testPoint.getY() / this.sourceseq.getPixelSizeY();
            this.sourcepoints[i][2] = testPoint.getZ() / this.sourceseq.getPixelSizeZ();
        }
    }

    private boolean CheckTREvsFRE() {
        boolean check;
        block4: {
            check = false;
            double error = 0.0;
            double predictederror = 0.0;
            double FLEmax = (Double)this.uFLE.getValue();
            TargetRegistrationErrorMap ComputeFRE = new TargetRegistrationErrorMap();
            ComputeFRE.ReadFiducials(this.target);
            double[] f = ComputeFRE.PreComputeTRE();
            if (this.sourcepoints == null && this.targetpoints == null) break block4;
            if (!this.mode3D) {
                ArrayList listfiducials = this.sourceseq.getROIs();
                this.ReOrder(listfiducials);
                this.fiducialsvector = this.createVectorfromdoublearray(this.sourcepoints, this.targetpoints);
                for (int index = 0; index < this.fiducialsvector.size(); ++index) {
                    error = this.fiducialsvector.get(index).getDiffinpixels();
                    if (!((error = error * this.sourceseq.getPixelSizeX() * 1000.0) > (predictederror = (double)ComputeFRE.ComputeTRE(FLEmax, (int)this.fiducialsvector.get((int)index).first.getX(), (int)this.fiducialsvector.get((int)index).first.getY(), 0, f)))) continue;
                    check = true;
                }
            } else {
                this.fiducialsvector3D = this.createVectorfromdoublearray3D(this.sourcepoints, this.targetpoints);
                for (int index = 0; index < this.fiducialsvector3D.size(); ++index) {
                    error = Math.sqrt(Math.pow((this.fiducialsvector3D.get(index).getfirstxinpixels() - this.fiducialsvector3D.get(index).getsecondxinpixels()) * this.sourceseq.getPixelSizeX(), 2.0) + Math.pow((this.fiducialsvector3D.get(index).getfirstyinpixels() - this.fiducialsvector3D.get(index).getsecondyinpixels()) * this.sourceseq.getPixelSizeY(), 2.0) + Math.pow((this.fiducialsvector3D.get(index).getfirstzinpixels() - this.fiducialsvector3D.get(index).getsecondzinpixels()) * this.sourceseq.getPixelSizeZ(), 2.0));
                    predictederror = ComputeFRE.ComputeTRE(FLEmax, (int)this.fiducialsvector3D.get(index).getfirstxinpixels(), (int)this.fiducialsvector3D.get(index).getfirstyinpixels(), (int)this.fiducialsvector3D.get(index).getfirstzinpixels(), f);
                    if (!((error *= 1000.0) > predictederror)) continue;
                    check = true;
                }
            }
        }
        return check;
    }

    private boolean CheckTREvsFREmc(PointsPair leftpoint, String name, ArrayList<double[]> datap) {
        boolean check = false;
        double error = 0.0;
        double predictederror = 0.0;
        double FLEmax = (Double)this.uFLE.getValue();
        TargetRegistrationErrorMap ComputeFRE = new TargetRegistrationErrorMap();
        ComputeFRE.ReadFiducials(this.target);
        double[] f = ComputeFRE.PreComputeTRE();
        error = leftpoint.getDiffinpixels();
        error = error * this.sourceseq.getPixelSizeX() * 1000.0;
        predictederror = ComputeFRE.ComputeTRE(FLEmax, (int)leftpoint.first.getX(), (int)leftpoint.first.getY(), 0, f);
        double[] mytab = new double[]{predictederror, error, this.distancetogravitycenter(leftpoint.second, this.target)};
        datap.add(mytab);
        return check;
    }

    private double distancetogravitycenter(Point2D point, Sequence seqwithRois) {
        ArrayList listRoi = seqwithRois.getROIs();
        double GravityCenterX = 0.0;
        double GravityCenterY = 0.0;
        for (ROI roi : listRoi) {
            GravityCenterX += roi.getPosition5D().getX();
            GravityCenterY += roi.getPosition5D().getY();
        }
        double distance = Math.sqrt(Math.pow(point.getX() - (GravityCenterX /= (double)listRoi.size()), 2.0) + Math.pow(point.getY() - (GravityCenterY /= (double)listRoi.size()), 2.0));
        return distance * seqwithRois.getPixelSizeX() * 1000.0;
    }

    public double maxdifferrorinnm() {
        if (this.sourcepoints.length < 5) {
            double error = Math.max(this.sourceseq.getPixelSizeX(), this.target.getPixelSizeX());
            error = 4.0 * error * 1000.0;
            return error;
        }
        double error = 200.0;
        if (this.sourcepoints != null && this.targetpoints.length == this.sourcepoints.length) {
            if (!this.mode3D) {
                this.fiducialsvector = this.createVectorfromdoublearray(this.sourcepoints, this.targetpoints);
                double newerror = 0.0;
                for (int index = 0; index < this.fiducialsvector.size(); ++index) {
                    newerror += this.fiducialsvector.get(index).getDiffinpixels() * this.sourceseq.getPixelSizeX() * 1000.0;
                }
                if ((newerror /= (double)this.fiducialsvector.size()) > error) {
                    error = newerror;
                }
            } else {
                this.fiducialsvector3D = this.createVectorfromdoublearray3D(this.sourcepoints, this.targetpoints);
                double newerror = 0.0;
                for (int index = 0; index < this.fiducialsvector3D.size(); ++index) {
                    newerror = this.fiducialsvector3D.get(index).getDiffinpixels() * this.sourceseq.getPixelSizeX() * 1000.0;
                }
                if ((newerror /= (double)this.fiducialsvector.size()) > error) {
                    error = newerror;
                }
            }
        }
        return error;
    }

    public void stopExecution() {
        this.stopflag = true;
    }
}

