/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.easyclemv0;

import Jama.Matrix;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.frame.progress.ToolTipFrame;
import icy.gui.util.GuiUtil;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.type.point.Point5D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.BoxAndWhiskerToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import org.jfree.ui.RectangleInsets;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.kernel.roi.descriptor.measure.ROIMassCenterDescriptorsPlugin;
import plugins.kernel.roi.roi3d.ROI3DPoint;
import plugins.perrine.easyclemv0.PPPoint3D;
import plugins.perrine.easyclemv0.PointsPair;
import plugins.perrine.easyclemv0.PointsPair3D;
import plugins.perrine.easyclemv0.SimilarityRegistrationAnalytic;
import plugins.perrine.easyclemv0.SimilarityRegistrationAnalytic3D;
import plugins.perrine.easyclemv0.SimilarityTransformation2D;
import plugins.perrine.easyclemv0.SimilarityTransformation3D;
import plugins.perrine.easyclemv0.TargetRegistrationErrorMap;

public class MonteCarloTREstudy
extends EzPlug
implements EzStoppable {
    private EzVarSequence source;
    private EzVarSequence target;
    EzVarDouble uFLE = new EzVarDouble("Fiducial localisation error in nm", 200.0, 0.0, 10000.0, 10.0);
    EzVarInteger simulnumber = new EzVarInteger("Nb MonteCarlo Simulations", 100, 10, 10000, 10);
    Sequence backupsource;
    EzVarText choiceinputsection = new EzVarText("I want to study the transformation in:", new String[]{"Rigid (or affine)", "non Rigid)"}, 0, Boolean.valueOf(false));
    private double[][] sourcepoints;
    private double[][] targetpoints;
    private double[][] backuptargetpoints;
    private double[][] backupsourcepoints;
    private boolean mode3D = false;
    private Vector<PointsPair> fiducialsvector;
    private Vector<PointsPair3D> fiducialsvector3D;
    private ArrayList<ROI> backuproitarget;
    private ArrayList<ROI> backuproisource;
    boolean stopflag;
    Random generator = new Random();
    JPanel mainPanel = GuiUtil.generatePanel((String)"Graph");
    IcyFrame mainFrame = GuiUtil.generateTitleFrame((String)"Real configuration Error MC Simulations", (JPanel)this.mainPanel, (Dimension)new Dimension(300, 100), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
    private YIntervalSeries curve1;
    private YIntervalSeries curve2;
    private String namep;

    public void clean() {
    }

    protected void execute() {
        this.mainPanel = GuiUtil.generatePanel((String)"Graph");
        this.mainFrame = GuiUtil.generateTitleFrame((String)"Real configuration Error MC Simulations", (JPanel)this.mainPanel, (Dimension)new Dimension(300, 100), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        this.stopflag = false;
        this.GetTargetPointsfromROI();
        this.GetSourcePointsfromROI();
        if (this.sourcepoints.length != this.targetpoints.length) {
            System.out.println("source points different from target point");
            return;
        }
        this.curve1 = new YIntervalSeries((Comparable)((Object)"Discrepancy"));
        this.curve2 = new YIntervalSeries((Comparable)((Object)"Predicted Error"));
        this.backuproitarget = new ArrayList();
        this.backuproisource = new ArrayList();
        this.backuptargetpoints = new double[this.targetpoints.length][3];
        this.backupsourcepoints = new double[this.sourcepoints.length][3];
        for (int i = 0; i < this.targetpoints.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.backuptargetpoints[i][j] = this.targetpoints[i][j];
                this.backupsourcepoints[i][j] = this.sourcepoints[i][j];
            }
            this.backuproitarget.add((ROI)new ROI3DPoint(((ROI)((Sequence)this.target.getValue()).getROIs().get(i)).getPosition5D()));
            this.backuproisource.add((ROI)new ROI3DPoint(((ROI)((Sequence)this.source.getValue()).getROIs().get(i)).getPosition5D()));
        }
        if (!this.mode3D) {
            this.fiducialsvector = this.createVectorfromdoublearray(this.sourcepoints, this.targetpoints);
            this.fiducialsvector3D = new Vector();
        } else {
            this.fiducialsvector3D = this.createVectorfromdoublearray3D(this.sourcepoints, this.targetpoints);
            this.fiducialsvector = new Vector();
        }
        this.ComputeTransfo(true);
        this.CheckTREvsFRE();
        double FLE = (Double)this.uFLE.getValue();
        int nbsimul = (Integer)this.simulnumber.getValue();
        ProgressFrame myprogressbar = new ProgressFrame("Computing simulations...");
        myprogressbar.setLength((double)(nbsimul * this.backupsourcepoints.length));
        myprogressbar.setPosition(0.0);
        DefaultBoxAndWhiskerCategoryDataset dataset2 = new DefaultBoxAndWhiskerCategoryDataset();
        for (int p = 0; p < this.backupsourcepoints.length && !this.stopflag; ++p) {
            ArrayList<double[]> datap = new ArrayList<double[]>();
            for (int mc = 0; mc < nbsimul; ++mc) {
                myprogressbar.setPosition((double)(p * nbsimul + mc));
                ArrayList<ROI3DPoint> tmpcopyroisource = new ArrayList<ROI3DPoint>();
                ArrayList<ROI3DPoint> tmpcopyroitarget = new ArrayList<ROI3DPoint>();
                for (int i = 0; i < this.backupsourcepoints.length; ++i) {
                    tmpcopyroisource.add(new ROI3DPoint(this.backuproitarget.get(i).getPosition5D()));
                    tmpcopyroitarget.add(new ROI3DPoint(this.backuproisource.get(i).getPosition5D()));
                }
                if (this.stopflag) break;
                ((Sequence)this.target.getValue()).removeAllROI();
                ((Sequence)this.source.getValue()).removeAllROI();
                ((Sequence)this.target.getValue()).addROIs(tmpcopyroitarget, false);
                ((Sequence)this.source.getValue()).addROIs(tmpcopyroisource, false);
                this.shakeRois((Sequence)this.target.getValue(), FLE * 2.0);
                this.shakeRois((Sequence)this.source.getValue(), FLE * 2.0);
                ArrayList listfiducialst = ((Sequence)this.target.getValue()).getROIs();
                this.ReOrder(listfiducialst);
                ArrayList listfiducialss = ((Sequence)this.source.getValue()).getROIs();
                this.ReOrder(listfiducialss);
                this.namep = ((ROI)listfiducialst.get(p)).getName();
                ((Sequence)this.target.getValue()).removeROI((ROI)listfiducialst.get(p));
                ((Sequence)this.source.getValue()).removeROI((ROI)listfiducialss.get(p));
                this.GetTargetPointsfromROI();
                this.GetSourcePointsfromROI();
                if (!this.mode3D) {
                    this.fiducialsvector = this.createVectorfromdoublearray(this.sourcepoints, this.targetpoints);
                    this.fiducialsvector3D = new Vector();
                } else {
                    this.fiducialsvector3D = this.createVectorfromdoublearray3D(this.sourcepoints, this.targetpoints);
                    this.fiducialsvector = new Vector();
                }
                SimilarityTransformation2D newtransfo = this.ComputeTransfo(false);
                Point2D.Double testPoint = new Point2D.Double(this.backupsourcepoints[p][0], this.backupsourcepoints[p][1]);
                newtransfo.apply(testPoint);
                PointsPair outpoint = new PointsPair(testPoint, new Point2D.Double(this.backuptargetpoints[p][0], this.backuptargetpoints[p][1]));
                this.CheckTREvsFREmc(outpoint, ((ROI)listfiducialst.get(p)).getName(), datap);
            }
            double averageerror = 0.0;
            double maxerror = 0.0;
            double minerror = 1000.0;
            double averagepredictederror = 0.0;
            double averagedist = 0.0;
            double maxperror = 0.0;
            double minperror = 1000.0;
            ArrayList<Double> list = new ArrayList<Double>();
            ArrayList<Double> list2 = new ArrayList<Double>();
            for (int i = 0; i < datap.size(); ++i) {
                averageerror += ((double[])datap.get(i))[1];
                averagepredictederror += ((double[])datap.get(i))[0];
                maxperror = Math.max(maxperror, ((double[])datap.get(i))[0]);
                maxerror = Math.max(maxerror, ((double[])datap.get(i))[1]);
                minperror = Math.min(minperror, ((double[])datap.get(i))[0]);
                minerror = Math.min(minerror, ((double[])datap.get(i))[1]);
                averagedist += ((double[])datap.get(i))[2];
                list.add(((double[])datap.get(i))[1]);
                list2.add(((double[])datap.get(i))[0]);
            }
            this.curve1.add(averagedist /= (double)datap.size(), averageerror /= (double)datap.size(), minerror, maxerror);
            this.curve2.add(averagedist, averagepredictederror /= (double)datap.size(), minperror, maxperror);
            dataset2.add(list, (Comparable)((Object)"Left one out discrepancy (Ground truth TRE)"), (Comparable)((Object)("ROI " + this.namep)));
            dataset2.add(list2, (Comparable)((Object)"Predicted TRE "), (Comparable)((Object)("ROI " + this.namep)));
        }
        ((Sequence)this.target.getValue()).removeAllROI();
        ((Sequence)this.source.getValue()).removeAllROI();
        ((Sequence)this.target.getValue()).addROIs(this.backuproitarget, false);
        ((Sequence)this.source.getValue()).addROIs(this.backuproisource, false);
        YIntervalSeriesCollection dataset = new YIntervalSeriesCollection();
        dataset.addSeries(this.curve1);
        dataset.addSeries(this.curve2);
        JFreeChart jfreechart = MonteCarloTREstudy.CreateChart(dataset, nbsimul, FLE);
        ChartPanel chartPanel = new ChartPanel(jfreechart);
        chartPanel.setFillZoomRectangle(true);
        chartPanel.setMouseWheelEnabled(true);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.mainPanel.add(chartPanel);
        this.mainFrame.pack();
        this.addIcyFrame(this.mainFrame);
        this.mainFrame.setVisible(true);
        this.mainFrame.center();
        this.mainFrame.requestFocus();
        this.WhiskerPlot(dataset2);
        myprogressbar.close();
    }

    private void WhiskerPlot(DefaultBoxAndWhiskerCategoryDataset dataset2) {
        CategoryAxis xAxis = new CategoryAxis("Left Out Point");
        NumberAxis yAxis = new NumberAxis("in nanometers");
        yAxis.setAutoRangeIncludesZero(true);
        BoxAndWhiskerRenderer renderer = new BoxAndWhiskerRenderer();
        renderer.setFillBox(true);
        renderer.setMeanVisible(true);
        renderer.setBaseToolTipGenerator(new BoxAndWhiskerToolTipGenerator());
        CategoryPlot plot = new CategoryPlot(dataset2, xAxis, yAxis, renderer);
        plot.setDomainGridlinesVisible(true);
        plot.setRangePannable(true);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        JFreeChart chart2 = new JFreeChart("Discrepancy distribution for TRE per ROI", JFreeChart.DEFAULT_TITLE_FONT, plot, true);
        ChartPanel chartPanel = new ChartPanel(chart2);
        chartPanel.setPreferredSize(new Dimension(450, 270));
        this.mainPanel.add(chartPanel);
    }

    private void shakeRois(Sequence seq, double FLE) {
        ArrayList listfiducials = seq.getROIs();
        double FLEp = FLE / (seq.getPixelSizeX() * 1000.0);
        double FLEpz = FLE / (seq.getPixelSizeZ() * 1000.0);
        double higher = Math.sqrt(FLEp * FLEp / 3.0);
        double lowerz = -FLEpz;
        double higherz = FLEpz;
        for (ROI roi : listfiducials) {
            Point5D position = roi.getPosition5D();
            position.setX(position.getX() + this.generator.nextGaussian() * (higher / 2.0));
            position.setY(position.getY() + this.generator.nextGaussian() * (higher / 2.0));
            if (this.mode3D) {
                position.setZ(position.getZ() + Math.random() * (higherz - lowerz) + lowerz);
            }
            roi.setPosition5D(position);
        }
    }

    private static JFreeChart CreateChart(YIntervalSeriesCollection dataset, int mc, double fle) {
        JFreeChart chart = ChartFactory.createXYLineChart("Discrepancy vs error for " + mc + "  simulations, FLE= " + fle + "nm", "Distance from the center of gravity for the point removed ", "in nm", dataset, PlotOrientation.VERTICAL, true, true, false);
        chart.setBackgroundPaint(Color.white);
        XYPlot xyplot = (XYPlot)chart.getPlot();
        xyplot.setInsets(new RectangleInsets(5.0, 5.0, 5.0, 20.0));
        xyplot.setBackgroundPaint(Color.lightGray);
        xyplot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        xyplot.setDomainGridlinePaint(Color.white);
        xyplot.setRangeGridlinePaint(Color.white);
        DeviationRenderer deviationrenderer = new DeviationRenderer(true, false);
        deviationrenderer.setSeriesStroke(0, new BasicStroke(3.0f, 1, 1));
        deviationrenderer.setSeriesShapesVisible(0, true);
        deviationrenderer.setSeriesShapesVisible(1, true);
        deviationrenderer.setSeriesStroke(1, new BasicStroke(3.0f, 1, 1));
        deviationrenderer.setSeriesFillPaint(0, new Color(255, 200, 200));
        deviationrenderer.setSeriesFillPaint(1, new Color(200, 200, 255));
        xyplot.setRenderer(deviationrenderer);
        NumberAxis numberaxis = (NumberAxis)xyplot.getRangeAxis();
        numberaxis.setAutoRangeIncludesZero(true);
        numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return chart;
    }

    protected void initialize() {
        EzLabel textinfo1 = new EzLabel("Give information about error computation, usind leave one out as well.");
        new ToolTipFrame("<html><br>This plugin compute from a set of matching points: <br> <li> The accuracy with Monte Carlo Simulations <br>(moving randomly all points around their initial position with the FLE error),<br>  of the registration error of a point against its target position<br> when the point is left OUT the set of point for the registration (i.e N-1 points are used)</li><br><li> The predicted average  error on the same point, computed <b>without any ground truth</b></li> <br><b> FLE </b> is the localization error you ca expect, i.e basically the resolution of your image <br>(around 400 nm i Fluoresence for exemple),  <br>ROI Points should have similar names in both source and target image, such as Point 1, Point 2,..)</html>");
        this.source = new EzVarSequence("Select Source Image ");
        this.target = new EzVarSequence("Select Target Image ");
        this.addEzComponent((EzComponent)this.source);
        this.addEzComponent((EzComponent)this.target);
        this.addEzComponent((EzComponent)this.uFLE);
        this.addEzComponent((EzComponent)this.simulnumber);
        this.addEzComponent((EzComponent)textinfo1);
        new ToolTipFrame("Use a set of Roi as generated by Ec-Clem on 2 images.\n Pay attention to the image metadata (pixel size)");
    }

    void GetTargetPointsfromROI() {
        ArrayList listfiducials = ((Sequence)this.target.getValue()).getROIs();
        this.ReOrder(listfiducials);
        this.targetpoints = new double[listfiducials.size()][3];
        int i = -1;
        for (ROI roi : listfiducials) {
            ++i;
            Point5D p3D = null;
            try {
                p3D = ROIMassCenterDescriptorsPlugin.computeMassCenter((ROI)roi);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (Double.isNaN(p3D.getX())) {
                p3D = roi.getPosition5D();
            }
            if (roi.getClassName() == "plugins.perrine.easyclemv0.myRoi3D") {
                p3D = roi.getPosition5D();
            }
            if (roi.getClassName() == "plugins.kernel.roi.roi2d.ROI2DPoint") {
                p3D = roi.getPosition5D();
            }
            this.targetpoints[i][0] = p3D.getX();
            this.targetpoints[i][1] = p3D.getY();
            this.targetpoints[i][2] = p3D.getZ();
            this.targetpoints[i][2] = p3D.getZ();
        }
    }

    void GetSourcePointsfromROI() {
        if (this.source.getValue() == null) {
            MessageDialog.showDialog((String)"Make sure source image is openned");
            return;
        }
        ArrayList listfiducials = ((Sequence)this.source.getValue()).getROIs();
        this.ReOrder(listfiducials);
        this.sourcepoints = new double[listfiducials.size()][3];
        int i = -1;
        for (ROI roi : listfiducials) {
            ++i;
            Point5D p3D = null;
            try {
                p3D = ROIMassCenterDescriptorsPlugin.computeMassCenter((ROI)roi);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (roi.getClassName() == "plugins.perrine.easyclemv0.myRoi3D") {
                p3D = roi.getPosition5D();
            }
            if (roi.getClassName() == "plugins.kernel.roi.roi2d.ROI2DPoint") {
                p3D = roi.getPosition5D();
            }
            if (Double.isNaN(p3D.getX())) {
                p3D = roi.getPosition5D();
            }
            this.sourcepoints[i][0] = p3D.getX();
            this.sourcepoints[i][1] = p3D.getY();
            this.sourcepoints[i][2] = p3D.getZ();
        }
    }

    private void ReOrder(ArrayList<ROI> listfiducials) {
        boolean permut;
        int longueur = listfiducials.size();
        do {
            permut = false;
            for (int i = 0; i < longueur - 1; ++i) {
                if (listfiducials.get(i).getName().compareTo(listfiducials.get(i + 1).getName()) <= 0) continue;
                ROI tampon = listfiducials.get(i);
                listfiducials.set(i, listfiducials.get(i + 1));
                listfiducials.set(i + 1, tampon);
                permut = true;
            }
        } while (permut);
    }

    SimilarityTransformation2D ComputeTransfo(boolean message) {
        SimilarityTransformation2D newtransfo = null;
        if (this.fiducialsvector.size() > 2 || this.fiducialsvector3D.size() > 3) {
            double back_up_pixelsizex = ((Sequence)this.source.getValue()).getPixelSizeX();
            double back_up_pixelsizey = ((Sequence)this.source.getValue()).getPixelSizeY();
            double back_up_pixelsizez = ((Sequence)this.source.getValue()).getPixelSizeZ();
            if (!this.mode3D) {
                SimilarityRegistrationAnalytic meanfiducialsalgo = new SimilarityRegistrationAnalytic();
                newtransfo = message ? meanfiducialsalgo.apply(this.fiducialsvector) : meanfiducialsalgo.applynomessage(this.fiducialsvector);
                double pixelsizexum = ((Sequence)this.target.getValue()).getPixelSizeX();
                double pixelsizeyum = ((Sequence)this.target.getValue()).getPixelSizeY();
                ((Sequence)this.source.getValue()).setPixelSizeX(pixelsizexum);
                ((Sequence)this.source.getValue()).setPixelSizeY(pixelsizeyum);
                this.updateSourcePoints2D(newtransfo);
                this.updateRoi();
            } else if (!this.testcoplanarity(this.fiducialsvector3D) || this.fiducialsvector3D.size() >= 6) {
                SimilarityRegistrationAnalytic3D meanfiducialsalgo = new SimilarityRegistrationAnalytic3D();
                SimilarityTransformation3D newtransfo3 = meanfiducialsalgo.apply(this.fiducialsvector3D, back_up_pixelsizex, back_up_pixelsizey, back_up_pixelsizez, ((Sequence)this.target.getValue()).getPixelSizeX(), ((Sequence)this.target.getValue()).getPixelSizeY(), ((Sequence)this.target.getValue()).getPixelSizeZ());
                Matrix transfo = newtransfo3.getMatrix();
                if (transfo.get(2, 2) != 0.0) {
                    this.updateSourcePoints3D(newtransfo3);
                    this.updateRoi();
                }
            } else {
                System.out.println("Instability: One more point");
                new AnnounceFrame("The position of the points does not allow a correct 3D transform. \n You need at least 2 points in separate z (slice). \n You may want to consider a 2D transform (it will still transform the full stack).");
            }
        } else {
            System.out.println("One more point");
            if (this.mode3D) {
                new AnnounceFrame("No transformation will be computed with less than 4 points. You have placed " + this.fiducialsvector3D.size() + " points", 2);
            } else {
                new AnnounceFrame("No transformation will be computed with less than 3 points. You have placed " + this.fiducialsvector.size() + " points", 2);
            }
        }
        return newtransfo;
    }

    Vector<PointsPair> createVectorfromdoublearray(double[][] sourcepoints2, double[][] targetpoints2) {
        Vector<PointsPair> points = new Vector<PointsPair>();
        if (targetpoints2.length == sourcepoints2.length) {
            for (int i = 0; i < sourcepoints2.length; ++i) {
                points.addElement(new PointsPair(new Point2D.Double(sourcepoints2[i][0], sourcepoints2[i][1]), new Point2D.Double(targetpoints2[i][0], targetpoints2[i][1])));
            }
        }
        return points;
    }

    Vector<PointsPair3D> createVectorfromdoublearray3D(double[][] sourcepoints2, double[][] targetpoints2) {
        Vector<PointsPair3D> points = new Vector<PointsPair3D>();
        for (int i = 0; i < sourcepoints2.length; ++i) {
            points.addElement(new PointsPair3D(new PPPoint3D(sourcepoints2[i][0], sourcepoints2[i][1], sourcepoints2[i][2]), new PPPoint3D(targetpoints2[i][0], targetpoints2[i][1], targetpoints2[i][2])));
        }
        return points;
    }

    private void updateSourcePoints2D(SimilarityTransformation2D newtransfo) {
        for (int i = 0; i < this.sourcepoints.length; ++i) {
            Point2D.Double testPoint = new Point2D.Double(this.sourcepoints[i][0], this.sourcepoints[i][1]);
            newtransfo.apply(testPoint);
            this.sourcepoints[i][0] = ((Point2D)testPoint).getX();
            this.sourcepoints[i][1] = ((Point2D)testPoint).getY();
        }
    }

    void updateRoi() {
        ArrayList listfiducials = ((Sequence)this.source.getValue()).getROIs();
        this.ReOrder(listfiducials);
        int i = -1;
        for (ROI roi : listfiducials) {
            Point5D position = roi.getPosition5D();
            position.setX(this.sourcepoints[++i][0]);
            position.setY(this.sourcepoints[i][1]);
            position.setZ(this.sourcepoints[i][2]);
            roi.setPosition5D(position);
        }
    }

    private boolean testcoplanarity(Vector<PointsPair3D> fiducialsvector3d2) {
        boolean testsource = true;
        boolean testtarget = true;
        double zsource = fiducialsvector3d2.get((int)0).first.getZ();
        for (int i = 1; i < fiducialsvector3d2.size(); ++i) {
            PointsPair3D currentpair = fiducialsvector3d2.get(i);
            if (currentpair.first.getZ() == zsource) continue;
            testsource = false;
            break;
        }
        double ztarget = fiducialsvector3d2.get((int)0).second.getZ();
        for (int i = 1; i < fiducialsvector3d2.size(); ++i) {
            PointsPair3D currentpair = fiducialsvector3d2.get(i);
            if (currentpair.second.getZ() == ztarget) continue;
            testtarget = false;
            break;
        }
        return testsource || testtarget;
    }

    void updateSourcePoints3D(SimilarityTransformation3D newtransfo) {
        for (int i = 0; i < this.sourcepoints.length; ++i) {
            PPPoint3D testPoint = new PPPoint3D(this.sourcepoints[i][0], this.sourcepoints[i][1], this.sourcepoints[i][2]);
            newtransfo.apply(testPoint);
            this.sourcepoints[i][0] = testPoint.getX() / ((Sequence)this.source.getValue()).getPixelSizeX();
            this.sourcepoints[i][1] = testPoint.getY() / ((Sequence)this.source.getValue()).getPixelSizeY();
            this.sourcepoints[i][2] = testPoint.getZ() / ((Sequence)this.source.getValue()).getPixelSizeZ();
        }
    }

    private boolean CheckTREvsFRE() {
        boolean check;
        block4: {
            check = false;
            double error = 0.0;
            double predictederror = 0.0;
            double FLEmax = (Double)this.uFLE.getValue();
            TargetRegistrationErrorMap ComputeFRE = new TargetRegistrationErrorMap();
            ComputeFRE.ReadFiducials((Sequence)this.target.getValue());
            double[] f = ComputeFRE.PreComputeTRE();
            if (this.sourcepoints == null && this.targetpoints == null) break block4;
            if (!this.mode3D) {
                ArrayList listfiducials = ((Sequence)this.source.getValue()).getROIs();
                this.ReOrder(listfiducials);
                this.fiducialsvector = this.createVectorfromdoublearray(this.sourcepoints, this.targetpoints);
                for (int index = 0; index < this.fiducialsvector.size(); ++index) {
                    error = this.fiducialsvector.get(index).getDiffinpixels();
                    if (!((error = error * ((Sequence)this.source.getValue()).getPixelSizeX() * 1000.0) > (predictederror = (double)ComputeFRE.ComputeTRE(FLEmax, (int)this.fiducialsvector.get((int)index).first.getX(), (int)this.fiducialsvector.get((int)index).first.getY(), 0, f)))) continue;
                    check = true;
                }
            } else {
                this.fiducialsvector3D = this.createVectorfromdoublearray3D(this.sourcepoints, this.targetpoints);
                for (int index = 0; index < this.fiducialsvector3D.size(); ++index) {
                    error = Math.sqrt(Math.pow((this.fiducialsvector3D.get(index).getfirstxinpixels() - this.fiducialsvector3D.get(index).getsecondxinpixels()) * ((Sequence)this.source.getValue()).getPixelSizeX(), 2.0) + Math.pow((this.fiducialsvector3D.get(index).getfirstyinpixels() - this.fiducialsvector3D.get(index).getsecondyinpixels()) * ((Sequence)this.source.getValue()).getPixelSizeY(), 2.0) + Math.pow((this.fiducialsvector3D.get(index).getfirstzinpixels() - this.fiducialsvector3D.get(index).getsecondzinpixels()) * ((Sequence)this.source.getValue()).getPixelSizeZ(), 2.0));
                    predictederror = ComputeFRE.ComputeTRE(FLEmax, (int)this.fiducialsvector3D.get(index).getfirstxinpixels(), (int)this.fiducialsvector3D.get(index).getfirstyinpixels(), (int)this.fiducialsvector3D.get(index).getfirstzinpixels(), f);
                    if (!((error *= 1000.0) > predictederror)) continue;
                    check = true;
                }
            }
        }
        return check;
    }

    private boolean CheckTREvsFREmc(PointsPair leftpoint, String name, ArrayList<double[]> datap) {
        boolean check = false;
        double error = 0.0;
        double predictederror = 0.0;
        double FLEmax = (Double)this.uFLE.getValue();
        TargetRegistrationErrorMap ComputeFRE = new TargetRegistrationErrorMap();
        ComputeFRE.ReadFiducials((Sequence)this.target.getValue());
        double[] f = ComputeFRE.PreComputeTRE();
        error = leftpoint.getDiffinpixels();
        error = error * ((Sequence)this.source.getValue()).getPixelSizeX() * 1000.0;
        predictederror = ComputeFRE.ComputeTRE(FLEmax, (int)leftpoint.first.getX(), (int)leftpoint.first.getY(), 0, f);
        double[] mytab = new double[]{predictederror, error, this.distancetogravitycenter(leftpoint.second, (Sequence)this.target.getValue())};
        datap.add(mytab);
        return check;
    }

    private double distancetogravitycenter(Point2D point, Sequence seqwithRois) {
        ArrayList listRoi = seqwithRois.getROIs();
        double GravityCenterX = 0.0;
        double GravityCenterY = 0.0;
        for (ROI roi : listRoi) {
            GravityCenterX += roi.getPosition5D().getX();
            GravityCenterY += roi.getPosition5D().getY();
        }
        double distance = Math.sqrt(Math.pow(point.getX() - (GravityCenterX /= (double)listRoi.size()), 2.0) + Math.pow(point.getY() - (GravityCenterY /= (double)listRoi.size()), 2.0));
        return distance * seqwithRois.getPixelSizeX() * 1000.0;
    }

    public double maxdifferrorinnm() {
        if (this.sourcepoints.length < 5) {
            double error = Math.max(((Sequence)this.source.getValue()).getPixelSizeX(), ((Sequence)this.target.getValue()).getPixelSizeX());
            error = 4.0 * error * 1000.0;
            return error;
        }
        double error = 200.0;
        if (this.sourcepoints != null && this.targetpoints.length == this.sourcepoints.length) {
            if (!this.mode3D) {
                this.fiducialsvector = this.createVectorfromdoublearray(this.sourcepoints, this.targetpoints);
                double newerror = 0.0;
                for (int index = 0; index < this.fiducialsvector.size(); ++index) {
                    newerror += this.fiducialsvector.get(index).getDiffinpixels() * ((Sequence)this.source.getValue()).getPixelSizeX() * 1000.0;
                }
                if ((newerror /= (double)this.fiducialsvector.size()) > error) {
                    error = newerror;
                }
            } else {
                this.fiducialsvector3D = this.createVectorfromdoublearray3D(this.sourcepoints, this.targetpoints);
                double newerror = 0.0;
                for (int index = 0; index < this.fiducialsvector3D.size(); ++index) {
                    newerror = this.fiducialsvector3D.get(index).getDiffinpixels() * ((Sequence)this.source.getValue()).getPixelSizeX() * 1000.0;
                }
                if ((newerror /= (double)this.fiducialsvector.size()) > error) {
                    error = newerror;
                }
            }
        }
        return error;
    }

    public void stopExecution() {
        this.stopflag = true;
    }
}

