/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.easyclemv0;

import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.DataType;
import icy.util.XMLUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import vtk.vtkAbstractTransform;
import vtk.vtkDataArray;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkDoubleArray;
import vtk.vtkFloatArray;
import vtk.vtkImageContinuousDilate3D;
import vtk.vtkImageData;
import vtk.vtkImageGridSource;
import vtk.vtkImageReslice;
import vtk.vtkIntArray;
import vtk.vtkPointData;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkShortArray;
import vtk.vtkThinPlateSplineTransform;
import vtk.vtkTransformPolyDataFilter;
import vtk.vtkUnsignedCharArray;
import vtk.vtkUnsignedIntArray;
import vtk.vtkUnsignedShortArray;
import vtk.vtkVertexGlyphFilter;

public class NonRigidTranformationVTK
implements Runnable {
    private double InputSpacingx;
    private double InputSpacingy;
    private double InputSpacingz;
    private Sequence imagesource;
    private Sequence imagetarget;
    private vtkDataSet[] imageData;
    private vtkImageReslice ImageReslice;
    double[][] sourcepoints;
    double[][] targetpoints;
    private int extentx;
    private int extenty;
    private int extentz;
    private double spacingx;
    private double spacingy;
    private double spacingz;
    private Runnable transformer;
    private boolean checkgrid;

    @Override
    public void run() {
        vtkPoints lmsource = this.createvtkpoints(this.sourcepoints, this.InputSpacingx, this.InputSpacingy, this.InputSpacingz);
        vtkPoints lmtarget = this.createvtkpoints(this.targetpoints, this.spacingx, this.spacingy, this.spacingz);
        this.SaveNonRigidTransform(lmsource, lmtarget);
        final vtkThinPlateSplineTransform myvtkTransform = new vtkThinPlateSplineTransform();
        myvtkTransform.SetSourceLandmarks(lmsource);
        myvtkTransform.SetTargetLandmarks(lmtarget);
        if (this.extentz <= 1) {
            myvtkTransform.SetBasisToR2LogR();
        } else {
            myvtkTransform.SetBasisToR();
        }
        final int nbc = this.imagesource.getSizeC();
        this.imageData = new vtkDataSet[nbc];
        final DataType datatype = this.imagesource.getDataType_();
        this.transformer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressFrame progress = new ProgressFrame("Applying the NON RIGID transformation...");
                progress.setLength(10.0);
                System.out.println("Starting to non rigidly register " + NonRigidTranformationVTK.this.imagesource.getFilename() + " on " + NonRigidTranformationVTK.this.imagetarget.getFilename());
                int nbt = NonRigidTranformationVTK.this.imagesource.getSizeT();
                int nbz = NonRigidTranformationVTK.this.extentz + 1;
                int w = NonRigidTranformationVTK.this.extentx + 1;
                int h = NonRigidTranformationVTK.this.extenty + 1;
                vtkImageGridSource sourcegrid = new vtkImageGridSource();
                if (NonRigidTranformationVTK.this.checkgrid) {
                    progress.setPosition(1.0);
                    sourcegrid.SetDataExtent(0, NonRigidTranformationVTK.this.extentx, 0, NonRigidTranformationVTK.this.extenty, 0, NonRigidTranformationVTK.this.extentz);
                    sourcegrid.SetLineValue(255.0);
                    sourcegrid.SetFillValue(0.0);
                    sourcegrid.SetDataScalarType(3);
                    sourcegrid.SetDataSpacing(NonRigidTranformationVTK.this.InputSpacingx, NonRigidTranformationVTK.this.InputSpacingy, NonRigidTranformationVTK.this.InputSpacingz);
                    sourcegrid.SetGridSpacing(Math.round(NonRigidTranformationVTK.this.extentx / 10), Math.round(NonRigidTranformationVTK.this.extenty / 10), Math.round(NonRigidTranformationVTK.this.extentz));
                    sourcegrid.Update();
                    vtkImageData imagedatagrid = new vtkImageData();
                    progress.setPosition(1.5);
                    if (NonRigidTranformationVTK.this.extentz <= 1) {
                        vtkImageContinuousDilate3D dilate = new vtkImageContinuousDilate3D();
                        dilate.SetInputData((vtkDataObject)sourcegrid.GetOutput());
                        dilate.SetKernelSize(NonRigidTranformationVTK.this.extentx / 400, NonRigidTranformationVTK.this.extenty / 400, 1);
                        dilate.Update();
                        imagedatagrid = dilate.GetOutput();
                    } else {
                        imagedatagrid = sourcegrid.GetOutput();
                    }
                    progress.setPosition(3.0);
                    vtkImageReslice ImageReslicegrid = new vtkImageReslice();
                    ImageReslicegrid.SetInputData((vtkDataObject)imagedatagrid);
                    ImageReslicegrid.SetOutputDimensionality(3);
                    ImageReslicegrid.SetOutputOrigin(0.0, 0.0, 0.0);
                    ImageReslicegrid.SetOutputSpacing(NonRigidTranformationVTK.this.spacingx, NonRigidTranformationVTK.this.spacingy, NonRigidTranformationVTK.this.spacingz);
                    ImageReslicegrid.SetOutputExtent(0, NonRigidTranformationVTK.this.extentx, 0, NonRigidTranformationVTK.this.extenty, 0, NonRigidTranformationVTK.this.extentz);
                    ImageReslicegrid.SetResliceTransform(myvtkTransform.GetInverse());
                    ImageReslicegrid.SetInterpolationModeToLinear();
                    ImageReslicegrid.Update();
                    progress.setPosition(4.0);
                    imagedatagrid = ImageReslicegrid.GetOutput();
                    progress.setPosition(5.0);
                    final Sequence grid = new Sequence();
                    grid.beginUpdate();
                    grid.removeAllImages();
                    try {
                        for (int z = 0; z < nbz; ++z) {
                            IcyBufferedImage image = new IcyBufferedImage(w, h, 1, DataType.UBYTE);
                            progress.setPosition(5.0 + (double)z * 2.5 / (double)NonRigidTranformationVTK.this.extentz);
                            vtkDataArray myvtkarray = imagedatagrid.GetPointData().GetScalars();
                            byte[] inData = ((vtkUnsignedCharArray)myvtkarray).GetJavaArray();
                            byte[] outData = new byte[w * h];
                            for (int i = 0; i < h; ++i) {
                                for (int j = 0; j < w; ++j) {
                                    outData[i * w + j] = inData[z * w * h + i * w + j];
                                }
                            }
                            image.setDataXYAsByte(0, outData);
                            grid.setImage(0, z, (BufferedImage)image);
                        }
                    }
                    finally {
                        grid.endUpdate();
                    }
                    grid.setName("Deformed source grid");
                    grid.setPixelSizeX(NonRigidTranformationVTK.this.spacingx);
                    grid.setPixelSizeY(NonRigidTranformationVTK.this.spacingy);
                    grid.setPixelSizeZ(NonRigidTranformationVTK.this.spacingz);
                    ThreadUtil.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            new Viewer(grid);
                        }
                    });
                }
                progress.setPosition(5.0);
                for (int c = 0; c < NonRigidTranformationVTK.this.imagesource.getSizeC(); ++c) {
                    NonRigidTranformationVTK.this.converttoVtkImageData(c);
                    NonRigidTranformationVTK.this.ImageReslice = new vtkImageReslice();
                    NonRigidTranformationVTK.this.ImageReslice.SetInputData((vtkDataObject)NonRigidTranformationVTK.this.imageData[c]);
                    NonRigidTranformationVTK.this.ImageReslice.SetOutputDimensionality(3);
                    NonRigidTranformationVTK.this.ImageReslice.SetOutputOrigin(0.0, 0.0, 0.0);
                    NonRigidTranformationVTK.this.ImageReslice.SetOutputSpacing(NonRigidTranformationVTK.this.spacingx, NonRigidTranformationVTK.this.spacingy, NonRigidTranformationVTK.this.spacingz);
                    NonRigidTranformationVTK.this.ImageReslice.SetOutputExtent(0, NonRigidTranformationVTK.this.extentx, 0, NonRigidTranformationVTK.this.extenty, 0, NonRigidTranformationVTK.this.extentz);
                    NonRigidTranformationVTK.this.ImageReslice.SetResliceTransform(myvtkTransform.GetInverse());
                    NonRigidTranformationVTK.this.ImageReslice.SetInterpolationModeToLinear();
                    NonRigidTranformationVTK.this.ImageReslice.Update();
                    ((NonRigidTranformationVTK)NonRigidTranformationVTK.this).imageData[c] = NonRigidTranformationVTK.this.ImageReslice.GetOutput();
                }
                NonRigidTranformationVTK.this.imagesource.beginUpdate();
                NonRigidTranformationVTK.this.imagesource.removeAllImages();
                try {
                    switch (datatype) {
                        case UBYTE: {
                            int j;
                            Object[] outData;
                            Object[] inData;
                            vtkDataArray myvtkarray;
                            int c;
                            IcyBufferedImage image;
                            int t;
                            for (t = 0; t < nbt; ++t) {
                                for (int z = 0; z < nbz; ++z) {
                                    image = new IcyBufferedImage(w, h, nbc, datatype);
                                    progress.setPosition(7.5 + (double)z * 2.5 / (double)NonRigidTranformationVTK.this.extentz);
                                    for (c = 0; c < nbc; ++c) {
                                        myvtkarray = NonRigidTranformationVTK.this.imageData[c].GetPointData().GetScalars();
                                        inData = ((vtkUnsignedCharArray)myvtkarray).GetJavaArray();
                                        outData = new byte[w * h];
                                        for (int i = 0; i < h; ++i) {
                                            for (j = 0; j < w; ++j) {
                                                outData[i * w + j] = inData[z * w * h + i * w + j];
                                            }
                                        }
                                        image.setDataXYAsByte(c, outData);
                                    }
                                    NonRigidTranformationVTK.this.imagesource.setImage(t, z, (BufferedImage)image);
                                }
                            }
                            break;
                        }
                        case BYTE: {
                            int j;
                            Object[] outData;
                            Object[] inData;
                            vtkDataArray myvtkarray;
                            int c;
                            IcyBufferedImage image;
                            int t;
                            for (t = 0; t < nbt; ++t) {
                                for (int z = 0; z < nbz; ++z) {
                                    image = new IcyBufferedImage(w, h, nbc, datatype);
                                    for (c = 0; c < nbc; ++c) {
                                        myvtkarray = NonRigidTranformationVTK.this.imageData[c].GetPointData().GetScalars();
                                        inData = ((vtkUnsignedCharArray)myvtkarray).GetJavaArray();
                                        outData = new byte[w * h];
                                        for (int i = 0; i < h; ++i) {
                                            for (j = 0; j < w; ++j) {
                                                outData[i * w + j] = inData[z * w * h + i * w + j];
                                            }
                                        }
                                        image.setDataXYAsByte(c, outData);
                                    }
                                    NonRigidTranformationVTK.this.imagesource.setImage(t, z, (BufferedImage)image);
                                }
                            }
                            break;
                        }
                        case USHORT: {
                            int j;
                            Object[] outData;
                            Object[] inData;
                            vtkDataArray myvtkarray;
                            int c;
                            IcyBufferedImage image;
                            int t;
                            for (t = 0; t < nbt; ++t) {
                                for (int z = 0; z < nbz; ++z) {
                                    image = new IcyBufferedImage(w, h, nbc, datatype);
                                    for (c = 0; c < nbc; ++c) {
                                        myvtkarray = NonRigidTranformationVTK.this.imageData[c].GetPointData().GetScalars();
                                        inData = ((vtkUnsignedShortArray)myvtkarray).GetJavaArray();
                                        outData = new short[w * h];
                                        for (int i = 0; i < h; ++i) {
                                            for (j = 0; j < w; ++j) {
                                                outData[i * w + j] = inData[z * w * h + i * w + j];
                                            }
                                        }
                                        image.setDataXYAsShort(c, (short[])outData);
                                    }
                                    NonRigidTranformationVTK.this.imagesource.setImage(t, z, (BufferedImage)image);
                                }
                            }
                            break;
                        }
                        case UINT: {
                            int j;
                            Object[] outData;
                            Object[] inData;
                            vtkDataArray myvtkarray;
                            int c;
                            IcyBufferedImage image;
                            int t;
                            for (t = 0; t < nbt; ++t) {
                                for (int z = 0; z < nbz; ++z) {
                                    image = new IcyBufferedImage(w, h, nbc, datatype);
                                    for (c = 0; c < nbc; ++c) {
                                        myvtkarray = NonRigidTranformationVTK.this.imageData[c].GetPointData().GetScalars();
                                        inData = ((vtkUnsignedIntArray)myvtkarray).GetJavaArray();
                                        outData = new int[w * h];
                                        for (int i = 0; i < h; ++i) {
                                            for (j = 0; j < w; ++j) {
                                                outData[i * w + j] = inData[z * w * h + i * w + j];
                                            }
                                        }
                                        image.setDataXYAsInt(c, (int[])outData);
                                    }
                                    NonRigidTranformationVTK.this.imagesource.setImage(t, z, (BufferedImage)image);
                                }
                            }
                            break;
                        }
                        case INT: {
                            int j;
                            Object[] outData;
                            Object[] inData;
                            vtkDataArray myvtkarray;
                            int c;
                            IcyBufferedImage image;
                            int t;
                            for (t = 0; t < nbt; ++t) {
                                for (int z = 0; z < nbz; ++z) {
                                    image = new IcyBufferedImage(w, h, nbc, datatype);
                                    for (c = 0; c < nbc; ++c) {
                                        myvtkarray = NonRigidTranformationVTK.this.imageData[c].GetPointData().GetScalars();
                                        inData = ((vtkIntArray)myvtkarray).GetJavaArray();
                                        outData = new int[w * h];
                                        for (int i = 0; i < h; ++i) {
                                            for (j = 0; j < w; ++j) {
                                                outData[i * w + j] = inData[z * w * h + i * w + j];
                                            }
                                        }
                                        image.setDataXYAsInt(c, (int[])outData);
                                    }
                                    NonRigidTranformationVTK.this.imagesource.setImage(t, z, (BufferedImage)image);
                                }
                            }
                            break;
                        }
                        case SHORT: {
                            int j;
                            Object[] outData;
                            Object[] inData;
                            vtkDataArray myvtkarray;
                            int c;
                            IcyBufferedImage image;
                            int t;
                            for (t = 0; t < nbt; ++t) {
                                for (int z = 0; z < nbz; ++z) {
                                    image = new IcyBufferedImage(w, h, nbc, datatype);
                                    for (c = 0; c < nbc; ++c) {
                                        myvtkarray = NonRigidTranformationVTK.this.imageData[c].GetPointData().GetScalars();
                                        inData = ((vtkShortArray)myvtkarray).GetJavaArray();
                                        outData = new short[w * h];
                                        for (int i = 0; i < h; ++i) {
                                            for (j = 0; j < w; ++j) {
                                                outData[i * w + j] = inData[z * w * h + i * w + j];
                                            }
                                        }
                                        image.setDataXYAsShort(c, (short[])outData);
                                    }
                                    NonRigidTranformationVTK.this.imagesource.setImage(t, z, (BufferedImage)image);
                                }
                            }
                            break;
                        }
                        case FLOAT: {
                            int j;
                            Object[] outData;
                            Object[] inData;
                            vtkDataArray myvtkarray;
                            int c;
                            IcyBufferedImage image;
                            int t;
                            for (t = 0; t < nbt; ++t) {
                                for (int z = 0; z < nbz; ++z) {
                                    image = new IcyBufferedImage(w, h, nbc, datatype);
                                    for (c = 0; c < nbc; ++c) {
                                        myvtkarray = NonRigidTranformationVTK.this.imageData[c].GetPointData().GetScalars();
                                        inData = ((vtkFloatArray)myvtkarray).GetJavaArray();
                                        outData = new float[w * h];
                                        for (int i = 0; i < h; ++i) {
                                            for (j = 0; j < w; ++j) {
                                                outData[i * w + j] = inData[z * w * h + i * w + j];
                                            }
                                        }
                                        image.setDataXYAsFloat(c, (float[])outData);
                                    }
                                    NonRigidTranformationVTK.this.imagesource.setImage(t, z, (BufferedImage)image);
                                }
                            }
                            break;
                        }
                        case DOUBLE: {
                            int j;
                            Object[] outData;
                            Object[] inData;
                            vtkDataArray myvtkarray;
                            int c;
                            IcyBufferedImage image;
                            int t;
                            for (t = 0; t < nbt; ++t) {
                                for (int z = 0; z < nbz; ++z) {
                                    image = new IcyBufferedImage(w, h, nbc, datatype);
                                    for (c = 0; c < nbc; ++c) {
                                        myvtkarray = NonRigidTranformationVTK.this.imageData[c].GetPointData().GetScalars();
                                        inData = ((vtkDoubleArray)myvtkarray).GetJavaArray();
                                        outData = new double[w * h];
                                        for (int i = 0; i < h; ++i) {
                                            for (j = 0; j < w; ++j) {
                                                outData[i * w + j] = inData[z * w * h + i * w + j];
                                            }
                                        }
                                        image.setDataXYAsDouble(c, (double[])outData);
                                    }
                                    NonRigidTranformationVTK.this.imagesource.setImage(t, z, (BufferedImage)image);
                                }
                            }
                            break;
                        }
                        default: {
                            System.err.println("unknown data format");
                        }
                    }
                    NonRigidTranformationVTK.this.imagesource.setPixelSizeX(NonRigidTranformationVTK.this.spacingx);
                    NonRigidTranformationVTK.this.imagesource.setPixelSizeY(NonRigidTranformationVTK.this.spacingy);
                    NonRigidTranformationVTK.this.imagesource.setPixelSizeZ(NonRigidTranformationVTK.this.spacingz);
                }
                finally {
                    NonRigidTranformationVTK.this.imagesource.endUpdate();
                    progress.setPosition(10.0);
                    progress.close();
                    new AnnounceFrame("Non Rigid Transformation Updated", 5);
                }
            }
        };
        ThreadUtil.bgRunSingle((Runnable)this.transformer);
        vtkTransformPolyDataFilter tr = new vtkTransformPolyDataFilter();
        vtkPolyData mypoints = new vtkPolyData();
        mypoints.SetPoints(lmsource);
        vtkVertexGlyphFilter vertexfilter = new vtkVertexGlyphFilter();
        vertexfilter.SetInputData((vtkDataObject)mypoints);
        vtkPolyData sourcepolydata = new vtkPolyData();
        vertexfilter.Update();
        sourcepolydata.ShallowCopy((vtkDataObject)vertexfilter.GetOutput());
        tr.SetInputData((vtkDataObject)sourcepolydata);
        tr.SetTransform((vtkAbstractTransform)myvtkTransform);
        tr.Update();
        vtkPolyData modifiedpoints = tr.GetOutput();
        int p = 0;
        while ((long)p < modifiedpoints.GetNumberOfPoints()) {
            double[] newpos = modifiedpoints.GetPoint((long)p);
            this.sourcepoints[p][0] = newpos[0] / this.spacingx;
            this.sourcepoints[p][1] = newpos[1] / this.spacingy;
            this.sourcepoints[p][2] = newpos[2] / this.spacingz;
            ++p;
        }
        System.out.println("have been applied");
    }

    private void SaveNonRigidTransform(vtkPoints lmsource, vtkPoints lmtarget) {
        String name = this.imagesource.getFilename() + "_NONRIGIDtransfo.xml";
        File XMLFile = new File(name);
        Document document = XMLUtil.createDocument((boolean)true);
        Element transfoElement = XMLUtil.addElement((Node)document.getDocumentElement(), (String)"transfoelements");
        XMLUtil.setAttributeIntValue((Element)transfoElement, (String)"extentx", (int)this.extentx);
        XMLUtil.setAttributeIntValue((Element)transfoElement, (String)"extenty", (int)this.extenty);
        XMLUtil.setAttributeIntValue((Element)transfoElement, (String)"extentz", (int)this.extentz);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"sx", (double)this.spacingx);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"sy", (double)this.spacingy);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"sz", (double)this.spacingz);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"ix", (double)this.InputSpacingx);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"iy", (double)this.InputSpacingy);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"iz", (double)this.InputSpacingz);
        XMLUtil.setAttributeIntValue((Element)transfoElement, (String)"Npoints", (int)((int)lmsource.GetNumberOfPoints()));
        XMLUtil.setAttributeValue((Element)transfoElement, (String)"process_date", (String)new Date().toString());
        int idx = 0;
        while ((long)idx < lmsource.GetNumberOfPoints()) {
            Element PointPairElement = XMLUtil.addElement((Node)document.getDocumentElement(), (String)"pointspairsinphysicalcoordinates");
            XMLUtil.setAttributeIntValue((Element)PointPairElement, (String)"pairnumber", (int)idx);
            XMLUtil.setAttributeDoubleValue((Element)PointPairElement, (String)"xsource", (double)lmsource.GetPoint((long)idx)[0]);
            XMLUtil.setAttributeDoubleValue((Element)PointPairElement, (String)"ysource", (double)lmsource.GetPoint((long)idx)[1]);
            XMLUtil.setAttributeDoubleValue((Element)PointPairElement, (String)"zsource", (double)lmsource.GetPoint((long)idx)[2]);
            XMLUtil.setAttributeDoubleValue((Element)PointPairElement, (String)"xtarget", (double)lmtarget.GetPoint((long)idx)[0]);
            XMLUtil.setAttributeDoubleValue((Element)PointPairElement, (String)"ytarget", (double)lmtarget.GetPoint((long)idx)[1]);
            XMLUtil.setAttributeDoubleValue((Element)PointPairElement, (String)"ztarget", (double)lmtarget.GetPoint((long)idx)[2]);
            ++idx;
        }
        XMLUtil.saveDocument((Document)document, (File)XMLFile);
        System.out.println("Elements to reapply non rigid transfo as been saved as " + XMLFile.getPath());
        System.out.println("If there is no path indicated, it means it is in your ICY installation path");
    }

    public void setImageSourceandpoints(boolean checkgrid, Sequence imagesourceseq, double[][] sourcepoints) {
        this.checkgrid = checkgrid;
        this.imagesource = imagesourceseq;
        this.InputSpacingx = this.imagesource.getPixelSizeX();
        this.InputSpacingy = this.imagesource.getPixelSizeY();
        this.InputSpacingz = this.imagesource.getPixelSizeZ();
        this.sourcepoints = sourcepoints;
    }

    public void setImageTargetandpoints(Sequence imageseq, double[][] sourcepoints) {
        this.imagetarget = imageseq;
        int w = imageseq.getSizeX();
        int h = imageseq.getSizeY();
        int z = imageseq.getSizeZ();
        this.extentx = w - 1;
        this.extenty = h - 1;
        this.extentz = z - 1;
        this.spacingx = imageseq.getPixelSizeX();
        this.spacingy = imageseq.getPixelSizeY();
        this.spacingz = imageseq.getPixelSizeZ();
        this.targetpoints = sourcepoints;
    }

    private vtkPoints createvtkpoints(double[][] points, double sizex, double sizey, double sizez) {
        vtkPoints mypoints = new vtkPoints();
        mypoints.SetNumberOfPoints((long)points.length);
        for (int i = 0; i < points.length; ++i) {
            mypoints.SetPoint((long)i, points[i][0] * sizex, points[i][1] * sizey, points[i][2] * sizez);
        }
        return mypoints;
    }

    void converttoVtkImageData(int posC) {
        vtkPointData pointData;
        Sequence sequence2 = this.imagesource;
        if (this.imagesource == null) {
            return;
        }
        int sizeX = sequence2.getSizeX();
        int sizeY = sequence2.getSizeY();
        int sizeZ = sequence2.getSizeZ();
        DataType dataType = sequence2.getDataType_();
        boolean posT = false;
        vtkImageData newImageData = new vtkImageData();
        newImageData.SetDimensions(sizeX, sizeY, sizeZ);
        newImageData.SetSpacing(this.InputSpacingx, this.InputSpacingy, this.InputSpacingz);
        switch (dataType) {
            case UBYTE: {
                newImageData.AllocateScalars(3, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkUnsignedCharArray)array).SetJavaArray(this.imagesource.getDataCopyCXYZAsByte(0));
                    break;
                }
                ((vtkUnsignedCharArray)array).SetJavaArray(this.imagesource.getDataCopyXYZAsByte(0, posC));
                break;
            }
            case BYTE: {
                newImageData.AllocateScalars(3, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkUnsignedCharArray)array).SetJavaArray(this.imagesource.getDataCopyCXYZAsByte(0));
                    break;
                }
                ((vtkUnsignedCharArray)array).SetJavaArray(this.imagesource.getDataCopyXYZAsByte(0, posC));
                break;
            }
            case USHORT: {
                newImageData.AllocateScalars(5, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkUnsignedShortArray)array).SetJavaArray(this.imagesource.getDataCopyCXYZAsShort(0));
                    break;
                }
                ((vtkUnsignedShortArray)array).SetJavaArray(this.imagesource.getDataCopyXYZAsShort(0, posC));
                break;
            }
            case SHORT: {
                newImageData.AllocateScalars(4, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkShortArray)array).SetJavaArray(this.imagesource.getDataCopyCXYZAsShort(0));
                    break;
                }
                ((vtkShortArray)array).SetJavaArray(this.imagesource.getDataCopyXYZAsShort(0, posC));
                break;
            }
            case UINT: {
                newImageData.AllocateScalars(7, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkUnsignedIntArray)array).SetJavaArray(this.imagesource.getDataCopyCXYZAsInt(0));
                    break;
                }
                ((vtkUnsignedIntArray)array).SetJavaArray(this.imagesource.getDataCopyXYZAsInt(0, posC));
                break;
            }
            case INT: {
                newImageData.AllocateScalars(6, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkIntArray)array).SetJavaArray(this.imagesource.getDataCopyCXYZAsInt(0));
                    break;
                }
                ((vtkIntArray)array).SetJavaArray(this.imagesource.getDataCopyXYZAsInt(0, posC));
                break;
            }
            case FLOAT: {
                newImageData.AllocateScalars(10, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkFloatArray)array).SetJavaArray(this.imagesource.getDataCopyCXYZAsFloat(0));
                    break;
                }
                ((vtkFloatArray)array).SetJavaArray(this.imagesource.getDataCopyXYZAsFloat(0, posC));
                break;
            }
            case DOUBLE: {
                newImageData.AllocateScalars(11, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkDoubleArray)array).SetJavaArray(this.imagesource.getDataCopyCXYZAsDouble(0));
                    break;
                }
                ((vtkDoubleArray)array).SetJavaArray(this.imagesource.getDataCopyXYZAsDouble(0, posC));
                break;
            }
            default: {
                newImageData.SetDimensions(1, 1, 1);
                newImageData.SetSpacing(this.imagesource.getPixelSizeX(), this.imagesource.getPixelSizeY(), this.imagesource.getPixelSizeZ());
                newImageData.SetNumberOfScalarComponents(1, null);
                newImageData.SetExtent(0, 0, 0, 0, 0, 0);
                newImageData.AllocateScalars(null);
            }
        }
        if (this.imageData[posC] != null && (pointData = this.imageData[posC].GetPointData()) != null) {
            vtkDataArray dataArray = pointData.GetScalars();
            if (dataArray != null) {
                dataArray.Delete();
            }
            pointData.Delete();
            this.imageData[posC].ReleaseData();
            this.imageData[posC].Delete();
        }
        this.imageData[posC] = newImageData;
    }
}

