/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.easyclemv0;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import icy.util.Random;
import java.util.Enumeration;
import java.util.Vector;
import plugins.perrine.easyclemv0.PointsPair3D;
import plugins.perrine.easyclemv0.SimilarityTransformation3D;

public class SimilarityRegistrationAnalytic3D {
    public SimilarityTransformation3D apply(Vector<PointsPair3D> fiducials) {
        double smeanx = 0.0;
        double smeany = 0.0;
        double smeanz = 0.0;
        double tmeanx = 0.0;
        double tmeany = 0.0;
        double tmeanz = 0.0;
        Enumeration<PointsPair3D> fiducialsE = fiducials.elements();
        while (fiducialsE.hasMoreElements()) {
            PointsPair3D pair = fiducialsE.nextElement();
            smeanx += pair.first.getX();
            smeany += pair.first.getY();
            tmeanx += pair.second.getX();
            tmeany += pair.second.getY();
            smeanz += pair.first.getZ();
            tmeanz += pair.second.getZ();
        }
        int numPoints = fiducials.size();
        smeanx /= (double)numPoints;
        smeany /= (double)numPoints;
        tmeanx /= (double)numPoints;
        tmeany /= (double)numPoints;
        smeanz /= (double)numPoints;
        tmeanz /= (double)numPoints;
        fiducialsE = fiducials.elements();
        while (fiducialsE.hasMoreElements()) {
            PointsPair3D pair = fiducialsE.nextElement();
            pair.first.setLocation(pair.first.getX() - smeanx, pair.first.getY() - smeany, pair.first.getZ() - smeanz);
            pair.second.setLocation(pair.second.getX() - tmeanx, pair.second.getY() - tmeany, pair.second.getZ() - tmeanz);
        }
        double meanlengthfirst = 0.0;
        double meanlengthsecond = 0.0;
        fiducialsE = fiducials.elements();
        while (fiducialsE.hasMoreElements()) {
            PointsPair3D pair = fiducialsE.nextElement();
            double normfirstsquared = pair.first.getX() * pair.first.getX() + pair.first.getY() * pair.first.getY() + pair.first.getZ() * pair.first.getZ();
            double normsecondsquared = pair.second.getX() * pair.second.getX() + pair.second.getY() * pair.second.getY() + pair.second.getZ() * pair.second.getZ();
            meanlengthfirst += normfirstsquared;
            meanlengthsecond += normsecondsquared;
        }
        double scale = Math.sqrt(meanlengthsecond / meanlengthfirst);
        Matrix R = Matrix.identity((int)3, (int)3);
        if (fiducials.size() > 2) {
            fiducialsE = fiducials.elements();
            Matrix M = new Matrix(3, 3, 0.0);
            int i = 0;
            while (fiducialsE.hasMoreElements()) {
                PointsPair3D pair = fiducialsE.nextElement();
                Matrix Rs = new Matrix(3, 1);
                Matrix Rp = new Matrix(3, 1);
                Rs.set(0, 0, pair.first.getX());
                Rs.set(1, 0, pair.first.getY());
                Rs.set(2, 0, pair.first.getZ());
                Rp.set(0, 0, pair.second.getX());
                Rp.set(1, 0, pair.second.getY());
                Rp.set(2, 0, pair.second.getZ());
                System.out.println(i++);
                M.plusEquals(Rp.times(Rs.transpose()));
            }
            Matrix Q = M.transpose().times(M);
            EigenvalueDecomposition evd = Q.eig();
            Matrix v = evd.getV();
            Matrix d = evd.getD();
            for (int r = 0; r < d.getRowDimension(); ++r) {
                for (int c = 0; c < d.getColumnDimension(); ++c) {
                    if (!(d.get(r, c) > 0.0)) continue;
                    d.set(r, c, 1.0 / Math.sqrt(d.get(r, c)));
                }
            }
            Matrix invsquareRootQ = v.times(d.times(v.transpose()));
            R = M.times(invsquareRootQ);
        }
        double[][] vals = new double[][]{{tmeanx}, {tmeany}, {tmeanz}};
        Matrix vecmeantarget = new Matrix((double[][])vals);
        double[][] valss = new double[][]{{smeanx}, {smeany}, {smeanz}};
        Matrix vecmeansource = new Matrix((double[][])valss);
        Matrix T = vecmeantarget.minus(R.times(vecmeansource).times(scale));
        System.out.println("R is :");
        R.print(1, 5);
        System.out.println("T is : ");
        T.print(1, 5);
        System.out.println("Scale is " + scale);
        double[] scalexyz = new double[]{scale, scale};
        return new SimilarityTransformation3D(T, R, scalexyz, 1.0, 1.0, 1.0);
    }

    public SimilarityTransformation3D apply(Vector<PointsPair3D> fiducials, double pixelSizeXsource, double pixelSizeYsource, double pixelSizeZsource, double pixelSizeXtarget, double pixelSizeYtarget, double pixelSizeZtarget) {
        Enumeration<PointsPair3D> fiducialsE = fiducials.elements();
        while (fiducialsE.hasMoreElements()) {
            PointsPair3D pair = fiducialsE.nextElement();
            pair.first.setLocation(pair.first.getX() * pixelSizeXsource, pair.first.getY() * pixelSizeYsource, pair.first.getZ() * pixelSizeZsource);
            pair.second.setLocation(pair.second.getX() * pixelSizeXtarget, pair.second.getY() * pixelSizeYtarget, pair.second.getZ() * pixelSizeZtarget);
        }
        double smeanx = 0.0;
        double smeany = 0.0;
        double smeanz = 0.0;
        double tmeanx = 0.0;
        double tmeany = 0.0;
        double tmeanz = 0.0;
        fiducialsE = fiducials.elements();
        while (fiducialsE.hasMoreElements()) {
            PointsPair3D pair = fiducialsE.nextElement();
            smeanx += pair.first.getX();
            smeany += pair.first.getY();
            tmeanx += pair.second.getX();
            tmeany += pair.second.getY();
            smeanz += pair.first.getZ();
            tmeanz += pair.second.getZ();
        }
        int numPoints = fiducials.size();
        smeanx /= (double)numPoints;
        smeany /= (double)numPoints;
        tmeanx /= (double)numPoints;
        tmeany /= (double)numPoints;
        smeanz /= (double)numPoints;
        tmeanz /= (double)numPoints;
        fiducialsE = fiducials.elements();
        while (fiducialsE.hasMoreElements()) {
            PointsPair3D pair = fiducialsE.nextElement();
            pair.first.setLocation(pair.first.getX() - smeanx, pair.first.getY() - smeany, pair.first.getZ() - smeanz);
            pair.second.setLocation(pair.second.getX() - tmeanx, pair.second.getY() - tmeany, pair.second.getZ() - tmeanz);
            if (pair.second.getZ() == 0.0) {
                pair.second.setLocation(pair.second.getX(), pair.second.getY(), Random.nextDouble() * pixelSizeZtarget - 0.5);
            }
            if (pair.first.getZ() != 0.0) continue;
            pair.first.setLocation(pair.first.getX(), pair.first.getY(), Random.nextDouble() * pixelSizeZsource - 0.5);
        }
        double meanlengthfirst = 0.0;
        double meanlengthsecond = 0.0;
        fiducialsE = fiducials.elements();
        while (fiducialsE.hasMoreElements()) {
            PointsPair3D pair = fiducialsE.nextElement();
            double normfirstsquared = pair.first.getX() * pair.first.getX() + pair.first.getY() * pair.first.getY() + pair.first.getZ() * pair.first.getZ();
            double normsecondsquared = pair.second.getX() * pair.second.getX() + pair.second.getY() * pair.second.getY() + pair.second.getZ() * pair.second.getZ();
            meanlengthfirst += normfirstsquared;
            meanlengthsecond += normsecondsquared;
        }
        double scale = Math.sqrt(meanlengthsecond / meanlengthfirst);
        Matrix R = Matrix.identity((int)3, (int)3);
        if (fiducials.size() > 3) {
            fiducialsE = fiducials.elements();
            Matrix M = new Matrix(3, 3, 0.0);
            int i = 0;
            while (fiducialsE.hasMoreElements()) {
                PointsPair3D pair = fiducialsE.nextElement();
                Matrix Rs = new Matrix(3, 1);
                Matrix Rp = new Matrix(3, 1);
                Rs.set(0, 0, pair.first.getX());
                Rs.set(1, 0, pair.first.getY());
                Rs.set(2, 0, pair.first.getZ());
                Rp.set(0, 0, pair.second.getX());
                Rp.set(1, 0, pair.second.getY());
                Rp.set(2, 0, pair.second.getZ());
                System.out.println(i++);
                M.plusEquals(Rp.times(Rs.transpose()));
            }
            Matrix Q = M.transpose().times(M);
            EigenvalueDecomposition evd = Q.eig();
            Matrix v = evd.getV();
            Matrix d = evd.getD();
            for (int r = 0; r < d.getRowDimension(); ++r) {
                for (int c = 0; c < d.getColumnDimension(); ++c) {
                    if (!(d.get(r, c) > 0.0)) continue;
                    d.set(r, c, 1.0 / Math.sqrt(d.get(r, c)));
                }
            }
            Matrix invsquareRootQ = v.times(d.times(v.transpose()));
            R = M.times(invsquareRootQ);
        }
        double[][] vals = new double[][]{{tmeanx}, {tmeany}, {tmeanz}};
        Matrix vecmeantarget = new Matrix((double[][])vals);
        double[][] valss = new double[][]{{smeanx}, {smeany}, {smeanz}};
        Matrix vecmeansource = new Matrix((double[][])valss);
        Matrix T = vecmeantarget.minus(R.times(vecmeansource).times(scale));
        System.out.println("R is :");
        R.print(1, 5);
        System.out.println("T is : ");
        T.print(1, 5);
        System.out.println("Scale is " + scale);
        double[] scalexyz = new double[]{scale, scale};
        return new SimilarityTransformation3D(T, R, scalexyz, pixelSizeXsource, pixelSizeYsource, pixelSizeZsource);
    }
}

