/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.easyclemv0;

import Jama.Matrix;
import java.awt.geom.Point2D;

public class SimilarityTransformation2D {
    private double dx;
    private double dy;
    private double sTheta;
    private double cTheta;
    private double scale;
    private Matrix T;
    private Matrix R;

    public SimilarityTransformation2D(Matrix T, Matrix R, double scale) {
        this.dx = T.get(0, 0);
        this.dy = T.get(1, 0);
        this.scale = scale;
        this.cTheta = R.get(0, 0);
        this.sTheta = R.get(1, 0);
        this.T = T.copy();
        this.R = R.copy();
    }

    public void apply_old(Point2D pnt) {
        double newX = this.dx + this.scale * this.cTheta * pnt.getX() - this.scale * this.sTheta * pnt.getY();
        double newY = this.dy + this.scale * this.sTheta * pnt.getX() + this.scale * this.cTheta * pnt.getY();
        pnt.setLocation(newX, newY);
    }

    public void apply(Point2D pnt) {
        Matrix matrixtransfo = this.getMatrix();
        double newX = matrixtransfo.get(0, 3) + matrixtransfo.get(0, 0) * pnt.getX() + matrixtransfo.get(0, 1) * pnt.getY();
        double newY = matrixtransfo.get(1, 3) + matrixtransfo.get(1, 0) * pnt.getX() + matrixtransfo.get(1, 1) * pnt.getY();
        pnt.setLocation(newX, newY);
    }

    public double getS() {
        return this.sTheta;
    }

    public double getC() {
        return this.cTheta;
    }

    public double getdx() {
        return this.dx;
    }

    public double getdy() {
        return this.dy;
    }

    public double getscale() {
        return this.scale;
    }

    public Matrix getR() {
        return this.R;
    }

    public Matrix getT() {
        return this.T;
    }

    public Matrix getMatrix() {
        Matrix transfomatrix3D = new Matrix(4, 4);
        transfomatrix3D.set(0, 0, this.R.get(0, 0) * this.scale);
        transfomatrix3D.set(0, 1, this.R.get(0, 1) * this.scale);
        transfomatrix3D.set(0, 2, this.R.get(0, 2) * this.scale);
        transfomatrix3D.set(0, 3, this.T.get(0, 0));
        transfomatrix3D.set(1, 0, this.R.get(1, 0) * this.scale);
        transfomatrix3D.set(1, 1, this.R.get(1, 1) * this.scale);
        transfomatrix3D.set(1, 2, this.R.get(1, 2) * this.scale);
        transfomatrix3D.set(1, 3, this.T.get(1, 0));
        transfomatrix3D.set(2, 0, this.R.get(2, 0) * this.scale);
        transfomatrix3D.set(2, 1, this.R.get(2, 1) * this.scale);
        transfomatrix3D.set(2, 2, this.R.get(2, 2) * this.scale);
        transfomatrix3D.set(2, 3, this.T.get(2, 0));
        transfomatrix3D.set(3, 0, 0.0);
        transfomatrix3D.set(3, 1, 0.0);
        transfomatrix3D.set(3, 2, 0.0);
        transfomatrix3D.set(3, 3, 1.0);
        return transfomatrix3D;
    }
}

