/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.easyclemv0;

import Jama.Matrix;
import plugins.perrine.easyclemv0.PPPoint3D;

public class SimilarityTransformation3D {
    private double dx;
    private double dy;
    private double dz;
    private double scalexy;
    private double scalez;
    private Matrix T;
    private Matrix R;
    private double orisizeX;
    private double orisizeY;
    private double orisizeZ;

    public SimilarityTransformation3D(Matrix T, Matrix R, double[] scale, double orisizeX, double orisizeY, double orisizeZ) {
        this.dx = T.get(0, 0);
        this.dy = T.get(1, 0);
        this.dz = T.get(2, 0);
        this.scalexy = scale[0];
        this.scalez = scale[1];
        this.T = T.copy();
        this.R = R.copy();
        this.orisizeX = orisizeX;
        this.orisizeY = orisizeY;
        this.orisizeZ = orisizeZ;
    }

    public SimilarityTransformation3D(Matrix Transfo, double orisizex2, double orisizey2, double orisizez2) {
        this.scalexy = 1.0;
        this.scalez = 1.0;
        this.R = new Matrix(3, 3);
        this.T = new Matrix(3, 1);
        this.R.set(0, 0, Transfo.get(0, 0));
        this.R.set(0, 1, Transfo.get(0, 1));
        this.R.set(0, 2, Transfo.get(0, 2));
        this.R.set(1, 0, Transfo.get(1, 0));
        this.R.set(1, 1, Transfo.get(1, 1));
        this.R.set(1, 2, Transfo.get(1, 2));
        this.R.set(2, 0, Transfo.get(2, 0));
        this.R.set(2, 1, Transfo.get(2, 1));
        this.R.set(2, 2, Transfo.get(2, 2));
        this.T.set(0, 0, Transfo.get(0, 3));
        this.T.set(1, 0, Transfo.get(1, 3));
        this.T.set(2, 0, Transfo.get(2, 3));
        this.orisizeX = orisizex2;
        this.orisizeY = orisizey2;
        this.orisizeZ = orisizez2;
    }

    public void apply(PPPoint3D pnt) {
        Matrix matrixtransfo = this.getMatrix();
        double newX = matrixtransfo.get(0, 3) + matrixtransfo.get(0, 0) * pnt.getX() * this.orisizeX + matrixtransfo.get(0, 1) * pnt.getY() * this.orisizeY + matrixtransfo.get(0, 2) * pnt.getZ() * this.orisizeZ;
        double newY = matrixtransfo.get(1, 3) + matrixtransfo.get(1, 0) * pnt.getX() * this.orisizeX + matrixtransfo.get(1, 1) * pnt.getY() * this.orisizeY + matrixtransfo.get(1, 2) * pnt.getZ() * this.orisizeZ;
        double newZ = matrixtransfo.get(2, 3) + matrixtransfo.get(2, 0) * pnt.getX() * this.orisizeX + matrixtransfo.get(2, 1) * pnt.getY() * this.orisizeY + matrixtransfo.get(2, 2) * pnt.getZ() * this.orisizeZ;
        pnt.setLocation(newX, newY, newZ);
    }

    public double getorisizex() {
        return this.orisizeX;
    }

    public double getorisizey() {
        return this.orisizeY;
    }

    public double getorisizez() {
        return this.orisizeZ;
    }

    public double getdx() {
        return this.dx;
    }

    public double getdy() {
        return this.dy;
    }

    public double getdz() {
        return this.dz;
    }

    public double getscalex() {
        return this.scalexy;
    }

    public double getscalez() {
        return this.scalez;
    }

    public Matrix getR() {
        return this.R;
    }

    public Matrix getT() {
        return this.T;
    }

    public Matrix getMatrix() {
        Matrix transfomatrix3D = new Matrix(4, 4);
        transfomatrix3D.set(0, 0, this.R.get(0, 0) * this.scalexy);
        transfomatrix3D.set(0, 1, this.R.get(0, 1) * this.scalexy);
        transfomatrix3D.set(0, 2, this.R.get(0, 2) * this.scalexy);
        transfomatrix3D.set(0, 3, this.T.get(0, 0));
        transfomatrix3D.set(1, 0, this.R.get(1, 0) * this.scalexy);
        transfomatrix3D.set(1, 1, this.R.get(1, 1) * this.scalexy);
        transfomatrix3D.set(1, 2, this.R.get(1, 2) * this.scalexy);
        transfomatrix3D.set(1, 3, this.T.get(1, 0));
        transfomatrix3D.set(2, 0, this.R.get(2, 0) * this.scalexy);
        transfomatrix3D.set(2, 1, this.R.get(2, 1) * this.scalexy);
        transfomatrix3D.set(2, 2, this.R.get(2, 2) * this.scalez);
        transfomatrix3D.set(2, 3, this.T.get(2, 0));
        transfomatrix3D.set(3, 0, 0.0);
        transfomatrix3D.set(3, 1, 0.0);
        transfomatrix3D.set(3, 2, 0.0);
        transfomatrix3D.set(3, 3, 1.0);
        return transfomatrix3D;
    }

    public Matrix getMatrixnoScale() {
        Matrix transfomatrix3D = new Matrix(4, 4);
        transfomatrix3D.set(0, 0, this.R.get(0, 0));
        transfomatrix3D.set(0, 1, this.R.get(0, 1));
        transfomatrix3D.set(0, 2, this.R.get(0, 2));
        transfomatrix3D.set(0, 3, this.T.get(0, 0));
        transfomatrix3D.set(1, 0, this.R.get(1, 0));
        transfomatrix3D.set(1, 1, this.R.get(1, 1));
        transfomatrix3D.set(1, 2, this.R.get(1, 2));
        transfomatrix3D.set(1, 3, this.T.get(1, 0));
        transfomatrix3D.set(2, 0, this.R.get(2, 0));
        transfomatrix3D.set(2, 1, this.R.get(2, 1));
        transfomatrix3D.set(2, 2, this.R.get(2, 2));
        transfomatrix3D.set(2, 3, this.T.get(2, 0));
        transfomatrix3D.set(3, 0, 0.0);
        transfomatrix3D.set(3, 1, 0.0);
        transfomatrix3D.set(3, 2, 0.0);
        transfomatrix3D.set(3, 3, 1.0);
        return transfomatrix3D;
    }
}

