/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.easyclemv0;

import Jama.Matrix;
import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.DataType;
import java.awt.image.BufferedImage;
import vtk.vtkDataArray;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkDoubleArray;
import vtk.vtkFloatArray;
import vtk.vtkImageChangeInformation;
import vtk.vtkImageData;
import vtk.vtkImageReslice;
import vtk.vtkIntArray;
import vtk.vtkMatrix4x4;
import vtk.vtkPointData;
import vtk.vtkShortArray;
import vtk.vtkTransform;
import vtk.vtkUnsignedCharArray;
import vtk.vtkUnsignedIntArray;
import vtk.vtkUnsignedShortArray;

public class Stack3DVTKTransformer
implements Runnable {
    private vtkImageReslice ImageReslice;
    private vtkMatrix4x4 transfo3D;
    private Sequence sequence;
    private DataType oriType;
    private vtkDataSet[] imageData;
    private int extentx;
    private int extenty;
    private int extentz;
    private double spacingx;
    private double spacingy;
    private double spacingz;
    private double scalexy;
    private double scalez;
    private double InputSpacingz;
    private double InputSpacingx;
    private double InputSpacingy;
    private int recenter = 0;

    public void setImageSource(Sequence value) {
        this.sequence = value;
        this.oriType = value.getDataType_();
        this.InputSpacingx = this.sequence.getPixelSizeX();
        this.InputSpacingy = this.sequence.getPixelSizeY();
        this.InputSpacingz = this.sequence.getPixelSizeZ();
    }

    public void setImageSource(Sequence value, double orisizex, double orisizey, double orisizez) {
        this.sequence = value;
        this.oriType = value.getDataType_();
        this.InputSpacingx = orisizex;
        this.InputSpacingy = orisizey;
        this.InputSpacingz = orisizez;
    }

    public DataType getoriType() {
        return this.oriType;
    }

    public void setParameters(Matrix Transfo, double scalexy, double scalez) {
        if (Transfo.getRowDimension() == 4) {
            this.transfo3D = new vtkMatrix4x4();
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.transfo3D.SetElement(i, j, Transfo.get(i, j));
                }
            }
        }
        this.setScalexy(scalexy);
        this.setScalez(scalez);
    }

    public void setDestinationsize(int w, int h, int z, double spacingx, double spacingy, double spacingz) {
        this.extentx = w - 1;
        this.extenty = h - 1;
        this.extentz = z - 1;
        this.spacingx = spacingx;
        this.spacingy = spacingy;
        this.spacingz = spacingz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        System.out.println("I will apply transfo now");
        ProgressFrame progress = new ProgressFrame("Applying the transformation...");
        int nbc = this.sequence.getSizeC();
        this.imageData = new vtkDataSet[nbc];
        for (int c = 0; c < this.sequence.getSizeC(); ++c) {
            this.converttoVtkImageData(c);
            vtkTransform mytransfo = new vtkTransform();
            mytransfo.SetMatrix(this.transfo3D);
            this.ImageReslice = new vtkImageReslice();
            if (this.recenter == 1) {
                vtkImageChangeInformation change = new vtkImageChangeInformation();
                change.SetInputData((vtkDataObject)this.imageData[c]);
                change.CenterImageOn();
                change.Update();
                this.ImageReslice.SetInputData((vtkDataObject)change.GetOutput());
                this.ImageReslice.SetOutputDimensionality(3);
            } else {
                this.ImageReslice.SetInputData((vtkDataObject)this.imageData[c]);
                this.ImageReslice.SetOutputDimensionality(3);
                this.ImageReslice.SetOutputOrigin(0.0, 0.0, 0.0);
            }
            this.ImageReslice.SetOutputSpacing(this.spacingx, this.spacingy, this.spacingz);
            this.ImageReslice.SetOutputExtent(0, this.extentx, 0, this.extenty, 0, this.extentz);
            this.ImageReslice.SetResliceTransform(mytransfo.GetInverse());
            this.ImageReslice.SetInterpolationModeToLinear();
            this.ImageReslice.Update();
            this.imageData[c] = this.ImageReslice.GetOutput();
        }
        int nbt = this.sequence.getSizeT();
        int nbz = this.extentz + 1;
        int w = this.extentx + 1;
        int h = this.extenty + 1;
        DataType datatype = this.sequence.getDataType_();
        this.sequence.beginUpdate();
        this.sequence.removeAllImages();
        try {
            switch (datatype) {
                case UBYTE: {
                    for (int t = 0; t < nbt; ++t) {
                        for (int z = 0; z < nbz; ++z) {
                            IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                            progress.setPosition((double)z);
                            for (int c = 0; c < nbc; ++c) {
                                vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                byte[] inData = ((vtkUnsignedCharArray)myvtkarray).GetJavaArray();
                                byte[] outData = new byte[w * h];
                                for (int i = 0; i < h; ++i) {
                                    for (int j = 0; j < w; ++j) {
                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                    }
                                }
                                image.setDataXYAsByte(c, outData);
                            }
                            this.sequence.setImage(t, z, (BufferedImage)image);
                        }
                    }
                    break;
                }
                case BYTE: {
                    for (int t = 0; t < nbt; ++t) {
                        for (int z = 0; z < nbz; ++z) {
                            IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                            progress.setPosition((double)z);
                            for (int c = 0; c < nbc; ++c) {
                                vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                byte[] inData = ((vtkUnsignedCharArray)myvtkarray).GetJavaArray();
                                byte[] outData = new byte[w * h];
                                for (int i = 0; i < h; ++i) {
                                    for (int j = 0; j < w; ++j) {
                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                    }
                                }
                                image.setDataXYAsByte(c, outData);
                            }
                            this.sequence.setImage(t, z, (BufferedImage)image);
                        }
                    }
                    break;
                }
                case USHORT: {
                    for (int t = 0; t < nbt; ++t) {
                        for (int z = 0; z < nbz; ++z) {
                            IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                            progress.setPosition((double)z);
                            for (int c = 0; c < nbc; ++c) {
                                vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                short[] inData = ((vtkUnsignedShortArray)myvtkarray).GetJavaArray();
                                short[] outData = new short[w * h];
                                for (int i = 0; i < h; ++i) {
                                    for (int j = 0; j < w; ++j) {
                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                    }
                                }
                                image.setDataXYAsShort(c, outData);
                            }
                            this.sequence.setImage(t, z, (BufferedImage)image);
                        }
                    }
                    break;
                }
                case SHORT: {
                    for (int t = 0; t < nbt; ++t) {
                        for (int z = 0; z < nbz; ++z) {
                            IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                            progress.setPosition((double)z);
                            for (int c = 0; c < nbc; ++c) {
                                vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                short[] inData = ((vtkShortArray)myvtkarray).GetJavaArray();
                                short[] outData = new short[w * h];
                                for (int i = 0; i < h; ++i) {
                                    for (int j = 0; j < w; ++j) {
                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                    }
                                }
                                image.setDataXYAsShort(c, outData);
                            }
                            this.sequence.setImage(t, z, (BufferedImage)image);
                        }
                    }
                    break;
                }
                case INT: {
                    for (int t = 0; t < nbt; ++t) {
                        for (int z = 0; z < nbz; ++z) {
                            IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                            progress.setPosition((double)z);
                            for (int c = 0; c < nbc; ++c) {
                                vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                int[] inData = ((vtkIntArray)myvtkarray).GetJavaArray();
                                int[] outData = new int[w * h];
                                for (int i = 0; i < h; ++i) {
                                    for (int j = 0; j < w; ++j) {
                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                    }
                                }
                                image.setDataXYAsInt(c, outData);
                            }
                            this.sequence.setImage(t, z, (BufferedImage)image);
                        }
                    }
                    break;
                }
                case UINT: {
                    for (int t = 0; t < nbt; ++t) {
                        for (int z = 0; z < nbz; ++z) {
                            IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                            progress.setPosition((double)z);
                            for (int c = 0; c < nbc; ++c) {
                                vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                int[] inData = ((vtkUnsignedIntArray)myvtkarray).GetJavaArray();
                                int[] outData = new int[w * h];
                                for (int i = 0; i < h; ++i) {
                                    for (int j = 0; j < w; ++j) {
                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                    }
                                }
                                image.setDataXYAsInt(c, outData);
                            }
                            this.sequence.setImage(t, z, (BufferedImage)image);
                        }
                    }
                    break;
                }
                case FLOAT: {
                    for (int t = 0; t < nbt; ++t) {
                        for (int z = 0; z < nbz; ++z) {
                            IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                            progress.setPosition((double)z);
                            for (int c = 0; c < nbc; ++c) {
                                vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                float[] inData = ((vtkFloatArray)myvtkarray).GetJavaArray();
                                float[] outData = new float[w * h];
                                for (int i = 0; i < h; ++i) {
                                    for (int j = 0; j < w; ++j) {
                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                    }
                                }
                                image.setDataXYAsFloat(c, outData);
                            }
                            this.sequence.setImage(t, z, (BufferedImage)image);
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    for (int t = 0; t < nbt; ++t) {
                        for (int z = 0; z < nbz; ++z) {
                            IcyBufferedImage image = new IcyBufferedImage(w, h, nbc, datatype);
                            progress.setPosition((double)z);
                            for (int c = 0; c < nbc; ++c) {
                                vtkDataArray myvtkarray = this.imageData[c].GetPointData().GetScalars();
                                double[] inData = ((vtkDoubleArray)myvtkarray).GetJavaArray();
                                double[] outData = new double[w * h];
                                for (int i = 0; i < h; ++i) {
                                    for (int j = 0; j < w; ++j) {
                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                    }
                                }
                                image.setDataXYAsDouble(c, outData);
                            }
                            this.sequence.setImage(t, z, (BufferedImage)image);
                        }
                    }
                    break;
                }
            }
            this.sequence.setPixelSizeX(this.spacingx);
            this.sequence.setPixelSizeY(this.spacingy);
            this.sequence.setPixelSizeZ(this.spacingz);
        }
        finally {
            this.sequence.endUpdate();
        }
        progress.close();
        System.out.println("have been applied");
    }

    void converttoVtkImageData(int posC) {
        vtkPointData pointData;
        Sequence sequence2 = this.sequence;
        if (this.sequence == null) {
            return;
        }
        int sizeX = sequence2.getSizeX();
        int sizeY = sequence2.getSizeY();
        int sizeZ = sequence2.getSizeZ();
        DataType dataType = sequence2.getDataType_();
        boolean posT = false;
        vtkImageData newImageData = new vtkImageData();
        newImageData.SetDimensions(sizeX, sizeY, sizeZ);
        newImageData.SetSpacing(this.InputSpacingx, this.InputSpacingy, this.InputSpacingz);
        switch (dataType) {
            case UBYTE: {
                newImageData.AllocateScalars(3, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkUnsignedCharArray)array).SetJavaArray(this.sequence.getDataCopyCXYZAsByte(0));
                    break;
                }
                ((vtkUnsignedCharArray)array).SetJavaArray(this.sequence.getDataCopyXYZAsByte(0, posC));
                break;
            }
            case BYTE: {
                newImageData.AllocateScalars(3, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkUnsignedCharArray)array).SetJavaArray(this.sequence.getDataCopyCXYZAsByte(0));
                    break;
                }
                ((vtkUnsignedCharArray)array).SetJavaArray(this.sequence.getDataCopyXYZAsByte(0, posC));
                break;
            }
            case USHORT: {
                newImageData.AllocateScalars(5, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkUnsignedShortArray)array).SetJavaArray(this.sequence.getDataCopyCXYZAsShort(0));
                    break;
                }
                ((vtkUnsignedShortArray)array).SetJavaArray(this.sequence.getDataCopyXYZAsShort(0, posC));
                break;
            }
            case SHORT: {
                newImageData.AllocateScalars(4, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkShortArray)array).SetJavaArray(this.sequence.getDataCopyCXYZAsShort(0));
                    break;
                }
                ((vtkShortArray)array).SetJavaArray(this.sequence.getDataCopyXYZAsShort(0, posC));
                break;
            }
            case UINT: {
                newImageData.AllocateScalars(7, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkUnsignedIntArray)array).SetJavaArray(this.sequence.getDataCopyCXYZAsInt(0));
                    break;
                }
                ((vtkUnsignedIntArray)array).SetJavaArray(this.sequence.getDataCopyXYZAsInt(0, posC));
                break;
            }
            case INT: {
                newImageData.AllocateScalars(6, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkIntArray)array).SetJavaArray(this.sequence.getDataCopyCXYZAsInt(0));
                    break;
                }
                ((vtkIntArray)array).SetJavaArray(this.sequence.getDataCopyXYZAsInt(0, posC));
                break;
            }
            case FLOAT: {
                newImageData.AllocateScalars(10, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkFloatArray)array).SetJavaArray(this.sequence.getDataCopyCXYZAsFloat(0));
                    break;
                }
                ((vtkFloatArray)array).SetJavaArray(this.sequence.getDataCopyXYZAsFloat(0, posC));
                break;
            }
            case DOUBLE: {
                newImageData.AllocateScalars(11, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkDoubleArray)array).SetJavaArray(this.sequence.getDataCopyCXYZAsDouble(0));
                    break;
                }
                ((vtkDoubleArray)array).SetJavaArray(this.sequence.getDataCopyXYZAsDouble(0, posC));
                break;
            }
            default: {
                newImageData.SetDimensions(1, 1, 1);
                newImageData.SetSpacing(this.sequence.getPixelSizeX(), this.sequence.getPixelSizeY(), this.sequence.getPixelSizeZ());
                newImageData.SetNumberOfScalarComponents(1, null);
                newImageData.SetExtent(0, 0, 0, 0, 0, 0);
                newImageData.AllocateScalars(null);
            }
        }
        if (this.imageData[posC] != null && (pointData = this.imageData[posC].GetPointData()) != null) {
            vtkDataArray dataArray = pointData.GetScalars();
            if (dataArray != null) {
                dataArray.Delete();
            }
            pointData.Delete();
            this.imageData[posC].ReleaseData();
            this.imageData[posC].Delete();
        }
        this.imageData[posC] = newImageData;
    }

    public void setDestinationsize(int w, int h, int z, double spacingx, double spacingy, double spacingz, int recenter) {
        this.extentx = w - 1;
        this.extenty = h - 1;
        this.extentz = z - 1;
        this.spacingx = spacingx;
        this.spacingy = spacingy;
        this.spacingz = spacingz;
        this.recenter = recenter;
    }

    public double getScalexy() {
        return this.scalexy;
    }

    public void setScalexy(double scalexy) {
        this.scalexy = scalexy;
    }

    public double getScalez() {
        return this.scalez;
    }

    public void setScalez(double scalez) {
        this.scalez = scalez;
    }
}

