/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.easyclemv0;

import Jama.Matrix;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.image.colormap.FireColorMap;
import icy.image.colormap.IcyColorMap;
import icy.image.lut.LUT;
import icy.painter.Overlay;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.point.Point5D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import plugins.kernel.roi.descriptor.measure.ROIMassCenterDescriptorsPlugin;
import plugins.stef.tools.overlay.ColorBarOverlay;

public class TargetRegistrationErrorMap
implements Runnable {
    private double[][] fiducials = null;
    double FLE;
    private Matrix eigenVector;
    private double[] bary;
    private ProgressFrame myprogressbar;
    private double c1;
    private double c2;
    private double c3;
    private double principalAxesV1;
    private double principalAxesV2;
    private double principalAxesV3;
    private double principalAxesU1;
    private double principalAxesU2;
    private double principalAxesU3;
    private double principalAxesW1;
    private double principalAxesW2;
    private double principalAxesW3;
    double[][] eigenVectorMatrix;
    private double numc1;
    private double numc2;
    private double numc3;
    private Sequence sequence;
    private IcyBufferedImage image;
    Viewer myviewer;

    @Override
    public void run() {
        if (this.sequence.getROIs().size() < 3) {
            MessageDialog.showDialog((String)"You need at least 4 points to compute an error map ");
        }
        this.ReadFiducials(this.sequence);
        this.myprogressbar = new ProgressFrame("EasyCLEM is computing Error Map");
        this.myprogressbar.setLength((double)(this.sequence.getSizeX() * this.sequence.getSizeZ()));
        this.myprogressbar.setPosition(0.0);
        this.myprogressbar.setPosition(10.0);
        this.myprogressbar.setMessage("EasyCLEM was Precomputing Inertia Matrix done");
        double[] f = this.PreComputeTRE();
        final Sequence TREMAP = this.ComputeTREMAP(this.sequence, this.FLE, f, this.image);
        this.myprogressbar.close();
        double sizex = this.sequence.getPixelSizeX();
        double sizey = this.sequence.getPixelSizeY();
        double sizez = this.sequence.getPixelSizeZ();
        if (TREMAP == null) {
            MessageDialog.showDialog((String)"No active image");
            return;
        }
        TREMAP.setPixelSizeX(sizex);
        TREMAP.setPixelSizeY(sizey);
        TREMAP.setPixelSizeZ(sizez);
        TREMAP.setAutoUpdateChannelBounds(false);
        TREMAP.endUpdate();
        TREMAP.setName("Prediction of registration only error in nanometers (if calibration settings were correct)");
        ColorBarOverlay mycolorbar = new ColorBarOverlay(null);
        mycolorbar.setDisplayMinMax(true);
        TREMAP.addOverlay((Overlay)mycolorbar);
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Viewer myviewer = new Viewer(TREMAP);
                LUT mylut = myviewer.getLut();
                mylut.getLutChannel(0).setColorMap((IcyColorMap)new FireColorMap(), false);
                System.out.println("done");
            }
        });
    }

    public void apply(Sequence sequence, IcyBufferedImage image, double FLE) {
        this.FLE = FLE;
        this.sequence = sequence;
        this.image = image;
        new Thread(this).start();
    }

    private Sequence ComputeTREMAP(Sequence sequence, double fLE2, double[] f, IcyBufferedImage image) {
        Sequence newsequence = new Sequence();
        if (image == null) {
            return null;
        }
        this.myprogressbar.setMessage("EasyCLEM is computing Error Map");
        for (int z = 0; z < sequence.getSizeZ(); ++z) {
            float[] dataArray = new float[image.getSizeX() * image.getSizeY()];
            for (int x = 0; x < image.getSizeX(); ++x) {
                this.myprogressbar.setPosition(this.myprogressbar.getPosition() + 1.0);
                for (int y = 0; y < image.getSizeY(); ++y) {
                    dataArray[image.getOffset((int)x, (int)y)] = this.ComputeTRE(fLE2, x, y, z, f);
                }
            }
            this.myprogressbar.setPosition(this.myprogressbar.getPosition() + (double)z);
            IcyBufferedImage imageResult = new IcyBufferedImage(sequence.getSizeX(), sequence.getSizeY(), (Object)dataArray);
            newsequence.setImage(0, z, (BufferedImage)imageResult);
            imageResult.getType();
        }
        return newsequence;
    }

    float ComputeTRE(double fLE2, int x, int y, int z, double[] f) {
        double[] mypoint = new double[]{(double)x * this.sequence.getPixelSizeX() * 1000.0, (double)y * this.sequence.getPixelSizeY() * 1000.0, (double)z * this.sequence.getPixelSizeZ() * 1000.0};
        double[] d = new double[3];
        for (int i = 0; i < this.fiducials.length; ++i) {
            d[0] = d[0] + this.DistanceSQUAREPointToLine3Dfast(mypoint, this.principalAxesU1, this.principalAxesV1, this.principalAxesW1, this.c1, this.numc1, this.bary);
            d[1] = d[1] + this.DistanceSQUAREPointToLine3Dfast(mypoint, this.principalAxesU2, this.principalAxesV2, this.principalAxesW2, this.c2, this.numc2, this.bary);
            d[2] = this.numc3 != 0.0 ? d[2] + this.DistanceSQUAREPointToLine3Dfast(mypoint, this.principalAxesU3, this.principalAxesV3, this.principalAxesW3, this.c3, this.numc3, this.bary) : d[2] + Math.pow(this.DistancePointtoPoint(this.fiducials[i], this.bary), 2.0);
        }
        double doverf = 0.0;
        double sumdoverf = 0.0;
        for (int i = 0; i < 3; ++i) {
            doverf = d[i] / f[i];
            sumdoverf += doverf;
        }
        double TRE = Math.sqrt(1.0 / (double)this.fiducials.length * (1.0 + 0.3333333333333333 * sumdoverf) * Math.pow(fLE2, 2.0));
        return (float)TRE;
    }

    double[] PreComputeTRE() {
        this.bary = this.averageposition(this.fiducials);
        double Ixx = this.moment(1, 2);
        double Iyy = this.moment(0, 2);
        double Izz = this.moment(0, 1);
        double Ixy = this.product(0, 1);
        double Ixz = this.product(0, 2);
        double Iyz = this.product(1, 2);
        double[][] matrixd = new double[3][3];
        matrixd[0][0] = Ixx;
        matrixd[0][1] = -Ixy;
        matrixd[0][2] = -Ixz;
        matrixd[1][0] = -Ixy;
        matrixd[1][1] = Iyy;
        matrixd[1][2] = -Iyz;
        matrixd[2][0] = -Ixz;
        matrixd[2][1] = -Iyz;
        matrixd[2][2] = Izz;
        Matrix inertiaMatrix = new Matrix(matrixd);
        this.eigenVector = inertiaMatrix.eig().getV();
        this.eigenVectorMatrix = this.eigenVector.getArray();
        double[] f = new double[3];
        this.principalAxesU1 = this.eigenVectorMatrix[0][0];
        this.principalAxesU2 = this.eigenVectorMatrix[0][1];
        this.principalAxesU3 = this.eigenVectorMatrix[0][2];
        this.principalAxesV1 = this.eigenVectorMatrix[1][0];
        this.principalAxesV2 = this.eigenVectorMatrix[1][1];
        this.principalAxesV3 = this.eigenVectorMatrix[1][2];
        this.principalAxesW1 = this.eigenVectorMatrix[1][0];
        this.principalAxesW2 = this.eigenVectorMatrix[1][1];
        this.principalAxesW3 = this.eigenVectorMatrix[1][2];
        this.c1 = -(this.principalAxesV1 * this.bary[0] - this.principalAxesU1 * this.bary[1] + this.principalAxesW1 * this.bary[2]);
        this.c2 = -(this.principalAxesV2 * this.bary[0] - this.principalAxesU2 * this.bary[1] + this.principalAxesW2 * this.bary[2]);
        this.c3 = -(this.principalAxesV3 * this.bary[0] - this.principalAxesU3 * this.bary[1] + this.principalAxesW3 * this.bary[2]);
        this.numc1 = Math.pow(this.principalAxesV1, 2.0) + Math.pow(this.principalAxesU1, 2.0) + Math.pow(this.principalAxesW1, 2.0);
        this.numc2 = Math.pow(this.principalAxesV2, 2.0) + Math.pow(this.principalAxesU2, 2.0) + Math.pow(this.principalAxesW2, 2.0);
        this.numc3 = Math.pow(this.principalAxesV3, 2.0) + Math.pow(this.principalAxesU3, 2.0) + Math.pow(this.principalAxesW3, 2.0);
        for (int i = 0; i < this.fiducials.length; ++i) {
            f[0] = f[0] + this.DistanceSQUAREPointToLine3Dfast(this.fiducials[i], this.principalAxesU1, this.principalAxesV1, this.principalAxesW1, this.c1, this.numc1, this.bary);
            f[1] = f[1] + this.DistanceSQUAREPointToLine3Dfast(this.fiducials[i], this.principalAxesU2, this.principalAxesV2, this.principalAxesW2, this.c2, this.numc2, this.bary);
            f[2] = this.numc3 != 0.0 ? f[2] + this.DistanceSQUAREPointToLine3Dfast(this.fiducials[i], this.principalAxesU3, this.principalAxesV3, this.principalAxesW3, this.c3, this.numc3, this.bary) : f[2] + Math.pow(this.DistancePointtoPoint(this.fiducials[i], this.bary), 2.0);
        }
        return f;
    }

    private double DistancePointtoPoint(double[] ds, double[] bary) {
        return Math.sqrt(Math.pow(ds[0] - bary[0], 2.0) + Math.pow(ds[1] - bary[1], 2.0));
    }

    private double DistanceSQUAREPointToLine3Dfast(double[] fiduciaires, double principalAxesU, double principalAxesV, double principalAxesW, double c, double numc, double[] bary) {
        double distance = Math.pow(principalAxesV * fiduciaires[0] - principalAxesU * fiduciaires[1] + principalAxesW * fiduciaires[2] + c, 2.0) / numc;
        return distance;
    }

    private double product(int c1, int c2) {
        double P = 0.0;
        for (int i = 0; i < this.fiducials.length; ++i) {
            P += this.fiducials[i][c1] * this.fiducials[i][c2];
        }
        return P;
    }

    private double moment(int c1, int c2) {
        double I = 0.0;
        for (int i = 0; i < this.fiducials.length; ++i) {
            I += Math.pow(this.fiducials[i][c1], 2.0) + Math.pow(this.fiducials[i][c2], 2.0);
        }
        return I;
    }

    private double[] averageposition(double[][] fiducials2) {
        double[] average = new double[3];
        average[0] = 0.0;
        average[1] = 0.0;
        for (int i = 0; i < fiducials2.length; ++i) {
            average[0] = average[0] + fiducials2[i][0];
            average[1] = average[1] + fiducials2[i][1];
            average[2] = average[2] + fiducials2[i][2];
        }
        average[0] = average[0] / (double)fiducials2.length;
        average[1] = average[1] / (double)fiducials2.length;
        average[2] = average[2] / (double)fiducials2.length;
        return average;
    }

    void ReadFiducials(double[][] points, Sequence seq) {
        this.fiducials = new double[points.length][3];
        for (int i = 0; i < points.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.fiducials[i][j] = points[i][j];
            }
        }
        this.sequence = seq;
    }

    void ReadFiducials(Sequence seq) {
        this.sequence = seq;
        ArrayList listfiducials = seq.getROIs();
        this.fiducials = new double[listfiducials.size()][3];
        int i = -1;
        for (ROI roi : listfiducials) {
            ++i;
            Point5D p3D = null;
            try {
                p3D = ROIMassCenterDescriptorsPlugin.computeMassCenter((ROI)roi);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (roi.getClassName() == "plugins.kernel.roi.roi3d.ROI3DPoint") {
                p3D = roi.getPosition5D();
            }
            if (Double.isNaN(p3D.getX())) {
                p3D = roi.getPosition5D();
            }
            this.fiducials[i][0] = p3D.getX() * seq.getPixelSizeX() * 1000.0;
            this.fiducials[i][1] = p3D.getY() * seq.getPixelSizeY() * 1000.0;
            this.fiducials[i][2] = p3D.getZ() * seq.getPixelSizeZ() * 1000.0;
        }
    }

    double[] getPrincipalAxe1() {
        double[] pu = new double[]{this.principalAxesU1, this.principalAxesV1, this.principalAxesW1};
        return pu;
    }

    double[] getPrincipalAxe2() {
        double[] pu = new double[]{this.principalAxesU2, this.principalAxesV2, this.principalAxesW2};
        return pu;
    }

    double[] getPrincipalAxe3() {
        double[] pu = new double[]{this.principalAxesU3, this.principalAxesV3, this.principalAxesW3};
        return pu;
    }
}

