/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.easyclemv0;

import icy.canvas.IcyCanvas;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.system.thread.ThreadUtil;
import icy.type.DataType;
import icy.util.XMLUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.kernel.canvas.VtkCanvas;
import vtk.vtkAbstractTransform;
import vtk.vtkCamera;
import vtk.vtkDataArray;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkDoubleArray;
import vtk.vtkFloatArray;
import vtk.vtkImageChangeInformation;
import vtk.vtkImageData;
import vtk.vtkImageReslice;
import vtk.vtkIntArray;
import vtk.vtkMatrix4x4;
import vtk.vtkPointData;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkShortArray;
import vtk.vtkTransform;
import vtk.vtkTransformPolyDataFilter;
import vtk.vtkUnsignedCharArray;
import vtk.vtkUnsignedIntArray;
import vtk.vtkUnsignedShortArray;

public class TransformBasedonCameraView
extends EzPlug {
    EzVarSequence source;
    private Sequence sequence;
    private vtkDataSet[] imageData;
    private double InputSpacingx;
    private double InputSpacingy;
    private double InputSpacingz;
    private Runnable transformer;
    private Sequence sequence2;
    EzVarText choiceinputsection = new EzVarText("Output volume:", new String[]{"crop the data to match original dimensions (keep size and metadata)", "keep full output volume (adapt image size but keep metadata"}, 0, Boolean.valueOf(false));
    private boolean modeboundingbox;

    public void clean() {
    }

    protected void execute() {
        this.sequence = (Sequence)this.source.getValue();
        this.modeboundingbox = this.choiceinputsection.getValue() != "crop the data to match original dimensions (keep size and metadata)";
        Viewer v = this.sequence.getFirstViewer();
        IcyCanvas mycanvas = v.getCanvas();
        if (v.getCanvas().getClass().getName() == "plugins.kernel.canvas.VtkCanvas") {
            VtkCanvas test = (VtkCanvas)mycanvas;
            vtkCamera mycam = test.getCamera();
            System.out.println("View plane normal: " + mycam.GetViewPlaneNormal()[0]);
            System.out.println(mycam.GetViewPlaneNormal()[1]);
            System.out.println(mycam.GetViewPlaneNormal()[2]);
            vtkMatrix4x4 viewmatrix = mycam.GetViewTransformMatrix();
            vtkMatrix4x4 newmatrix = new vtkMatrix4x4();
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    newmatrix.SetElement(i, j, viewmatrix.GetElement(i, j));
                }
            }
            newmatrix.SetElement(0, 3, 0.0);
            newmatrix.SetElement(1, 3, 0.0);
            newmatrix.SetElement(2, 3, 0.0);
            vtkMatrix4x4 correctionMatrix = new vtkMatrix4x4();
            correctionMatrix.Identity();
            correctionMatrix.SetElement(1, 1, -1.0);
            correctionMatrix.SetElement(2, 2, -1.0);
            final vtkTransform viewtransform = new vtkTransform();
            viewtransform.SetMatrix(newmatrix);
            viewtransform.PostMultiply();
            viewtransform.Concatenate(correctionMatrix);
            this.InputSpacingx = this.sequence.getPixelSizeX();
            this.InputSpacingy = this.sequence.getPixelSizeY();
            this.InputSpacingz = this.sequence.getPixelSizeZ();
            final DataType oriType = this.sequence.getDataType_();
            try {
                this.sequence2 = SequenceUtil.getCopy((Sequence)this.sequence);
                this.transformer = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        System.out.println("I will apply transfo now");
                        ProgressFrame progress = new ProgressFrame("Applying the transformation...");
                        int nbc = TransformBasedonCameraView.this.sequence.getSizeC();
                        TransformBasedonCameraView.access$102(TransformBasedonCameraView.this, new vtkDataSet[nbc]);
                        TransformBasedonCameraView.this.writeTransfo3D(viewtransform.GetMatrix());
                        int nbt = TransformBasedonCameraView.this.sequence.getSizeT();
                        int nbz = TransformBasedonCameraView.this.sequence.getSizeZ();
                        int w = TransformBasedonCameraView.this.sequence.getSizeX();
                        int h = TransformBasedonCameraView.this.sequence.getSizeY();
                        for (int c = 0; c < TransformBasedonCameraView.this.sequence.getSizeC(); ++c) {
                            TransformBasedonCameraView.this.converttoVtkImageData(c);
                            vtkImageChangeInformation change = new vtkImageChangeInformation();
                            change.SetInputData((vtkDataObject)TransformBasedonCameraView.this.imageData[c]);
                            change.CenterImageOn();
                            change.Update();
                            vtkImageReslice ImageReslice = new vtkImageReslice();
                            ImageReslice.SetInputData((vtkDataObject)change.GetOutput());
                            ImageReslice.SetOutputDimensionality(3);
                            ImageReslice.SetOutputSpacing(TransformBasedonCameraView.this.InputSpacingx, TransformBasedonCameraView.this.InputSpacingy, TransformBasedonCameraView.this.InputSpacingz);
                            if (TransformBasedonCameraView.this.modeboundingbox) {
                                vtkTransformPolyDataFilter tr = new vtkTransformPolyDataFilter();
                                vtkPoints mypoints = new vtkPoints();
                                mypoints.SetNumberOfPoints(2L);
                                mypoints.SetPoint(0L, 0.0, 0.0, 0.0);
                                mypoints.SetPoint(1L, (double)TransformBasedonCameraView.this.sequence.getSizeX() * TransformBasedonCameraView.this.InputSpacingx, (double)TransformBasedonCameraView.this.sequence.getSizeY() * TransformBasedonCameraView.this.InputSpacingy, (double)TransformBasedonCameraView.this.sequence.getSizeZ() * TransformBasedonCameraView.this.InputSpacingz);
                                vtkPolyData boundspolydata = new vtkPolyData();
                                boundspolydata.SetPoints(mypoints);
                                tr.SetInputData((vtkDataObject)boundspolydata);
                                tr.SetTransform((vtkAbstractTransform)viewtransform);
                                tr.Update();
                                vtkPolyData modifiedboundpoints = tr.GetOutput();
                                double[] bounds = new double[6];
                                double[] newpos = modifiedboundpoints.GetPoint(0L);
                                bounds[0] = Math.abs(newpos[0] / TransformBasedonCameraView.this.InputSpacingx);
                                bounds[2] = Math.abs(newpos[1] / TransformBasedonCameraView.this.InputSpacingy);
                                bounds[4] = Math.abs(newpos[2] / TransformBasedonCameraView.this.InputSpacingz);
                                newpos = modifiedboundpoints.GetPoint(1L);
                                bounds[1] = Math.abs(newpos[0] / TransformBasedonCameraView.this.InputSpacingx);
                                bounds[3] = Math.abs(newpos[1] / TransformBasedonCameraView.this.InputSpacingy);
                                bounds[5] = Math.abs(newpos[2] / TransformBasedonCameraView.this.InputSpacingz);
                                w = 1 + (int)bounds[1] - (int)bounds[0];
                                h = 1 + (int)bounds[3] - (int)bounds[2];
                                nbz = 1 + (int)bounds[5] - (int)bounds[4];
                                ImageReslice.SetOutputExtent((int)bounds[0], (int)bounds[1], (int)bounds[2], (int)bounds[3], (int)bounds[4], (int)bounds[5]);
                            } else {
                                ImageReslice.SetOutputExtent(0, TransformBasedonCameraView.this.sequence.getSizeX() - 1, 0, TransformBasedonCameraView.this.sequence.getSizeY() - 1, 0, TransformBasedonCameraView.this.sequence.getSizeZ() - 1);
                                nbt = TransformBasedonCameraView.this.sequence.getSizeT();
                                nbz = TransformBasedonCameraView.this.sequence.getSizeZ();
                                w = TransformBasedonCameraView.this.sequence.getSizeX();
                                h = TransformBasedonCameraView.this.sequence.getSizeY();
                            }
                            ImageReslice.SetResliceTransform(viewtransform.GetInverse());
                            System.out.println(viewtransform.GetInverse());
                            ImageReslice.SetInterpolationModeToLinear();
                            ImageReslice.Update();
                            ((TransformBasedonCameraView)TransformBasedonCameraView.this).imageData[c] = ImageReslice.GetOutput();
                        }
                        DataType datatype = TransformBasedonCameraView.this.sequence.getDataType_();
                        TransformBasedonCameraView.this.sequence2.beginUpdate();
                        TransformBasedonCameraView.this.sequence2.removeAllImages();
                        progress.setLength((double)nbz);
                        try {
                            switch (oriType) {
                                case UBYTE: {
                                    Object[] outData;
                                    Object[] inData;
                                    vtkDataArray myvtkarray;
                                    IcyBufferedImage image;
                                    for (int t = 0; t < nbt; ++t) {
                                        for (int z = 0; z < nbz; ++z) {
                                            image = new IcyBufferedImage(w, h, nbc, datatype);
                                            progress.setPosition((double)z);
                                            for (int c = 0; c < nbc; ++c) {
                                                myvtkarray = TransformBasedonCameraView.this.imageData[c].GetPointData().GetScalars();
                                                inData = ((vtkUnsignedCharArray)myvtkarray).GetJavaArray();
                                                outData = new byte[w * h];
                                                for (int i = 0; i < h; ++i) {
                                                    for (int j = 0; j < w; ++j) {
                                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                                    }
                                                }
                                                image.setDataXYAsByte(c, outData);
                                            }
                                            TransformBasedonCameraView.this.sequence2.setImage(t, z, (BufferedImage)image);
                                        }
                                    }
                                    break;
                                }
                                case BYTE: {
                                    Object[] outData;
                                    Object[] inData;
                                    vtkDataArray myvtkarray;
                                    IcyBufferedImage image;
                                    for (int t = 0; t < nbt; ++t) {
                                        for (int z = 0; z < nbz; ++z) {
                                            image = new IcyBufferedImage(w, h, nbc, datatype);
                                            progress.setPosition((double)z);
                                            for (int c = 0; c < nbc; ++c) {
                                                myvtkarray = TransformBasedonCameraView.this.imageData[c].GetPointData().GetScalars();
                                                inData = ((vtkUnsignedCharArray)myvtkarray).GetJavaArray();
                                                outData = new byte[w * h];
                                                for (int i = 0; i < h; ++i) {
                                                    for (int j = 0; j < w; ++j) {
                                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                                    }
                                                }
                                                image.setDataXYAsByte(c, outData);
                                            }
                                            TransformBasedonCameraView.this.sequence2.setImage(t, z, (BufferedImage)image);
                                        }
                                    }
                                    break;
                                }
                                case USHORT: {
                                    Object[] outData;
                                    Object[] inData;
                                    vtkDataArray myvtkarray;
                                    IcyBufferedImage image;
                                    for (int t = 0; t < nbt; ++t) {
                                        for (int z = 0; z < nbz; ++z) {
                                            image = new IcyBufferedImage(w, h, nbc, datatype);
                                            progress.setPosition((double)z);
                                            for (int c = 0; c < nbc; ++c) {
                                                myvtkarray = TransformBasedonCameraView.this.imageData[c].GetPointData().GetScalars();
                                                inData = ((vtkUnsignedShortArray)myvtkarray).GetJavaArray();
                                                outData = new short[w * h];
                                                for (int i = 0; i < h; ++i) {
                                                    for (int j = 0; j < w; ++j) {
                                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                                    }
                                                }
                                                image.setDataXYAsShort(c, (short[])outData);
                                            }
                                            TransformBasedonCameraView.this.sequence2.setImage(t, z, (BufferedImage)image);
                                        }
                                    }
                                    break;
                                }
                                case SHORT: {
                                    Object[] outData;
                                    Object[] inData;
                                    vtkDataArray myvtkarray;
                                    IcyBufferedImage image;
                                    for (int t = 0; t < nbt; ++t) {
                                        for (int z = 0; z < nbz; ++z) {
                                            image = new IcyBufferedImage(w, h, nbc, datatype);
                                            progress.setPosition((double)z);
                                            for (int c = 0; c < nbc; ++c) {
                                                myvtkarray = TransformBasedonCameraView.this.imageData[c].GetPointData().GetScalars();
                                                inData = ((vtkShortArray)myvtkarray).GetJavaArray();
                                                outData = new short[w * h];
                                                for (int i = 0; i < h; ++i) {
                                                    for (int j = 0; j < w; ++j) {
                                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                                    }
                                                }
                                                image.setDataXYAsShort(c, (short[])outData);
                                            }
                                            TransformBasedonCameraView.this.sequence2.setImage(t, z, (BufferedImage)image);
                                        }
                                    }
                                    break;
                                }
                                case INT: {
                                    Object[] outData;
                                    Object[] inData;
                                    vtkDataArray myvtkarray;
                                    IcyBufferedImage image;
                                    for (int t = 0; t < nbt; ++t) {
                                        for (int z = 0; z < nbz; ++z) {
                                            image = new IcyBufferedImage(w, h, nbc, datatype);
                                            progress.setPosition((double)z);
                                            for (int c = 0; c < nbc; ++c) {
                                                myvtkarray = TransformBasedonCameraView.this.imageData[c].GetPointData().GetScalars();
                                                inData = ((vtkIntArray)myvtkarray).GetJavaArray();
                                                outData = new int[w * h];
                                                for (int i = 0; i < h; ++i) {
                                                    for (int j = 0; j < w; ++j) {
                                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                                    }
                                                }
                                                image.setDataXYAsInt(c, (int[])outData);
                                            }
                                            TransformBasedonCameraView.this.sequence2.setImage(t, z, (BufferedImage)image);
                                        }
                                    }
                                    break;
                                }
                                case UINT: {
                                    Object[] outData;
                                    Object[] inData;
                                    vtkDataArray myvtkarray;
                                    IcyBufferedImage image;
                                    for (int t = 0; t < nbt; ++t) {
                                        for (int z = 0; z < nbz; ++z) {
                                            image = new IcyBufferedImage(w, h, nbc, datatype);
                                            progress.setPosition((double)z);
                                            for (int c = 0; c < nbc; ++c) {
                                                myvtkarray = TransformBasedonCameraView.this.imageData[c].GetPointData().GetScalars();
                                                inData = ((vtkUnsignedIntArray)myvtkarray).GetJavaArray();
                                                outData = new int[w * h];
                                                for (int i = 0; i < h; ++i) {
                                                    for (int j = 0; j < w; ++j) {
                                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                                    }
                                                }
                                                image.setDataXYAsInt(c, (int[])outData);
                                            }
                                            TransformBasedonCameraView.this.sequence2.setImage(t, z, (BufferedImage)image);
                                        }
                                    }
                                    break;
                                }
                                case FLOAT: {
                                    Object[] outData;
                                    Object[] inData;
                                    vtkDataArray myvtkarray;
                                    IcyBufferedImage image;
                                    for (int t = 0; t < nbt; ++t) {
                                        for (int z = 0; z < nbz; ++z) {
                                            image = new IcyBufferedImage(w, h, nbc, datatype);
                                            progress.setPosition((double)z);
                                            for (int c = 0; c < nbc; ++c) {
                                                myvtkarray = TransformBasedonCameraView.this.imageData[c].GetPointData().GetScalars();
                                                inData = ((vtkFloatArray)myvtkarray).GetJavaArray();
                                                outData = new float[w * h];
                                                for (int i = 0; i < h; ++i) {
                                                    for (int j = 0; j < w; ++j) {
                                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                                    }
                                                }
                                                image.setDataXYAsFloat(c, (float[])outData);
                                            }
                                            TransformBasedonCameraView.this.sequence2.setImage(t, z, (BufferedImage)image);
                                        }
                                    }
                                    break;
                                }
                                case DOUBLE: {
                                    Object[] outData;
                                    Object[] inData;
                                    vtkDataArray myvtkarray;
                                    IcyBufferedImage image;
                                    for (int t = 0; t < nbt; ++t) {
                                        for (int z = 0; z < nbz; ++z) {
                                            image = new IcyBufferedImage(w, h, nbc, datatype);
                                            progress.setPosition((double)z);
                                            for (int c = 0; c < nbc; ++c) {
                                                myvtkarray = TransformBasedonCameraView.this.imageData[c].GetPointData().GetScalars();
                                                inData = ((vtkDoubleArray)myvtkarray).GetJavaArray();
                                                outData = new double[w * h];
                                                for (int i = 0; i < h; ++i) {
                                                    for (int j = 0; j < w; ++j) {
                                                        outData[i * w + j] = inData[z * w * h + i * w + j];
                                                    }
                                                }
                                                image.setDataXYAsDouble(c, (double[])outData);
                                            }
                                            TransformBasedonCameraView.this.sequence2.setImage(t, z, (BufferedImage)image);
                                        }
                                    }
                                    break;
                                }
                            }
                            TransformBasedonCameraView.this.sequence2.setPixelSizeX(TransformBasedonCameraView.this.InputSpacingx);
                            TransformBasedonCameraView.this.sequence2.setPixelSizeY(TransformBasedonCameraView.this.InputSpacingy);
                            TransformBasedonCameraView.this.sequence2.setPixelSizeZ(TransformBasedonCameraView.this.InputSpacingz);
                        }
                        finally {
                            TransformBasedonCameraView.this.sequence2.endUpdate();
                        }
                        progress.close();
                        TransformBasedonCameraView.this.sequence2.setName("rotated");
                        System.out.println("have been applied");
                    }
                };
                ThreadUtil.bgRunSingle((Runnable)this.transformer);
                this.addSequence(this.sequence2);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            MessageDialog.showDialog((String)"Please switch to 3D view");
        }
    }

    protected void writeTransfo3D(vtkMatrix4x4 transfo) {
        String name = ((Sequence)this.source.getValue()).getFilename() + "_3D_MANUAL_ROTATE_transfo.xml";
        File XMLFile = new File(name);
        Document document = XMLUtil.createDocument((boolean)true);
        Element transfoElement1 = XMLUtil.addElement((Node)document.getDocumentElement(), (String)"TargetSize");
        XMLUtil.setAttributeIntValue((Element)transfoElement1, (String)"width", (int)this.sequence.getSizeX());
        XMLUtil.setAttributeIntValue((Element)transfoElement1, (String)"height", (int)this.sequence.getSizeY());
        XMLUtil.setAttributeIntValue((Element)transfoElement1, (String)"nz", (int)this.sequence.getSizeZ());
        XMLUtil.setAttributeDoubleValue((Element)transfoElement1, (String)"sx", (double)this.InputSpacingx);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement1, (String)"sy", (double)this.InputSpacingy);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement1, (String)"sz", (double)this.InputSpacingz);
        XMLUtil.setAttributeIntValue((Element)transfoElement1, (String)"recenter", (int)1);
        Element transfoElement = XMLUtil.addElement((Node)document.getDocumentElement(), (String)"MatrixTransformation");
        XMLUtil.setAttributeIntValue((Element)transfoElement, (String)"order", (int)0);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m00", (double)transfo.GetElement(0, 0));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m10", (double)transfo.GetElement(0, 1));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m20", (double)transfo.GetElement(0, 2));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m30", (double)transfo.GetElement(0, 3));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m01", (double)transfo.GetElement(1, 0));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m11", (double)transfo.GetElement(1, 1));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m21", (double)transfo.GetElement(1, 2));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m31", (double)transfo.GetElement(1, 3));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m02", (double)transfo.GetElement(2, 0));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m12", (double)transfo.GetElement(2, 1));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m22", (double)transfo.GetElement(2, 2));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m32", (double)transfo.GetElement(2, 3));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m03", (double)transfo.GetElement(3, 0));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m13", (double)transfo.GetElement(3, 1));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m23", (double)transfo.GetElement(3, 2));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m33", (double)transfo.GetElement(3, 3));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"formerpixelsizeX", (double)this.InputSpacingx);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"formerpixelsizeY", (double)this.InputSpacingy);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"formerpixelsizeZ", (double)this.InputSpacingz);
        XMLUtil.setAttributeValue((Element)transfoElement, (String)"process_date", (String)new Date().toString());
        XMLUtil.saveDocument((Document)document, (File)XMLFile);
        System.out.println("Saved as" + XMLFile.getPath());
        new AnnounceFrame("Transfo Saved as" + XMLFile.getPath());
    }

    protected void initialize() {
        EzLabel textinfo1 = new EzLabel("Manual Prealignment:");
        EzLabel textinfo3 = new EzLabel("Please select the stack you want to transform,\n select 3D view canvas and then,\n turn in the direction you want to reslice it. \nWhen ready, press play.The transform will be saved \n and can be reapplied through Ec-CLEM later if needed. ");
        this.source = new EzVarSequence("Select Source Stack ");
        this.addEzComponent((EzComponent)textinfo1);
        this.addEzComponent((EzComponent)this.source);
        this.addEzComponent((EzComponent)textinfo3);
        this.addEzComponent((EzComponent)this.choiceinputsection);
    }

    void converttoVtkImageData(int posC) {
        vtkPointData pointData;
        if (this.sequence == null) {
            return;
        }
        int sizeX = this.sequence.getSizeX();
        int sizeY = this.sequence.getSizeY();
        int sizeZ = this.sequence.getSizeZ();
        DataType dataType = this.sequence.getDataType_();
        int posT = this.sequence.getFirstViewer().getPositionT();
        vtkImageData newImageData = new vtkImageData();
        newImageData.SetDimensions(sizeX, sizeY, sizeZ);
        newImageData.SetSpacing(this.InputSpacingx, this.InputSpacingy, this.InputSpacingz);
        switch (dataType) {
            case UBYTE: {
                newImageData.AllocateScalars(3, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkUnsignedCharArray)array).SetJavaArray(this.sequence.getDataCopyCXYZAsByte(posT));
                    break;
                }
                ((vtkUnsignedCharArray)array).SetJavaArray(this.sequence.getDataCopyXYZAsByte(posT, posC));
                break;
            }
            case BYTE: {
                newImageData.AllocateScalars(3, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkUnsignedCharArray)array).SetJavaArray(this.sequence.getDataCopyCXYZAsByte(posT));
                    break;
                }
                ((vtkUnsignedCharArray)array).SetJavaArray(this.sequence.getDataCopyXYZAsByte(posT, posC));
                break;
            }
            case USHORT: {
                newImageData.AllocateScalars(5, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkUnsignedShortArray)array).SetJavaArray(this.sequence.getDataCopyCXYZAsShort(posT));
                    break;
                }
                ((vtkUnsignedShortArray)array).SetJavaArray(this.sequence.getDataCopyXYZAsShort(posT, posC));
                break;
            }
            case SHORT: {
                newImageData.AllocateScalars(4, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkShortArray)array).SetJavaArray(this.sequence.getDataCopyCXYZAsShort(posT));
                    break;
                }
                ((vtkShortArray)array).SetJavaArray(this.sequence.getDataCopyXYZAsShort(posT, posC));
                break;
            }
            case UINT: {
                newImageData.AllocateScalars(7, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkUnsignedIntArray)array).SetJavaArray(this.sequence.getDataCopyCXYZAsInt(posT));
                    break;
                }
                ((vtkUnsignedIntArray)array).SetJavaArray(this.sequence.getDataCopyXYZAsInt(posT, posC));
                break;
            }
            case INT: {
                newImageData.AllocateScalars(6, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkIntArray)array).SetJavaArray(this.sequence.getDataCopyCXYZAsInt(posT));
                    break;
                }
                ((vtkIntArray)array).SetJavaArray(this.sequence.getDataCopyXYZAsInt(posT, posC));
                break;
            }
            case FLOAT: {
                newImageData.AllocateScalars(10, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkFloatArray)array).SetJavaArray(this.sequence.getDataCopyCXYZAsFloat(posT));
                    break;
                }
                ((vtkFloatArray)array).SetJavaArray(this.sequence.getDataCopyXYZAsFloat(posT, posC));
                break;
            }
            case DOUBLE: {
                newImageData.AllocateScalars(11, 1);
                vtkDataArray array = newImageData.GetPointData().GetScalars();
                if (posC == -1) {
                    ((vtkDoubleArray)array).SetJavaArray(this.sequence.getDataCopyCXYZAsDouble(posT));
                    break;
                }
                ((vtkDoubleArray)array).SetJavaArray(this.sequence.getDataCopyXYZAsDouble(posT, posC));
                break;
            }
            default: {
                newImageData.SetDimensions(1, 1, 1);
                newImageData.SetSpacing(this.sequence.getPixelSizeX(), this.sequence.getPixelSizeY(), this.sequence.getPixelSizeZ());
                newImageData.SetNumberOfScalarComponents(1, null);
                newImageData.SetExtent(0, 0, 0, 0, 0, 0);
                newImageData.AllocateScalars(null);
            }
        }
        if (this.imageData[posC] != null && (pointData = this.imageData[posC].GetPointData()) != null) {
            vtkDataArray dataArray = pointData.GetScalars();
            if (dataArray != null) {
                dataArray.Delete();
            }
            pointData.Delete();
            this.imageData[posC].ReleaseData();
            this.imageData[posC].Delete();
        }
        this.imageData[posC] = newImageData;
    }

    static /* synthetic */ vtkDataSet[] access$102(TransformBasedonCameraView x0, vtkDataSet[] x1) {
        x0.imageData = x1;
        return x1;
    }
}

