/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.flies;

import icy.gui.dialog.MessageDialog;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.painter.Overlay;
import icy.util.StringUtil;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.SequenceCamData;
import plugins.fmp.multiSPOTS.series.BuildBackground;
import plugins.fmp.multiSPOTS.series.BuildSeriesOptions;
import plugins.fmp.multiSPOTS.tools.ImageTransform.ImageTransformEnums;
import plugins.fmp.multiSPOTS.tools.Overlay.OverlayThreshold;

public class Detect2Background
extends JPanel
implements ChangeListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private MultiSPOTS parent0 = null;
    private String detectString = "Build background...";
    private JButton startComputationButton = new JButton(this.detectString);
    private JSpinner backgroundThresholdSpinner = new JSpinner(new SpinnerNumberModel(60, 0, 255, 1));
    private JSpinner backgroundNFramesSpinner = new JSpinner(new SpinnerNumberModel(20, 0, 255, 1));
    private JSpinner backgroundJitterSpinner = new JSpinner(new SpinnerNumberModel(1, 0, 255, 1));
    private JSpinner backgroundDeltaSpinner = new JSpinner(new SpinnerNumberModel(20, 0, 255, 1));
    private JButton loadButton = new JButton("Load...");
    private JButton saveButton = new JButton("Save...");
    private JCheckBox allCheckBox = new JCheckBox("ALL (current to last)", false);
    private JCheckBox overlayCheckBox = new JCheckBox("overlay");
    private BuildBackground buildBackground = null;
    private OverlayThreshold ov = null;

    void init(GridLayout capLayout, MultiSPOTS parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.startComputationButton);
        panel1.add(this.allCheckBox);
        panel1.add(this.loadButton);
        panel1.add(this.saveButton);
        this.add(panel1);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(new JLabel("threshold/fly "));
        panel2.add(this.backgroundThresholdSpinner);
        panel2.add(new JLabel("over n frames "));
        panel2.add(this.backgroundNFramesSpinner);
        panel2.add(this.overlayCheckBox);
        panel2.validate();
        this.add(panel2);
        JPanel panel3 = new JPanel(flowLayout);
        panel3.add(new JLabel("min delta fly/background "));
        panel3.add(this.backgroundDeltaSpinner);
        panel3.add(new JLabel("jitter around fly "));
        panel3.add(this.backgroundJitterSpinner);
        this.add(panel3);
        this.defineActionListeners();
        this.backgroundThresholdSpinner.addChangeListener(this);
    }

    private void defineActionListeners() {
        this.startComputationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Detect2Background.this.startComputationButton.getText().equals(Detect2Background.this.detectString)) {
                    Detect2Background.this.startComputation();
                } else {
                    Detect2Background.this.stopComputation();
                }
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Detect2Background)Detect2Background.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    exp.saveReferenceImage(exp.seqCamData.refImage);
                }
            }
        });
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Detect2Background.this.loadBackground();
            }
        });
        this.allCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = Color.BLACK;
                if (Detect2Background.this.allCheckBox.isSelected()) {
                    color = Color.RED;
                }
                Detect2Background.this.allCheckBox.setForeground(color);
                Detect2Background.this.startComputationButton.setForeground(color);
            }
        });
        this.overlayCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Experiment exp = (Experiment)((Detect2Background)Detect2Background.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    if (Detect2Background.this.overlayCheckBox.isSelected()) {
                        if (Detect2Background.this.ov == null) {
                            Detect2Background.this.ov = new OverlayThreshold(exp.seqCamData.seq);
                        }
                        exp.seqCamData.seq.addOverlay((Overlay)Detect2Background.this.ov);
                        Detect2Background.this.updateOverlay(exp);
                    } else {
                        Detect2Background.this.removeOverlay(exp);
                    }
                }
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.backgroundThresholdSpinner) {
            Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
            if (!this.overlayCheckBox.isSelected()) {
                this.overlayCheckBox.setSelected(true);
            }
            if (exp != null) {
                this.updateOverlay(exp);
            }
        }
    }

    void loadBackground() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            boolean flag = exp.loadReferenceImage();
            if (flag) {
                Viewer v = new Viewer(exp.seqReference, true);
                Rectangle rectv = exp.seqCamData.seq.getFirstViewer().getBoundsInternal();
                v.setBounds(rectv);
            } else {
                MessageDialog.showDialog((String)"Reference file not found on disk", (int)0);
            }
        }
    }

    private void updateOverlay(Experiment exp) {
        SequenceCamData seqCamData = exp.seqCamData;
        if (seqCamData == null) {
            return;
        }
        if (this.ov == null) {
            this.ov = new OverlayThreshold(seqCamData.seq);
            int t = exp.seqCamData.currentFrame;
            exp.seqCamData.refImage = IcyBufferedImageUtil.getCopy((IcyBufferedImage)exp.seqCamData.getSeqImage(t, 0));
        } else {
            seqCamData.seq.removeOverlay((Overlay)this.ov);
            this.ov.setSequence(seqCamData.seq);
        }
        this.ov.setReferenceImage(exp.seqCamData.refImage);
        seqCamData.seq.addOverlay((Overlay)this.ov);
        boolean ifGreater = true;
        ImageTransformEnums transformOp = ImageTransformEnums.NONE;
        int threshold = (Integer)this.backgroundThresholdSpinner.getValue();
        this.ov.setThresholdSingle(threshold, transformOp, ifGreater);
        this.ov.painterChanged();
    }

    private void removeOverlay(Experiment exp) {
        if (exp.seqCamData != null && exp.seqCamData.seq != null) {
            exp.seqCamData.seq.removeOverlay((Overlay)this.ov);
        }
    }

    private BuildSeriesOptions initTrackParameters() {
        BuildSeriesOptions options = this.buildBackground.options;
        options.expList = this.parent0.expListCombo;
        options.expList.index0 = this.parent0.expListCombo.getSelectedIndex();
        options.expList.index1 = this.allCheckBox.isSelected() ? options.expList.getItemCount() - 1 : this.parent0.expListCombo.getSelectedIndex();
        options.btrackWhite = true;
        options.backgroundThreshold = (Integer)this.backgroundThresholdSpinner.getValue();
        options.backgroundNFrames = (Integer)this.backgroundNFramesSpinner.getValue();
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        options.backgroundFirst = exp.seqCamData.currentFrame;
        options.forceBuildBackground = true;
        options.detectFlies = false;
        options.parent0Rect = this.parent0.mainFrame.getBoundsInternal();
        options.isFrameFixed = this.parent0.dlgExcel.tabCommonOptions.getIsFixedFrame();
        options.t_Ms_First = this.parent0.dlgExcel.tabCommonOptions.getStartMs();
        options.t_Ms_Last = this.parent0.dlgExcel.tabCommonOptions.getEndMs();
        options.t_Ms_BinDuration = this.parent0.dlgExcel.tabCommonOptions.getBinMs();
        options.background_jitter = (Integer)this.backgroundJitterSpinner.getValue();
        options.background_delta = (Integer)this.backgroundDeltaSpinner.getValue();
        return options;
    }

    void startComputation() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        this.parent0.dlgBrowse.panelLoadSave.closeViewsForCurrentExperiment(exp);
        this.buildBackground = new BuildBackground();
        this.buildBackground.options = this.initTrackParameters();
        this.buildBackground.stopFlag = false;
        this.buildBackground.addPropertyChangeListener(this);
        this.buildBackground.execute();
        this.startComputationButton.setText("STOP");
    }

    private void stopComputation() {
        if (this.buildBackground != null && !this.buildBackground.stopFlag) {
            this.buildBackground.stopFlag = true;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (StringUtil.equals((String)"thread_ended", (String)evt.getPropertyName())) {
            this.startComputationButton.setText(this.detectString);
            this.loadBackground();
        }
    }
}

