/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.experiment;

import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.type.geom.Polygon2D;
import icy.util.XMLUtil;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multiSPOTS.experiment.CapillariesArray;
import plugins.fmp.multiSPOTS.experiment.Capillary;
import plugins.fmp.multiSPOTS.experiment.FlyPosition;
import plugins.fmp.multiSPOTS.experiment.FlyPositions;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DRectangle;

public class Cage {
    public ROI2D cageRoi2D = null;
    public BooleanMask2D cageMask2D = null;
    public FlyPositions flyPositions = new FlyPositions();
    public int cageNFlies = 0;
    public int cageAge = 5;
    public String strCageComment = "..";
    public String strCageSex = "..";
    public String strCageStrain = "..";
    private String strCageNumber = null;
    public boolean valid = false;
    public boolean bDetect = true;
    public boolean initialflyRemoved = false;
    private final String ID_CAGELIMITS = "CageLimits";
    private final String ID_FLYPOSITIONS = "FlyPositions";
    private final String ID_NFLIES = "nflies";
    private final String ID_AGE = "age";
    private final String ID_COMMENT = "comment";
    private final String ID_SEX = "sex";
    private final String ID_STRAIN = "strain";

    public boolean xmlSaveCage(Node node, int index) {
        if (node == null) {
            return false;
        }
        Element xmlVal = XMLUtil.addElement((Node)node, (String)("Cage" + index));
        this.xmlSaveCageLimits(xmlVal);
        this.xmlSaveCageParameters(xmlVal);
        if (this.cageNFlies > 0) {
            this.xmlSaveFlyPositions(xmlVal);
        }
        return true;
    }

    public boolean xmlSaveCageParameters(Element xmlVal) {
        XMLUtil.setElementIntValue((Node)xmlVal, (String)"nflies", (int)this.cageNFlies);
        XMLUtil.setElementIntValue((Node)xmlVal, (String)"age", (int)this.cageAge);
        XMLUtil.setElementValue((Node)xmlVal, (String)"comment", (String)this.strCageComment);
        XMLUtil.setElementValue((Node)xmlVal, (String)"sex", (String)this.strCageSex);
        XMLUtil.setElementValue((Node)xmlVal, (String)"strain", (String)this.strCageStrain);
        return true;
    }

    public boolean xmlSaveCageLimits(Element xmlVal) {
        Element xmlVal2 = XMLUtil.addElement((Node)xmlVal, (String)"CageLimits");
        if (this.cageRoi2D != null) {
            this.cageRoi2D.setSelected(false);
            this.cageRoi2D.saveToXML((Node)xmlVal2);
        }
        return true;
    }

    public String csvExportCageDescription(String sep) {
        StringBuffer sbf = new StringBuffer();
        ArrayList<String> row = new ArrayList<String>();
        row.add(this.strCageNumber);
        row.add(this.cageRoi2D.getName());
        row.add(Integer.toString(this.cageNFlies));
        row.add(Integer.toString(this.cageAge));
        row.add(this.strCageComment);
        row.add(this.strCageStrain);
        row.add(this.strCageSex);
        int npoints = 0;
        if (this.cageRoi2D != null) {
            Polygon2D polygon = ((ROI2DPolygon)this.cageRoi2D).getPolygon2D();
            row.add(Integer.toString(polygon.npoints));
            for (int i = 0; i < npoints; ++i) {
                row.add(Integer.toString((int)polygon.xpoints[i]));
                row.add(Integer.toString((int)polygon.ypoints[i]));
            }
        } else {
            row.add("0");
        }
        sbf.append(String.join((CharSequence)sep, row));
        sbf.append("\n");
        return sbf.toString();
    }

    public boolean xmlSaveFlyPositions(Element xmlVal) {
        Element xmlVal2 = XMLUtil.addElement((Node)xmlVal, (String)"FlyPositions");
        this.flyPositions.saveXYTseriesToXML(xmlVal2);
        return true;
    }

    public boolean xmlLoadCage(Node node, int index) {
        if (node == null) {
            return false;
        }
        Element xmlVal = XMLUtil.getElement((Node)node, (String)("Cage" + index));
        if (xmlVal == null) {
            return false;
        }
        this.xmlLoadCageLimits(xmlVal);
        this.xmlLoadCageParameters(xmlVal);
        this.xmlLoadFlyPositions(xmlVal);
        return true;
    }

    public boolean xmlLoadCageLimits(Element xmlVal) {
        Element xmlVal2 = XMLUtil.getElement((Node)xmlVal, (String)"CageLimits");
        if (xmlVal2 != null) {
            this.cageRoi2D = (ROI2D)ROI.createFromXML((Node)xmlVal2);
            this.cageRoi2D.setSelected(false);
        }
        return true;
    }

    public boolean xmlLoadCageParameters(Element xmlVal) {
        this.cageNFlies = XMLUtil.getElementIntValue((Node)xmlVal, (String)"nflies", (int)this.cageNFlies);
        this.cageAge = XMLUtil.getElementIntValue((Node)xmlVal, (String)"age", (int)this.cageAge);
        this.strCageComment = XMLUtil.getElementValue((Node)xmlVal, (String)"comment", (String)this.strCageComment);
        this.strCageSex = XMLUtil.getElementValue((Node)xmlVal, (String)"sex", (String)this.strCageSex);
        this.strCageStrain = XMLUtil.getElementValue((Node)xmlVal, (String)"strain", (String)this.strCageStrain);
        return true;
    }

    public boolean xmlLoadFlyPositions(Element xmlVal) {
        Element xmlVal2 = XMLUtil.getElement((Node)xmlVal, (String)"FlyPositions");
        if (xmlVal2 != null) {
            this.flyPositions.loadXYTseriesFromXML(xmlVal2);
            return true;
        }
        return false;
    }

    public String getCageNumber() {
        if (this.strCageNumber == null) {
            this.strCageNumber = this.cageRoi2D.getName().substring(this.cageRoi2D.getName().length() - 3);
        }
        return this.strCageNumber;
    }

    public int getCageNumberInteger() {
        int cagenb = -1;
        this.strCageNumber = this.getCageNumber();
        if (this.strCageNumber != null) {
            try {
                return Integer.parseInt(this.strCageNumber);
            }
            catch (NumberFormatException e) {
                return cagenb;
            }
        }
        return cagenb;
    }

    public void clearMeasures() {
        this.flyPositions.clear();
    }

    public Point2D getCenterTopCage() {
        Rectangle2D rect = this.cageRoi2D.getBounds2D();
        Point2D.Double pt = new Point2D.Double(rect.getX() + rect.getWidth() / 2.0, rect.getY());
        return pt;
    }

    public Point2D getCenterTipCapillaries(CapillariesArray capillaries) {
        ArrayList<Point2D> listpts = new ArrayList<Point2D>();
        for (Capillary cap : capillaries.capillariesList) {
            Point2D pt = cap.getCapillaryTipWithinROI2D(this.cageRoi2D);
            if (pt == null) continue;
            listpts.add(pt);
        }
        double x = 0.0;
        double y = 0.0;
        int n = listpts.size();
        for (Point2D pt : listpts) {
            x += pt.getX();
            y += pt.getY();
        }
        Point2D.Double pt = new Point2D.Double(x / (double)n, y / (double)n);
        return pt;
    }

    public void copyCage(Cage cage) {
        this.cageRoi2D = cage.cageRoi2D;
        this.cageNFlies = cage.cageNFlies;
        this.strCageComment = cage.strCageComment;
        this.strCageNumber = cage.strCageNumber;
        this.valid = false;
        this.flyPositions.copyXYTaSeries(cage.flyPositions);
    }

    public ROI2DRectangle getRoiRectangleFromPositionAtT(int t) {
        int nitems = this.flyPositions.flyPositionList.size();
        if (nitems == 0 || t >= nitems) {
            return null;
        }
        FlyPosition aValue = this.flyPositions.flyPositionList.get(t);
        ROI2DRectangle flyRoiR = new ROI2DRectangle(aValue.rectPosition);
        flyRoiR.setName("detR" + this.getCageNumber() + "_" + t);
        flyRoiR.setT(t);
        return flyRoiR;
    }

    public void transferRoisToPositions(List<ROI2D> detectedROIsList) {
        String filter = "detR" + this.getCageNumber();
        for (ROI2D roi : detectedROIsList) {
            String name = roi.getName();
            if (!name.contains(filter)) continue;
            Rectangle2D rect = ((ROI2DRectangle)roi).getRectangle();
            int t = roi.getT();
            this.flyPositions.flyPositionList.get((int)t).rectPosition = rect;
        }
    }

    public void computeCageBooleanMask2D() throws InterruptedException {
        this.cageMask2D = this.cageRoi2D.getBooleanMask2D(0, 0, 1, true);
    }
}

